/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.geom.DPoint;
import de.geocalc.geom.DRectangle;
import de.geocalc.kafplot.DatObject;
import de.geocalc.kafplot.IdentitaetUtil;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktContainer;
import de.geocalc.kafplot.PunktNummer;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.Stat;
import de.geocalc.kafplot.StatElement;
import de.geocalc.kafplot.TagObject;
import de.geocalc.kafplot.TrafoGewicht;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.kafplot.io.kpv.KpvIOProperties;
import de.geocalc.kafplot.io.xml.XmlIOProperties;
import de.geocalc.text.IFormat;
import de.geocalc.util.sml.Tag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class TrafoPunkt
extends DPoint
implements PunktContainer,
DatObject,
TagObject,
Cloneable,
StatElement {
    private Punkt p;
    private boolean isFirst = false;
    private boolean isOnline = true;
    private Stat stat = null;
    private float vy;
    private float vx;
    private float ry;
    private float rx;
    private String bemerkung;
    private TrafoGewicht gewichte;
    private TrafoSystem system;

    public TrafoPunkt() {
        this(null, 0.0, 0.0);
    }

    public TrafoPunkt(Punkt punkt, double d, double d2) {
        super(d, d2);
        this.p = punkt;
    }

    public TrafoPunkt(Punkt punkt, double d, double d2, TrafoGewicht trafoGewicht) {
        super(d, d2);
        this.p = punkt;
        this.setGewichte(trafoGewicht);
    }

    public TrafoSystem getContainer() {
        return this.system;
    }

    public void setContainer(TrafoSystem trafoSystem) {
        this.system = trafoSystem;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public DRectangle getBounds() {
        return new DRectangle(this.p.y, this.p.x, 0.0, 0.0);
    }

    @Override
    public boolean contains(Punkt punkt) {
        return this.p.equals(punkt);
    }

    @Override
    public PunktTable getPunkte() {
        PunktTable punktTable = new PunktTable();
        if (this.p != null) {
            punktTable.put(this.p);
        }
        return punktTable;
    }

    public void setOn(boolean bl) {
        this.isOnline = bl;
    }

    @Override
    public boolean isOn() {
        return this.isOnline;
    }

    public void setPunkt(Punkt punkt) {
        this.p = punkt;
    }

    public Punkt getPunkt() {
        return this.p;
    }

    public void setFirst(boolean bl) {
        this.isFirst = bl;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public void setVy(float f) {
        this.vy = f;
    }

    public void setVx(float f) {
        this.vx = f;
    }

    public void setVyx(float f, float f2) {
        this.vy = f;
        this.vx = f2;
    }

    public float getVy() {
        return this.vy;
    }

    public float getVx() {
        return this.vx;
    }

    public float getVs() {
        return (float)Math.sqrt(this.vy * this.vy + this.vx * this.vx);
    }

    public void setRy(float f) {
        this.ry = f;
    }

    public void setRx(float f) {
        this.rx = f;
    }

    public void setRyx(float f, float f2) {
        this.ry = f;
        this.rx = f2;
    }

    public float getRy() {
        return this.ry;
    }

    public float getRx() {
        return this.rx;
    }

    public float getRs() {
        return (float)Math.sqrt(this.ry * this.ry + this.rx * this.rx);
    }

    public boolean hasGewichte() {
        return this.gewichte != null;
    }

    public void setGewichte(TrafoGewicht trafoGewicht) {
        this.gewichte = trafoGewicht;
    }

    public TrafoGewicht getGewichte() {
        return this.gewichte;
    }

    @Override
    public boolean hasStatistik() {
        return this.stat != null;
    }

    @Override
    public void setStatistik(Stat stat) {
        this.stat = stat;
    }

    @Override
    public Stat getStatistik() {
        return this.stat;
    }

    @Override
    public final boolean hasBemerkung() {
        return this.bemerkung != null;
    }

    @Override
    public final void setBemerkung(String string) {
        this.bemerkung = string;
    }

    @Override
    public final void addBemerkung(String string) {
        this.bemerkung = this.bemerkung == null ? string : this.bemerkung + string;
    }

    @Override
    public final void addTag(String string) {
        this.bemerkung = this.bemerkung == null ? string : string + this.bemerkung;
    }

    @Override
    public final boolean hasTag(String string) {
        return this.bemerkung != null && Tag.hasTag(this.bemerkung, string);
    }

    @Override
    public final String getBemerkung() {
        return this.bemerkung;
    }

    @Override
    public final String getBemerkungText() {
        if (this.bemerkung == null) {
            return null;
        }
        if (Tag.hasTag(this.bemerkung)) {
            return Tag.parseText(this.bemerkung);
        }
        return this.bemerkung;
    }

    public final String getClassName() {
        return "Trafopunkt";
    }

    public final String getObjectName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.p != null) {
            stringBuffer.append(Long.toString(this.p.nr));
        }
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.f_3.format(this.y));
        stringBuffer.append(",");
        stringBuffer.append(IFormat.f_3.format(this.x));
        return stringBuffer.toString();
    }

    public String getExceptionableName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClassName());
        stringBuffer.append(": ");
        stringBuffer.append(this.getObjectName());
        return stringBuffer.toString();
    }

    public final String toDebugString() {
        return this.getExceptionableName();
    }

    public final String getFormatedStatistikName(int n) {
        if (n == 1) {
            return "Y-Koordinate";
        }
        if (n == 2) {
            return "X-Koordinate";
        }
        return "";
    }

    @Override
    public String toDatLine() {
        String string = this.bemerkung;
        StringBuffer stringBuffer = new StringBuffer(60);
        if (!this.isOn()) {
            stringBuffer.append("C");
            stringBuffer.append(IFormat.i01.format(this.isFirst ? (long)KafkaIOProperties.trafoParameter : 2L));
            stringBuffer.append(" ");
        } else {
            stringBuffer.append(IFormat.i01.format(this.isFirst ? (long)KafkaIOProperties.trafoParameter : 2L));
            stringBuffer.append("  ");
        }
        IdentitaetUtil identitaetUtil = new IdentitaetUtil(this.p, string, 1, !KafkaIOProperties.writeOffline);
        Punkt punkt = identitaetUtil.getPunkt();
        string = identitaetUtil.getBem();
        stringBuffer.append(IFormat.i14.format(punkt.buildKatNr(KafkaIOProperties.pnrModus, KafkaIOProperties.writeUmnum ? punkt.getNr() : punkt.nr)));
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.f7_3.format(this.y));
        stringBuffer.append("  ");
        stringBuffer.append(IFormat.f7_3.format(this.x));
        stringBuffer.append(" ");
        if (this.hasGewichte() && (this.isFirst || !this.gewichte.equals(KafkaIOProperties.lastTrafoGewicht))) {
            KafkaIOProperties.lastTrafoGewicht = this.gewichte;
            stringBuffer.append(KafkaIOProperties.lastTrafoGewicht.toDatString());
        } else {
            stringBuffer.append("                ");
        }
        if (string != null) {
            stringBuffer.append(IFormat.getSpaces(40));
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String toXmlLine() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(XmlIOProperties.openln("tpunkt"));
        stringBuffer.append(XmlIOProperties.dataln("nr", Long.toString(this.p.nr)));
        stringBuffer.append(XmlIOProperties.dataln("y", IFormat.f_3.format(this.y).toString()));
        stringBuffer.append(XmlIOProperties.dataln("x", IFormat.f_3.format(this.x).toString()));
        stringBuffer.append(XmlIOProperties.close("tpunkt"));
        return stringBuffer.toString();
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(32);
        PunktNummer.writeObject(this.getPunkt().nr, dataOutput);
        dataOutput.writeDouble(this.y);
        dataOutput.writeDouble(this.x);
        if (this.vy != 0.0f || this.vx != 0.0f || this.ry != 0.0f || this.rx != 0.0f) {
            dataOutput.writeByte(7);
            dataOutput.writeFloat(this.vy);
            dataOutput.writeFloat(this.vx);
            dataOutput.writeFloat(this.ry);
            dataOutput.writeFloat(this.rx);
        } else {
            dataOutput.writeByte(0);
        }
        if (this.hasGewichte() && KpvIOProperties.writeStatistik()) {
            dataOutput.writeShort(KpvIOProperties.getTrafoGewichtId(this.getGewichte()));
        } else {
            dataOutput.writeShort(0);
        }
        if (this.hasStatistik() && KpvIOProperties.writeStatistik()) {
            this.getStatistik().writeObject(dataOutput);
        } else {
            dataOutput.writeByte(0);
        }
    }

    public static TrafoPunkt readObject(DataInput dataInput) throws IOException {
        Punkt punkt = new Punkt();
        punkt.nr = PunktNummer.readObject(dataInput);
        TrafoPunkt trafoPunkt = new TrafoPunkt(punkt, dataInput.readDouble(), dataInput.readDouble());
        if (KpvIOProperties.RVER >= 110) {
            if (dataInput.readByte() != 0) {
                trafoPunkt.vy = dataInput.readFloat();
                trafoPunkt.vx = dataInput.readFloat();
                trafoPunkt.ry = dataInput.readFloat();
                trafoPunkt.rx = dataInput.readFloat();
            }
            trafoPunkt.setGewichte(KpvIOProperties.getTrafoGewichtVal(dataInput.readShort()));
            trafoPunkt.setStatistik(Stat.readObject(dataInput));
        }
        return trafoPunkt;
    }
}

