/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.ITextField;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.LokalTransform;
import de.geocalc.kafplot.Punkt;
import de.geocalc.text.IFormat;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;

public class TrafoSysDialog
extends IDialog
implements ActionListener,
ItemListener {
    private static Vector systems = new Vector();
    DataBase db;
    private static final String OK_COMMAND = "OK";
    private static final String ABORT_COMMAND = "Abbrechen";
    private static final String NEW_SYSTEM = "neue Transformationsparameter";
    private Choice sysChoice;
    private TextField rotTextField;
    private TextField dxTextField;
    private TextField dyTextField;
    private TextField mTextField;
    private Button okButton;
    private Button abortButton;
    private Checkbox inverseCheckbox;

    public TrafoSysDialog(IFrame iFrame, String string, DataBase dataBase) {
        super(iFrame, string, true);
        this.db = dataBase;
        this.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        Label label = new Label("Auswahl: ");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.sysChoice = new Choice();
        iPanel.add(this.sysChoice);
        this.sysChoice.addItemListener(this);
        this.sysChoice.add("    ");
        Object object = LokalTransform.elements();
        while (object.hasMoreElements()) {
            LokalTransform lokalTransform = (LokalTransform)object.nextElement();
            this.sysChoice.add(lokalTransform.getName());
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.sysChoice, gridBagConstraints);
        label = new Label("Translation dy [m]: ");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dyTextField = new ITextField(IFormat.f_3.format(0.0).toString(), 14);
        iPanel.add(this.dyTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.dyTextField, gridBagConstraints);
        label = new Label("Translation dx [m]: ");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dxTextField = new ITextField(IFormat.f_3.format(0.0).toString(), 14);
        iPanel.add(this.dxTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.dxTextField, gridBagConstraints);
        label = new Label("Rotation [rad]");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.rotTextField = new ITextField(IFormat.f_10.format(0.0).toString(), 14);
        iPanel.add(this.rotTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.rotTextField, gridBagConstraints);
        label = new Label("Ma\u00dfstab: ");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.mTextField = new ITextField(IFormat.f_10.format(1.0).toString(), 14);
        iPanel.add(this.mTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.mTextField, gridBagConstraints);
        label = new Label("r\u00fcckw\u00e4rts: ");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.inverseCheckbox = new Checkbox("");
        iPanel.add(this.inverseCheckbox);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.inverseCheckbox, gridBagConstraints);
        this.add("North", iPanel);
        object = new Panel(new FlowLayout(2));
        this.okButton = new Button(OK_COMMAND);
        this.okButton.addActionListener(this);
        ((Container)object).add(this.okButton);
        this.abortButton = new Button(ABORT_COMMAND);
        this.abortButton.addActionListener(this);
        ((Container)object).add(this.abortButton);
        this.add("South", (Component)object);
        this.inverseCheckbox.setState(dataBase.getKooSystem() >= 150);
        this.pack();
        this.setLocationOfParent(iFrame);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        String string = this.sysChoice.getSelectedItem();
        LokalTransform lokalTransform = LokalTransform.get(string);
        if (lokalTransform == null) {
            this.dxTextField.setText(IFormat.f_3.format(0.0).toString());
            this.dyTextField.setText(IFormat.f_3.format(0.0).toString());
            this.rotTextField.setText(IFormat.f_10.format(0.0).toString());
            this.mTextField.setText(IFormat.f_10.format(1.0).toString());
        } else {
            this.dxTextField.setText(IFormat.f_3.format(lokalTransform.getDx()).toString());
            this.dyTextField.setText(IFormat.f_3.format(lokalTransform.getDy()).toString());
            this.rotTextField.setText(IFormat.f_10.format(lokalTransform.getRotation()).toString());
            this.mTextField.setText(IFormat.f_10.format(lokalTransform.getScale()).toString());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK_COMMAND)) {
            this.doStandardAction();
        } else if (string.equals(ABORT_COMMAND)) {
            this.doAbortAction();
        }
    }

    @Override
    protected void doStandardAction() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        try {
            d = new Double(this.dyTextField.getText());
        }
        catch (Exception exception) {
            this.dyTextField.setForeground(Color.red);
            return;
        }
        try {
            d2 = new Double(this.dxTextField.getText());
        }
        catch (Exception exception) {
            this.dxTextField.setForeground(Color.red);
            return;
        }
        try {
            d3 = new Double(this.rotTextField.getText());
        }
        catch (Exception exception) {
            this.rotTextField.setForeground(Color.red);
            return;
        }
        try {
            d4 = new Double(this.mTextField.getText());
        }
        catch (Exception exception) {
            this.mTextField.setForeground(Color.red);
            return;
        }
        LokalTransform lokalTransform = new LokalTransform(d, d2, d3, d4);
        boolean bl = this.inverseCheckbox.getState();
        Enumeration enumeration = DataBase.P.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            if (bl) {
                lokalTransform.inverse(punkt);
                continue;
            }
            lokalTransform.transform(punkt);
        }
        this.db.setArea(-1);
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

