/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IGraphics;
import de.geocalc.geom.DPoint;
import de.geocalc.kafplot.DatContainer;
import de.geocalc.kafplot.DatObject;
import de.geocalc.kafplot.KatasterElement;
import de.geocalc.kafplot.PaintObject;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.RissInfo;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.ValueDataContainer;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.kafplot.io.xml.XmlIOProperties;
import de.geocalc.text.IFormat;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

public class TrafoSystem
extends ValueDataContainer
implements PaintObject,
KatasterElement,
DatContainer,
DatObject {
    private boolean isSuperSystem = false;
    private double superMasstab = 1.0;
    private int parameter = 4;
    private int nr;
    private boolean isVisible = true;
    private double my;
    private double mx;
    private double ty;
    private double tx;
    private double yas;
    private double xas;
    private double yns;
    private double xns;

    @Override
    public int getModel() {
        return 0;
    }

    public TrafoSystem(int n) {
        this.rissInfo = new RissInfo(n, n == 9 ? 402 : 401);
    }

    public boolean isSuperSystem() {
        return this.isSuperSystem;
    }

    public void setSuperSystem(boolean bl) {
        this.isSuperSystem = bl;
    }

    public double getSuperMasstab() {
        return this.superMasstab;
    }

    public void setSuperMasstab(double d) {
        this.superMasstab = d;
    }

    @Override
    public void setName(String string) {
        this.rissInfo.setName(string);
    }

    @Override
    public void addElement(Object object) {
        if (object instanceof TrafoPunkt) {
            ((TrafoPunkt)object).setContainer(this);
        }
        super.addElement(object);
    }

    @Override
    public void initGeom() {
        if (this.size() > 0) {
            TrafoPunkt trafoPunkt = (TrafoPunkt)this.firstElement();
            trafoPunkt.setFirst(true);
        }
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = 0.0;
        double d4 = 0.0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = ((TrafoPunkt)enumeration.nextElement()).getPunkt();
            if (punkt == null) continue;
            d = Math.min(d, punkt.y);
            d2 = Math.min(d2, punkt.x);
            d3 = Math.max(d3, punkt.y);
            d4 = Math.max(d4, punkt.x);
        }
        this.setBounds(d, d2, d3 - d, d4 - d2);
        this.createHull();
    }

    @Override
    public int getId() {
        return this.rissInfo.getId();
    }

    public void setStatus(int n) {
        this.setTyp(n);
    }

    public int getStatus() {
        return this.getTyp();
    }

    public String getStatusAsString() {
        switch (this.rissInfo.getTyp()) {
            case 8: {
                return "Transformation";
            }
            case 9: {
                return "Digitalisierung";
            }
            case 2: {
                return "Katasterriss";
            }
        }
        return "unbekannt";
    }

    public void setNummer(int n) {
        this.nr = n;
    }

    public int getNummer() {
        return this.nr;
    }

    public void setParameter(int n) {
        this.parameter = n;
    }

    public int getParameter() {
        return this.parameter;
    }

    @Override
    public boolean isKatasterElement() {
        return this.isKatasterNachweisElement();
    }

    @Override
    public boolean isKatasterNeuElement() {
        return false;
    }

    @Override
    public boolean isKatasterNachweisElement() {
        return this.rissInfo.getTyp() == 2;
    }

    @Override
    public DatObject createKatasterElement() {
        return this;
    }

    @Override
    public boolean contains(Punkt punkt) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            TrafoPunkt trafoPunkt = (TrafoPunkt)enumeration.nextElement();
            if (!trafoPunkt.getPunkt().equals(punkt)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getClassName() {
        return "TrafoSystem";
    }

    @Override
    public String getObjectName() {
        return this.getName();
    }

    @Override
    public String toDebugString() {
        return this.getClassName() + ": " + this.getObjectName();
    }

    @Override
    public String toDatLine() {
        StringBuffer stringBuffer = new StringBuffer(30);
        switch (this.rissInfo.getTyp()) {
            case 8: {
                stringBuffer.append("C!Trafo:");
                break;
            }
            case 9: {
                stringBuffer.append("C!Digit:");
                break;
            }
            case 2: {
                stringBuffer.append("C!Riss:");
                break;
            }
            default: {
                stringBuffer.append("C!Trafo:");
            }
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.rissInfo.toString());
        return stringBuffer.toString();
    }

    @Override
    public void writeDatContainer(PrintWriter printWriter) throws IOException {
        Object object;
        TrafoPunkt trafoPunkt = null;
        boolean bl = false;
        KafkaIOProperties.trafoParameter = this.parameter;
        printWriter.println(this.toDatLine());
        if (this.isSuperSystem) {
            object = new StringBuffer(60);
            ((StringBuffer)object).append(9);
            ((StringBuffer)object).append("  ");
            ((StringBuffer)object).append(this.parameter);
            ((StringBuffer)object).append("  ");
            ((StringBuffer)object).append(-1);
            ((StringBuffer)object).append("  ");
            ((StringBuffer)object).append(IFormat.f_6.format(this.superMasstab));
            printWriter.println(object);
        }
        object = this.elements();
        while (object.hasMoreElements()) {
            TrafoPunkt trafoPunkt2 = (TrafoPunkt)object.nextElement();
            if (!KafkaIOProperties.writeOffline && !trafoPunkt2.isOn() || KafkaIOProperties.writeMenge && !KafkaIOProperties.hasPunkt(trafoPunkt2.getPunkt())) continue;
            if (trafoPunkt == null) {
                trafoPunkt = (TrafoPunkt)trafoPunkt2.clone();
                if (this.isSuperSystem) {
                    trafoPunkt.setFirst(false);
                    if (this.parameter != 0) continue;
                    printWriter.println(trafoPunkt.toDatLine());
                    bl = true;
                    continue;
                }
                trafoPunkt.setFirst(true);
                continue;
            }
            if (!bl) {
                printWriter.println(trafoPunkt.toDatLine());
                bl = true;
            }
            printWriter.println(trafoPunkt2.toDatLine());
        }
    }

    public double getXMasstab() {
        if (this.my == 0.0) {
            this.computeParameter();
        }
        return this.mx;
    }

    public double getYMasstab() {
        if (this.my == 0.0) {
            this.computeParameter();
        }
        return this.my;
    }

    public double getXRotation() {
        if (this.my == 0.0) {
            this.computeParameter();
        }
        return this.tx;
    }

    public double getYRotation() {
        if (this.my == 0.0) {
            this.computeParameter();
        }
        return this.ty;
    }

    public double[] getTransformParam() {
        if (this.my == 0.0) {
            this.computeParameter();
        }
        double[] dArray = new double[]{this.mx * Math.cos(this.tx), this.my * -Math.sin(this.ty), this.my * Math.cos(this.ty), this.mx * Math.sin(this.tx)};
        return dArray;
    }

    public DPoint getSourceCenter() {
        return new DPoint(this.yas, this.xas);
    }

    public DPoint getDestCenter() {
        return new DPoint(this.yns, this.xns);
    }

    public DPoint getTransformPoint(DPoint dPoint) {
        if (this.my == 0.0) {
            this.computeParameter();
        }
        double d = this.mx * Math.cos(this.tx);
        double d2 = this.my * -Math.sin(this.ty);
        double d3 = this.my * Math.cos(this.ty);
        double d4 = this.mx * Math.sin(this.tx);
        return new DPoint(this.yns - d3 * this.yas - d4 * this.xas + d3 * dPoint.y + d4 * dPoint.x, this.xns - d * this.xas - d2 * this.yas + d * dPoint.x + d2 * dPoint.y);
    }

    public DPoint getInversePoint(DPoint dPoint) {
        if (this.my == 0.0) {
            this.computeParameter();
        }
        double d = this.mx * Math.cos(this.tx);
        double d2 = this.my * Math.sin(this.ty);
        double d3 = this.my * Math.cos(this.ty);
        double d4 = this.mx * Math.sin(this.tx);
        double d5 = d * d3 + d2 * d4;
        double d6 = d3 / d5;
        double d7 = d2 / d5;
        double d8 = d / d5;
        double d9 = -d4 / d5;
        double d10 = this.yns - d3 * this.yas - d4 * this.xas;
        double d11 = this.xns - d * this.xas + d2 * this.yas;
        return new DPoint(-d8 * d10 - d9 * d11 + d8 * dPoint.y + d9 * dPoint.x, -d6 * d11 - d7 * d10 + d6 * dPoint.x + d7 * dPoint.y);
    }

    private void computeParameter() {
        double d;
        double d2;
        double d3;
        double d4;
        this.yas = 0.0;
        this.xas = 0.0;
        this.yns = 0.0;
        this.xns = 0.0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            TrafoPunkt trafoPunkt = (TrafoPunkt)enumeration.nextElement();
            if (!trafoPunkt.isOn()) continue;
            this.yas += trafoPunkt.y;
            this.xas += trafoPunkt.x;
            this.yns += trafoPunkt.getPunkt().y;
            this.xns += trafoPunkt.getPunkt().x;
        }
        this.yas /= (double)this.size();
        this.xas /= (double)this.size();
        this.yns /= (double)this.size();
        this.xns /= (double)this.size();
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        Enumeration enumeration2 = this.elements();
        while (enumeration2.hasMoreElements()) {
            TrafoPunkt trafoPunkt = (TrafoPunkt)enumeration2.nextElement();
            if (!trafoPunkt.isOn()) continue;
            d4 = trafoPunkt.y - this.yas;
            d3 = trafoPunkt.x - this.xas;
            d2 = trafoPunkt.getPunkt().y - this.yns;
            d = trafoPunkt.getPunkt().x - this.xns;
            d5 += d4 * d4;
            d6 += d3 * d3;
            d7 += d3 * d4;
            d8 += d3 * d2;
            d9 += d3 * d;
            d10 += d4 * d2;
            d11 += d4 * d;
        }
        double d12 = d6 * d5 - d7 * d7;
        d4 = d9 * d5 / d12 - d11 * d7 / d12;
        d3 = d9 * d7 / d12 - d11 * d6 / d12;
        d2 = d10 * d6 / d12 - d8 * d7 / d12;
        d = d8 * d5 / d12 - d10 * d7 / d12;
        double d13 = d5 + d6;
        double d14 = (d8 - d11) / d13;
        double d15 = (d9 + d10) / d13;
        switch (this.parameter) {
            case 3: {
                this.my = 1.0;
                this.mx = 1.0;
                this.tx = this.ty = Math.atan2(d14, d15);
                break;
            }
            default: {
                this.mx = this.my = Math.sqrt(d14 * d14 + d15 * d15);
                this.tx = this.ty = Math.atan2(d14, d15);
                break;
            }
            case 5: {
                this.mx = Math.sqrt(d4 * d4 + d * d);
                this.my = Math.sqrt(d3 * d3 + d2 * d2);
                this.tx = this.ty = Math.atan2(d14, d15);
                break;
            }
            case 6: {
                this.mx = Math.sqrt(d4 * d4 + d * d);
                this.my = Math.sqrt(d3 * d3 + d2 * d2);
                this.tx = Math.atan2(d, d4);
                this.ty = Math.atan2(d3, d2);
            }
        }
    }

    public void writeXmlLine(PrintWriter printWriter) throws IOException {
        String[] stringArray = new String[this.getName() == null ? 3 : 4];
        stringArray[0] = XmlIOProperties.att("id", Integer.toString(this.nr));
        stringArray[1] = XmlIOProperties.att("par", Integer.toString(this.parameter));
        stringArray[2] = XmlIOProperties.att("ts", this.getStatusAsString());
        if (this.getName() != null) {
            stringArray[3] = XmlIOProperties.att("name", this.getName());
        }
        printWriter.println(XmlIOProperties.open("trafosystem", stringArray));
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            printWriter.println(((TrafoPunkt)enumeration.nextElement()).toXmlLine());
        }
        printWriter.println(XmlIOProperties.close("trafosystem"));
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(31);
        KafPlotIOConstants.writeString(dataOutput, this.getName());
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ((TrafoPunkt)enumeration.nextElement()).writeObject(dataOutput);
        }
        dataOutput.writeByte(0);
    }

    public static TrafoSystem readObject(DataInput dataInput) throws IOException {
        byte by;
        TrafoSystem trafoSystem = new TrafoSystem(0);
        trafoSystem.setName(KafPlotIOConstants.readString(dataInput));
        while ((by = dataInput.readByte()) != -1 && by == 32) {
            trafoSystem.addElement(TrafoPunkt.readObject(dataInput));
        }
        return trafoSystem;
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        this.drawBackground(iGraphics, bl, bl2);
        this.drawForeground(iGraphics, bl, bl2);
        this.drawInscription(iGraphics, bl, bl2);
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    @Override
    public void drawForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
    }
}

