/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ErrorDialog;
import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.IProgressBar;
import de.geocalc.awt.ITextField;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.GeomElement;
import de.geocalc.geom.GeomException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.ErrorObject;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.PropertyLoader;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktNummer;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.event.DataBaseEvent;
import de.geocalc.kafplot.event.DataBaseListener;
import de.geocalc.text.IFormat;
import de.geocalc.util.Comparator;
import de.geocalc.util.LongHashObject;
import de.geocalc.util.SortableVector;
import de.geocalc.util.sml.Tag;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class UmnumPointsDialog
extends IDialog
implements ActionListener,
ItemListener,
TextListener,
DataBaseListener {
    private static final String DO_COMMAND = "Erzeugen";
    private static final String OK_COMMAND = "OK";
    private static final String ABORT_COMMAND = "Abbrechen";
    protected ActionListener listener;
    protected DataBase db;
    protected IProgressBar progressBar;
    protected Label amtLabel;
    protected Label lokLabel;
    protected Label nrLenLabel;
    protected Label progressLabel;
    private ITextField newNrTextField;
    private ITextField addNrTextField;
    private ITextField flsNrTextField;
    private Checkbox expandCheckbox;
    private Checkbox reduceCheckbox;
    private Checkbox amtCheckbox;
    private Checkbox lokCheckbox;
    private Checkbox newNrCheckbox;
    private Checkbox addNrCheckbox;
    private Checkbox flsNrCheckbox;
    private Checkbox umnNrCheckbox;
    private Checkbox umnCheckbox;
    private Checkbox endCheckbox;
    private Checkbox useDefaultGmkNumbers;
    private Choice expandChoice;
    private Choice reduceChoice;
    private Choice umnChoice;
    protected Button doButton;
    protected Button okButton;
    protected Button abortButton;
    protected Button filterButton;
    private int lokPointCount = 0;
    private int amtPointCount = 0;
    protected ExceptionList errList = new ExceptionList();
    private int umnumPoints = 0;
    private int notPoints = 0;
    private boolean hasDefaultGmkNumbers = false;

    public UmnumPointsDialog(IFrame iFrame, String string, DataBase dataBase) {
        super(iFrame, string, false);
        this.db = dataBase;
        DataBase.addDataBaseListener(this);
        try {
            InputStream inputStream;
            String string2 = "gemarkungen.pnr.properties";
            InputStream inputStream2 = inputStream = new File(string2).exists() ? new FileInputStream(new File(string2)) : this.getClass().getResourceAsStream("/" + string2);
            if (inputStream != null) {
                this.hasDefaultGmkNumbers = true;
                inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.countPoints();
        this.setLayout(new BorderLayout());
        this.add("North", this.createDialogPanel());
        this.add("South", this.createButtonPanel());
        this.pack();
        this.setLocationOfParent(iFrame, -11);
        this.setResizable(false);
    }

    private void countPoints() {
        Enumeration enumeration;
        UmnumPointsDialog umnumPointsDialog = this;
        Enumeration enumeration2 = umnumPointsDialog.db.hasMenge() ? DataBase.MENGE.elements() : (enumeration = DataBase.P.elements());
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            if (punkt.isKatasterPunkt()) {
                ++this.amtPointCount;
                continue;
            }
            ++this.lokPointCount;
        }
    }

    @Override
    public void dataBaseUpdated(DataBaseEvent dataBaseEvent) {
        this.countPoints();
        this.setCountLabel();
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    @Override
    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    @Override
    public String getActionCommand() {
        return this.actionCommand;
    }

    protected Panel createDialogPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.fill = 2;
        Panel panel = new Panel(gridBagLayout);
        IPanel iPanel = null;
        iPanel = this.createActionPanel();
        panel.add(iPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(iPanel, gridBagConstraints);
        iPanel = this.createOptionPanel();
        panel.add(iPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(iPanel, gridBagConstraints);
        iPanel = this.createProgressPanel();
        panel.add(iPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(iPanel, gridBagConstraints);
        return panel;
    }

    private IPanel createOptionPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Auswahl"));
        this.lokCheckbox = new Checkbox("lokale Punkte", false);
        iPanel.add(this.lokCheckbox);
        this.lokCheckbox.addItemListener(this);
        this.lokCheckbox.setEnabled(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.lokCheckbox, gridBagConstraints);
        UmnumPointsDialog umnumPointsDialog = this;
        this.lokLabel = new Label(this.lokPointCount + " lokale " + (umnumPointsDialog.db.hasMenge() ? " Mengenpunkte" : "Punkte"));
        iPanel.add(this.lokLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.lokLabel, gridBagConstraints);
        this.amtCheckbox = new Checkbox("amtliche Punkte", true);
        iPanel.add(this.amtCheckbox);
        this.amtCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.amtCheckbox, gridBagConstraints);
        UmnumPointsDialog umnumPointsDialog2 = this;
        this.amtLabel = new Label(this.amtPointCount + " amtliche " + (umnumPointsDialog2.db.hasMenge() ? " Mengenpunkte" : "Punkte"));
        iPanel.add(this.amtLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.amtLabel, gridBagConstraints);
        return iPanel;
    }

    private IPanel createActionPanel() {
        int n;
        int n2 = DataBase.model.getModel();
        String[] stringArray = PunktNummer.getNames(n2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Aktion"));
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.reduceCheckbox = new Checkbox("Nummer reduzieren:", true, checkboxGroup);
        iPanel.add(this.reduceCheckbox);
        this.reduceCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.reduceCheckbox, gridBagConstraints);
        this.reduceChoice = new Choice();
        iPanel.add(this.reduceChoice);
        for (n = 0; n < stringArray.length; ++n) {
            this.reduceChoice.addItem(stringArray[n]);
        }
        this.reduceChoice.select(0);
        this.reduceChoice.setEnabled(true);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.reduceChoice, gridBagConstraints);
        this.expandCheckbox = new Checkbox("Nummer erweitern:", false, checkboxGroup);
        iPanel.add(this.expandCheckbox);
        this.expandCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.expandCheckbox, gridBagConstraints);
        this.expandChoice = new Choice();
        iPanel.add(this.expandChoice);
        for (n = 0; n < stringArray.length; ++n) {
            this.expandChoice.addItem(stringArray[n]);
        }
        this.expandChoice.select(0);
        this.expandChoice.setEnabled(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.expandChoice, gridBagConstraints);
        this.newNrCheckbox = new Checkbox("neue Nummer:", false, checkboxGroup);
        iPanel.add(this.newNrCheckbox);
        this.newNrCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.newNrCheckbox, gridBagConstraints);
        this.newNrTextField = new ITextField("10000", 6);
        iPanel.add(this.newNrTextField);
        this.newNrTextField.addTextListener(this);
        this.newNrTextField.setEnabled(true);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.newNrTextField, gridBagConstraints);
        Label label = new Label("fortlaufend");
        iPanel.add(label);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.addNrCheckbox = new Checkbox("Zuschlag:", false, checkboxGroup);
        iPanel.add(this.addNrCheckbox);
        this.addNrCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.addNrCheckbox, gridBagConstraints);
        this.addNrTextField = new ITextField("10000", 6);
        iPanel.add(this.addNrTextField);
        this.addNrTextField.addTextListener(this);
        this.addNrTextField.setEnabled(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.addNrTextField, gridBagConstraints);
        label = new Label("fest");
        iPanel.add(label);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.flsNrCheckbox = new Checkbox("Gmk+Flur+", false, checkboxGroup);
        iPanel.add(this.flsNrCheckbox);
        this.flsNrCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.flsNrCheckbox, gridBagConstraints);
        this.flsNrTextField = new ITextField("70001", 4);
        iPanel.add(this.flsNrTextField);
        this.flsNrTextField.addTextListener(this);
        this.flsNrTextField.setEnabled(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.flsNrTextField, gridBagConstraints);
        this.nrLenLabel = new Label("5-stellig fortlaufend");
        iPanel.add(this.nrLenLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.nrLenLabel, gridBagConstraints);
        if (this.hasDefaultGmkNumbers) {
            this.useDefaultGmkNumbers = new Checkbox("mit Vorgabe", true);
            iPanel.add(this.useDefaultGmkNumbers);
            this.useDefaultGmkNumbers.setEnabled(false);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 4;
            gridBagLayout.setConstraints(this.useDefaultGmkNumbers, gridBagConstraints);
        }
        this.umnNrCheckbox = new Checkbox("aus Umnumliste:", false, checkboxGroup);
        iPanel.add(this.umnNrCheckbox);
        this.umnNrCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.umnNrCheckbox, gridBagConstraints);
        this.umnChoice = new Choice();
        iPanel.add(this.umnChoice);
        for (n = 0; n < stringArray.length; ++n) {
            this.umnChoice.addItem(stringArray[n]);
        }
        this.umnChoice.select(0);
        this.umnChoice.setEnabled(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.umnChoice, gridBagConstraints);
        label = new Label("Ergebnis als:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        checkboxGroup = new CheckboxGroup();
        this.endCheckbox = new Checkbox("endg\u00fcltige Nummer", true, checkboxGroup);
        iPanel.add(this.endCheckbox);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.endCheckbox, gridBagConstraints);
        this.umnCheckbox = new Checkbox("Umnummerierung", false, checkboxGroup);
        iPanel.add(this.umnCheckbox);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.umnCheckbox, gridBagConstraints);
        return iPanel;
    }

    private IPanel createProgressPanel() {
        IPanel iPanel = new IPanel(new BorderLayout());
        iPanel.setBorder(new IBorder(1));
        this.progressBar = new IProgressBar();
        iPanel.add("North", this.progressBar);
        this.progressLabel = new Label("   ");
        iPanel.add("South", this.progressLabel);
        return iPanel;
    }

    private Panel createButtonPanel() {
        Panel panel = new Panel(new FlowLayout(2));
        this.doButton = new Button(DO_COMMAND);
        this.doButton.addActionListener(this);
        panel.add(this.doButton);
        this.okButton = new Button(OK_COMMAND);
        this.okButton.addActionListener(this);
        this.okButton.setEnabled(false);
        panel.add(this.okButton);
        this.abortButton = new Button(ABORT_COMMAND);
        this.abortButton.addActionListener(this);
        panel.add(this.abortButton);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(DO_COMMAND)) {
            this.doStandardAction();
            boolean bl = this.umnumPoints > 0 || this.notPoints > 0;
            this.doButton.setEnabled(!bl);
            this.okButton.setEnabled(bl);
            this.abortButton.setEnabled(!bl);
        } else if (string.equals(OK_COMMAND)) {
            this.saveErgs();
            if (this.umnumPoints > 0) {
                DataBase.isSaved = false;
            }
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_data_update"));
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_repaint"));
            }
            this.endDialog();
        } else if (string.equals(ABORT_COMMAND)) {
            this.endDialog();
        }
    }

    @Override
    public void textValueChanged(TextEvent textEvent) {
        Object object = textEvent.getSource();
        if (object == this.newNrTextField) {
            this.newNrTextField.setForeground(IFormat.hasOnlyNumbers(this.newNrTextField.getText().trim()) ? Color.black : Color.red);
        } else if (object == this.addNrTextField) {
            this.addNrTextField.setForeground(IFormat.hasOnlyNumbers(this.addNrTextField.getText().trim()) ? Color.black : Color.red);
        } else if (object == this.flsNrTextField) {
            this.flsNrTextField.setForeground(IFormat.hasOnlyNumbers(this.flsNrTextField.getText().trim()) ? Color.black : Color.red);
            int n = this.flsNrTextField.getText().trim().length();
            this.nrLenLabel.setText(n + "-stellig fortlaufend");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        this.reduceChoice.setEnabled(this.reduceCheckbox.getState());
        this.expandChoice.setEnabled(this.expandCheckbox.getState());
        this.newNrTextField.setEnabled(this.newNrCheckbox.getState());
        this.addNrTextField.setEnabled(this.addNrCheckbox.getState());
        this.flsNrTextField.setEnabled(this.flsNrCheckbox.getState());
        if (this.useDefaultGmkNumbers != null) {
            this.useDefaultGmkNumbers.setEnabled(this.flsNrCheckbox.getState());
        }
        this.umnChoice.setEnabled(this.umnNrCheckbox.getState());
        if (this.reduceCheckbox.getState() || this.expandCheckbox.getState()) {
            this.lokCheckbox.setState(false);
            this.lokCheckbox.setEnabled(false);
        } else {
            this.lokCheckbox.setEnabled(true);
        }
        this.lokLabel.setEnabled(this.lokCheckbox.getState());
        this.amtLabel.setEnabled(this.amtCheckbox.getState());
    }

    private void setCountLabel() {
        UmnumPointsDialog umnumPointsDialog = this;
        this.lokLabel.setText(this.lokPointCount + " lokale " + (umnumPointsDialog.db.hasMenge() ? " Mengenpunkte" : "Punkte"));
        UmnumPointsDialog umnumPointsDialog2 = this;
        this.amtLabel.setText(this.amtPointCount + " amtliche " + (umnumPointsDialog2.db.hasMenge() ? " Mengenpunkte" : "Punkte"));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void doStandardAction() {
        block59: {
            block64: {
                block62: {
                    block61: {
                        block60: {
                            block58: {
                                var1_1 = 0L;
                                var3_2 = -1;
                                this.newNrTextField.setForeground(Color.black);
                                this.addNrTextField.setForeground(Color.black);
                                this.flsNrTextField.setForeground(Color.black);
                                if (this.newNrCheckbox.getState()) {
                                    try {
                                        var1_1 = Long.parseLong(this.newNrTextField.getText().trim());
                                    }
                                    catch (Exception var4_3) {
                                        this.newNrTextField.setForeground(Color.red);
                                        return;
                                    }
                                }
                                if (this.addNrCheckbox.getState()) {
                                    try {
                                        var1_1 = Long.parseLong(this.addNrTextField.getText().trim());
                                    }
                                    catch (Exception var4_4) {
                                        this.addNrTextField.setForeground(Color.red);
                                        return;
                                    }
                                }
                                if (this.flsNrCheckbox.getState()) {
                                    try {
                                        var4_5 = this.flsNrTextField.getText().trim();
                                        var3_2 = var4_5.length();
                                        var1_1 = Long.parseLong((String)var4_5);
                                    }
                                    catch (Exception var4_6) {
                                        this.flsNrTextField.setForeground(Color.red);
                                        return;
                                    }
                                }
                                var4_5 = new Hashtable<K, V>();
                                var5_7 = DataBase.P.elements();
                                while (var5_7.hasMoreElements()) {
                                    var6_8 = (Punkt)var5_7.nextElement();
                                    if (var6_8.getUmnum() <= 0L) continue;
                                    var4_5.put(new Long(var6_8.getUmnum()), var6_8);
                                }
                                var5_7 = new Hashtable<K, V>();
                                var6_8 = DataBase.P.elements();
                                while (var6_8.hasMoreElements()) {
                                    var7_10 = (Punkt)var6_8.nextElement();
                                    if (!var7_10.isMasterPoint() && !var7_10.isIndirektPoint()) continue;
                                    var5_7.put(new Long(var7_10.nr), var7_10);
                                }
                                this.progressLabel.setText("...");
                                this.progressBar.setValue(0);
                                v0 = this;
                                var6_9 = v0.db.hasMenge() ? DataBase.MENGE.size() : DataBase.P.size();
                                this.umnumPoints = 0;
                                this.notPoints = 0;
                                var7_11 = 0;
                                var8_12 = 0;
                                var9_13 = this.amtCheckbox.getState();
                                var10_14 = this.lokCheckbox.getState();
                                v1 = this;
                                var11_15 = v1.db.hasMenge() ? DataBase.MENGE : new PunktTable();
                                v2 = this;
                                if (!v2.db.hasMenge()) {
                                    var12_16 = DataBase.P.elements();
                                    while (var12_16.hasMoreElements()) {
                                        var11_15.put((Punkt)var12_16.nextElement());
                                    }
                                }
                                if (!this.reduceCheckbox.getState()) break block58;
                                var12_17 = PunktNummer.getLength(this.reduceChoice.getSelectedItem());
                                var13_21 = PunktNummer.getMinUsableNumber(var12_17);
                                var15_28 = new SortableVector(100);
                                var16_33 = var11_15.elements();
                                while (var16_33.hasMoreElements()) {
                                    var17_34 = (Punkt)var16_33.nextElement();
                                    if (!var9_13 || !var17_34.isKatasterPunkt() || var17_34.nr <= var13_21) continue;
                                    var15_28.addElement(var17_34);
                                }
                                var15_28.sort(new DistanceComparator(this, KafPlotProperties.getGrafikCenter()));
                                var16_33 = var15_28.elements();
                                while (var16_33.hasMoreElements()) {
                                    var17_34 = (Punkt)var16_33.nextElement();
                                    var1_1 = var17_34.buildKatNr(var12_17, var17_34.nr);
                                    if (DataBase.P.get(var1_1) == null) {
                                        if (this.umnum((Punkt)var17_34, var1_1, (Hashtable)var4_5)) {
                                            ++this.umnumPoints;
                                        }
                                    } else {
                                        var18_35 = var12_17;
                                        do {
                                            var18_35 = PunktNummer.getRaised(var18_35);
                                            var1_1 = var17_34.buildKatNr(var18_35, var17_34.nr);
                                            if (DataBase.P.get(var1_1) != null || !this.umnum((Punkt)var17_34, var1_1, (Hashtable)var4_5)) continue;
                                            ++this.umnumPoints;
                                            break;
                                        } while (var18_35 > 0 && var18_35 != var12_17);
                                    }
                                    var7_11 = this.showProgress(var8_12, var6_9, var7_11, this.umnumPoints, this.notPoints);
                                    ++var8_12;
                                }
                                break block59;
                            }
                            if (!this.expandCheckbox.getState()) break block60;
                            var12_18 = PunktNummer.getLength(this.expandChoice.getSelectedItem());
                            var13_22 = var11_15.elements();
                            while (var13_22.hasMoreElements()) {
                                var14_39 = (Punkt)var13_22.nextElement();
                                if (var9_13 && var14_39.isKatasterPunkt() && (var1_1 = var14_39.buildKatNr(var12_18, var14_39.nr)) != var14_39.nr && this.umnum(var14_39, var1_1, (Hashtable)var4_5)) {
                                    ++this.umnumPoints;
                                }
                                var7_11 = this.showProgress(var8_12, var6_9, var7_11, this.umnumPoints, this.notPoints);
                            }
                            break block59;
                        }
                        if (!this.newNrCheckbox.getState()) break block61;
                        var12_16 = var11_15.elements();
                        while (var12_16.hasMoreElements()) {
                            var13_23 = (Punkt)var12_16.nextElement();
                            if (!(var13_23.isKatasterPunkt() == false ? var10_14 == false : var9_13 == false)) {
                                if (this.endCheckbox.getState()) {
                                    var14_40 = null;
                                    while (true) {
                                        var14_40 = (Punkt)DataBase.P.get(var1_1);
                                        if (var14_40 == null) break;
                                        this.errList.addException(new GeomException(var14_40, var14_40, "Die Nummer " + var1_1 + " ist bereits vorhanden und wurde \u00fcbersprungen"));
                                        ++var1_1;
                                    }
                                }
                                if (this.umnum(var13_23, var1_1, (Hashtable)var4_5)) {
                                    ++this.umnumPoints;
                                }
                                ++var1_1;
                                var7_11 = this.showProgress(var8_12, var6_9, var7_11, this.umnumPoints, this.notPoints);
                            }
                            ++var8_12;
                        }
                        break block59;
                    }
                    if (!this.addNrCheckbox.getState()) break block62;
                    var12_16 = var11_15.elements();
                    while (var12_16.hasMoreElements()) {
                        block63: {
                            var13_24 = (Punkt)var12_16.nextElement();
                            if (var13_24.isKatasterPunkt() != false ? var9_13 == false : var10_14 == false) break block63;
                            var14_41 = var13_24.nr + var1_1;
                            if (!this.endCheckbox.getState()) ** GOTO lbl-1000
                            var16_33 = (Punkt)DataBase.P.get(var14_41);
                            if (var16_33 != null) {
                                this.errList.addException(new GeomException(var13_24, new DLine(var13_24, (DPoint)var16_33), "Die Nummer " + var14_41 + " ist bereits vorhanden, der Punkt " + var13_24.nr + " wurde nicht umnummeriert"));
                                ++this.notPoints;
                            } else lbl-1000:
                            // 2 sources

                            {
                                if (this.umnum(var13_24, var14_41, (Hashtable)var4_5)) {
                                    ++this.umnumPoints;
                                }
                                var7_11 = this.showProgress(var8_12, var6_9, var7_11, this.umnumPoints, this.notPoints);
                            }
                        }
                        ++var8_12;
                    }
                    break block59;
                }
                if (!this.flsNrCheckbox.getState()) break block64;
                var12_16 = new PunktTable();
                var13_25 = var11_15.elements();
                while (var13_25.hasMoreElements()) {
                    var14_42 = (Punkt)var13_25.nextElement();
                    if (var14_42.isKatasterPunkt() != false ? var9_13 == false : var10_14 == false) continue;
                    var12_16.put((LongHashObject)var14_42);
                }
                var6_9 = var12_16.size();
                var13_25 = new Hashtable<K, V>();
                if (this.hasDefaultGmkNumbers && this.useDefaultGmkNumbers.getState()) {
                    try {
                        var14_42 = "gemarkungen.pnr.properties";
                        var15_29 = new File((String)var14_42).exists() != false ? new FileInputStream(new File((String)var14_42)) : this.getClass().getResourceAsStream("/" + (String)var14_42);
                        this.load((InputStream)var15_29, (Hashtable)var13_25, var3_2);
                    }
                    catch (Exception var14_43) {
                        var15_29 = new ErrorDialog(this.parent, var14_43);
                        var15_29.setVisible(true);
                    }
                }
                var14_44 = (long)Math.pow(10.0, var3_2) - 1L;
                var16_33 = DataBase.FLST.elements();
                while (var16_33.hasMoreElements()) {
                    var17_34 = (Flurstueck)var16_33.nextElement();
                    if (!var17_34.isArea()) continue;
                    var18_36 = var17_34.getBounds();
                    var19_50 = var17_34.getPolygon();
                    var20_52 = ((long)var17_34.getGemarkung() % 10000L * 1000L + (long)var17_34.getFlur()) * (long)Math.pow(10.0, var3_2);
                    var22_53 = (Long)var13_25.get(new Long(var20_52));
                    var23_55 = var22_53 != null ? var22_53.longValue() : var1_1;
                    var25_58 = var12_16.elements();
                    while (var25_58.hasMoreElements()) {
                        var26_59 = (Punkt)var25_58.nextElement();
                        if (!var18_36.contains(var26_59) || !var19_50.contains(var26_59)) continue;
                        var12_16.remove(var26_59);
                        ++var8_12;
                        if (var23_55 > var14_44) {
                            this.errList.addException(new GeomException(var26_59, var26_59, "Punkt " + var26_59.nr + " \u00fcberschreitet maximalen Nummernbereich " + var14_44 + ", Punkt wird ignoriert"));
                            ++this.notPoints;
                            continue;
                        }
                        var27_60 = var20_52 + var23_55;
                        if (this.umnum(var26_59, var27_60, (Hashtable)var4_5)) {
                            ++this.umnumPoints;
                            var13_25.put(new Long(var20_52), new Long(++var23_55));
                        }
                        var7_11 = this.showProgress(var8_12, var6_9, var7_11, this.umnumPoints, this.notPoints);
                    }
                }
                var16_33 = new Hashtable<K, V>();
                var17_34 = DataBase.FLST.elements();
                while (var17_34.hasMoreElements()) {
                    var18_36 = (Flurstueck)var17_34.nextElement();
                    var19_50 = var18_36.getPunkte();
                    var20_52 = ((long)var18_36.getGemarkung() % 10000L * 1000L + (long)var18_36.getFlur()) * (long)Math.pow(10.0, var3_2);
                    var22_53 = var19_50.elements();
                    while (var22_53.hasMoreElements()) {
                        var23_57 = (Punkt)var22_53.nextElement();
                        if (!var12_16.contains(var23_57) || (var24_61 = (Long)var16_33.get(var23_57)) != null && var24_61 <= var20_52) continue;
                        var16_33.put(var23_57, new Long(var20_52));
                    }
                }
                var17_34 = var16_33.keys();
                while (var17_34.hasMoreElements()) {
                    var18_36 = (Punkt)var17_34.nextElement();
                    var19_51 = (Long)var16_33.get(var18_36);
                    var21_63 = (Long)var13_25.get(new Long(var19_51));
                    var22_54 = var21_63 != null ? var21_63 : var1_1;
                    var12_16.remove((LongHashObject)var18_36);
                    ++var8_12;
                    if (var22_54 > var14_44) {
                        this.errList.addException(new GeomException((DPoint)var18_36, (GeomElement)var18_36, "Punkt " + var18_36.nr + " \u00fcberschreitet maximalen Nummernbereich " + var14_44 + ", Punkt wird ignoriert"));
                        ++this.notPoints;
                        continue;
                    }
                    var24_62 = var19_51 + var22_54;
                    if (this.umnum((Punkt)var18_36, var24_62, (Hashtable)var4_5)) {
                        ++this.umnumPoints;
                        var13_25.put(new Long(var19_51), new Long(++var22_54));
                    }
                    var7_11 = this.showProgress(var8_12, var6_9, var7_11, this.umnumPoints, this.notPoints);
                }
                var17_34 = var12_16.elements();
                while (var17_34.hasMoreElements()) {
                    var18_36 = (Punkt)var17_34.nextElement();
                    this.errList.addException(new GeomException((DPoint)var18_36, (GeomElement)var18_36, "Punkt " + var18_36.nr + " liegt in keiner Flurst\u00fccksfl\u00e4che, Punkt wurde ignoriert"));
                }
                break block59;
            }
            if (!this.umnNrCheckbox.getState()) break block59;
            var12_19 = PunktNummer.getLength(this.umnChoice.getSelectedItem());
            var13_26 = var11_15.elements();
            while (var13_26.hasMoreElements()) {
                block65: {
                    block66: {
                        var14_45 = (Punkt)var13_26.nextElement();
                        if ((var14_45.isKatasterPunkt() == false ? var10_14 == false : var9_13 == false) || var14_45.getUmnum() <= 0L) break block65;
                        var15_30 = var14_45.buildKatNr(var12_19, var14_45.getUmnum());
                        if (!this.umnCheckbox.getState()) break block66;
                        if (var15_30 == var14_45.getUmnum()) {
                            this.errList.addException(new GeomException(var14_45, var14_45, "Punkt " + var14_45.nr + " besitzt bereits die Umnummerierung " + var15_30));
                        } else {
                            var17_34 = (Punkt)DataBase.P.get(var15_30);
                            if (var17_34 != null) {
                                this.errList.addException(new GeomException(var14_45, new DLine(var14_45, (DPoint)var17_34), "Punkt " + var14_45.nr + " erh\u00e4lt die Umnummerierung " + var15_30 + ", diese Nummer ist bereits als Auftragspunkt vorhanden"));
                            }
                            if ((var17_34 = (Punkt)var4_5.get(new Long(var15_30))) != null) {
                                this.errList.addException(new GeomException(var14_45, new DLine(var14_45, (DPoint)var17_34), "Punkt " + var14_45.nr + " erh\u00e4lt die Umnummerierung " + var15_30 + ", diese Nummer ist bereits als Umnummerierung vorhanden"));
                            }
                            var14_45.setUmnum(var15_30);
                        }
                        ** GOTO lbl282
                    }
                    var17_34 = (Punkt)DataBase.P.get(var15_30);
                    if (var17_34 != null) {
                        this.errList.addException(new GeomException(var14_45, new DLine(var14_45, (DPoint)var17_34), "Die Nummer " + var15_30 + " ist bereits vorhanden, der Punkt " + var14_45.nr + " wurde nicht umnummeriert"));
                        ++this.notPoints;
                    } else {
                        DataBase.P.remove(var14_45);
                        var14_45.nr = var15_30;
                        DataBase.P.put(var14_45);
                        var14_45.setUmnum(0L);
                        var14_45.setFlagUM_PNR(false);
lbl282:
                        // 3 sources

                        ++this.umnumPoints;
                        var7_11 = this.showProgress(var8_12, var6_9, var7_11, this.umnumPoints, this.notPoints);
                    }
                }
                ++var8_12;
            }
        }
        this.sleep();
        var12_20 = DataBase.P.elements();
        while (var12_20.hasMoreElements()) {
            var13_27 = (Punkt)var12_20.nextElement();
            if (var13_27.hasTag("REF")) {
                try {
                    var14_46 = var13_27.getTag("REF").getValue();
                    var15_31 = Long.parseLong(var14_46);
                    var17_34 = (Punkt)var5_7.get(new Long(var15_31));
                    if (var15_31 != var17_34.nr) {
                        var18_38 = var13_27.getBemerkung();
                        var18_38 = Tag.removeTag((String)var18_38, "REF");
                        var18_38 = Tag.toString("REF", Long.toString(var17_34.nr)) + (String)var18_38;
                        var13_27.setBemerkung((String)var18_38);
                    }
                }
                catch (Exception var14_47) {
                    this.errList.addException(new GeomException(var13_27, var13_27, "Fehler bei der Umnummerierung der Referenz REF des Punktes " + var13_27.nr));
                }
            }
            if (!var13_27.hasTag("IND")) continue;
            try {
                var14_48 = var13_27.getTag("IND").getValue();
                var15_32 = Long.parseLong(var14_48);
                var17_34 = (Punkt)var5_7.get(new Long(var15_32));
                if (var15_32 == var17_34.nr) continue;
                var18_38 = var13_27.getBemerkung();
                var18_38 = Tag.removeTag((String)var18_38, "IND");
                var18_38 = Tag.toString("IND", Long.toString(var17_34.nr)) + (String)var18_38;
                var13_27.setBemerkung((String)var18_38);
            }
            catch (Exception var14_49) {
                this.errList.addException(new GeomException(var13_27, var13_27, "Fehler bei der Umnummerierung der Referenz IND des Punktes " + var13_27.nr));
            }
        }
        this.progressBar.setValue(100);
        this.progressLabel.setText(this.umnumPoints + " umnummeriert, " + this.notPoints + " ignoriert, " + this.errList.size() + " Fehlermeldungen");
        this.okButton.setEnabled(true);
        this.sleep();
    }

    private int showProgress(int n, int n2, int n3, int n4, int n5) {
        int n6 = n * 100 / n2;
        if (n6 % 5 == 0 && n6 != n3) {
            this.progressBar.setValue(n6);
            this.progressLabel.setText(n4 + " umnummeriert, " + n5 + " ignoriert, " + this.errList.size() + " Fehlermeldungen");
            this.sleep();
        }
        return n6;
    }

    private boolean umnum(Punkt punkt, long l, Hashtable hashtable) {
        if (this.umnCheckbox.getState()) {
            Punkt punkt2 = (Punkt)DataBase.P.get(l);
            if (punkt2 != null) {
                this.errList.addException(new GeomException(punkt, new DLine(punkt, punkt2), "Punkt " + punkt.nr + " erh\u00e4lt die Umnummerierung " + l + ", diese Nummer ist bereits als Auftragspunkt vorhanden"));
            }
            if ((punkt2 = (Punkt)hashtable.get(new Long(l))) != null) {
                this.errList.addException(new GeomException(punkt, new DLine(punkt, punkt2), "Punkt " + punkt.nr + " erh\u00e4lt die Umnummerierung " + l + ", diese Nummer ist bereits als Umnummerierung vorhanden"));
            }
            if (punkt.getUmnum() > 0L) {
                this.errList.addException(new GeomException(punkt, punkt, "Punkt " + punkt.nr + " erh\u00e4lt die Umnummerierung " + l + ", die vorhandene Umnummerierung " + punkt.getUmnum() + " wird \u00fcberschrieben"));
            }
            punkt.setUmnum(l);
            punkt.setFlagUM_PNR(true);
            if (!DataBase.UMNUM.contains(punkt)) {
                DataBase.UMNUM.addElement(punkt);
            }
        } else {
            Punkt punkt3 = (Punkt)hashtable.get(new Long(l));
            if (punkt3 != null) {
                this.errList.addException(new GeomException(punkt, new DLine(punkt, punkt3), "Punkt " + punkt.nr + " erh\u00e4lt die neue Nummer " + l + ", diese Nummer ist bereits als Umnummerierung vorhanden"));
            }
            if (punkt.getUmnum() > 0L) {
                this.errList.addException(new GeomException(punkt, punkt, "Punkt " + punkt.nr + " erh\u00e4lt die neue Nummer " + l + ", die vorhandene Umnummerierung " + punkt.getUmnum() + " bleibt erhalten"));
            }
            DataBase.P.remove(punkt);
            punkt.nr = l;
            DataBase.P.put(punkt);
        }
        return true;
    }

    private void saveErgs() {
        Enumeration enumeration = this.errList.elements();
        while (enumeration.hasMoreElements()) {
            DataBase.ERR.addElement(new ErrorObject("UmnumPoints", (GeomException)enumeration.nextElement()));
        }
    }

    private void sleep() {
        try {
            Thread.sleep(5L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }

    public void load(InputStream inputStream, Hashtable hashtable, int n) throws IOException {
        LineNumberReader lineNumberReader = null;
        try {
            String string;
            lineNumberReader = PropertyLoader.createReader(inputStream);
            while ((string = lineNumberReader.readLine()) != null) {
                if (string.length() == 0 || string.startsWith("#")) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
                String string2 = "";
                String string3 = "";
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new IOException("GemarkungFlurSchl\u00fcssel fehlt");
                }
                string2 = stringTokenizer.nextToken().trim();
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new IOException("Punktnummer fehlt");
                }
                string3 = stringTokenizer.nextToken().trim();
                int n2 = string2.indexOf(".");
                if (n2 < 0) {
                    throw new IOException("ung\u00fcltiger GemarkungFlurSchl\u00fcssel: " + string2 + ", Vorgabe: 122603.001");
                }
                long l = Long.parseLong(string2.substring(0, n2));
                long l2 = Long.parseLong(string2.substring(n2 + 1));
                if (string3.length() != n) {
                    throw new IOException("Stellenanzahl von " + string3 + " passt nicht zur Vorgabenummer");
                }
                long l3 = Long.parseLong(string3);
                long l4 = (l % 10000L * 1000L + l2) * (long)Math.pow(10.0, n);
                hashtable.put(new Long(l4), new Long(l3));
            }
        }
        catch (IOException iOException) {
            throw new IOException("gemarkungen.pnr.properties Fehler in Zeile: " + (lineNumberReader != null ? lineNumberReader.getLineNumber() : 0) + "\n" + iOException.getMessage());
        }
        catch (Exception exception) {
            throw new IOException("gemarkungen.pnr.properties Fehler in Zeile: " + (lineNumberReader != null ? lineNumberReader.getLineNumber() : 0) + "\n" + exception.getMessage());
        }
    }

    private class DistanceComparator
    implements Comparator {
        private DPoint distPoint;

        public DistanceComparator(UmnumPointsDialog umnumPointsDialog, DPoint dPoint) {
            this.distPoint = dPoint;
        }

        @Override
        public int compare(Object object, Object object2) {
            double d = this.distPoint.getDistance2((DPoint)object) - this.distPoint.getDistance2((DPoint)object2);
            if (d < 0.0) {
                return -1;
            }
            if (d > 0.0) {
                return 1;
            }
            return 0;
        }
    }
}

