/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ClearPolygon;
import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IViewport;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DRectangle;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.RissInfo;
import de.geocalc.kafplot.Stat;
import de.geocalc.kafplot.Stat4;
import de.geocalc.kafplot.TextArt;
import de.geocalc.kafplot.TextSymbol;
import de.geocalc.text.IFormat;
import de.geocalc.util.VoidEnumerator;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public abstract class ValueDataContainer
extends DataContainer {
    private Vector hull;
    protected RissInfo rissInfo;
    public Stat4 maxStat = new Stat4(null, null);
    public int maxStatGrzw;
    public int maxStatEgk;
    public boolean hasStatistik = false;
    int statCount = 0;
    private static final TextArt ta = TextArt.create(11);
    private static final TextSymbol sym = new TextSymbol(ta);
    private static final int rahmen = 42011140;
    private static final int center = 1;
    private static final TextArt TA = TextArt.create(11);

    public RissInfo getRissInfo() {
        return this.rissInfo;
    }

    public void setName(String string) {
        this.rissInfo.parseString(string);
    }

    public boolean hasName() {
        return this.rissInfo.hasName();
    }

    @Override
    public String getName() {
        return this.rissInfo.getName();
    }

    public String getKeyString() {
        return this.rissInfo.getKeyString();
    }

    public void setEntstehung(String string) {
        this.rissInfo.setEntstehung(string);
    }

    public boolean hasEntstehung() {
        return this.rissInfo.hasEntstehung();
    }

    public String getEntstehung() {
        return this.rissInfo.getEntstehung();
    }

    @Override
    public int getId() {
        return this.rissInfo.getId();
    }

    public void setTyp(int n) {
        this.rissInfo.setTyp(n);
    }

    public int getTyp() {
        return this.rissInfo.getTyp();
    }

    public String getDate() {
        return this.rissInfo.getDate();
    }

    public void updateStatistik(Stat stat) {
        if (stat != null) {
            DataBase.updateStatistik(this.maxStat, stat);
            double d = this.statCount;
            double d2 = this.statCount + 1;
            this.maxStat.setV(4, (short)Math.rint(((double)this.maxStat.getV(4) * d + (double)stat.getSumV()) / d2));
            this.maxStat.setSaV(4, (short)Math.rint(((double)this.maxStat.getSaV(4) * d + (double)stat.getMaxSaV()) / d2));
            this.maxStat.setSaN(4, (short)Math.rint(((double)this.maxStat.getSaN(4) * d + (double)stat.getMaxSaN()) / d2));
            this.maxStat.setEp(4, (short)Math.rint(((double)this.maxStat.getEp(4) * d + (double)stat.getSumEp()) / d2));
            this.maxStat.setEv(4, (short)Math.rint(((double)this.maxStat.getEv(4) * d + (double)stat.getMidEv()) / d2));
            this.maxStat.setNv(4, (short)Math.rint(((double)this.maxStat.getNv(4) * d + (double)stat.getMaxNv()) / d2));
            this.maxStat.setGf(4, (short)Math.rint(((double)this.maxStat.getGf(4) * d + (double)stat.getSumGf()) / d2));
            ++this.statCount;
            this.maxStatGrzw = Math.max(this.maxStatGrzw, stat.getMaxGrzw());
            this.maxStatEgk = Math.max(this.maxStatEgk, stat.getMaxEgk());
            this.hasStatistik = true;
        }
    }

    public Vector getHull() {
        return this.hull;
    }

    protected void createHull() {
        this.hull = new Vector();
        PunktTable punktTable = this.getPunkte();
        if (punktTable.size() == 0) {
            return;
        }
        Punkt punkt = null;
        Punkt punkt2 = null;
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        Enumeration enumeration = punktTable.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt3 = (Punkt)enumeration.nextElement();
            if (punkt3.y < d) {
                punkt = punkt3;
                d = punkt3.y;
            }
            if (!(punkt3.y > d2)) continue;
            punkt2 = punkt3;
            d2 = punkt3.y;
        }
        this.hull.addElement(punkt);
        this.hull.addElement(punkt2);
        this.hull.addElement(punkt);
        punktTable.remove(punkt);
        punktTable.remove(punkt2);
        boolean bl = false;
        do {
            Object object;
            double d3;
            Object object2;
            Object object3;
            int n;
            if ((n = this.hull.size()) > 3) {
                object3 = punktTable.elements();
                while (object3.hasMoreElements()) {
                    Punkt punkt4 = (Punkt)object3.nextElement();
                    object2 = (Punkt)this.hull.firstElement();
                    d3 = 0.0;
                    for (int i = 1; i < n; ++i) {
                        object = (Punkt)this.hull.elementAt(i);
                        d3 = DLine.getDistance(((Punkt)object2).y, ((Punkt)object2).x, ((Punkt)object).y, ((Punkt)object).x, punkt4.y, punkt4.x);
                        if (d3 > 0.0) break;
                        object2 = object;
                    }
                    if (!(d3 < 0.0)) continue;
                    punktTable.remove(punkt4);
                }
            }
            object3 = (Punkt)this.hull.firstElement();
            bl = false;
            for (int i = 1; i < this.hull.size(); ++i) {
                object2 = (Punkt)this.hull.elementAt(i);
                d3 = 0.0;
                Punkt punkt5 = null;
                object = punktTable.elements();
                while (object.hasMoreElements()) {
                    Punkt punkt6 = (Punkt)object.nextElement();
                    double d4 = DLine.getDistance(((Punkt)object3).y, ((Punkt)object3).x, ((Punkt)object2).y, ((Punkt)object2).x, punkt6.y, punkt6.x);
                    if (!(d4 > d3)) continue;
                    punkt5 = punkt6;
                    d3 = d4;
                }
                if (punkt5 != null) {
                    bl = true;
                    this.hull.insertElementAt(punkt5, i);
                    punktTable.remove(punkt5);
                    object3 = punkt5;
                    continue;
                }
                object3 = object2;
            }
        } while (bl);
    }

    public void drawHullBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
        IViewport iViewport = iGraphics.getViewport();
        if (!this.isVisible() || !this.isViewable(iViewport)) {
            return;
        }
        if (this.hull == null || this.hull.size() < 1) {
            return;
        }
        Graphics graphics = iGraphics.getGraphics();
        Point point = new Point();
        int n = this.hull.size();
        ClearPolygon clearPolygon = new ClearPolygon(n);
        int n2 = 0;
        Punkt punkt = (Punkt)this.hull.elementAt(0);
        n2 = iViewport.incode(punkt.y, punkt.x);
        for (int i = 1; i < n; ++i) {
            Punkt punkt2 = (Punkt)this.hull.elementAt(i);
            DLine dLine = iViewport.intersectLine(punkt.y, punkt.x, punkt2.y, punkt2.x);
            if (dLine != null) {
                point = iGraphics.getGraphicPoint(dLine.ya, dLine.xa, point);
                ((Polygon)clearPolygon).addPoint(point.x, point.y);
                point = iGraphics.getGraphicPoint(dLine.ye, dLine.xe, point);
                ((Polygon)clearPolygon).addPoint(point.x, point.y);
                n2 = iViewport.incode(dLine.ye, dLine.xe);
            }
            n2 = IGraphics.addViewPortPoints(n2, punkt2.y, punkt2.x, iViewport, clearPolygon);
            punkt = punkt2;
        }
        if (clearPolygon.npoints > 2) {
            graphics.fillPolygon(clearPolygon.xpoints, clearPolygon.ypoints, clearPolygon.npoints);
        }
    }

    public void drawHullForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
        IViewport iViewport = iGraphics.getViewport();
        Graphics graphics = iGraphics.getGraphics();
        if (this.hull == null || this.hull.size() < 1) {
            return;
        }
        int n = this.hull.size();
        if (!this.isVisible() || !this.isViewable(iViewport) || n < 2) {
            return;
        }
        Point point = new Point();
        Point point2 = new Point();
        Punkt punkt = (Punkt)this.hull.elementAt(0);
        for (int i = 1; i < n; ++i) {
            Punkt punkt2 = (Punkt)this.hull.elementAt(i);
            iGraphics.drawLine(punkt, punkt2, 3);
            punkt = punkt2;
        }
    }

    public void drawHullInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (this.getName() == null) {
            return;
        }
        if (!this.isViewable(iGraphics.getViewport())) {
            return;
        }
        DRectangle dRectangle = this.getBounds();
        double d = dRectangle.y + dRectangle.width / 2.0;
        double d2 = dRectangle.x + dRectangle.height / 2.0;
        if (!iGraphics.contains(d, d2)) {
            return;
        }
        Graphics graphics = iGraphics.getGraphics();
        Font font = KafPlotProperties.getRissFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Point point = new Point();
        point = iGraphics.getGraphicPoint(d, d2, point);
        graphics.setFont(font);
        graphics.drawString(this.getName(), point.x - fontMetrics.stringWidth(this.getName()) / 2, point.y + fontMetrics.getAscent() / 2);
    }

    public void drawPartInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (this.getName() == null) {
            return;
        }
        if (!this.isViewable(iGraphics.getViewport())) {
            return;
        }
        Graphics graphics = iGraphics.getGraphics();
        String string = this.getName();
        int n = 0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Messung)) continue;
            Messung messung = (Messung)e;
            Messung messung2 = messung.getReferenz();
            if (messung.getMessungsArtIgnoreErr() != 210 || messung2 == null) continue;
            double d = DLine.getAngle(messung.pz != null ? messung.pz : messung.ps, messung2.pz != null ? messung2.pz : messung2.ps) + iGraphics.getRotation();
            DPoint dPoint = DLine.getMidPoint(messung.pz != null ? messung.pz : messung.ps, messung2.pz != null ? messung2.pz : messung2.ps);
            Point point = iGraphics.getGraphicPoint(dPoint, new Point());
            TextSymbol.paint(graphics, string + "M" + IFormat.i02.format(++n), point, ta, 1, 42011140, d, 3.0);
        }
    }

    @Override
    public Object getAttribute(String string) throws NoSuchElementException {
        throw new NoSuchElementException("ValueDataContainer");
    }

    @Override
    public Object setAttribute(String string, Object object) {
        return null;
    }

    @Override
    public Object removeAttribute(String string) {
        return null;
    }

    @Override
    public Enumeration attributes() {
        return new VoidEnumerator();
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }
}

