/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IException;
import de.geocalc.kafplot.PropertyLoader;
import de.geocalc.kafplot.Symbol;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.kafplot.io.xml.XmlIOProperties;
import de.geocalc.text.IFormat;
import de.geocalc.util.IntegerHashList;
import de.geocalc.util.IntegerHashObject;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class VermarkungsArt
implements IntegerHashObject {
    public static final int KAF_UNDEF = 0;
    public static final int KAF_MARKE_ALLGEMEIN = 1;
    public static final int KAF_MARKE_SPEZIELL = 2;
    public static final int KAF_MARKE_TIEF = 3;
    public static final int KAF_ECKE = 4;
    public static final int KAF_OHNE_MARKE = 10;
    public static final int KAF_INDIREKT = 11;
    public static final int KAF_UNBEKANNT = 19;
    public static final int KAF_MARKE_LFP = 21;
    public static final int KAF_MARKE_HFP = 22;
    public static final int KAF_MARKE_SFP = 23;
    public static final int KAF_FEHLT = 99;
    public static final int STEIN_NN = 10;
    public static final int STEIN_N = 11;
    public static final int STEIN_J = 12;
    public static final int KMARKE = 13;
    public static final int PLATTE = 14;
    public static final int HZIEGEL = 15;
    public static final int PFEILER = 17;
    public static final int ROHR_NN = 20;
    public static final int ROHR_N = 21;
    public static final int ROHR_J = 22;
    public static final int MARKE_NN = 25;
    public static final int MARKE_N = 26;
    public static final int MARKE_J = 27;
    public static final int PFAHL = 30;
    public static final int FLASCHE = 35;
    public static final int NAGEL = 40;
    public static final int SOCKEL_ROH = 41;
    public static final int SOCKEL_VERP = 42;
    public static final int ECKE_ROH = 43;
    public static final int ECKE_VERP = 44;
    public static final int FESTL_WSV = 45;
    public static final int SMARKE_NN = 50;
    public static final int SMARKE_N = 51;
    public static final int SMARKE_J = 52;
    public static final int BRAREF = 54;
    public static final int MEISZEL = 60;
    public static final int FESTGELEGT = 70;
    public static final int INDIREKT = 88;
    public static final int ZURUECK = 89;
    public static final int UNVERMARKT = 90;
    public static final int FEHLT = 94;
    public static final int OV_FEHLT = 98;
    public static final int UNBEKANNT = 99;
    public static final String AUFGEF = "aufgef.";
    public static final VermarkungsArt UNKNOWN = new VermarkungsArt(0, Symbol.UNDEF, "");
    private static final IntegerHashList VaListe = new IntegerHashList();
    private int art;
    private int kva;
    private int kaf;
    private int abm;
    private int bza;
    private String bez;
    private String kzl;
    private Symbol sym;

    public static int AlkisToAlk(int n, int n2) {
        switch (n) {
            case 1000: {
                return 1;
            }
            case 1100: {
                return 10 + VermarkungsArt.AlkisVbToAlk(n2);
            }
            case 1140: {
                return 50 + VermarkungsArt.AlkisVbToAlk(n2);
            }
            case 1200: {
                return 20 + VermarkungsArt.AlkisVbToAlk(n2);
            }
            case 1300: {
                return 40;
            }
            case 1500: {
                return 30;
            }
            case 1620: {
                return 35;
            }
            case 1630: {
                return 14;
            }
            case 1640: {
                return 15;
            }
            case 1711: {
                return 41;
            }
            case 1712: {
                return 42;
            }
            case 1713: {
                return 43;
            }
            case 1714: {
                return 44;
            }
            case 1800: {
                return 17;
            }
            case 2230: {
                return 45;
            }
            case 9500: {
                return 90;
            }
            case 9600: {
                return 89;
            }
            case 9998: {
                return 99;
            }
        }
        return 0;
    }

    private static int AlkisVbToAlk(int n) {
        if (n <= 0) {
            return 0;
        }
        if (n == 1000 || n == 2000 || n == 3000) {
            return 2;
        }
        if (n == 4000) {
            return 1;
        }
        return 0;
    }

    public VermarkungsArt() {
        this(0, 0, null, null, null, 0);
    }

    public VermarkungsArt(int n, Symbol symbol, String string) {
        this(n, n, symbol, string, null, 0);
    }

    public VermarkungsArt(int n, Symbol symbol, String string, String string2) {
        this(n, n, symbol, string, string2, 0);
    }

    public VermarkungsArt(int n, int n2, Symbol symbol, String string, String string2, int n3) {
        this.art = n;
        this.kva = n2;
        this.sym = symbol;
        this.bez = string;
        this.kzl = string2;
        this.kaf = n3;
    }

    @Override
    public final int intHashKey() {
        return this.art;
    }

    public int compareTo(int n) {
        if (this.art < n) {
            return -1;
        }
        if (this.art > n) {
            return 1;
        }
        return 0;
    }

    public static String getItem(int n) {
        return n >= 1000 ? IFormat.i04.format(n) : IFormat.i03.format(n) + "  " + VermarkungsArt.toString(n);
    }

    public String toXmlLine() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[]{XmlIOProperties.att("id", Integer.toString(this.art)), XmlIOProperties.att("name", this.bez), XmlIOProperties.att("vak", this.kva != this.art ? IFormat.i03.format(this.kva).toString() : null), XmlIOProperties.att("krz", this.kzl)};
        stringBuffer.append(XmlIOProperties.data("vermarkung", stringArray));
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof VermarkungsArt) {
            return this.art == ((VermarkungsArt)object).art;
        }
        return false;
    }

    public void setArt(int n) {
        this.art = n;
    }

    public int getArt() {
        return this.art;
    }

    private void setKafArt(int n) {
        this.kaf = n;
    }

    public int getKafArt() {
        return this.kaf;
    }

    public int getModArt() {
        return this.kva <= 0 ? this.art : this.kva;
    }

    public void setKatasterArt(int n) {
        this.kva = n;
    }

    public int getKatasterArt() {
        return this.kva <= 0 ? this.art : this.kva;
    }

    public void setSymbol(Symbol symbol) {
        this.sym = symbol;
    }

    public Symbol getSymbol() {
        return this.sym;
    }

    public void setName(String string) {
        this.bez = string;
    }

    public String getName() {
        return this.bez;
    }

    public void setKuerzel(String string) {
        this.kzl = string;
    }

    public String getKuerzel() {
        return this.kzl;
    }

    public static VermarkungsArt getVermarkungsArt(int n) {
        VermarkungsArt vermarkungsArt = (VermarkungsArt)VaListe.get(n);
        if (vermarkungsArt == null) {
            return UNKNOWN;
        }
        return vermarkungsArt;
    }

    public static String toString(int n) {
        VermarkungsArt vermarkungsArt = VermarkungsArt.getVermarkungsArt(n);
        if (vermarkungsArt == null) {
            return "unbekannt";
        }
        return vermarkungsArt.getName();
    }

    public static Symbol toSymbol(int n) {
        VermarkungsArt vermarkungsArt = VermarkungsArt.getVermarkungsArt(n);
        if (vermarkungsArt == null) {
            return Symbol.UNDEF;
        }
        return vermarkungsArt.getSymbol();
    }

    public static String toKuerzel(int n) {
        VermarkungsArt vermarkungsArt = VermarkungsArt.getVermarkungsArt(n);
        if (vermarkungsArt == null || vermarkungsArt.getKuerzel() == null) {
            return "";
        }
        return vermarkungsArt.getKuerzel();
    }

    public static String toVbKuerzel(int n) {
        if (n == 1000) {
            return "mit UV";
        }
        if (n == 4000) {
            return "ohne UV";
        }
        return "";
    }

    public static String toIdString(int n) {
        VermarkungsArt vermarkungsArt = VermarkungsArt.getVermarkungsArt(n);
        if (vermarkungsArt == null) {
            return "";
        }
        if (vermarkungsArt.getKuerzel() == null) {
            return Integer.toString(n);
        }
        return vermarkungsArt.getKuerzel();
    }

    public static String toVbIdString(int n) {
        if (n == 1000) {
            return "J";
        }
        if (n == 4000) {
            return "N";
        }
        return "";
    }

    public boolean isUnvermarkt() {
        return VermarkungsArt.isUnvermarkt(this.getKafArt());
    }

    public static boolean isVermarkt(int n) {
        switch (n) {
            case 0: 
            case 10: 
            case 11: 
            case 19: 
            case 99: {
                return false;
            }
        }
        return true;
    }

    public static boolean isUnvermarkt(int n) {
        switch (n) {
            case 0: 
            case 10: 
            case 11: 
            case 19: 
            case 99: {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void load(InputStream inputStream) throws IOException {
        LineNumberReader lineNumberReader = null;
        try {
            String string;
            lineNumberReader = PropertyLoader.createReader(inputStream);
            VermarkungsArt vermarkungsArt = null;
            VermarkungsArt vermarkungsArt2 = null;
            while ((string = lineNumberReader.readLine()) != null) {
                if (string.length() == 0 || string.charAt(0) == '#') continue;
                vermarkungsArt = VermarkungsArt.parseVermarkungsArt(string);
                if (vermarkungsArt.getSymbol() == null) {
                    if (vermarkungsArt2 == null) throw new IException("Angaben fehlen");
                    vermarkungsArt.setSymbol(vermarkungsArt2.getSymbol());
                }
                if (vermarkungsArt.getName() == null) {
                    if (vermarkungsArt2 == null) throw new IException("Angaben fehlen");
                    vermarkungsArt.setName(vermarkungsArt2.getName());
                }
                if (vermarkungsArt.getKuerzel() == null) {
                    if (vermarkungsArt2 == null) throw new IException("Angaben fehlen");
                    vermarkungsArt.setKuerzel(vermarkungsArt2.getKuerzel());
                } else if (vermarkungsArt.getKuerzel().equals("-")) {
                    vermarkungsArt.setKuerzel(null);
                }
                VermarkungsArt vermarkungsArt3 = (VermarkungsArt)VaListe.get(vermarkungsArt.getModArt());
                if (vermarkungsArt3 == null) {
                    throw new IException("KatasterArt " + vermarkungsArt.getModArt() + " nicht vorhanden");
                }
                vermarkungsArt.setKafArt(vermarkungsArt3.getKafArt());
                if (VaListe.get(vermarkungsArt.getArt()) != null) {
                    throw new IException("\u00dcberschreiben der bereits vorhandenen Art " + vermarkungsArt.getArt() + " nicht m\u00f6glich");
                }
                VaListe.put(vermarkungsArt);
                vermarkungsArt2 = vermarkungsArt;
            }
            return;
        }
        catch (IException iException) {
            throw new IOException("Fehler in Zeile: " + (lineNumberReader != null ? lineNumberReader.getLineNumber() : 0) + "\n" + iException.getMessage());
        }
    }

    private static VermarkungsArt parseVermarkungsArt(String string) throws IException {
        VermarkungsArt vermarkungsArt = new VermarkungsArt();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        try {
            vermarkungsArt.setArt(new Integer(stringTokenizer.nextToken().trim()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IException("ung\u00fcltige Art");
        }
        if (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ";");
            try {
                vermarkungsArt.setKatasterArt(new Integer(stringTokenizer2.nextToken().trim()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IException("ung\u00fcltige VA");
            }
            if (stringTokenizer2.hasMoreTokens()) {
                vermarkungsArt.setSymbol(Symbol.getSymbol(stringTokenizer2.nextToken().trim()));
            }
            if (stringTokenizer2.hasMoreTokens()) {
                vermarkungsArt.setName(stringTokenizer2.nextToken().trim());
            }
            if (stringTokenizer2.hasMoreTokens()) {
                vermarkungsArt.setKuerzel(stringTokenizer2.nextToken().trim());
            }
        } else {
            throw new IException("Angaben fehlen");
        }
        return vermarkungsArt;
    }

    public static Enumeration elements() {
        return VaListe.elements();
    }

    public static Enumeration sortedElements() {
        return VaListe.sortedElements();
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.art);
        dataOutput.writeShort(this.kva);
        KafPlotIOConstants.writeString(dataOutput, this.bez);
        KafPlotIOConstants.writeString(dataOutput, this.kzl);
        String string = this.sym != null ? this.sym.getName() : null;
        KafPlotIOConstants.writeString(dataOutput, string);
    }

    public static VermarkungsArt readObject(DataInput dataInput) throws IOException {
        VermarkungsArt vermarkungsArt = new VermarkungsArt();
        vermarkungsArt.art = dataInput.readShort();
        vermarkungsArt.kva = dataInput.readShort();
        vermarkungsArt.bez = KafPlotIOConstants.readString(dataInput);
        vermarkungsArt.kzl = KafPlotIOConstants.readString(dataInput);
        try {
            vermarkungsArt.sym = Symbol.getSymbol(KafPlotIOConstants.readString(dataInput));
        }
        catch (IException iException) {
            // empty catch block
        }
        return vermarkungsArt;
    }

    public static void saveObject(VermarkungsArt vermarkungsArt) {
        if (vermarkungsArt == null) {
            throw new NullPointerException("VermarkungsArt");
        }
        VaListe.put(vermarkungsArt);
    }

    static {
        VaListe.put(new VermarkungsArt(1, 1, Symbol.ST, "Marke  allgemein", null, 1));
        VaListe.put(new VermarkungsArt(10, 10, Symbol.ST, "Stein", "ST", 2));
        VaListe.put(new VermarkungsArt(11, 11, Symbol.ST, "Stein", "ST", 2));
        VaListe.put(new VermarkungsArt(12, 12, Symbol.ST, "Stein", "ST", 2));
        VaListe.put(new VermarkungsArt(13, 13, Symbol.R, "Kunststoffmarke", "K", 2));
        VaListe.put(new VermarkungsArt(14, 14, Symbol.R_, "Platte", "Pl", 3));
        VaListe.put(new VermarkungsArt(15, 15, Symbol.R_, "Hohlziegel", "Hz", 3));
        VaListe.put(new VermarkungsArt(17, 17, Symbol.ST, "Pfeiler", null, 2));
        VaListe.put(new VermarkungsArt(20, 20, Symbol.R, "Rohr", "R", 2));
        VaListe.put(new VermarkungsArt(21, 21, Symbol.R, "Rohr", "R", 2));
        VaListe.put(new VermarkungsArt(22, 22, Symbol.R, "Rohr", "R", 2));
        VaListe.put(new VermarkungsArt(25, 25, Symbol.R, "Vermessungsmarke", "M", 2));
        VaListe.put(new VermarkungsArt(26, 26, Symbol.R, "Vermessungsmarke", "M", 2));
        VaListe.put(new VermarkungsArt(27, 27, Symbol.R, "Vermessungsmarke", "M", 2));
        VaListe.put(new VermarkungsArt(30, 30, Symbol.R, "Pfahl", "Pf", 2));
        VaListe.put(new VermarkungsArt(35, 35, Symbol.R_, "Flasche", "Fl", 3));
        VaListe.put(new VermarkungsArt(40, 40, Symbol.R, "Bolzen", "B", 2));
        VaListe.put(new VermarkungsArt(41, 41, Symbol.UV, "Sockel (roh)", null, 4));
        VaListe.put(new VermarkungsArt(42, 42, Symbol.UV, "Sockel (verputzt)", null, 4));
        VaListe.put(new VermarkungsArt(43, 43, Symbol.UV, "Ecke (roh)", null, 4));
        VaListe.put(new VermarkungsArt(44, 44, Symbol.UV, "Ecke (verputzt)", null, 4));
        VaListe.put(new VermarkungsArt(45, 45, Symbol.UV, "Festlegung WSV", "WSV", 2));
        VaListe.put(new VermarkungsArt(50, 50, Symbol.R, "Verm.marke (SV)", "SV", 2));
        VaListe.put(new VermarkungsArt(51, 51, Symbol.R, "Verm.marke (SV)", "SV", 2));
        VaListe.put(new VermarkungsArt(52, 52, Symbol.R, "Verm.marke (SV)", "SV", 2));
        VaListe.put(new VermarkungsArt(54, 54, Symbol.R, "BRAREF-Vermarkung", null, 2));
        VaListe.put(new VermarkungsArt(60, 60, Symbol.KR, "Mei\u00dfelzeichen", "Mz", 2));
        VaListe.put(new VermarkungsArt(70, 70, Symbol.UV, "dauerhaft festgelegt", null, 4));
        VaListe.put(new VermarkungsArt(88, 88, Symbol.UV, "indirekt vermarkt", null, 11));
        VaListe.put(new VermarkungsArt(89, 89, Symbol.UV, "unv.  zur\u00fcckgestellt", null, 10));
        VaListe.put(new VermarkungsArt(90, 90, Symbol.UV, "unv.", null, 10));
        VaListe.put(new VermarkungsArt(94, 94, Symbol.UV, "Vermarkung fehlt", null, 10));
        VaListe.put(new VermarkungsArt(98, 98, Symbol.UV, "Abmarkung fehlt", null, 99));
        VaListe.put(new VermarkungsArt(99, 99, Symbol.UV, "keine Ang. bekannt", null, 19));
        VaListe.put(new VermarkungsArt(110, 110, null, "TP 1.Ordnung", null, 21));
        VaListe.put(new VermarkungsArt(111, 111, null, "TP 4.Ordnung", null, 21));
        VaListe.put(new VermarkungsArt(116, 116, null, "Leuchtschraube, -bolzen", null, 21));
        VaListe.put(new VermarkungsArt(117, 117, null, "Bolzen, 3. und 4.Ordnung", null, 21));
        VaListe.put(new VermarkungsArt(119, 119, null, "TP 3.Ordnung", null, 21));
        VaListe.put(new VermarkungsArt(120, 120, null, "Pfeiler", null, 21));
        VaListe.put(new VermarkungsArt(121, 121, null, "Plattformbolzen", null, 21));
        VaListe.put(new VermarkungsArt(122, 122, null, "Turmbolzen", null, 21));
        VaListe.put(new VermarkungsArt(171, 171, null, "TP 3. und 4.Ordn. u. OP", null, 21));
        VaListe.put(new VermarkungsArt(172, 172, null, "TP 3. und 4.Ordnung", null, 21));
        VaListe.put(new VermarkungsArt(180, 180, null, "Knopf", null, 21));
        VaListe.put(new VermarkungsArt(182, 182, null, "Spitze", null, 21));
        VaListe.put(new VermarkungsArt(183, 183, null, "Kreuz", null, 21));
        VaListe.put(new VermarkungsArt(190, 190, null, "Unterird. Vermarkung", null, 21));
        VaListe.put(new VermarkungsArt(201, 201, null, "Unterirdische S\u00e4ule", null, 22));
        VaListe.put(new VermarkungsArt(202, 202, null, "Unterirdischer Rammstab", null, 22));
        VaListe.put(new VermarkungsArt(203, 203, null, "Unterirdischer Pfeiler", null, 22));
        VaListe.put(new VermarkungsArt(204, 204, null, "Unterirdischer Bolzen", null, 22));
        VaListe.put(new VermarkungsArt(221, 221, null, "Mauerbolzen", null, 22));
        VaListe.put(new VermarkungsArt(222, 222, null, "vertikaler Bolzen", null, 22));
        VaListe.put(new VermarkungsArt(223, 223, null, "H\u00f6henmarke", null, 22));
        VaListe.put(new VermarkungsArt(231, 231, null, "Pfeilerbolzen", null, 22));
        VaListe.put(new VermarkungsArt(310, 310, null, "Gravimeterplatte", null, 23));
        VaListe.put(new VermarkungsArt(311, 311, null, "Gravimeternagel", null, 23));
        VaListe.put(new VermarkungsArt(312, 312, null, "Gravimeterpfeiler", null, 23));
        VaListe.put(new VermarkungsArt(1000, 1000, Symbol.ST, "Marke  allgemein", "Ma", 1));
        VaListe.put(new VermarkungsArt(1100, 1100, Symbol.ST, "Stein", "St", 2));
        VaListe.put(new VermarkungsArt(1111, 1111, Symbol.ST, "Lochstein", "LSt", 2));
        VaListe.put(new VermarkungsArt(1120, 1120, Symbol.ST, "Unbehauener Feldstein", "F", 2));
        VaListe.put(new VermarkungsArt(1140, 1140, Symbol.R, "Kunststoffmarke", "K", 2));
        VaListe.put(new VermarkungsArt(1200, 1200, Symbol.R, "Rohr", "R", 2));
        VaListe.put(new VermarkungsArt(1230, 1230, Symbol.R_, "Drainrohr", "D", 3));
        VaListe.put(new VermarkungsArt(1300, 1300, Symbol.R, "Bolzen/Nagel", "B/N", 2));
        VaListe.put(new VermarkungsArt(1400, 1400, Symbol.KR, "Mei\u00dfelzeichen", "Mz", 2));
        VaListe.put(new VermarkungsArt(1500, 1500, Symbol.R, "Pfahl", "Pf", 2));
        VaListe.put(new VermarkungsArt(1620, 1620, Symbol.R_, "Flasche", "Fl", 3));
        VaListe.put(new VermarkungsArt(1630, 1630, Symbol.R_, "Platte", "Pl", 3));
        VaListe.put(new VermarkungsArt(1640, 1640, Symbol.R_, "Hohlziegel", "Hz", 3));
        VaListe.put(new VermarkungsArt(1711, 1711, Symbol.UV, "Sockel (roh)", "Sr", 4));
        VaListe.put(new VermarkungsArt(1712, 1712, Symbol.UV, "Sockel (verputzt)", "Sv", 4));
        VaListe.put(new VermarkungsArt(1713, 1713, Symbol.UV, "Mauerecke (roh)", "Mr", 4));
        VaListe.put(new VermarkungsArt(1714, 1714, Symbol.UV, "Mauerecke (verputzt)", "Mv", 4));
        VaListe.put(new VermarkungsArt(1800, 1800, Symbol.ST, "Pfeiler", "P", 2));
        VaListe.put(new VermarkungsArt(2230, 2230, Symbol.UV, "Festlegung WSV", "Wa", 2));
        VaListe.put(new VermarkungsArt(9500, 9500, Symbol.UV, "Ohne Marke", "oM", 10));
        VaListe.put(new VermarkungsArt(9600, 9600, Symbol.UV, "Abmarkung ausgesetzt", "Aza", 10));
        VaListe.put(new VermarkungsArt(9998, 9998, Symbol.UV, "keine Ang. bekannt", "Ns", 19));
        VaListe.put(new VermarkungsArt(9999, 9500, Symbol.UV, "Abmarkung fehlt", null, 99));
    }
}

