/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ErrorDialog;
import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.IProgressBar;
import de.geocalc.awt.IProgressElement;
import de.geocalc.io.IFileOutputException;
import de.geocalc.io.Util;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.ViewerWriterOptionDialog;
import de.geocalc.kafplot.io.IFileWriter;
import de.geocalc.kafplot.io.KpvWriter;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ViewerWriterDialog
extends IDialog
implements ActionListener {
    DataBase db;
    File kpvOutFile;
    File htmOutFile;
    protected ExceptionList exceptions;
    private static final String FILE_NAME_BUTTON_TEXT = "...";
    private static final String RISS_FILE_NAME_COMMAND = "JAR";
    private static final String OK_COMMAND = "OK";
    private static final String OPTION_COMMAND = "Optionen";
    private static final String ABORT_COMMAND = "Abbrechen";
    private TextField kpvFileNameTextField;
    private Button kpvFileNameButton;
    private Button okButton;
    private Button optionButton;
    private Button abortButton;
    private Label kpvFileNameLabel;
    private Label progressLabel;
    private IProgressBar progressBar;
    private String filePath;

    public ViewerWriterDialog(IFrame iFrame, String string, DataBase dataBase, String string2) {
        super(iFrame, string, true);
        this.db = dataBase;
        this.filePath = dataBase.getDestPath();
        this.exceptions = new ExceptionList();
        this.setLayout(new BorderLayout());
        Panel panel = new Panel(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Dateien"));
        this.kpvFileNameLabel = new Label("Daten: ");
        iPanel.add(this.kpvFileNameLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.kpvFileNameLabel, gridBagConstraints);
        this.kpvFileNameTextField = new TextField(DataBase.getDestFileDisplayName(string2 + ".viewer.jar"), 40);
        iPanel.add(this.kpvFileNameTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.kpvFileNameTextField, gridBagConstraints);
        this.kpvFileNameButton = new Button(FILE_NAME_BUTTON_TEXT);
        iPanel.add(this.kpvFileNameButton);
        this.kpvFileNameButton.setActionCommand(RISS_FILE_NAME_COMMAND);
        this.kpvFileNameButton.addActionListener(this);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.kpvFileNameButton, gridBagConstraints);
        panel.add("North", iPanel);
        IPanel iPanel2 = new IPanel(new BorderLayout());
        IBorder iBorder = new IBorder(1);
        iPanel2.setBorder(iBorder);
        Panel panel2 = new Panel(new FlowLayout());
        this.progressBar = new IProgressBar();
        panel2.add(this.progressBar);
        iPanel2.add("North", panel2);
        Panel panel3 = new Panel(new GridLayout(1, 1));
        this.progressLabel = new Label();
        panel3.add(this.progressLabel);
        iPanel2.add("South", panel3);
        panel.add("South", iPanel2);
        this.add("North", panel);
        Panel panel4 = new Panel(new FlowLayout(2));
        this.okButton = new Button(OK_COMMAND);
        this.okButton.addActionListener(this);
        panel4.add(this.okButton);
        this.optionButton = new Button(OPTION_COMMAND);
        this.optionButton.addActionListener(this);
        panel4.add(this.optionButton);
        this.abortButton = new Button(ABORT_COMMAND);
        this.abortButton.addActionListener(this);
        panel4.add(this.abortButton);
        this.add("South", panel4);
        this.pack();
        this.setLocationOfParent(iFrame);
    }

    public void write() {
        Object object = Util.getFile(this.filePath, this.kpvFileNameTextField.getText()).getAbsolutePath();
        if (!((String)object).toLowerCase().endsWith(".jar")) {
            object = (String)object + ".jar";
        }
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            ZipInputStream zipInputStream = null;
            ZipOutputStream zipOutputStream = null;
            try {
                zipInputStream = new ZipInputStream(classLoader.getResourceAsStream("viewer/Viewer.jar"));
            }
            catch (Exception exception) {
                try {
                    zipInputStream = new ZipInputStream(classLoader.getResourceAsStream("Viewer.jar"));
                }
                catch (Exception exception2) {
                    throw new IFileOutputException("viewer.jar nicht im Programmverzeichnis vorhanden");
                }
            }
            try {
                zipOutputStream = new ZipOutputStream(new FileOutputStream((String)object));
            }
            catch (Exception exception) {
                throw new IFileOutputException("Datei " + this.kpvFileNameTextField.getText() + " kann nicht erzeugt werden");
            }
            try {
                this.progressLabel.setText("Erzeuge Programm...");
                byte[] byArray = new byte[262144];
                int n = 0;
                Object object2 = zipInputStream.getNextEntry();
                while (object2 != null) {
                    zipOutputStream.putNextEntry((ZipEntry)object2);
                    if (!((ZipEntry)object2).isDirectory()) {
                        int n2 = zipInputStream.read(byArray);
                        while (n2 > -1) {
                            zipOutputStream.write(byArray, 0, n2);
                            n2 = zipInputStream.read(byArray);
                        }
                    }
                    zipOutputStream.closeEntry();
                    if (++n % 10 == 0) {
                        this.progressBar.setValue(n / 6);
                    }
                    object2 = zipInputStream.getNextEntry();
                }
                try {
                    zipInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.progressBar.setValue(0);
                this.progressLabel.setText("Erzeuge Daten...");
                zipOutputStream.putNextEntry(new ZipEntry("data.kpv"));
                object2 = new KpvWriter(zipOutputStream, this.db, false);
                ((IFileWriter)object2).setExceptionList(this.exceptions);
                ((IProgressElement)object2).setProgressBar(this.progressBar);
                ((KpvWriter)object2).write();
                this.progressBar.setValue(0);
                this.progressLabel.setText("Komprimiere Daten...");
                zipOutputStream.closeEntry();
                this.progressBar.setValue(50);
                zipOutputStream.close();
                this.progressBar.setValue(100);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IFileOutputException(exception.getMessage());
            }
        }
        catch (IFileOutputException iFileOutputException) {
            ErrorDialog errorDialog = new ErrorDialog(this.parent, iFileOutputException);
            errorDialog.setVisible(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK_COMMAND)) {
            this.write();
            this.endDialog();
        } else if (string.equals(ABORT_COMMAND)) {
            this.endDialog();
        } else if (string.equals(RISS_FILE_NAME_COMMAND)) {
            FileDialog fileDialog = new FileDialog((Frame)this.parent, "Speichern", 1);
            fileDialog.setFile(this.kpvFileNameTextField.getText());
            fileDialog.setDirectory(this.filePath);
            fileDialog.setVisible(true);
            if (fileDialog.getFile() != null) {
                this.kpvFileNameTextField.setText(fileDialog.getDirectory() + fileDialog.getFile());
                this.filePath = fileDialog.getDirectory();
            }
        } else if (string.equals(OPTION_COMMAND)) {
            ViewerWriterOptionDialog viewerWriterOptionDialog = new ViewerWriterOptionDialog(this.parent, OPTION_COMMAND);
            viewerWriterOptionDialog.setVisible(true);
        }
    }

    @Override
    protected void endDialog() {
        if (!this.exceptions.isEmpty()) {
            ErrorDialog errorDialog = new ErrorDialog(this.parent, "Es sind Fehler beim Schreiben der Daten aufgetreten, \ndie fehlerhafte Daten wurden markiert.", this.exceptions);
            errorDialog.setVisible(true);
        }
        super.endDialog();
    }

    @Override
    protected void doStandardAction() {
        this.write();
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

