/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IOptionDialog;
import de.geocalc.awt.IPanel;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.io.kpv.KpvIOProperties;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class ViewerWriterOptionDialog
extends IOptionDialog
implements ActionListener,
ItemListener {
    private Checkbox allFlstCheckbox;
    private Checkbox onlyFlstFortfuehrungCheckbox;
    private Checkbox onlyGemarkungCheckbox;
    private Checkbox writeErrorsCheckbox;
    private Checkbox writeStatistikCheckbox;
    private List gemarkungList;

    public ViewerWriterOptionDialog(IFrame iFrame, String string) {
        super(iFrame, string, false);
    }

    @Override
    protected IPanel layoutDialogPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        IPanel iPanel = new IPanel(gridBagLayout);
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        iPanel.setBorder(new IBorder(1));
        this.writeStatistikCheckbox = new Checkbox("Schreiben der Statistik", KpvIOProperties.writeStatistik());
        iPanel.add(this.writeStatistikCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.writeStatistikCheckbox, gridBagConstraints);
        this.writeErrorsCheckbox = new Checkbox("Schreiben der Fehlermeldungen", KpvIOProperties.writeErrors());
        iPanel.add(this.writeErrorsCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.writeErrorsCheckbox, gridBagConstraints);
        Label label = new Label("Auswahl der Fl\u00e4chen: ");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.allFlstCheckbox = new Checkbox("alles", KpvIOProperties.getAreaSwitch() == 0, checkboxGroup);
        iPanel.add(this.allFlstCheckbox);
        this.allFlstCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.allFlstCheckbox, gridBagConstraints);
        this.onlyFlstFortfuehrungCheckbox = new Checkbox("nur fortgef\u00fchrte Flurst\u00fccksfl\u00e4chen", KpvIOProperties.getAreaSwitch() == 1, checkboxGroup);
        iPanel.add(this.onlyFlstFortfuehrungCheckbox);
        this.onlyFlstFortfuehrungCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.onlyFlstFortfuehrungCheckbox, gridBagConstraints);
        this.onlyGemarkungCheckbox = new Checkbox("nur ausgew\u00e4hlte Gemarkungen", KpvIOProperties.getAreaSwitch() == 2, checkboxGroup);
        iPanel.add(this.onlyGemarkungCheckbox);
        this.onlyGemarkungCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.onlyGemarkungCheckbox, gridBagConstraints);
        Vector vector = DataBase.FLST.getGemarkungKeys();
        this.gemarkungList = new List(vector.size(), true);
        for (int i = 0; i < vector.size(); ++i) {
            Integer n = (Integer)vector.elementAt(i);
            this.gemarkungList.addItem(n.toString());
            if (!KpvIOProperties.hasGemarkung(n)) continue;
            this.gemarkungList.select(i);
        }
        iPanel.add(this.gemarkungList);
        this.gemarkungList.setEnabled(this.onlyGemarkungCheckbox.getState());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagLayout.setConstraints(this.gemarkungList, gridBagConstraints);
        return iPanel;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.gemarkungList.setEnabled(this.onlyGemarkungCheckbox.getState());
        super.itemStateChanged(itemEvent);
    }

    @Override
    protected void setOptions() {
        KpvIOProperties.writeStatistik(this.writeStatistikCheckbox.getState());
        KpvIOProperties.writeErrors(this.writeErrorsCheckbox.getState());
        if (this.allFlstCheckbox.getState()) {
            KpvIOProperties.setAreaSwitch(0);
        } else if (this.onlyFlstFortfuehrungCheckbox.getState()) {
            KpvIOProperties.setAreaSwitch(1);
        } else if (this.onlyGemarkungCheckbox.getState()) {
            KpvIOProperties.setAreaSwitch(2);
        }
        KpvIOProperties.clearGemarkungen();
        for (int i = 0; i < this.gemarkungList.countItems(); ++i) {
            if (!this.gemarkungList.isIndexSelected(i)) continue;
            String string = this.gemarkungList.getItem(i);
            KpvIOProperties.addGemarkung(Integer.parseInt(string));
        }
    }
}

