/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.FlowText;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IOptionDialog;
import de.geocalc.awt.IPanel;
import de.geocalc.kafplot.io.wldge.WldgeIOProperties;
import de.geocalc.text.IFormat;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class WldgeImportOptionDialog
extends IOptionDialog
implements ActionListener,
ItemListener {
    private static final String HELP1_TEXT = "Flurst\u00fccke k\u00f6nnen \u00fcbernommen\nwerden als separates ALB-St\u00fcck\noder als Flurst\u00fcck.\nWenn Abgleich gew\u00e4hlt wird,\nf\u00fcllt KafPlot die vorhandenen\nFlurst\u00fccke mit den ALB-Daten auf.";
    private static final String NUTZ_OHNE = "ohne Buchfl\u00e4chen";
    private static final String NUTZ_BUCH = "mit Buchfl\u00e4chen";
    private static final String NUTZ_SOLL = "als Sollfl\u00e4chen";
    private static final String SPEC_NO = "keine";
    private static final String SPEC_ALB = "aus ALB";
    private static final String SPEC_ALK = "aus ALK";
    private static final String SPEC_BOTH = "immer";
    private CheckboxGroup cbg;
    private Checkbox allCheckbox;
    private Checkbox sollCheckbox;
    private Choice nutzFlaecheChoice;
    private Choice nutzSpecChoice;
    private Label diffLabel;
    private Label addLabel;
    private Label percentLabel;
    private Label nutzFlaecheLabel;
    private Label nutzSpecLabel;
    private TextField addTextField;
    private TextField percentTextField;

    public WldgeImportOptionDialog(IFrame iFrame, String string) {
        super(iFrame, string, false);
        this.updateComponents();
        this.pack();
    }

    @Override
    protected IPanel layoutDialogPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 18;
        IPanel iPanel = new IPanel(gridBagLayout);
        IPanel iPanel2 = this.createOptionPanel();
        iPanel.add(iPanel2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(iPanel2, gridBagConstraints);
        iPanel2 = this.createHelpPanel();
        iPanel.add(iPanel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(iPanel2, gridBagConstraints);
        return iPanel;
    }

    private IPanel createOptionPanel() {
        this.cbg = new CheckboxGroup();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 18;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "\u00dcbernahme"));
        Checkbox checkbox = new Checkbox("neu als ALB", WldgeIOProperties.getImportOption() == 0, this.cbg);
        iPanel.add(checkbox);
        checkbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(checkbox, gridBagConstraints);
        checkbox = new Checkbox("neu als FLST", WldgeIOProperties.getImportOption() == 1, this.cbg);
        iPanel.add(checkbox);
        checkbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(checkbox, gridBagConstraints);
        checkbox = new Checkbox("Abgleich", WldgeIOProperties.getImportOption() == 2, this.cbg);
        iPanel.add(checkbox);
        checkbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(checkbox, gridBagConstraints);
        this.allCheckbox = new Checkbox("alle Daten", WldgeIOProperties.isImportAll());
        iPanel.add(this.allCheckbox);
        this.allCheckbox.setEnabled(WldgeIOProperties.getImportOption() == 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.allCheckbox, gridBagConstraints);
        this.diffLabel = new Label("zul\u00e4ssige Fl\u00e4chendifferenz: ");
        iPanel.add(this.diffLabel);
        this.diffLabel.setEnabled(WldgeIOProperties.getImportOption() == 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.diffLabel, gridBagConstraints);
        this.addTextField = new TextField(5);
        iPanel.add(this.addTextField);
        this.addTextField.setText(IFormat.f_1.format(WldgeIOProperties.getAddDifferenz()));
        this.addTextField.setEnabled(WldgeIOProperties.getImportOption() == 2);
        this.addTextField.setEditable(WldgeIOProperties.getImportOption() == 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.addTextField, gridBagConstraints);
        this.addLabel = new Label("m\u02db +");
        iPanel.add(this.addLabel);
        this.addLabel.setEnabled(WldgeIOProperties.getImportOption() == 2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.addLabel, gridBagConstraints);
        this.percentTextField = new TextField(5);
        iPanel.add(this.percentTextField);
        this.percentTextField.setText(IFormat.f_1.format(WldgeIOProperties.getPercentDifferenz()));
        this.percentTextField.setEnabled(WldgeIOProperties.getImportOption() == 2);
        this.percentTextField.setEditable(WldgeIOProperties.getImportOption() == 2);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.percentTextField, gridBagConstraints);
        this.percentLabel = new Label("%");
        iPanel.add(this.percentLabel);
        this.percentLabel.setEnabled(WldgeIOProperties.getImportOption() == 2);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.percentLabel, gridBagConstraints);
        this.sollCheckbox = new Checkbox("Flurst\u00fccksfl\u00e4che als Sollfl\u00e4che", WldgeIOProperties.isStammstueckSoll());
        iPanel.add(this.sollCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.sollCheckbox, gridBagConstraints);
        this.nutzFlaecheLabel = new Label("\u00dcbernahme der Nutzungsartenfl\u00e4chen:");
        iPanel.add(this.nutzFlaecheLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagLayout.setConstraints(this.nutzFlaecheLabel, gridBagConstraints);
        this.nutzFlaecheChoice = new Choice();
        iPanel.add(this.nutzFlaecheChoice);
        this.nutzFlaecheChoice.add(NUTZ_OHNE);
        this.nutzFlaecheChoice.add(NUTZ_BUCH);
        this.nutzFlaecheChoice.add(NUTZ_SOLL);
        switch (WldgeIOProperties.getNutzungFlaecheArt()) {
            case 1: {
                this.nutzFlaecheChoice.select(1);
                break;
            }
            case 2: {
                this.nutzFlaecheChoice.select(2);
                break;
            }
            default: {
                this.nutzFlaecheChoice.select(0);
            }
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagLayout.setConstraints(this.nutzFlaecheChoice, gridBagConstraints);
        this.nutzSpecLabel = new Label("Spezialisierung der Nutzungsarten:");
        iPanel.add(this.nutzSpecLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagLayout.setConstraints(this.nutzSpecLabel, gridBagConstraints);
        this.nutzSpecChoice = new Choice();
        iPanel.add(this.nutzSpecChoice);
        this.nutzSpecChoice.add(SPEC_NO);
        this.nutzSpecChoice.add(SPEC_ALB);
        this.nutzSpecChoice.add(SPEC_ALK);
        this.nutzSpecChoice.add(SPEC_BOTH);
        switch (WldgeIOProperties.getNutzungSpec()) {
            case 1: {
                this.nutzSpecChoice.select(1);
                break;
            }
            case 2: {
                this.nutzSpecChoice.select(2);
                break;
            }
            case 3: {
                this.nutzSpecChoice.select(3);
                break;
            }
            default: {
                this.nutzSpecChoice.select(0);
            }
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagLayout.setConstraints(this.nutzSpecChoice, gridBagConstraints);
        return iPanel;
    }

    private IPanel createHelpPanel() {
        IPanel iPanel = new IPanel();
        FlowText flowText = new FlowText(HELP1_TEXT, true);
        iPanel.add(flowText);
        return iPanel;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateComponents();
        super.itemStateChanged(itemEvent);
    }

    private void updateComponents() {
        boolean bl = this.cbg.getSelectedCheckbox().getLabel().equals("Abgleich");
        this.allCheckbox.setEnabled(bl);
        this.diffLabel.setEnabled(bl);
        this.addTextField.setEnabled(bl);
        this.addTextField.setEditable(bl);
        this.addLabel.setEnabled(bl);
        this.percentTextField.setEnabled(bl);
        this.percentTextField.setEditable(bl);
        this.percentLabel.setEnabled(bl);
        this.nutzSpecLabel.setEnabled(bl);
        this.nutzSpecChoice.setEnabled(bl);
    }

    @Override
    public void setOptions() {
        String string = this.cbg.getSelectedCheckbox().getLabel();
        if (string.equals("neu als ALB")) {
            WldgeIOProperties.setImportOption(0);
        } else if (string.equals("neu als FLST")) {
            WldgeIOProperties.setImportOption(1);
        } else {
            WldgeIOProperties.setImportOption(2);
        }
        WldgeIOProperties.setImportAll(this.allCheckbox.getState());
        try {
            WldgeIOProperties.setAddDifferenz(new Double(IFormat.getFloats(this.addTextField.getText())));
            WldgeIOProperties.setPercentDifferenz(new Double(IFormat.getFloats(this.percentTextField.getText())));
        }
        catch (Exception exception) {
            // empty catch block
        }
        WldgeIOProperties.setStammstueckSoll(this.sollCheckbox.getState());
        switch (this.nutzFlaecheChoice.getSelectedIndex()) {
            case 1: {
                WldgeIOProperties.setNutzungFlaecheArt(1);
                break;
            }
            case 2: {
                WldgeIOProperties.setNutzungFlaecheArt(2);
                break;
            }
            default: {
                WldgeIOProperties.setNutzungFlaecheArt(0);
            }
        }
        switch (this.nutzSpecChoice.getSelectedIndex()) {
            case 1: {
                WldgeIOProperties.setNutzungSpec(1);
                break;
            }
            case 2: {
                WldgeIOProperties.setNutzungSpec(2);
                break;
            }
            case 3: {
                WldgeIOProperties.setNutzungSpec(3);
                break;
            }
            default: {
                WldgeIOProperties.setNutzungSpec(0);
            }
        }
    }
}

