/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.util.DataType;
import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IProgressElement;
import de.geocalc.awt.image.PassFilter;
import de.geocalc.geom.DPoint;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.GeoImage;
import de.geocalc.kafplot.GeoImageLocation;
import de.geocalc.kafplot.KafPlotColor;
import de.geocalc.kafplot.KafPlotVersion;
import de.geocalc.kafplot.KoordinatenSystem;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.io.TfwWriter;
import de.geocalc.text.IFormat;
import de.geocalc.xml.XMLElement;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class WmsGeoImage
extends GeoImage {
    private static final String INFO_FILE_NAME = "KafPlot.WMS.GetFeatureInfo";
    private static final String PRIOR_FORMATS = "html:html,text:txt,gml:xml,wms_xml:xml,xml:xml";
    private Hashtable layers = new Hashtable();
    private Hashtable formats = new Hashtable();
    private Hashtable systems = new Hashtable();
    private Hashtable queryFormats = new Hashtable();
    boolean isValid = false;
    String encProxyAuthorization = null;
    String encServerAuthorization = null;
    String requestPath = null;
    String requestParam = null;
    String preferedImageFormat = null;
    double ymin = Double.MAX_VALUE;
    double xmin = Double.MAX_VALUE;
    double ymax = -1.7976931348623157E308;
    double xmax = -1.7976931348623157E308;
    double dataYmin = 0.0;
    double resolution = 1.0;
    int width = 500;
    int height = 500;
    String system;
    String format;
    boolean changeProtocol = false;
    private String lastURL = null;
    private Point queryPoint = null;

    public WmsGeoImage() {
        this((String)null, (String)null);
    }

    public WmsGeoImage(String string, String string2) {
        this.setPathName(string);
        this.setName(string2);
        this.setImageLocation(new GeoImageLocation(this));
        this.setAlphaAlternate(true);
    }

    public void setProxyAuthorization(String string) {
        this.encProxyAuthorization = string;
    }

    public String getProxyAuthorization() {
        return this.encProxyAuthorization;
    }

    public void setServerAuthorization(String string) {
        this.encServerAuthorization = string;
    }

    public String getServerAuthorization() {
        return this.encServerAuthorization;
    }

    public void setResolution(double d) {
        if (d > 0.0 && d <= 1.0) {
            this.resolution = d;
        }
    }

    public void addFormat(String string) {
        this.formats.put(string, string);
    }

    public void setPreferedImageFormat(String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = Jimi.getDecoderTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string2.equals(string)) continue;
            this.preferedImageFormat = string;
        }
    }

    public void addQueryFormat(String string) {
        this.queryFormats.put(string, string);
    }

    public void addSystem(String string) {
        this.systems.put(string, string);
    }

    public Enumeration systems() {
        return this.systems.keys();
    }

    public void addLayer(String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        Layer layer = new Layer(this, string, string2, string3, string4, bl, bl2);
        this.layers.put(string, layer);
    }

    public boolean isLayerVisible(String string) {
        Layer layer = (Layer)this.layers.get(string);
        return layer != null && layer.isVisible;
    }

    public void setLayerVisible(String string, boolean bl) {
        Layer layer = (Layer)this.layers.get(string);
        if (layer != null) {
            layer.isVisible = bl;
        }
    }

    public boolean isLayerQueryable(String string) {
        Layer layer = (Layer)this.layers.get(string);
        return layer != null && layer.queryable;
    }

    public boolean isQueryable() {
        Enumeration enumeration = this.layers.elements();
        while (enumeration.hasMoreElements()) {
            if (!((Layer)enumeration.nextElement()).queryable) continue;
            return true;
        }
        return false;
    }

    public Enumeration layers() {
        return this.layers.keys();
    }

    public String getLayerTitle(String string) {
        Layer layer = (Layer)this.layers.get(string);
        return layer != null ? layer.title : null;
    }

    public String getLayerAbstract(String string) {
        Layer layer = (Layer)this.layers.get(string);
        return layer != null ? layer.abstr : null;
    }

    public String getLayerLegend(String string) {
        Layer layer = (Layer)this.layers.get(string);
        return layer != null ? layer.legend : null;
    }

    @Override
    public Message getMessage() {
        return new Message(this, "Bild: " + this.getName(), "Bild: " + this.getName() + " " + this.getWidth() + "x" + this.getHeight() + "px");
    }

    @Override
    public void setImageLocation(GeoImageLocation geoImageLocation) {
        GeoImageLocation geoImageLocation2 = this.getImageLocation();
        this.isValid = geoImageLocation2 != null && geoImageLocation2.equals(geoImageLocation);
        super.setImageLocation(geoImageLocation);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WmsGeoImage: ");
        if (this.getName() != null) {
            stringBuffer.append(this.getName());
        } else {
            stringBuffer.append("ohne Namen");
        }
        stringBuffer.append(" " + this.getWidth() + "," + this.getHeight());
        return stringBuffer.toString();
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (!iGraphics.isClip()) {
            GeoImageLocation geoImageLocation = this.getImageLocation();
            Rectangle rectangle = iGraphics.getViewRect();
            DPoint dPoint = iGraphics.getDataPoint(new Point(rectangle.x, rectangle.y), new DPoint());
            DPoint dPoint2 = iGraphics.getDataPoint(new Point(rectangle.x + rectangle.width, rectangle.y), new DPoint());
            DPoint dPoint3 = iGraphics.getDataPoint(new Point(rectangle.x, rectangle.y + rectangle.height), new DPoint());
            DPoint dPoint4 = iGraphics.getDataPoint(new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height), new DPoint());
            this.ymin = Double.MAX_VALUE;
            this.xmin = Double.MAX_VALUE;
            this.ymax = -1.7976931348623157E308;
            this.xmax = -1.7976931348623157E308;
            this.ymin = Math.min(this.ymin, dPoint.y);
            this.ymax = Math.max(this.ymax, dPoint.y);
            this.ymin = Math.min(this.ymin, dPoint2.y);
            this.ymax = Math.max(this.ymax, dPoint2.y);
            this.ymin = Math.min(this.ymin, dPoint3.y);
            this.ymax = Math.max(this.ymax, dPoint3.y);
            this.ymin = Math.min(this.ymin, dPoint4.y);
            this.ymax = Math.max(this.ymax, dPoint4.y);
            this.xmin = Math.min(this.xmin, dPoint.x);
            this.xmax = Math.max(this.xmax, dPoint.x);
            this.xmin = Math.min(this.xmin, dPoint2.x);
            this.xmax = Math.max(this.xmax, dPoint2.x);
            this.xmin = Math.min(this.xmin, dPoint3.x);
            this.xmax = Math.max(this.xmax, dPoint3.x);
            this.xmin = Math.min(this.xmin, dPoint4.x);
            this.xmax = Math.max(this.xmax, dPoint4.x);
            this.width = (int)Math.rint((this.ymax - this.ymin) * iGraphics.getScale());
            this.height = (int)Math.rint((this.xmax - this.xmin) * iGraphics.getScale());
            GeoImageLocation geoImageLocation2 = new GeoImageLocation(this);
            geoImageLocation2.setLocation(this.ymin, this.xmax);
            geoImageLocation2.setScale(1.0 / iGraphics.getScale());
            Point point = iGraphics.getGraphicPoint((this.ymin + this.ymax) / 2.0, (this.xmin + this.xmax) / 2.0, new Point());
            this.system = null;
            this.dataYmin = this.ymin;
            if (DataBase.kooSystemName != null) {
                this.system = DataBase.kooSystemName;
            } else if (DataBase.getKooSystem() == 489) {
                int n = KoordinatenSystem.getZone(DataBase.ymin);
                if (this.systems.get("EPSG:3258" + n) != null) {
                    this.system = "EPSG:3258" + n;
                } else if (this.systems.get("EPSG:258" + n) != null) {
                    this.system = "EPSG:258" + n;
                    this.ymin %= 1000000.0;
                    this.ymax %= 1000000.0;
                }
            }
            this.format = null;
            if (this.preferedImageFormat != null && this.formats.get(this.preferedImageFormat) != null) {
                this.format = this.preferedImageFormat;
            } else if (this.formats.get("image/png") != null) {
                this.format = "image/png";
            } else {
                String[] stringArray = Jimi.getDecoderTypes();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    if (this.formats.get(string) == null) continue;
                    this.format = string;
                    break;
                }
            }
            if (this.system == null && this.format != null) {
                this.setRasterImage(null);
            } else {
                super.setImageLocation(geoImageLocation2);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.getPathName() != null ? this.getPathName() : "");
                if (this.getPathName() != null && this.getPathName().indexOf("?") < 0) {
                    stringBuffer.append("?");
                }
                this.requestPath = stringBuffer.toString();
                stringBuffer = new StringBuffer();
                stringBuffer.append("&FORMAT=" + this.format);
                if (this.resolution != 1.0) {
                    stringBuffer.append("&WIDTH=" + (int)Math.rint((double)this.width * this.resolution));
                    stringBuffer.append("&HEIGHT=" + (int)Math.rint((double)this.height * this.resolution));
                } else {
                    stringBuffer.append("&WIDTH=" + this.width);
                    stringBuffer.append("&HEIGHT=" + this.height);
                }
                stringBuffer.append("&SRS=" + this.system);
                if (this.alphaAlternate) {
                    stringBuffer.append("&TRANSPARENT=true");
                }
                stringBuffer.append("&LAYERS=" + this.getVisibleLayersAsString());
                stringBuffer.append("&STYLES=");
                stringBuffer.append("&BBOX=" + this.ymin + "," + this.xmin + "," + this.ymax + "," + this.xmax);
                this.requestParam = stringBuffer.toString();
                String string = this.requestPath + "SERVICE=WMS&REQUEST=GetMap&Version=1.1.1" + this.requestParam;
                if (!string.equals(this.lastURL)) {
                    long l = System.currentTimeMillis();
                    Graphics graphics = iGraphics.getGraphics();
                    Font font = new Font("SansSerif", 3, 32);
                    FontMetrics fontMetrics = graphics.getFontMetrics(font);
                    Object object = "Lade Bilddaten: " + this.getName() + " ...";
                    graphics.setFont(font);
                    try {
                        graphics.setColor(KafPlotColor.IMAGE_FG);
                        graphics.setXORMode(Color.magenta);
                        graphics.drawString((String)object, point.x - fontMetrics.stringWidth((String)object) / 2, point.y);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getConnection(new URL(string)).getInputStream());
                        if (bufferedInputStream.markSupported()) {
                            bufferedInputStream.mark(1024);
                        }
                        try {
                            if (this.resolution != 0.0) {
                                FilteredImageSource filteredImageSource = new FilteredImageSource(Jimi.getImageProducer(bufferedInputStream), new AreaAveragingScaleFilter(this.width, this.height));
                                filteredImageSource = new FilteredImageSource(filteredImageSource, new PassFilter((ImageProducer)filteredImageSource, 3));
                                this.setRasterImage(Jimi.createRasterImage((ImageProducer)filteredImageSource, 4));
                            } else {
                                this.setRasterImage(Jimi.getRasterImage(bufferedInputStream));
                            }
                        }
                        catch (Exception exception) {
                            throw new Exception(this.readExceptionStream(bufferedInputStream));
                        }
                        System.out.println("RequestTime:" + (System.currentTimeMillis() - l));
                        graphics.drawString((String)object, point.x - fontMetrics.stringWidth((String)object) / 2, point.y);
                        graphics.setPaintMode();
                        this.lastURL = string;
                    }
                    catch (Exception exception) {
                        graphics.drawString((String)object, point.x - fontMetrics.stringWidth((String)object) / 2, point.y);
                        graphics.setPaintMode();
                        object = exception.getMessage();
                        graphics.setColor(KafPlotColor.IMAGE_FG);
                        font = new Font("SansSerif", 0, 12);
                        fontMetrics = graphics.getFontMetrics(font);
                        StringTokenizer stringTokenizer = new StringTokenizer(exception.getMessage(), "\n");
                        int n = point.y;
                        graphics.setFont(font);
                        while (stringTokenizer.hasMoreTokens()) {
                            String string2 = stringTokenizer.nextToken();
                            graphics.drawString(string2, point.x - fontMetrics.stringWidth(string2) / 2, n);
                            n += fontMetrics.getHeight();
                            System.out.println(string2);
                        }
                        return;
                    }
                }
            }
        }
        super.drawBackground(iGraphics, bl, bl2);
    }

    public void setQueryPoint(Point point) {
        this.queryPoint = point;
    }

    public void query(Point point) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        if (point == null) {
            point = this.queryPoint;
        }
        if (point == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("&I=" + point.x);
        stringBuffer.append("&X=" + point.x);
        stringBuffer.append("&J=" + point.y);
        stringBuffer.append("&Y=" + point.y);
        stringBuffer.append("&QUERY_LAYERS=");
        int n = 0;
        Object object5 = this.layers.keys();
        while (object5.hasMoreElements()) {
            string = object5.nextElement().toString();
            if (!this.isLayerVisible(string) || !this.isLayerQueryable(string)) continue;
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(string);
            ++n;
        }
        if (n == 0) {
            return;
        }
        object5 = null;
        string = "txt";
        int n2 = 99;
        Object object6 = this.queryFormats.elements();
        while (object6.hasMoreElements()) {
            object4 = object6.nextElement().toString();
            object3 = new StringTokenizer(PRIOR_FORMATS, ",");
            int n3 = 0;
            while (((StringTokenizer)object3).hasMoreElements()) {
                object2 = ((StringTokenizer)object3).nextToken();
                int n4 = ((String)object2).indexOf(":");
                object = ((String)object2).substring(0, n4);
                String string2 = ((String)object2).substring(n4 + 1);
                if (((String)object4).indexOf((String)object) >= 0 && n3 < n2) {
                    object5 = object4;
                    string = string2;
                    n2 = n3;
                }
                ++n3;
            }
        }
        if (object5 == null) {
            return;
        }
        stringBuffer.append("&INFO_FORMAT=" + object5);
        object6 = "KafPlot.WMS.GetFeatureInfo." + string;
        stringBuffer.append("&FEATURE_COUNT=99");
        object4 = this.requestPath + "SERVICE=WMS&REQUEST=GetFeatureInfo&Version=1.1.1" + this.requestParam + stringBuffer.toString();
        try {
            object3 = new BufferedInputStream(this.getConnection(new URL((String)object4)).getInputStream());
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)object3));
            object2 = new PrintWriter(new BufferedWriter(new FileWriter(new File((String)object6))));
            String string3 = null;
            while ((string3 = lineNumberReader.readLine()) != null) {
                ((PrintWriter)object2).println(string3);
            }
            ((PrintWriter)object2).close();
            try {
                object = Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + (String)object6);
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void save(int n, IProgressElement iProgressElement, ExceptionList exceptionList) {
        String string = DataType.getFileExtension(this.format);
        String string2 = TfwWriter.createFileExtension(string);
        String string3 = System.getProperty("user.dir") + File.separator;
        n = Math.max(n, 1);
        n = Math.min(n, 99);
        iProgressElement.setEndValue(n * n);
        iProgressElement.showProgress(0L);
        if (n == 1) {
            try {
                String string4 = this.getName();
                Jimi.putImage(this.getRasterImage(), string4 + "." + string);
                TfwWriter tfwWriter = new TfwWriter(new File(string4 + "." + string2), this.dataYmin, this.xmax, ((this.ymax - this.ymin) / (double)this.width + (this.xmax - this.xmin) / (double)this.height) / 2.0, 0.0);
                tfwWriter.write();
            }
            catch (Exception exception) {
                exceptionList.addException(exception);
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("&FORMAT=" + this.format);
            stringBuffer.append("&WIDTH=" + this.width);
            stringBuffer.append("&HEIGHT=" + this.height);
            stringBuffer.append("&SRS=" + this.system);
            stringBuffer.append("&LAYERS=" + this.getVisibleLayersAsString());
            stringBuffer.append("&STYLES=");
            String string5 = stringBuffer.toString();
            double d = (this.ymax - this.ymin) / (double)n;
            double d2 = (this.xmax - this.xmin) / (double)n;
            double d3 = this.xmin;
            for (int i = 0; i < n; ++i) {
                double d4 = this.ymin;
                double d5 = this.dataYmin;
                for (int j = 0; j < n; ++j) {
                    String string6 = this.requestPath + "SERVICE=WMS&REQUEST=GetMap&Version=1.1.1" + string5 + "&BBOX=" + d4 + "," + d3 + "," + (d4 + d) + "," + (d3 + d2);
                    try {
                        String string7 = this.getName() + "_" + IFormat.i02.format(i + 1) + "_" + IFormat.i02.format(j + 1);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getConnection(new URL(string6)).getInputStream());
                        if (bufferedInputStream.markSupported()) {
                            bufferedInputStream.mark(1024);
                        }
                        try {
                            this.setRasterImage(Jimi.getRasterImage(bufferedInputStream));
                        }
                        catch (Exception exception) {
                            throw new Exception(this.readExceptionStream(bufferedInputStream));
                        }
                        Jimi.putImage(this.getRasterImage(), string7 + "." + string);
                        TfwWriter tfwWriter = new TfwWriter(new File(string7 + "." + string2), d5, d3 + d2, (d / (double)this.width + d2 / (double)this.height) / 2.0, 0.0);
                        tfwWriter.write();
                        iProgressElement.showProgress((i + 1) * (j + 1), "Speichere " + string7 + "." + string);
                    }
                    catch (Exception exception) {
                        exceptionList.addException(exception);
                    }
                    d4 += d;
                    d5 += d;
                }
                d3 += d2;
            }
        }
        iProgressElement.showProgress(100L);
    }

    private String readExceptionStream(BufferedInputStream bufferedInputStream) throws Exception {
        if (bufferedInputStream.markSupported()) {
            bufferedInputStream.reset();
        }
        XMLElement xMLElement = new XMLElement();
        StringBuffer stringBuffer = new StringBuffer("Fehler beim Laden " + this.getName() + "\n");
        try {
            xMLElement.parseFromReader(new InputStreamReader(bufferedInputStream));
            Enumeration enumeration = xMLElement.enumerateChildren();
            while (enumeration.hasMoreElements()) {
                XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
                stringBuffer.append(xMLElement2.getContent());
            }
        }
        catch (Exception exception) {
            if (bufferedInputStream.markSupported()) {
                bufferedInputStream.reset();
            }
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(bufferedInputStream));
            String string = null;
            while ((string = lineNumberReader.readLine()) != null) {
                stringBuffer.append(string + "\n");
            }
        }
        return stringBuffer.toString().trim();
    }

    private URLConnection getConnection(URL uRL) throws IOException {
        Object object;
        if (this.changeProtocol) {
            object = uRL.toString();
            if (((String)object).startsWith("http:")) {
                object = "https:" + ((String)object).substring(5);
            } else if (((String)object).startsWith("https:")) {
                object = "http:" + ((String)object).substring(6);
            }
            uRL = new URL((String)object);
        }
        object = (HttpURLConnection)uRL.openConnection();
        ((URLConnection)object).setRequestProperty("User-Agent", KafPlotVersion.getUserAgent());
        if (this.getProxyAuthorization() != null) {
            ((URLConnection)object).setRequestProperty("Proxy-Authorization", this.getProxyAuthorization());
        }
        if (this.getServerAuthorization() != null) {
            ((URLConnection)object).setRequestProperty("Authorization", "Basic " + this.getServerAuthorization());
        }
        ((URLConnection)object).connect();
        int n = ((HttpURLConnection)object).getResponseCode();
        if (n >= 300) {
            Object object2 = uRL.toString();
            if (((String)object2).startsWith("http:")) {
                object2 = "https:" + ((String)object2).substring(5);
            } else if (((String)object2).startsWith("https:")) {
                object2 = "http:" + ((String)object2).substring(6);
            } else {
                throw new IOException("Keine Verbindung zu " + (String)object2 + " , ResponseCode: " + n);
            }
            uRL = new URL((String)object2);
            object = (HttpURLConnection)uRL.openConnection();
            ((URLConnection)object).setRequestProperty("User-Agent", KafPlotVersion.getUserAgent());
            if (this.getProxyAuthorization() != null) {
                ((URLConnection)object).setRequestProperty("Proxy-Authorization", this.getProxyAuthorization());
            }
            if (this.getServerAuthorization() != null) {
                ((URLConnection)object).setRequestProperty("Authorization", "Basic " + this.getServerAuthorization());
            }
            ((URLConnection)object).connect();
            if (((HttpURLConnection)object).getResponseCode() > 300) {
                throw new IOException("Keine Verbindung zu " + (String)object2 + " , ResponseCode: " + n);
            }
            this.changeProtocol = true;
        }
        return object;
    }

    private String getVisibleLayersAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Enumeration enumeration = this.layers.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            if (!this.isLayerVisible(string)) continue;
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    private class Layer {
        public boolean queryable = false;
        public boolean opaque = false;
        public boolean cascaded = false;
        public boolean isVisible = true;
        public String name = null;
        public String title = null;
        public String abstr = null;
        public String legend = null;

        public Layer(WmsGeoImage wmsGeoImage, String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
            this.name = string;
            this.title = string2;
            this.abstr = string3;
            this.legend = string4;
            this.queryable = bl;
            this.isVisible = bl2;
        }

        public String toString() {
            return this.name + ":" + this.title + ":" + this.abstr + ":" + (this.isVisible ? "visible" : "not visible");
        }
    }
}

