/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ErrorDialog;
import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.FlowText;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.IProgressBar;
import de.geocalc.awt.IProgressElement;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.WmsGeoImage;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class WmsSaveDialog
extends IDialog
implements ActionListener {
    DataBase db;
    protected ExceptionList exceptions;
    private static final String OK_COMMAND = "OK";
    private static final String ABORT_COMMAND = "Abbrechen";
    private static final String OPTION_COMMAND = "Optionen";
    private static final String HELP_TEXT_CELL = "Der WMS-Service kann mit einem Raster aus Zellen abgefragt werden. Damit erh\u00f6ht sich die Aufl\u00f6sung der abgefragten Bilddaten.";
    private Button okButton;
    private Button abortButton;
    private Label progressLabel;
    private IProgressBar progressBar;
    private Choice cellChoice;
    private WmsGeoImage img;

    public WmsSaveDialog(IFrame iFrame, String string, DataBase dataBase, WmsGeoImage wmsGeoImage) {
        super(iFrame, string, true);
        this.db = dataBase;
        this.img = wmsGeoImage;
        this.exceptions = new ExceptionList();
        this.setLayout(new BorderLayout());
        Panel panel = new Panel(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Zellen"));
        FlowText flowText = new FlowText(HELP_TEXT_CELL, false);
        iPanel.add(flowText);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(flowText, gridBagConstraints);
        this.cellChoice = new Choice();
        iPanel.add(this.cellChoice);
        this.cellChoice.add("1");
        this.cellChoice.add("2 x 2");
        this.cellChoice.add("4 x 4");
        this.cellChoice.add("8 x 8");
        this.cellChoice.add("16 x 16");
        this.cellChoice.add("32 x 32");
        this.cellChoice.add("64 x 64");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.cellChoice, gridBagConstraints);
        panel.add("North", iPanel);
        IPanel iPanel2 = new IPanel(new BorderLayout());
        IBorder iBorder = new IBorder(1);
        iPanel2.setBorder(iBorder);
        Panel panel2 = new Panel(new FlowLayout());
        this.progressBar = new IProgressBar();
        panel2.add(this.progressBar);
        iPanel2.add("North", panel2);
        Panel panel3 = new Panel(new GridLayout(1, 1));
        this.progressLabel = new Label();
        panel3.add(this.progressLabel);
        iPanel2.add("South", panel3);
        panel.add("South", iPanel2);
        this.add("North", panel);
        Panel panel4 = new Panel(new FlowLayout(2));
        this.okButton = new Button(OK_COMMAND);
        this.okButton.addActionListener(this);
        panel4.add(this.okButton);
        this.abortButton = new Button(ABORT_COMMAND);
        this.abortButton.addActionListener(this);
        panel4.add(this.abortButton);
        this.add("South", panel4);
        this.pack();
        this.setLocationOfParent(iFrame);
    }

    public void write() {
        String string = this.cellChoice.getSelectedItem();
        int n = string.indexOf("x");
        int n2 = Integer.parseInt(n > 0 ? string.substring(0, n).trim() : string);
        this.img.save(n2, new IProgressElement(this.progressBar, this.progressLabel), this.exceptions);
        if (this.exceptions.size() > 0) {
            ErrorDialog errorDialog = new ErrorDialog(this.parent, this.exceptions);
            errorDialog.setVisible(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK_COMMAND)) {
            this.write();
            this.endDialog();
        } else if (string.equals(ABORT_COMMAND)) {
            this.endDialog();
        }
    }

    @Override
    protected void endDialog() {
        if (!this.exceptions.isEmpty()) {
            ErrorDialog errorDialog = new ErrorDialog(this.parent, "Es sind Fehler beim Schreiben der Daten aufgetreten, \ndie fehlerhafte Daten wurden markiert.", this.exceptions);
            errorDialog.setVisible(true);
        }
        super.endDialog();
    }

    @Override
    protected void doStandardAction() {
        this.write();
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

