/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.kafplot.Ebene;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktParameterALK;
import de.geocalc.kafplot.io.IFreePunktReader;
import de.geocalc.kafplot.io.aga.AgaIOProperties;
import de.geocalc.text.IFormat;
import de.geocalc.util.LongHashList;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;

public class AgaKooReader
extends IFreePunktReader {
    private long nr = 0L;
    private double y;
    private double x;
    private double z;
    private int art;
    private int vat;

    public AgaKooReader(File file, LongHashList longHashList) {
        super(file, longHashList, null);
    }

    public AgaKooReader(File file, LongHashList longHashList, IProgressViewer iProgressViewer) {
        super(file, longHashList, iProgressViewer);
    }

    public AgaKooReader(File file, Vector vector) {
        super(file, vector, null);
    }

    public AgaKooReader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, vector, iProgressViewer);
    }

    @Override
    protected Punkt lineToPunkt(String string) {
        if (string.length() == 0) {
            return null;
        }
        switch (string.charAt(0)) {
            case '#': 
            case '*': 
            case '>': {
                return null;
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        int n = new Integer((String)stringTokenizer.nextElement());
        String string2 = "";
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextElement().toString().trim();
        }
        if (string2.indexOf("#") >= 0) {
            string2 = string2.substring(0, string2.indexOf("#")).trim();
        }
        block5 : switch (n) {
            case 0: {
                break;
            }
            case 4: {
                if (!AgaIOProperties.punktcode) break;
                String string3 = IFormat.getFirstNumbers(string2);
                switch (string3.length()) {
                    case 0: {
                        break block5;
                    }
                    case 1: {
                        this.art = Integer.parseInt(string3);
                        break block5;
                    }
                    case 2: 
                    case 3: {
                        this.vat = Integer.parseInt(string3);
                        break block5;
                    }
                }
                this.art = Integer.parseInt(string3.substring(0, 1));
                this.vat = Integer.parseInt(string3.substring(1, 4));
                break;
            }
            case 5: {
                Punkt punkt = this.createPunkt();
                try {
                    this.nr = Long.parseLong(string2);
                    return this.nr;
                }
                catch (Exception exception) {
                    throw new NumberFormatException();
                }
                finally {
                    return punkt;
                }
            }
            case 37: {
                this.x = new Double(string2);
                break;
            }
            case 38: {
                this.y = new Double(string2);
                break;
            }
            case 39: {
                this.z = new Double(string2);
            }
        }
        return null;
    }

    @Override
    protected Punkt getLastElement() {
        return this.createPunkt();
    }

    private Punkt createPunkt() {
        Punkt punkt = null;
        if (this.nr != 0L) {
            punkt = new Punkt(this.nr, this.y, this.x, (float)this.z);
            if (AgaIOProperties.punktcode) {
                PunktParameterALK punktParameterALK = new PunktParameterALK();
                if (this.art >= 0) {
                    punktParameterALK.setPa(this.art);
                    punktParameterALK.setEb(Ebene.getDefaultEbene(this.art));
                }
                if (this.vat >= 0) {
                    punktParameterALK.setVa(this.vat);
                }
                if (this.art >= 0 && this.vat >= 0) {
                    punkt.initParameter(punktParameterALK);
                }
            }
        }
        this.nr = 0L;
        this.art = -1;
        this.vat = -1;
        this.y = 0.0;
        this.x = 0.0;
        this.z = 0.0;
        return punkt;
    }
}

