/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.alk.EdbsLinie;
import de.geocalc.alk.EdbsName;
import de.geocalc.alk.EdbsObjekt;
import de.geocalc.alk.EdbsPunkt;
import de.geocalc.alk.EdbsText;
import de.geocalc.awt.IProgressViewer;
import de.geocalc.geodata.Feature;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DPolygon;
import de.geocalc.geom.DRectangle;
import de.geocalc.geom.GeomException;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.FlurstueckArt;
import de.geocalc.kafplot.FlurstueckTable;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.GObjectManipulator;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.GebaeudeKennzeichen;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.LinieParameter;
import de.geocalc.kafplot.ObjectSymbol;
import de.geocalc.kafplot.ObjectText;
import de.geocalc.kafplot.Oska;
import de.geocalc.kafplot.PropertyLoader;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.PunktParameterALK;
import de.geocalc.kafplot.Symbol;
import de.geocalc.kafplot.TopObject;
import de.geocalc.kafplot.io.ErrorWriter;
import de.geocalc.kafplot.io.IDataReader;
import de.geocalc.kafplot.io.edbs.EdbsIOProperties;
import de.geocalc.kataster.model.Alk;
import de.geocalc.text.IFormat;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class AlkReader
extends IDataReader {
    private static long NEW_NUMBER = 0L;
    private DataBase db;
    Hashtable HP = new Hashtable();
    Hashtable errObjects = new Hashtable();
    private static final Stack anchors = new Stack();
    private static final Stack points = new Stack();
    private static final int LINIE_OBJECT_DEF = 242;
    private de.geocalc.alk.AlkReader reader = null;
    private static final Vector ausgestaltungen = new Vector();

    public AlkReader(File file, DataBase dataBase) {
        this(file, dataBase, null);
    }

    public AlkReader(File file, DataBase dataBase, IProgressViewer iProgressViewer) {
        super(file, iProgressViewer);
        this.db = dataBase;
        Enumeration enumeration = dataBase.punkte();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            this.HP.put(new EdbsPunkt((long)Math.rint(punkt.x * 1000.0), (long)Math.rint(punkt.y * 1000.0)), punkt);
        }
        EdbsIOProperties.setInCleanAreas(EdbsIOProperties.isInStandardCleanAreas());
        if (Gemeinde.count() == 0) {
            new PropertyLoader().loadKatalogData();
        }
    }

    @Override
    protected void setParameter() {
        super.setParameter();
        this.katasterModel = 1;
        if (NEW_NUMBER > 0L) {
            super.setFreeStartNumber(NEW_NUMBER);
        }
    }

    @Override
    public boolean isMutableNumberReader() {
        return true;
    }

    public static void setNewNumber(long l) {
        NEW_NUMBER = l;
    }

    private double getKoo(long l) {
        return (double)l / 1000.0;
    }

    private double getAngle(int n) {
        if (n == 0) {
            return 1.5707963267948966;
        }
        double d = (double)n / 100.0;
        if (d > 200.0) {
            d -= 200.0;
        }
        return d * Math.PI / 200.0;
    }

    private Punkt createPunkt(EdbsObjekt edbsObjekt) {
        Cloneable cloneable;
        Punkt punkt = null;
        punkt = edbsObjekt.getName() != null ? new Punkt(Long.parseLong(edbsObjekt.getName())) : ((cloneable = (Punkt)this.HP.get(new EdbsPunkt(edbsObjekt.getX(), edbsObjekt.getY()))) != null ? (Punkt)((Punkt)cloneable).clone() : this.createPunkt());
        punkt.x = this.getKoo(edbsObjekt.getX());
        punkt.y = this.getKoo(edbsObjekt.getY());
        cloneable = new PunktParameterALK();
        int n = -1;
        switch (edbsObjekt.getFolie()) {
            case 50: {
                n = 0;
                break;
            }
            case 51: {
                n = 1;
                break;
            }
            case 52: {
                n = 2;
                break;
            }
            case 53: {
                n = 3;
                break;
            }
            case 54: {
                n = 4;
                break;
            }
            case 57: {
                n = 7;
                break;
            }
            case 58: {
                n = 8;
                break;
            }
            case 59: {
                n = 9;
            }
        }
        ((PunktParameterALK)cloneable).setPa(n);
        ((PunktParameterALK)cloneable).setOska(edbsObjekt.getOska());
        ((PunktParameterALK)cloneable).setFolie(edbsObjekt.getFolie());
        punkt.initParameter((PunktParameter)cloneable);
        punkt.nr = punkt.buildKatNr(this.getPnrModus());
        this.HP.put(new EdbsPunkt(edbsObjekt.getX(), edbsObjekt.getY()), punkt);
        return punkt;
    }

    private Punkt createPunkt() {
        Punkt punkt = new Punkt();
        punkt.nr = this.getFreeNumber(DataBase.P);
        return punkt;
    }

    private Punkt getPunkt(EdbsPunkt edbsPunkt) {
        Punkt punkt = (Punkt)this.HP.get(edbsPunkt);
        if (punkt != null) {
            return punkt;
        }
        punkt = this.createPunkt();
        punkt.x = (double)edbsPunkt.getX() / 1000.0;
        punkt.y = (double)edbsPunkt.getY() / 1000.0;
        this.HP.put(edbsPunkt, punkt);
        this.savePunkt(punkt, DataBase.P);
        return punkt;
    }

    private TopObject createTopObject(EdbsObjekt edbsObjekt) {
        TopObject topObject = new TopObject();
        topObject.x = (double)edbsObjekt.getX() / 1000.0;
        topObject.y = (double)edbsObjekt.getY() / 1000.0;
        topObject.setTextAngle(1.5707963267948966);
        topObject.setOska(edbsObjekt.getOska());
        topObject.setFolie(edbsObjekt.getFolie());
        if (edbsObjekt.getName() != null) {
            topObject.setBezeichnung(this.createName(edbsObjekt.getFolie(), edbsObjekt.getOska(), edbsObjekt.getName()));
        }
        if (edbsObjekt.getTyp() == 'F') {
            this.fillAreaObject(topObject, edbsObjekt);
        }
        this.fillAusgestaltung(topObject, edbsObjekt, edbsObjekt.getTyp() != 'F');
        return topObject;
    }

    private String createName(int n, int n2, String string) {
        switch (n2) {
            case 618: {
                if (string.startsWith("GM")) {
                    return string.substring(2);
                }
                return string;
            }
        }
        return string;
    }

    private Flurstueck createFlur(EdbsObjekt edbsObjekt) {
        Flurstueck flurstueck = new Flurstueck();
        String string = edbsObjekt.getName();
        if (string != null) {
            flurstueck.setGemarkung(Integer.parseInt(string.substring(2, 8)));
            flurstueck.setFlur(Integer.parseInt(string.substring(8, 11)));
        } else {
            DPoint dPoint = new DPoint(this.getKoo(edbsObjekt.getY()), this.getKoo(edbsObjekt.getX()));
            this.addException(new GeomException(2, dPoint, dPoint, "Objekt " + edbsObjekt.getNummer() + " hat keinen Objektnamen"));
        }
        flurstueck.setArt(300);
        flurstueck.setOska(edbsObjekt.getOska());
        flurstueck.setFolie(edbsObjekt.getFolie());
        this.fillAreaObject(flurstueck, edbsObjekt);
        this.fillAusgestaltung(flurstueck, edbsObjekt, false);
        return flurstueck;
    }

    private Flurstueck createFlurstueck(EdbsObjekt edbsObjekt) {
        Flurstueck flurstueck = new Flurstueck();
        String string = edbsObjekt.getName();
        if (string != null) {
            if (string.startsWith("SF")) {
                flurstueck.setGemarkung(Integer.parseInt(string.substring(2, 8)));
                flurstueck.setFlur(Integer.parseInt(string.substring(8, 12)));
                try {
                    flurstueck.setZaehler(Integer.parseInt(string.substring(12, 18)));
                    flurstueck.setNenner(Integer.parseInt(string.substring(18, 23)));
                    flurstueck.setTeil(0);
                }
                catch (Exception exception) {
                    flurstueck.setZaehler(Integer.parseInt(string.substring(12, 17)));
                    flurstueck.setTeil(string.charAt(17) - 96);
                    flurstueck.setNenner(Integer.parseInt(string.substring(18, 23)));
                }
            } else {
                flurstueck.setGemarkung(Integer.parseInt(string.substring(2, 8)));
                flurstueck.setFlur(Integer.parseInt(string.substring(8, 11)));
                flurstueck.setZaehler(Integer.parseInt(string.substring(11, 16)));
                flurstueck.setNenner(Integer.parseInt(string.substring(16, 19)));
                flurstueck.setTeil(0);
            }
        } else {
            DPoint dPoint = new DPoint(this.getKoo(edbsObjekt.getY()), this.getKoo(edbsObjekt.getX()));
            this.addException(new GeomException(2, dPoint, dPoint, "Objekt " + edbsObjekt.getNummer() + " hat keinen Objektnamen"));
        }
        flurstueck.setArt(700);
        flurstueck.setOska(edbsObjekt.getOska());
        flurstueck.setFolie(edbsObjekt.getFolie());
        this.fillAreaObject(flurstueck, edbsObjekt);
        this.fillAusgestaltung(flurstueck, edbsObjekt, false);
        return flurstueck;
    }

    private Flurstueck createNutzung(EdbsObjekt edbsObjekt) {
        Flurstueck flurstueck = new Flurstueck();
        flurstueck.setTeil(0);
        flurstueck.setNutzung(edbsObjekt.getOska() / 10);
        flurstueck.setArt(FlurstueckArt.getArt(9, 0, 0));
        this.fillAreaObject(flurstueck, edbsObjekt);
        this.fillAusgestaltung(flurstueck, edbsObjekt, false);
        return flurstueck;
    }

    private Gebaeude createGebaeude(EdbsObjekt edbsObjekt) {
        Gebaeude gebaeude = new Gebaeude();
        boolean bl = false;
        if (edbsObjekt.getName() != null) {
            try {
                gebaeude.setLeitzeichen(GebaeudeKennzeichen.parseBspeLine(edbsObjekt.getName()));
            }
            catch (Exception exception) {
                bl = true;
                DPoint dPoint = new DPoint(this.getKoo(edbsObjekt.getY()), this.getKoo(edbsObjekt.getX()));
                this.addException(new GeomException(2, dPoint, dPoint, "Geb\u00e4ude " + edbsObjekt.getNummer() + " hat ung\u00fcltigen Objektnamen " + edbsObjekt.getName() + ", " + exception.getMessage()));
            }
        } else if (edbsObjekt.getFolie() == 11) {
            DPoint dPoint = new DPoint(this.getKoo(edbsObjekt.getY()), this.getKoo(edbsObjekt.getX()));
            this.addException(new GeomException(2, dPoint, dPoint, "Objekt " + edbsObjekt.getNummer() + " hat keinen Objektnamen"));
        }
        gebaeude.setOska(edbsObjekt.getOska());
        gebaeude.setFolie(edbsObjekt.getFolie());
        this.fillAreaObject(gebaeude, edbsObjekt);
        this.fillAusgestaltung(gebaeude, edbsObjekt, false);
        return gebaeude;
    }

    private void fillAusgestaltung(GObject gObject, EdbsObjekt edbsObjekt, boolean bl) {
        Object object;
        int n = edbsObjekt.size();
        for (int i = 0; i < n; ++i) {
            Object object2;
            object = edbsObjekt.elementAt(i);
            if (object instanceof EdbsLinie) {
                object2 = (EdbsLinie)object;
                if (!bl && ((EdbsLinie)object2).isDefGeom()) continue;
                this.addLinie(gObject, 2, (EdbsLinie)object2, false);
                continue;
            }
            if (object instanceof EdbsPunkt) {
                gObject.addDecor(this.createObjectSymbol((EdbsPunkt)object));
                continue;
            }
            if (object instanceof EdbsText) {
                gObject.addDecor(this.createObjectText((EdbsText)object));
                continue;
            }
            if (object instanceof EdbsName) {
                object2 = (EdbsName)object;
                byte by = ((EdbsName)object2).getAdI();
                double d = this.getKoo(((EdbsName)object2).getY());
                double d2 = this.getKoo(((EdbsName)object2).getX());
                double d3 = this.getAngle(((EdbsName)object2).getWinkel());
                if (by == 13 || by == 16) {
                    if (gObject.y != d) {
                        gObject.yt = d;
                    }
                    if (gObject.x != d2) {
                        gObject.xt = d2;
                    }
                    gObject.setTextAngle(d3);
                    continue;
                }
                if (by != 14 && by != 17 || !(gObject instanceof Gebaeude)) continue;
                try {
                    GebaeudeKennzeichen gebaeudeKennzeichen = GebaeudeKennzeichen.parseBspeLine(((EdbsName)object2).getText());
                    gebaeudeKennzeichen.y = d;
                    gebaeudeKennzeichen.x = d2;
                    gebaeudeKennzeichen.setAngle(d3);
                    ((Gebaeude)gObject).addKennzeichen(gebaeudeKennzeichen);
                }
                catch (Exception exception) {
                    this.addException(new GeomException(2, new DPoint(d, d2), gObject.getPolygon(), "Geb\u00e4ude " + gObject.getExceptionableName() + " hat ung\u00fcltigen Objektnamen " + ((EdbsName)object2).getText() + ", " + exception.getMessage()));
                }
                continue;
            }
            this.addException(new GeomException(2, gObject.getHashPoint(), gObject.getPolygon(), "Objekt " + gObject.getExceptionableName() + " hat unbekannte Ausgestaltungsgeometrie: " + object.getClass().getName()));
        }
        Enumeration enumeration = edbsObjekt.attributes();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            gObject.setAttribute((String)object, edbsObjekt.getAttribute((String)object));
        }
    }

    private ObjectSymbol createObjectSymbol(EdbsPunkt edbsPunkt) {
        Symbol symbol = null;
        try {
            symbol = Symbol.getSymbol(Integer.toString(edbsPunkt.getOska()));
        }
        catch (Exception exception) {
            symbol = Symbol.UNKNOWN;
        }
        return new ObjectSymbol(symbol, edbsPunkt.getOska(), (double)edbsPunkt.getY() / 1000.0, (double)edbsPunkt.getX() / 1000.0, (float)(this.getAngle(edbsPunkt.getWinkel()) - 1.5707963267948966));
    }

    private ObjectText createObjectText(EdbsText edbsText) {
        String string = edbsText.getText().trim();
        DPoint dPoint = new DPoint((double)edbsText.getY() / 1000.0, (double)edbsText.getX() / 1000.0);
        if (string.length() == 0 && (string = Oska.getDefaultText(edbsText.getOska())) == null) {
            string = "???";
            this.addException(new GeomException(2, dPoint, dPoint, "Text mit Oska " + edbsText.getOska() + " hat keinen Inhalt"));
        }
        return new ObjectText(string, edbsText.getOska(), dPoint.y, dPoint.x, (float)this.getAngle(edbsText.getWinkel()));
    }

    private static LinieParameter createLinieParameter(int n, int n2) {
        LinieParameter linieParameter = new LinieParameter();
        linieParameter.setOska(n2);
        linieParameter.setFolie(n);
        block0 : switch (n2) {
            case 242: {
                linieParameter.setLa(0);
                linieParameter.setEb(0);
                break;
            }
            default: {
                switch (n) {
                    case 1: 
                    case 2: 
                    case 3: {
                        linieParameter.setLa(2);
                        linieParameter.setEb(1);
                        break block0;
                    }
                    case 11: 
                    case 84: 
                    case 86: {
                        linieParameter.setLa(3);
                        linieParameter.setEb(2);
                        break block0;
                    }
                    case 21: {
                        linieParameter.setLa(4);
                        linieParameter.setEb(47);
                        break block0;
                    }
                    case 23: {
                        linieParameter.setLa(4);
                        linieParameter.setEb(3);
                        break block0;
                    }
                    case 28: {
                        linieParameter.setLa(4);
                        linieParameter.setEb(5);
                        break block0;
                    }
                }
                linieParameter.setLa(4);
                linieParameter.setEb(4);
            }
        }
        if (n2 == 249) {
            linieParameter.setEb(0);
        }
        return linieParameter;
    }

    private double getNextAngle(EdbsPunkt edbsPunkt, EdbsPunkt edbsPunkt2, EdbsPunkt edbsPunkt3, boolean bl) {
        boolean bl2;
        double d = DPoint.getOrientation((double)edbsPunkt2.getY() / 1000.0, (double)edbsPunkt2.getX() / 1000.0, (double)edbsPunkt.getY() / 1000.0, (double)edbsPunkt.getX() / 1000.0);
        double d2 = DPoint.getOrientation((double)edbsPunkt2.getY() / 1000.0, (double)edbsPunkt2.getX() / 1000.0, (double)edbsPunkt3.getY() / 1000.0, (double)edbsPunkt3.getX() / 1000.0);
        double d3 = Math.abs(d2 - d);
        if (d3 > Math.PI) {
            d3 = Math.PI * 2 - d3;
        }
        boolean bl3 = bl2 = DLine.getDistance((double)edbsPunkt.getY() / 1000.0, (double)edbsPunkt.getX() / 1000.0, (double)edbsPunkt2.getY() / 1000.0, (double)edbsPunkt2.getX() / 1000.0, (double)edbsPunkt3.getY() / 1000.0, (double)edbsPunkt3.getX() / 1000.0) >= 0.0;
        if (bl != bl2) {
            d3 = Math.abs(Math.PI * 2 - d3);
        }
        return d3;
    }

    private boolean repairAreaGeometry(GObject gObject, EdbsObjekt edbsObjekt) {
        Hashtable<EdbsLinie, EdbsLinie> hashtable = new Hashtable<EdbsLinie, EdbsLinie>();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = edbsObjekt.size() - 1; i >= 0; --i) {
            EdbsLinie edbsLinie;
            Object e = edbsObjekt.elementAt(i);
            if (!AlkReader.isDefLinie(e) || hashtable.put(edbsLinie = (EdbsLinie)e, edbsLinie) == null) continue;
            edbsObjekt.removeElementAt(i);
            this.addException(new GeomException(2, gObject.getHashPoint(), new DLine(this.getKoo(edbsLinie.getPa().getY()), this.getKoo(edbsLinie.getPa().getX()), this.getKoo(edbsLinie.getPe().getY()), this.getKoo(edbsLinie.getPe().getX())), "Verkettungsproblem bei " + gObject.getExceptionableName() + ", Doppelte Linie:" + edbsLinie.getPa().getY() + "," + edbsLinie.getPa().getX() + "-" + edbsLinie.getPe().getY() + "," + edbsLinie.getPe().getX()));
            bl = true;
        }
        return bl;
    }

    private void fillAreaObject(GObject gObject, EdbsObjekt edbsObjekt) {
        boolean bl;
        gObject.y = (double)edbsObjekt.getY() / 1000.0;
        gObject.x = (double)edbsObjekt.getX() / 1000.0;
        boolean bl2 = bl = (this.findPolygon(gObject, edbsObjekt, true) || this.findPolygon(gObject, edbsObjekt, false)) && gObject.getPolygon() != null;
        if (!bl && this.repairAreaGeometry(gObject, edbsObjekt)) {
            gObject.removeAllElements();
            boolean bl3 = bl = (this.findPolygon(gObject, edbsObjekt, true) || this.findPolygon(gObject, edbsObjekt, false)) && gObject.getPolygon() != null;
        }
        if (!bl) {
            this.addException(new GeomException(2, gObject.getHashPoint(), gObject.getHashPoint(), "Verkettungsproblem bei " + gObject.getExceptionableName() + ", Reparaturversuch"));
            gObject.removeAllElements();
            EdbsLinie[] edbsLinieArray = AlkReader.getDefLines(edbsObjekt);
            for (int i = edbsLinieArray.length - 1; i >= 0; --i) {
                EdbsLinie edbsLinie = edbsLinieArray[i];
                if (edbsLinie == null) continue;
                this.addLinie(gObject, 2, edbsLinie, false);
            }
            GObjectManipulator gObjectManipulator = new GObjectManipulator(gObject);
            try {
                gObjectManipulator.concatenate();
            }
            catch (Exception exception) {
                if (gObjectManipulator.hasExceptions()) {
                    Enumeration enumeration = gObjectManipulator.exceptions();
                    while (enumeration.hasMoreElements()) {
                        this.addException((Exception)enumeration.nextElement());
                    }
                }
                this.addException(new GeomException(2, gObject.getHashPoint(), gObject.getHashPoint(), "Verkettungsproblem bei " + gObject.getExceptionableName() + ", " + exception.getMessage() + ", Objekt fehlerhaft"));
            }
            if (EdbsIOProperties.isInCleanAreas()) {
                this.errObjects.put(gObject, gObject);
            }
        }
        gObject.initGeom();
    }

    private static boolean isDefLinie(Object object) {
        if (!(object instanceof EdbsLinie)) {
            return false;
        }
        EdbsLinie edbsLinie = (EdbsLinie)object;
        return edbsLinie.isDefGeom();
    }

    private static boolean isAnchor(EdbsLinie edbsLinie) {
        return edbsLinie.getOska() == 242;
    }

    private static EdbsLinie[] getDefLines(EdbsObjekt edbsObjekt) {
        int n = 0;
        int n2 = 0;
        for (int i = edbsObjekt.size() - 1; i >= 0; --i) {
            Object e = edbsObjekt.elementAt(i);
            if (!AlkReader.isDefLinie(e)) continue;
            ++n;
        }
        EdbsLinie[] edbsLinieArray = new EdbsLinie[n];
        int n3 = 0;
        for (n2 = edbsObjekt.size() - 1; n2 >= 0; --n2) {
            Object e = edbsObjekt.elementAt(n2);
            if (!AlkReader.isDefLinie(e)) continue;
            edbsLinieArray[n3++] = (EdbsLinie)e;
        }
        return edbsLinieArray;
    }

    private EdbsLinie getStartLinie(EdbsLinie[] edbsLinieArray) {
        int n = 0;
        int n2 = edbsLinieArray.length - 1;
        while (n2 >= 0) {
            EdbsLinie edbsLinie = edbsLinieArray[n2];
            if (edbsLinie != null && !AlkReader.isAnchor(edbsLinie)) {
                edbsLinieArray[n2] = null;
                return edbsLinie;
            }
            n = n2--;
        }
        EdbsLinie edbsLinie = edbsLinieArray[n];
        edbsLinieArray[n] = null;
        return edbsLinie;
    }

    private boolean findPolygon(GObject gObject, EdbsObjekt edbsObjekt, boolean bl) {
        anchors.removeAllElements();
        points.removeAllElements();
        gObject.removeAllElements();
        EdbsLinie[] edbsLinieArray = AlkReader.getDefLines(edbsObjekt);
        EdbsLinie edbsLinie = this.getStartLinie(edbsLinieArray);
        if (edbsLinie == null) {
            this.addException(new GeomException(2, gObject.getHashPoint(), gObject.getHashPoint(), "Verkettungsproblem bei " + gObject.getExceptionableName() + ", keinen Startpunkt gefunden"));
            gObject.initGeom();
            return true;
        }
        boolean bl2 = edbsObjekt.getNumber().equals(edbsLinie.getRight());
        this.addLinie(gObject, 1, edbsLinie, !bl2);
        EdbsPunkt edbsPunkt = bl2 ? edbsLinie.getPa() : edbsLinie.getPe();
        EdbsPunkt edbsPunkt2 = bl2 ? edbsLinie.getPe() : edbsLinie.getPa();
        int n = edbsLinieArray.length;
        int n2 = 1;
        boolean bl3 = false;
        EdbsPunkt edbsPunkt3 = edbsPunkt;
        boolean bl4 = false;
        int n3 = -1;
        do {
            int n4;
            double d = Double.MAX_VALUE;
            bl3 = false;
            for (n4 = edbsLinieArray.length - 1; n4 >= 0; --n4) {
                double d2;
                EdbsLinie edbsLinie2;
                if (n4 == n3 || (edbsLinie2 = edbsLinieArray[n4]) == null) continue;
                if (AlkReader.isAnchor(edbsLinie2)) {
                    if (bl4) continue;
                    if (edbsLinie2.getPa().equals(edbsPunkt2) || edbsLinie2.getPe().equals(edbsPunkt2)) {
                        edbsLinie = edbsLinie2;
                        n3 = n4;
                        bl3 = true;
                        break;
                    }
                }
                if (edbsLinie2.getPa().equals(edbsPunkt2) && edbsObjekt.getNumber().equals(edbsLinie2.getRight()) && (d2 = this.getNextAngle(edbsPunkt, edbsPunkt2, edbsLinie2.getNextAfterStart(), bl)) < d) {
                    d = d2;
                    edbsLinie = edbsLinie2;
                    n3 = n4;
                    bl3 = true;
                }
                if (!edbsLinie2.getPe().equals(edbsPunkt2) || !edbsObjekt.getNumber().equals(edbsLinie2.getLeft()) || !((d2 = this.getNextAngle(edbsPunkt, edbsPunkt2, edbsLinie2.getLastBeforeEnd(), bl)) < d)) continue;
                d = d2;
                edbsLinie = edbsLinie2;
                n3 = n4;
                bl3 = true;
            }
            if (bl3) {
                boolean bl5;
                n4 = edbsLinie.getPa().equals(edbsPunkt2) ? 1 : 0;
                boolean bl6 = bl5 = n4 == 0;
                if (edbsLinie.hasPoints() && edbsLinie.getPa().equals(edbsLinie.getPe())) {
                    bl5 = edbsObjekt.getNumber().equals(edbsLinie.getLeft());
                }
                this.addLinie(gObject, 0, edbsLinie, bl5);
                EdbsPunkt edbsPunkt4 = edbsPunkt = bl5 ? edbsLinie.getNextAfterStart() : edbsLinie.getLastBeforeEnd();
                if (AlkReader.isAnchor(edbsLinie)) {
                    if (anchors.size() > 0 && (EdbsLinie)anchors.peek() == edbsLinie) {
                        anchors.pop();
                        edbsPunkt = (EdbsPunkt)points.pop();
                        edbsLinieArray[n3] = null;
                        ++n2;
                    } else {
                        anchors.push(edbsLinie);
                        points.push(edbsPunkt);
                        edbsPunkt = edbsPunkt2;
                    }
                    bl4 = true;
                } else {
                    edbsPunkt = edbsPunkt2;
                    edbsLinieArray[n3] = null;
                    bl4 = false;
                    ++n2;
                }
                edbsPunkt2 = n4 != 0 ? edbsLinie.getPe() : edbsLinie.getPa();
                continue;
            }
            if (gObject.size() <= 0) continue;
            gObject.addElement(new Linie(9, this.getPunkt(edbsPunkt2), null));
        } while (bl3);
        return n2 == n;
    }

    private static void setLinieToObjDef(Linie linie, Punkt punkt) {
        linie.setMitte();
        linie.setPe(punkt);
        linie.setParameter(AlkReader.createLinieParameter(0, 242));
    }

    private void addLinie(GObject gObject, int n, EdbsLinie edbsLinie, boolean bl) {
        Punkt punkt = this.getPunkt(bl ? edbsLinie.getPe() : edbsLinie.getPa());
        Punkt punkt2 = this.getPunkt(bl ? edbsLinie.getPa() : edbsLinie.getPe());
        LinieParameter linieParameter = AlkReader.createLinieParameter(edbsLinie.getFolie(), edbsLinie.getOska());
        if (edbsLinie.hasPoints()) {
            int n2 = bl ? edbsLinie.points() - 1 : 0;
            int n3 = bl ? -1 : edbsLinie.points();
            int n4 = bl ? -1 : 1;
            for (int i = n2; i != n3; i += n4) {
                Punkt punkt3 = this.getPunkt(edbsLinie.pointAt(i));
                Linie linie = new Linie(i == n2 ? (n == 2 ? 1 : n) : 0, punkt, punkt3);
                this.setLineRadius(linie, edbsLinie, bl);
                linie.setParameter(linieParameter);
                gObject.addElement(linie);
                punkt = punkt3;
            }
            Linie linie = new Linie(0, punkt, punkt2);
            this.setLineRadius(linie, edbsLinie, bl);
            linie.setParameter(linieParameter);
            gObject.addElement(linie);
            if (n == 2) {
                linie = new Linie(9, punkt2, null);
                linie.setParameter(linieParameter);
                gObject.addElement(linie);
            }
        } else {
            Linie linie = new Linie(n, punkt, punkt2);
            this.setLineRadius(linie, edbsLinie, bl);
            linie.setParameter(linieParameter);
            gObject.addElement(linie);
        }
    }

    private void setLineRadius(Linie linie, EdbsLinie edbsLinie, boolean bl) {
        if (edbsLinie.getRadius() != 0) {
            int n = -(edbsLinie.getRadius() + ((double)edbsLinie.getRadius() > 0.0 ? 1 : -1));
            if (bl) {
                n = -n;
            }
            linie.setRadius((double)n / 1000.0);
            linie.setRadiusKoo(true);
        }
    }

    @Override
    public void userAbort() throws IFileInputException {
        try {
            if (this.reader != null) {
                this.reader.userAbort();
            }
        }
        catch (Exception exception) {
            throw new IFileInputException(this.getErrorKey() + "Fehler beim Schlie\u00dfen der Datei: " + this.inFile.getName());
        }
    }

    @Override
    public void read() throws IFileInputException {
        Vector<Flurstueck> vector;
        Object object;
        this.newNumber = super.getFreeStartNumber();
        DataBase.model = Alk.getInstance();
        try {
            Cloneable cloneable;
            Cloneable cloneable2;
            Object object2;
            Flurstueck flurstueck;
            int n;
            Flurstueck[] flurstueckArray;
            Cloneable cloneable3;
            try {
                this.reader = new de.geocalc.alk.AlkReader(this.inFile, this.progressBar);
                object = new int[]{42};
                this.reader.setUnreadFolien((int[])object);
                this.reader.read();
                if (this.reader.hasError()) {
                    this.addException(new Exception(this.reader.getErrorMessage()));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.addException(iOException);
            }
            if (this.progressBar != null) {
                this.progressBar.setValue(0);
            }
            object = this.reader.objects();
            block25: while (object.hasMoreElements()) {
                cloneable3 = (EdbsObjekt)object.nextElement();
                if (((EdbsObjekt)cloneable3).getTyp() != 'P') continue;
                switch (((EdbsObjekt)cloneable3).getFolie()) {
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 57: 
                    case 59: 
                    case 85: {
                        vector = this.createPunkt((EdbsObjekt)cloneable3);
                        this.savePunkt((Punkt)((Object)vector), DataBase.P);
                        continue block25;
                    }
                }
                DataBase.TOP.put(this.createTopObject((EdbsObjekt)cloneable3));
            }
            if (this.progressBar != null) {
                this.progressBar.setValue(10);
            }
            object = new FlurstueckTable();
            cloneable3 = new Hashtable();
            vector = new Vector<Flurstueck>(500);
            int n2 = 0;
            int n3 = this.reader.getObjectCount();
            Enumeration enumeration = this.reader.objects();
            while (enumeration.hasMoreElements()) {
                flurstueckArray = (Flurstueck[])enumeration.nextElement();
                n = flurstueckArray.getTyp();
                if (n != 80) {
                    if (n == 70) {
                        switch (flurstueckArray.getFolie()) {
                            case 2: {
                                flurstueck = this.createFlur((EdbsObjekt)flurstueckArray);
                                try {
                                    DataBase.FLST.put(flurstueck);
                                }
                                catch (Exception exception) {
                                    this.addException(exception);
                                }
                                break;
                            }
                            case 1: {
                                object2 = this.createFlurstueck((EdbsObjekt)flurstueckArray);
                                try {
                                    ((FlurstueckTable)object).put((Feature)object2);
                                }
                                catch (Exception exception) {
                                    this.addException(new GeomException(2, ((DataContainer)object2).getHashPoint(), ((GObject)object2).getPolygon(), "Flurst\u00fccksobjekt " + ((DataContainer)object2).getExceptionableName() + " ist doppelt in den Daten vorhanden, gel\u00f6scht"));
                                }
                                break;
                            }
                            case 21: {
                                var11_22 = this.createNutzung((EdbsObjekt)flurstueckArray);
                                ((DataContainer)var11_22).setVisible(false);
                                vector.addElement((Flurstueck)var11_22);
                                break;
                            }
                            case 11: 
                            case 84: 
                            case 86: {
                                var12_28 = this.createGebaeude((EdbsObjekt)flurstueckArray);
                                try {
                                    DataBase.GEB.put((Feature)((Object)var12_28));
                                }
                                catch (Exception exception) {
                                    this.addException(new GeomException(2, ((DataContainer)var12_28).getHashPoint(), ((GObject)var12_28).getPolygon(), "Geb\u00e4udeobjekt " + ((DataContainer)var12_28).getExceptionableName() + " ist doppelt in den Daten vorhanden, gel\u00f6scht"));
                                }
                                break;
                            }
                            case 42: {
                                break;
                            }
                            default: {
                                TopObject topObject = this.createTopObject((EdbsObjekt)flurstueckArray);
                                DataBase.TOP.put(topObject);
                                break;
                            }
                        }
                    } else if (n == 76) {
                        switch (flurstueckArray.getFolie()) {
                            case 2: 
                            case 3: {
                                flurstueck = new Flurstueck();
                                this.fillAusgestaltung(flurstueck, (EdbsObjekt)flurstueckArray, true);
                                object2 = flurstueck.elements();
                                while (object2.hasMoreElements()) {
                                    var11_22 = (Linie)object2.nextElement();
                                    var12_28 = (Linie)((Hashtable)cloneable3).get(var11_22);
                                    if (var12_28 != null && ((Linie)var12_28).getOska() < ((Linie)var11_22).getOska()) continue;
                                    ((Hashtable)cloneable3).put(var11_22, var11_22);
                                }
                                break;
                            }
                            default: {
                                object2 = this.createTopObject((EdbsObjekt)flurstueckArray);
                                DataBase.TOP.put((Feature)object2);
                            }
                        }
                    }
                    if (this.progressBar != null && n2 % 200 == 0) {
                        this.progressBar.setValue(10 + n2 * 40 / n3);
                    }
                }
                ++n2;
            }
            if (this.progressBar != null) {
                this.progressBar.setValue(50);
            }
            int n4 = vector.size();
            flurstueckArray = new Flurstueck[n4];
            for (n = 0; n < n4; ++n) {
                flurstueckArray[n] = (Flurstueck)vector.elementAt(n);
            }
            for (n = 0; n < flurstueckArray.length; ++n) {
                flurstueck = flurstueckArray[n];
                object2 = flurstueck.getPolygon();
                if (object2 == null || ((DPolygon)object2).contains(flurstueck.y, flurstueck.x)) continue;
                boolean bl = false;
                for (int i = 0; i < ((DPolygon)object2).npoints - 2; ++i) {
                    double d = (((DPolygon)object2).ypoints[i] + ((DPolygon)object2).ypoints[i + 1] + ((DPolygon)object2).ypoints[i + 2]) / 3.0;
                    double d2 = (((DPolygon)object2).xpoints[i] + ((DPolygon)object2).xpoints[i + 1] + ((DPolygon)object2).xpoints[i + 2]) / 3.0;
                    if (!((DPolygon)object2).contains(d, d2)) continue;
                    this.addException(new GeomException(3, flurstueck.getHashPoint(), flurstueck.getPolygon(), "Die Objektkoordinate der Nutzungsart " + flurstueck.getExceptionableName() + " liegt nicht innerhalb der Fl\u00e4che, Koordinate ver\u00e4ndert."));
                    flurstueck.y = d;
                    flurstueck.x = d2;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.addException(new GeomException(2, flurstueck.getHashPoint(), flurstueck.getPolygon(), "Die Objektkoordinate der Nutzungsart " + flurstueck.getExceptionableName() + " liegt nicht innerhalb der Fl\u00e4che."));
                flurstueck.setTempFlag1(true);
            }
            if (this.progressBar != null) {
                this.progressBar.setValue(55);
            }
            n2 = 0;
            n3 = ((Vector)object).size();
            Enumeration enumeration2 = ((Vector)object).elements();
            while (enumeration2.hasMoreElements()) {
                flurstueck = (Flurstueck)enumeration2.nextElement();
                boolean bl = flurstueck.size() == 3;
                this.saveFlst(flurstueck);
                DRectangle dRectangle = flurstueck.getBounds();
                DPolygon dPolygon = flurstueck.getPolygon();
                if (dPolygon != null) {
                    int n5 = 0;
                    cloneable2 = null;
                    for (int i = 0; i < n4; ++i) {
                        boolean bl2;
                        cloneable = flurstueckArray[i];
                        boolean bl3 = bl2 = ((DataContainer)cloneable).size() == 3;
                        if (((Flurstueck)cloneable).isVisible()) continue;
                        boolean bl4 = false;
                        if (bl && bl2) {
                            bl4 = dRectangle.equals(((DataContainer)cloneable).getBounds());
                        } else if (!bl2) {
                            boolean bl5 = bl4 = dRectangle.contains(((Flurstueck)cloneable).y, ((Flurstueck)cloneable).x) && dPolygon.contains(((Flurstueck)cloneable).y, ((Flurstueck)cloneable).x);
                        }
                        if (!bl4) continue;
                        ((Flurstueck)cloneable).setGemarkung(flurstueck.getGemarkung());
                        ((Flurstueck)cloneable).setFlur(flurstueck.getFlur());
                        ((Flurstueck)cloneable).setZaehler(flurstueck.getZaehler());
                        ((Flurstueck)cloneable).setNenner(flurstueck.getNenner());
                        if (n5 == 0) {
                            cloneable2 = cloneable;
                        } else {
                            this.saveFlst((Flurstueck)cloneable);
                        }
                        ((DataContainer)cloneable).setVisible(true);
                        ++n5;
                    }
                    if (n5 == 0) {
                        this.addException(new GeomException(2, flurstueck.getHashPoint(), flurstueck.getPolygon(), "F\u00fcr " + flurstueck.getExceptionableName() + " wurde keine Nutzung gefunden"));
                    } else if (n5 == 1) {
                        flurstueck.setNutzung(((Flurstueck)cloneable2).getNutzung());
                    } else {
                        this.saveFlst((Flurstueck)cloneable2);
                        flurstueck.setArt(FlurstueckArt.getArt(7, 9, 0));
                    }
                } else {
                    this.addException(new GeomException(2, flurstueck.getHashPoint(), flurstueck.getHashPoint(), flurstueck.getExceptionableName() + " hat kein Fl\u00e4chenpolygon"));
                }
                if (this.progressBar != null && n2 % 100 == 0) {
                    this.progressBar.setValue(55 + n2 * 40 / n3);
                }
                ++n2;
            }
            if (this.progressBar != null) {
                this.progressBar.setValue(95);
            }
            enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                flurstueck = (Flurstueck)enumeration2.nextElement();
                if (flurstueck.isVisible()) continue;
                this.addException(new GeomException(2, flurstueck.getHashPoint(), flurstueck.getHashPoint(), flurstueck.getExceptionableName() + " konnte keinem Flurst\u00fcck zugeordnet werden, gel\u00f6scht"));
            }
            boolean bl = false;
            flurstueck = null;
            Enumeration enumeration3 = DataBase.FLST.elements();
            while (enumeration3.hasMoreElements()) {
                Flurstueck flurstueck2 = (Flurstueck)enumeration3.nextElement();
                int n6 = flurstueck2.getArt();
                if (FlurstueckArt.isFlur(n6)) {
                    for (var13_38 = 0; var13_38 < flurstueck2.size(); ++var13_38) {
                        cloneable2 = (Linie)flurstueck2.elementAt(var13_38);
                        Linie linie = (Linie)((Hashtable)cloneable3).get(cloneable2);
                        if (linie == null) continue;
                        ((Linie)cloneable2).setParameter(linie.getParameter());
                    }
                } else if (FlurstueckArt.getTeil(n6) == 9) {
                    flurstueck = flurstueck2;
                } else if (FlurstueckArt.isNutzung(n6) && flurstueck != null) {
                    block36: for (var13_38 = 0; var13_38 < flurstueck2.size(); ++var13_38) {
                        cloneable2 = (Linie)flurstueck2.elementAt(var13_38);
                        if (((Linie)cloneable2).pe == null || ((Linie)cloneable2).getArt() == 0) continue;
                        for (int i = 0; i < flurstueck.size(); ++i) {
                            cloneable = (Linie)flurstueck.elementAt(i);
                            if (((Linie)cloneable).pe == null || ((Linie)cloneable).getArt() == 0 || !((Linie)cloneable2).equalsIgnoreArt((Linie)cloneable)) continue;
                            ((Linie)cloneable2).setParameter(((Linie)cloneable).getParameter());
                            continue block36;
                        }
                    }
                } else {
                    flurstueck = null;
                }
                ++n2;
            }
            if (this.progressBar != null) {
                this.progressBar.setValue(100);
            }
            int n7 = DataBase.FLST.size() + DataBase.GEB.size() + DataBase.TOP.size();
            if (EdbsIOProperties.isInCleanAreas()) {
                this.progressBar.setValue(0);
                int n8 = 0;
                AlkReader alkReader = this;
                Enumeration enumeration4 = alkReader.db.flurstuecke();
                while (enumeration4.hasMoreElements()) {
                    this.concatGeom((GObject)enumeration4.nextElement(), false);
                    if (n8 % 100 == 0) {
                        this.progressBar.setValue(n8 * 200 / n7);
                    }
                    ++n8;
                }
                AlkReader alkReader2 = this;
                enumeration4 = alkReader2.db.gebaeude();
                while (enumeration4.hasMoreElements()) {
                    this.concatGeom((GObject)enumeration4.nextElement(), true);
                    if (n8 % 100 == 0) {
                        this.progressBar.setValue(n8 * 200 / n7);
                    }
                    ++n8;
                }
                AlkReader alkReader3 = this;
                enumeration4 = alkReader3.db.topObjekte();
                while (enumeration4.hasMoreElements()) {
                    this.concatGeom((GObject)enumeration4.nextElement(), true);
                    if (n8 % 100 == 0) {
                        this.progressBar.setValue(n8 * 200 / n7);
                    }
                    ++n8;
                }
                this.progressBar.setValue(100);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = this.inFile.getName();
        int n = ((String)object).lastIndexOf(".");
        if (n >= 0) {
            object = ((String)object).substring(0, n);
        }
        if (this.getExceptionList().size() > 0) {
            vector = new ErrorWriter(new File((String)object + ".Import.err"), this.getExceptionList());
            ((ErrorWriter)((Object)vector)).setHeader("#ALK-Import am " + new Date().toString());
            try {
                ((ErrorWriter)((Object)vector)).write();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void concatGeom(GObject gObject, boolean bl) {
        if (gObject.isArea() && gObject.hasAnker() && this.errObjects.get(gObject) == null) {
            double d = Math.abs(gObject.getPolygonFlaeche());
            GObjectManipulator gObjectManipulator = new GObjectManipulator(gObject);
            try {
                gObjectManipulator.concatenate(bl);
            }
            catch (Exception exception) {
                if (gObjectManipulator.hasExceptions()) {
                    Enumeration enumeration = gObjectManipulator.exceptions();
                    while (enumeration.hasMoreElements()) {
                        this.addException((Exception)enumeration.nextElement());
                    }
                }
                this.addException(new GeomException(2, gObject.getHashPoint(), gObject.getHashPoint(), "Verkettungsproblem bei " + gObject.getExceptionableName() + ", " + exception.getMessage() + ", Ankererzeugung fehlerhaft"));
            }
            double d2 = Math.abs(gObject.getPolygonFlaeche());
            if (Math.abs(d - d2) > 0.1) {
                this.addException(new GeomException(2, gObject.getHashPoint(), gObject.getPolygon(), "Fl\u00e4chen\u00e4nderung bei " + gObject.getExceptionableName() + " nach Ankergenerierung: " + IFormat.f_1.format(d - d2) + "m\u02db , Fl\u00e4che pr\u00fcfen!"));
            }
        }
    }

    private void saveFlst(Flurstueck flurstueck) {
        try {
            DataBase.FLST.put(flurstueck);
        }
        catch (Exception exception) {
            this.addException(exception);
        }
    }
}

