/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.io.IPunktWriter;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.util.LongHashList;
import java.io.File;
import java.util.GregorianCalendar;
import java.util.Vector;

public class AlkWriter
extends IPunktWriter {
    private int lineNr = 0;
    private int amt = 0;
    private int jahr = 0;

    public AlkWriter(File file, LongHashList longHashList) {
        super(file, longHashList);
        this.setParameter();
    }

    public AlkWriter(File file, Vector vector) {
        super(file, vector);
        this.setParameter();
    }

    @Override
    protected void setParameter() {
        super.setSortModus(22);
    }

    @Override
    protected void initValues() {
        this.amt = super.getAmt();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.jahr = gregorianCalendar.get(1) % 100 * 10000 + (gregorianCalendar.get(2) + 1) * 100 + gregorianCalendar.get(5);
    }

    @Override
    protected String punktToLine(Punkt punkt) {
        return punkt.toULO8ALK(++this.lineNr, this.jahr);
    }

    @Override
    protected String getHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EDBS03120287AKND000000  0000ULQA00000001");
        stringBuffer.append(GeoNumberFormat.nr07n.format(this.amt).toString());
        stringBuffer.append("       ");
        stringBuffer.append("AUFTRN    019");
        stringBuffer.append("           ");
        stringBuffer.append("F");
        stringBuffer.append("               ");
        stringBuffer.append("               ");
        stringBuffer.append("          ");
        stringBuffer.append("8801");
        stringBuffer.append("               ");
        stringBuffer.append("               ");
        stringBuffer.append("               ");
        stringBuffer.append("               ");
        stringBuffer.append("               ");
        stringBuffer.append("          ");
        stringBuffer.append("          ");
        stringBuffer.append(GeoNumberFormat.nr07n.format(this.amt).toString());
        stringBuffer.append("          ");
        stringBuffer.append("          ");
        stringBuffer.append("GIAPGSB 9801    DZENTRALLK9802    3STDALK *          ASDLBE0005EQPASSWORT      ");
        return stringBuffer.toString();
    }

    @Override
    protected String getEndOfFile() {
        return "EDBS00240000AEND000000  0000";
    }
}

