/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.kafplot.EntstehungsArt;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktArt;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.PunktParameterALKIS;
import de.geocalc.kafplot.io.IKatPunktReader;
import de.geocalc.kafplot.io.alkis.AlkisIOProperties;
import de.geocalc.kataster.KatasterStatus;
import de.geocalc.util.LongHashList;
import java.io.File;
import java.util.Vector;

public class AlkisKooReader
extends IKatPunktReader {
    public AlkisKooReader(File file, LongHashList longHashList) {
        super(file, longHashList, null);
        this.punktStatus = -9;
    }

    public AlkisKooReader(File file, LongHashList longHashList, IProgressViewer iProgressViewer) {
        super(file, longHashList, iProgressViewer);
        this.punktStatus = -9;
    }

    public AlkisKooReader(File file, Vector vector) {
        super(file, vector, null);
        this.punktStatus = -9;
    }

    public AlkisKooReader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, vector, iProgressViewer);
        this.punktStatus = -9;
    }

    @Override
    protected void setParameter() {
        super.setParameter();
        this.setPunktStatus(-9);
        this.katasterModel = 2;
    }

    @Override
    public boolean isMutableStatusReader() {
        return false;
    }

    @Override
    protected Punkt lineToPunkt(String string) {
        Object object;
        int n = string.length();
        if (n < 65 || string.startsWith("*") || string.startsWith("#")) {
            return null;
        }
        Punkt punkt = new Punkt();
        punkt.setInternalPs(0);
        punkt.setPs(Integer.parseInt(string.substring(0, 1)));
        punkt.nr = Long.parseLong(string.substring(2, 17).trim());
        String string2 = string.substring(18, 33).trim();
        long l = Long.parseLong(string2.startsWith("v") ? string2.substring(1) : string2);
        if (l > AlkisIOProperties.getImportPnrReduction()) {
            l -= AlkisIOProperties.getImportPnrReduction();
        }
        if (l != punkt.nr) {
            punkt.setUmnum(l);
        }
        punkt.y = Double.parseDouble(string.substring(34, 46).trim());
        if (punkt.y > AlkisIOProperties.getImportYReduction()) {
            punkt.y -= AlkisIOProperties.getImportYReduction();
        }
        punkt.x = Double.parseDouble(string.substring(47, 58).trim());
        punkt.g = Float.parseFloat(string.substring(59, 65).trim());
        if (n >= 66 && ((String)(object = string.substring(66, Math.min(n, 75)).trim())).length() > 0) {
            punkt.h = Float.parseFloat((String)object);
        }
        object = new PunktParameterALKIS();
        String string3 = this.parseString(string, n, 76, 81, "");
        try {
            ((PunktParameterALKIS)object).setPa(PunktArt.parseString(string3));
            ((PunktParameterALKIS)object).setPst(KatasterStatus.parseString(string3));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((PunktParameterALKIS)object).setLg(this.parseInt(string, n, 82, 86, 0));
        ((PunktParameterALKIS)object).setLl(this.parseFloat(string, n, 87, 93, 0.0f));
        ((PunktParameterALKIS)object).setLz(this.parseInt(string, n, 94, 95, 0));
        ((PunktParameterALKIS)object).setEa(EntstehungsArt.parseChar(this.parseChar(string, n, 96, ' ')));
        ((PunktParameterALKIS)object).setEq(this.parseInt(string, n, 98, 102, 0));
        ((PunktParameterALKIS)object).setArt(this.parseInt(string, n, 103, 107, 0));
        ((PunktParameterALKIS)object).setVa(this.parseInt(string, n, 108, 112, 0));
        ((PunktParameterALKIS)object).setVb(this.parseInt(string, n, 113, 117, 0));
        ((PunktParameterALKIS)object).setVvt(this.parseInt(string, n, 118, 121, 0));
        ((PunktParameterALKIS)object).setLs(this.parseInt(string, n, 122, 126, 0));
        punkt.initParameter((PunktParameter)object);
        if (n > 127) {
            punkt.setBemerkung(string.substring(127));
        }
        return punkt;
    }

    private final String parseString(String string, int n, int n2, int n3, String string2) {
        try {
            if (n2 >= n) {
                return string2;
            }
            if (n3 > n) {
                n3 = n;
            }
            return string.substring(n2, n3).trim();
        }
        catch (Exception exception) {
            return string2;
        }
    }

    private final float parseFloat(String string, int n, int n2, int n3, float f) {
        if (n2 >= n) {
            return f;
        }
        if (n3 > n) {
            n3 = n;
        }
        while (n2 < n3 && string.charAt(n2) == ' ') {
            ++n2;
        }
        while (n3 > n2 && string.charAt(n3 - 1) == ' ') {
            --n3;
        }
        if (n2 != n3) {
            return Float.valueOf(string.substring(n2, n3)).floatValue();
        }
        return f;
    }

    private final int parseInt(String string, int n, int n2, int n3, int n4) throws NumberFormatException {
        if (n2 >= n) {
            return n4;
        }
        if (n3 > n) {
            n3 = n;
        }
        while (n2 < n3) {
            if (string.charAt(n2) == ' ') {
                ++n2;
                continue;
            }
            if (string.charAt(n2) != '+') break;
            ++n2;
        }
        while (n3 > n2 && string.charAt(n3 - 1) == ' ') {
            --n3;
        }
        if (n2 != n3) {
            try {
                return Integer.parseInt(string.substring(n2, n3));
            }
            catch (Exception exception) {
                throw new NumberFormatException("Ung\u00fcltiger Wert in Spalte " + n2 + "-" + n3);
            }
        }
        return n4;
    }

    private final char parseChar(String string, int n, int n2, char c) {
        if (n2 >= n) {
            return c;
        }
        return string.charAt(n2);
    }
}

