/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IException;
import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.Buchungsstelle;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.Gemarkung;
import de.geocalc.kafplot.Grundbuchblatt;
import de.geocalc.kafplot.KatasterParameter;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.Name;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.io.RtfWriter;
import de.geocalc.kafplot.io.rtf.RtfIOConstants;
import de.geocalc.text.GeoNumberFormat;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class BestandbelegWriter
extends RtfWriter {
    protected String date = RtfIOConstants.getString(new SimpleDateFormat("dd.MMM. yyyy").format(new Date()));
    private static final int[] oneRows = new int[]{9900};
    private static final int[] zusRows = new int[]{560, 1500, 2600, 3600, 9900};
    private static final int[] nameRows = new int[]{560, 1500, 2600, 3600, 6500, 9900};
    private static final char OHNE = '\u0000';
    private static final char EIGENE = 'E';
    private static final char KATASTER = 'K';
    private static final String EOL = "\n";
    private static final String RTF_HEADER = "{\\rtf1\\ansi\\ansicpg1252\\uc1 \\deff0\\deflang1033\\deflangfe1031\n{\\fonttbl\n{\\f0\\froman\\fcharset0\\fprq2{\\*\\panose 02020603050405020304}Times New Roman;}\n{\\f19\\froman\\fcharset238\\fprq2 Times New Roman CE;}\n{\\f20\\froman\\fcharset204\\fprq2 Times New Roman Cyr;}\n{\\f22\\froman\\fcharset161\\fprq2 Times New Roman Greek;}\n{\\f23\\froman\\fcharset162\\fprq2 Times New Roman Tur;}\n{\\f24\\froman\\fcharset186\\fprq2 Times New Roman Baltic;}\n}\n{\\colortbl;\n\\red0\\green0\\blue0;\n\\red0\\green0\\blue255;\n\\red0\\green255\\blue255;\n\\red0\\green255\\blue0;\n\\red255\\green0\\blue255;\n\\red255\\green0\\blue0;\n\\red255\\green255\\blue0;\n\\red255\\green255\\blue255;\n\\red0\\green0\\blue128;\n\\red0\\green128\\blue128;\n\\red0\\green128\\blue0;\n\\red128\\green0\\blue128;\n\\red128\\green0\\blue0;\n\\red128\\green128\\blue0;\n\\red128\\green128\\blue128;\n\\red192\\green192\\blue192;\n}\n{\\stylesheet{\\widctlpar\\adjustright \\lang1031\\cgrid \\snext0 Normal;}{\\*\\cs10 \\additive Default Paragraph Font;}\n{\\s15\\widctlpar\\tqc\\tx4536\\tqr\\tx9072\\adjustright \\lang1031\\cgrid \\sbasedon0 \\snext15 header;}\n{\\s16\\widctlpar\\tqc\\tx4536\\tqr\\tx9072\\adjustright \\lang1031\\cgrid \\sbasedon0 \\snext16 footer;}\n}\n{\\info\n{\\title Berechnung}{\\author KafPlot}\n{\\version2}{\\edmins0}{\\nofpages2}{\\nofwords98}{\\nofchars561}{\\*\\company  }\n{\\nofcharsws688}{\\vern113}\n}\n\\paperw11906\\paperh16838\\margl1418\\margr567\\margt1418\\margb1134 \\deftab708\\widowctrl\\ftnbj\\aenddoc\\hyphhotz425\\noxlattoyen\\expshrtn\\noultrlspc\\dntblnsbdb\\nospaceforul\\hyphcaps0\\formshade\\viewkind1\\viewscale100\\pgbrdrhead\\pgbrdrfoot \\fet0\\sectd\n\\linex0\\headery709\\footery709\\colsx708\\endnhere\\sectlinegrid360\\sectdefaultcl";
    private static final String FIRST_PAGE_HEADER = "{\\*\\pnseclvl1\\pnucrm\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}\n{\\*\\pnseclvl2\\pnucltr\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}\n{\\*\\pnseclvl3\\pndec\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}\n{\\*\\pnseclvl4\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxta )}}\n{\\*\\pnseclvl5\\pndec\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}\n{\\*\\pnseclvl6\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}\n{\\*\\pnseclvl7\\pnlcrm\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}\n{\\*\\pnseclvl8\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}\n{\\*\\pnseclvl9\\pnlcrm\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}";
    private static final String TABLE_HEADER = "\\trowd \\trkeep\\trhdr\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10\n\\trpaddl57\\trpaddr57\\trpaddfl3\\trpaddft3\\trpaddfb3\\trpaddfr3\n\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx560\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx1500\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx2600\\clvmgf\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx3600\\clvmgf\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx6500\\clvmgf\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx9900\n\\pard\\plain \\qc\\widctlpar\\intbl\\adjustright \\lang1031\\cgrid {\\fs16 Flur\\cell Flurst\\'fcck\\cell Fl\\'e4che [m\\'b2]\\cell Bestandsblatt\\cell Eigent\\'fcmer\\cell Adresse\\cell }\n\\pard \\widctlpar\\intbl\\adjustright {\\row }\n\\trowd \\trhdr\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx9900\n\\pard \\qc\\widctlpar\\intbl\\adjustright {\\fs20 \\cell }\n\\pard \\widctlpar\\intbl\\adjustright {\\fs20 \\row }";
    private static final String ROW_HEADER = "\\trowd \\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalc\\cltxlrtb\\trpaddl57\\trpaddr57\\trpaddfl3\\trpaddft3\\trpaddfb3\\trpaddfr3";
    private static final String ROW_FEATER = "\\pard \\widctlpar\\intbl\\adjustright {\\fs20 \\row }";
    private static final String RH = "\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright ";
    private static final String RF = "{\\row }";
    private static final String CELL = "\\cell";
    private static final String TABLE_FEATER = "\\pard \\widctlpar\\adjustright {\\fs20 \\par }";
    private static final String END_OF_FILE = "}";

    public BestandbelegWriter(File file, DataBase dataBase) {
        super(file, dataBase);
    }

    private double searchMessStrecke(Punkt punkt, Punkt punkt2, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            Messung messung = (Messung)enumeration.nextElement();
            switch (messung.getMessungsArt(true)) {
                case 240: {
                    if ((messung.ps != punkt || messung.pz != punkt2) && (messung.pz != punkt || messung.ps != punkt2)) break;
                    return messung.l2;
                }
                case 220: 
                case 260: {
                    if ((messung.ps != punkt || messung.pz != punkt2) && (messung.pz != punkt || messung.ps != punkt2)) break;
                    return messung.l1;
                }
            }
        }
        return 0.0;
    }

    @Override
    public void write() throws IFileOutputException {
        PrintWriter printWriter = null;
        try {
            printWriter = this.createWriter();
            int n = 0;
            super.setEndValue(DataBase.FLST.size());
            super.setProgressBreak();
            super.setValue(0L);
            super.setLabelText("Liste erstellen...");
            this.checkDatVars();
            printWriter.println(RTF_HEADER);
            this.writePageHeader(printWriter);
            this.writeStartPage(printWriter);
            printWriter.println(TABLE_HEADER);
            int n2 = 0;
            Enumeration enumeration = DataBase.FLST.elements();
            while (enumeration.hasMoreElements()) {
                Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
                boolean bl = true;
                Enumeration enumeration2 = flurstueck.buchungen();
                while (enumeration2.hasMoreElements()) {
                    Buchungsstelle buchungsstelle = (Buchungsstelle)enumeration2.nextElement();
                    Grundbuchblatt grundbuchblatt = (Grundbuchblatt)DataBase.BUCH.get(buchungsstelle.getGrundbuchblattName());
                    if (grundbuchblatt == null) continue;
                    if (n2 != flurstueck.getGemarkung()) {
                        n2 = flurstueck.getGemarkung();
                        String string = null;
                        Gemarkung gemarkung = Gemarkung.getGemarkung(n2);
                        if (gemarkung != null) {
                            string = gemarkung.getName();
                        }
                        if (string == null) {
                            this.addException(new IException("keine Gemarkungsname f\u00fcr die Gemarkung: " + GeoNumberFormat.nr.format(n2).toString() + " gefunden.", "\u00dcberpr\u00fcfen Sie die Einstellungen in der Konfigurationsdatei: \"gemarkungen.properties\"."));
                            string = DataBase.gemarkung != null ? DataBase.gemarkung : "";
                        }
                        this.writeSingleRow(printWriter, "Gemarkung: " + string);
                    }
                    boolean bl2 = false;
                    boolean bl3 = true;
                    Enumeration enumeration3 = grundbuchblatt.elements();
                    while (enumeration3.hasMoreElements()) {
                        Name name = (Name)enumeration3.nextElement();
                        this.writeName(printWriter, flurstueck, grundbuchblatt, name, bl, bl3);
                        bl = false;
                        bl3 = false;
                    }
                    if (grundbuchblatt.hasZusatz()) {
                        enumeration3 = new StringTokenizer(grundbuchblatt.getZusatz(), ";");
                        while (((StringTokenizer)enumeration3).hasMoreTokens()) {
                            this.writeZus(printWriter, ((StringTokenizer)enumeration3).nextToken());
                        }
                    }
                    this.writeSingleRow(printWriter);
                }
                if ((long)n++ % super.getProgressBreak() != 0L) continue;
                super.setProgress(n);
            }
            printWriter.println(TABLE_FEATER);
            printWriter.println(END_OF_FILE);
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
    }

    private void writeZus(PrintWriter printWriter, String string) {
        this.writeTableHeader(printWriter, zusRows);
        printWriter.println("\\pard \\qc\\widctlpar\\intbl\\adjustright {\\fs20 \\cell \\cell }");
        printWriter.println("\\pard \\qr\\widctlpar\\intbl\\adjustright {\\fs20 \\cell \\cell }");
        printWriter.println("\\pard \\ql\\widctlpar\\intbl\\adjustright {\\fs20 " + RtfIOConstants.getString(string) + " \\cell }");
        printWriter.println(ROW_FEATER);
    }

    private void writeName(PrintWriter printWriter, Flurstueck flurstueck, Grundbuchblatt grundbuchblatt, Name name, boolean bl, boolean bl2) {
        this.writeTableHeader(printWriter, nameRows);
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("\\pard \\qc\\widctlpar\\intbl\\adjustright {\\fs20 ");
        if (bl) {
            stringBuffer.append(flurstueck.getFlur());
        }
        stringBuffer.append("\\cell ");
        if (bl) {
            stringBuffer.append(flurstueck.toMiniString());
        }
        stringBuffer.append("\\cell }");
        printWriter.println(stringBuffer);
        stringBuffer = new StringBuffer(256);
        stringBuffer.append("\\pard \\qr\\widctlpar\\intbl\\adjustright {\\fs20 ");
        if (bl) {
            stringBuffer.append(flurstueck.getBuchFlaecheAsString());
        }
        stringBuffer.append("\\cell }");
        stringBuffer.append("\\pard \\qc\\widctlpar\\intbl\\adjustright {\\fs20 ");
        if (bl2) {
            stringBuffer.append(grundbuchblatt.getBlattAsString());
        }
        stringBuffer.append("\\cell }");
        printWriter.println(stringBuffer);
        stringBuffer = new StringBuffer(256);
        stringBuffer.append("\\pard \\ql\\widctlpar\\intbl\\adjustright {\\fs20 ");
        if (name != null) {
            if (name.hasName()) {
                stringBuffer.append("{\\b ");
                stringBuffer.append(RtfIOConstants.getString(name.getName()));
                stringBuffer.append(END_OF_FILE);
            }
            if (name.hasGeburtName()) {
                stringBuffer.append("\\line ");
                stringBuffer.append(RtfIOConstants.getString(name.getGeburtName()));
            }
            if (name.hasGeburtDatum()) {
                stringBuffer.append("\\line ");
                stringBuffer.append(RtfIOConstants.getString(name.getGeburtDatum()));
            }
        }
        stringBuffer.append("\\cell ");
        if (name != null) {
            boolean bl3 = false;
            boolean bl4 = false;
            if (name.hasAdresse()) {
                stringBuffer.append(RtfIOConstants.getString(name.getAdresse()));
                bl4 = true;
                bl3 = true;
            }
            if (name.hasPlzPf()) {
                if (bl4) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(RtfIOConstants.getString(name.getPlzPfAsString()));
                bl4 = true;
                bl3 = true;
            }
            if (name.hasPostfach()) {
                if (bl4) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(RtfIOConstants.getString(name.getPostfachAsString()));
                bl4 = true;
                bl3 = true;
            }
            bl4 = false;
            if (name.hasPostleitzahl()) {
                if (bl3) {
                    stringBuffer.append("\\line ");
                    bl3 = false;
                }
                stringBuffer.append(RtfIOConstants.getString(name.getPostleitzahlAsString()));
                bl4 = true;
            }
            if (name.hasOrt()) {
                if (bl3) {
                    stringBuffer.append("\\line ");
                    bl3 = false;
                } else if (bl4) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(RtfIOConstants.getString(name.getOrt()));
                bl4 = true;
            }
            if (name.hasLand()) {
                if (bl3) {
                    stringBuffer.append("\\line ");
                    bl3 = false;
                } else if (bl4) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(RtfIOConstants.getString(name.getLandAsString()));
                bl4 = true;
            }
        }
        stringBuffer.append("\\cell }");
        printWriter.println(stringBuffer);
        printWriter.println(ROW_FEATER);
    }

    private void writePageHeader(PrintWriter printWriter) {
        printWriter.println("{\\header");
        printWriter.println("\\trowd \\trgaph70\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10");
        printWriter.println("\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb");
        printWriter.println("\\cellx2962\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb");
        printWriter.println("\\cellx6033\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb");
        printWriter.println("\\cellx9900");
        printWriter.print("\\pard\\plain \\widctlpar\\intbl\\adjustright \\lang1031\\cgrid {\\fs20 Liste Eigent\\'fcmer\\cell Datum: ");
        printWriter.print(this.date);
        printWriter.println("\\cell Seite: }");
        printWriter.println("{\\field{\\*\\fldinst {\\fs20 PAGE  \\\\* ARABIC  \\\\* MERGEFORMAT }}{\\fldrslt {\\fs20\\lang1024 1}}}{\\fs20 /}");
        printWriter.println("{\\field{\\*\\fldinst {\\fs20 NUMPAGES  \\\\* ARABIC  \\\\* MERGEFORMAT }}{\\fldrslt {\\fs20\\lang1024 1}}}{\\fs20 \\cell }");
        printWriter.println(ROW_FEATER);
        printWriter.println("\\trowd \\trgaph70\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10");
        printWriter.println("\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb");
        printWriter.println("\\cellx9900");
        printWriter.print("\\pard \\widctlpar\\intbl\\adjustright {\\fs20 ");
        if (DataBase.vermStelle != null) {
            printWriter.println(RtfIOConstants.getString(DataBase.vermStelle));
        }
        printWriter.println("\\cell }");
        printWriter.println(ROW_FEATER);
        printWriter.println("\\pard\\plain \\s15\\widctlpar\\tqc\\tx4536\\tqr\\tx9072\\adjustright \\lang1031\\cgrid {\\par }");
        printWriter.println(END_OF_FILE);
    }

    private void writeStartPage(PrintWriter printWriter) {
        printWriter.println(FIRST_PAGE_HEADER);
        printWriter.print("\\pard\\plain \\nowidctlpar\\widctlpar\\adjustright \\lang1031\\cgrid {");
        if (DataBase.vermStelle != null) {
            printWriter.println(RtfIOConstants.getString(DataBase.vermStelle));
        }
        printWriter.print("\\par ");
        if (DataBase.adresse_1 != null) {
            printWriter.println(RtfIOConstants.getString(DataBase.adresse_1));
        }
        printWriter.print("\\par ");
        if (DataBase.adresse_2 != null) {
            printWriter.println(RtfIOConstants.getString(DataBase.adresse_2));
        }
        printWriter.print("\\par ");
        if (DataBase.adresse_3 != null) {
            printWriter.println(RtfIOConstants.getString(DataBase.adresse_3));
        }
        printWriter.println("{\\par }");
        printWriter.println("\\pard \\sb240\\sa240\\nowidctlpar\\widctlpar\\adjustright {\\par }");
        printWriter.println("\\trowd \\trgaph70\\trleft-108\\trbrdrt\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\cltxlrtb \\cellx2880\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\cltxlrtb \\cellx9104");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\cell \\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\trowd \\trgaph70\\trleft-108\\trbrdrt\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\clvertalt\\cltxlrtb \\cellx2880\\clvertalt\\cltxlrtb \\cellx9104");
        printWriter.print("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {Katasteramt:\\cell ");
        if (DataBase.katasterAmt != null) {
            printWriter.print(RtfIOConstants.getString(DataBase.katasterAmt));
        }
        printWriter.println("\\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.print("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {Gemarkung:\\cell ");
        if (DataBase.gemarkung != null) {
            printWriter.print(RtfIOConstants.getString(DataBase.gemarkung));
            Gemarkung gemarkung = Gemarkung.getGemarkung(DataBase.gemeinde, DataBase.gemarkung);
            if (gemarkung != null) {
                printWriter.print(" (" + gemarkung.getNummer() + ")");
            }
        }
        printWriter.println("\\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.print("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {Flur:\\cell ");
        if (DataBase.flur != null) {
            printWriter.print(DataBase.flur);
        }
        printWriter.println("\\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.print("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {Flurst\\'fcck");
        if (DataBase.flurstueck != null) {
            if (DataBase.flurstueck.indexOf(",") > 0) {
                printWriter.print("e");
            }
        }
        printWriter.print(":");
        printWriter.print("\\cell ");
        if (DataBase.flurstueck != null) {
            printWriter.print(RtfIOConstants.getString(DataBase.flurstueck));
        }
        printWriter.println("\\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\cell \\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\trowd \\trgaph70\\trrh1360\\trleft-108\\trbrdrt\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\cltxlrtb \\cellx9104");
        printWriter.println("\\pard \\qc\\nowidctlpar\\widctlpar\\intbl\\adjustright {\\b\\fs36 Liste der Eigent\\'fcmer\\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\pard \\sb240\\sa240\\nowidctlpar\\widctlpar\\adjustright {\\par }");
        printWriter.println("\\trowd \\trgaph70\\trleft1800 \\clvertalt\\cltxlrtb \\cellx4140\\clvertalt\\clbrdrb\\brdrdash\\brdrw10 \\cltxlrtb \\cellx6480");
        printWriter.println("\\pard \\nowidctlpar\\qc\\widctlpar\\intbl\\adjustright {Aufgestellt am:\\cell " + this.date + "\\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\trowd \\trgaph70\\trrh1080\\trleft1800 \\clvertalb\\clbrdrb\\brdrdash\\brdrw20 \\cltxlrtb \\cellx6480");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\trowd \\trgaph70\\trleft1800 \\clvertalt\\clbrdrt \\brdrdash\\brdrw20 \\cltxlrtb \\cellx6480");
        printWriter.println("\\pard \\qc\\nowidctlpar\\widctlpar\\intbl\\adjustright {\\fs18 (Unterschrift)\\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\trowd \\trgaph70\\trleft1800 \\clvertalt\\cltxlrtb \\cellx4140\\clvertalt\\cltxlrtb \\cellx6480");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\cell \\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\adjustright {\\par \\page\\par }}");
    }

    private void writeSingleRow(PrintWriter printWriter) {
        this.writeSingleRow(printWriter, null);
    }

    private void writeSingleRow(PrintWriter printWriter, String string) {
        this.writeTableHeader(printWriter, oneRows);
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("\\pard \\ql\\widctlpar\\intbl\\adjustright {\\fs20\\b ");
        if (string != null) {
            stringBuffer.append(RtfIOConstants.getString(string));
        }
        stringBuffer.append("\\cell }");
        printWriter.println(stringBuffer);
        printWriter.println(ROW_FEATER);
    }

    private double createGrenzwert(double d, char c) {
        if (c == 'K') {
            return KatasterParameter.getKatasterStreckengenauigkeit(d);
        }
        return KatasterParameter.getEigeneStreckengenauigkeit(d);
    }

    private void writeTableHeader(PrintWriter printWriter, int[] nArray) {
        printWriter.println(ROW_HEADER);
        for (int i = 0; i < nArray.length; ++i) {
            StringBuffer stringBuffer = new StringBuffer(40);
            stringBuffer.append("\\clvertalt\\cltxlrtb");
            stringBuffer.append("\\cellx");
            stringBuffer.append(nArray[i]);
            printWriter.println(stringBuffer);
        }
    }
}

