/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.io.GpsMessung;
import de.geocalc.kafplot.io.IGpsReader;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class BspReader
extends IGpsReader {
    public BspReader(File file, Vector vector) {
        super(file, vector, null);
    }

    public BspReader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, vector, iProgressViewer);
    }

    @Override
    protected GpsMessung lineToGpsMessung(String string) throws IFileInputException, IOException {
        if (string.startsWith("#") || string.length() == 0) {
            return null;
        }
        GpsMessung gpsMessung = new GpsMessung();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        boolean bl = stringTokenizer.countTokens() == 8;
        try {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            gpsMessung.pns = Long.parseLong(stringTokenizer.nextToken());
            gpsMessung.pnz = Long.parseLong(stringTokenizer.nextToken());
            d = Double.valueOf(stringTokenizer.nextToken());
            d2 = Double.valueOf(stringTokenizer.nextToken());
            if (bl) {
                d3 = Double.valueOf(stringTokenizer.nextToken());
            }
            d4 = Double.valueOf(stringTokenizer.nextToken());
            d5 = Double.valueOf(stringTokenizer.nextToken());
            if (bl) {
                d6 = Double.valueOf(stringTokenizer.nextToken());
            }
            gpsMessung.y = d4 - d;
            gpsMessung.x = d5 - d2;
            gpsMessung.z = d6 - d3;
        }
        catch (Exception exception) {
            throw new IFileInputException("Ung\u00fcltige Zeichen im Format");
        }
        return gpsMessung;
    }

    @Override
    protected void parseMessungen() {
        GpsMessung gpsMessung = null;
        Enumeration enumeration = this.M.elements();
        while (enumeration.hasMoreElements()) {
            GpsMessung gpsMessung2 = (GpsMessung)enumeration.nextElement();
            double d = Math.sqrt(gpsMessung2.y * gpsMessung2.y + gpsMessung2.x * gpsMessung2.x);
            double d2 = d / BspReader.getSA() / 100000.0;
            if ((d2 *= d2) < 1.0E-5) {
                this.addException(new Exception("Die Basisl\u00e4nge " + gpsMessung2.toString() + " ist zu kurz.\n    Die Gewichte werden auf das m\u00f6gliche Minimum gesetzt"));
                d2 = 1.0E-5;
            } else if (d2 > 99999.0) {
                this.addException(new Exception("Die Basisl\u00e4nge " + gpsMessung2.toString() + " ist zu lang.\n    Die Gewichte werden auf das m\u00f6gliche Maximum gesetzt"));
                d2 = 99999.0;
            }
            gpsMessung2.py = d2;
            gpsMessung2.px = d2;
            if (gpsMessung != null) {
                if (gpsMessung.pns == gpsMessung2.pns) {
                    gpsMessung2.pns = 0L;
                    continue;
                }
                gpsMessung = gpsMessung2;
                continue;
            }
            gpsMessung = gpsMessung2;
        }
    }
}

