/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.io.IPolarReader;
import de.geocalc.kafplot.io.PolarMessung;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class CaddyPolarReader
extends IPolarReader {
    int anzZpk = 0;
    private PolarMessung s = new PolarMessung();

    public CaddyPolarReader(File file, Vector vector) {
        super(file, vector, null);
    }

    public CaddyPolarReader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, vector, iProgressViewer);
    }

    @Override
    protected PolarMessung lineToPolarMessung(String string) throws IOException, IFileInputException {
        PolarMessung polarMessung = new PolarMessung();
        if (string.length() == 0) {
            return null;
        }
        if (string.startsWith("-")) {
            this.s = this.readStandpunkt(this.s, string);
            this.anzZpk = 0;
            return null;
        }
        polarMessung = this.readMessung(polarMessung, string);
        polarMessung.pns = this.anzZpk == 0 ? this.s.pns : 0L;
        if (polarMessung.r == 0.0 && this.anzZpk > 0) {
            throw new IFileInputException("Null-Richtung im Richtungssatz");
        }
        if (polarMessung.pns == 0L && this.anzZpk == 0) {
            throw new IFileInputException("Fehlender Standpunkt");
        }
        ++this.anzZpk;
        return polarMessung;
    }

    private PolarMessung readStandpunkt(PolarMessung polarMessung, String string) throws IFileInputException {
        try {
            polarMessung.pns = Long.parseLong(this.deleteLetters(string.substring(0, 8)));
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Punktnummer");
        }
        return polarMessung;
    }

    private PolarMessung readMessung(PolarMessung polarMessung, String string) throws IFileInputException {
        try {
            polarMessung.pnz = Long.parseLong(this.deleteLetters(string.substring(0, 8)));
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Punktnummer");
        }
        try {
            polarMessung.r = Double.valueOf(string.substring(13, 22).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Richtung");
        }
        try {
            polarMessung.s = Double.valueOf(string.substring(25, 33).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Strecke");
        }
        try {
            polarMessung.z = Double.valueOf(string.substring(35, 44).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Zenit");
        }
        return polarMessung;
    }
}

