/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.geom.DPoint;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.BemerkungTable;
import de.geocalc.kafplot.ErrorObject;
import de.geocalc.kafplot.TextBox;
import de.geocalc.kafplot.io.IDataReader;
import de.geocalc.kafplot.io.csv.CsvIOProperties;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class CsvErrorReader
extends IDataReader {
    LineNumberReader reader = null;
    protected BemerkungTable ERR = null;

    public CsvErrorReader(File file, BemerkungTable bemerkungTable) {
        this(file, bemerkungTable, null);
    }

    public CsvErrorReader(File file, BemerkungTable bemerkungTable, IProgressViewer iProgressViewer) {
        super(file, iProgressViewer);
        this.ERR = bemerkungTable;
        try {
            this.reader = this.createReader();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CsvErrorReader(URL uRL, BemerkungTable bemerkungTable, IProgressViewer iProgressViewer) {
        super(null, iProgressViewer);
        this.ERR = bemerkungTable;
        try {
            this.reader = this.createReader(uRL);
            this.setFileLength(uRL.openConnection().getContentLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void userAbort() throws IFileInputException {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception exception) {
            throw new IFileInputException(this.getErrorKey() + "Fehler beim Schlie\u00dfen der CsvDatei");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read() throws IFileInputException {
        String string = null;
        if (this.reader == null) {
            throw new IFileInputException("Datei nicht gefunden: " + this.getFile().getName());
        }
        try {
            String string2;
            long l = 0L;
            string = this.reader.readLine();
            if (string == null) {
                throw new IFileInputException("Keine Formatzeile in der CSV-Datei " + this.getFile().getName() + " vorhanden");
            }
            char c = CsvIOProperties.parseColDelim(string);
            if (c == '\u0000') {
                throw new IFileInputException("Unbekanntes Trennzeichen in der CSV-Datei " + this.getFile().getName());
            }
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
            Object object = new Tokenizer(this, string, c);
            int n4 = 0;
            while (((Tokenizer)object).hasMoreTokens()) {
                string2 = ((Tokenizer)object).nextToken();
                hashtable.put(new Integer(n4), string2);
                String string3 = string2.toUpperCase();
                if (string3.equals("CODE")) {
                    n = n4;
                } else if (string3.indexOf("CODE") >= 0 && n < 0) {
                    n = n4;
                } else if (string3.equals("RECHTSWERT")) {
                    n2 = n4;
                } else if (string3.indexOf("RECHTS") >= 0 && n2 < 0) {
                    n2 = n4;
                } else if (string3.equals("Y") && n2 < 0) {
                    n2 = n4;
                } else if (string3.indexOf("Y-") >= 0 && n2 < 0) {
                    n2 = n4;
                } else if (string3.equals("HOCHWERT")) {
                    n3 = n4;
                } else if (string3.indexOf("HOCH") >= 0 && n2 < 0) {
                    n3 = n4;
                } else if (string3.equals("X") && n2 < 0) {
                    n3 = n4;
                } else if (string3.indexOf("X-") >= 0 && n2 < 0) {
                    n3 = n4;
                }
                ++n4;
            }
            while ((string = this.reader.readLine()) != null) {
                if (string.length() == 0) continue;
                object = new ErrorObject(this.getFile().getName());
                StringBuffer stringBuffer = new StringBuffer();
                string2 = null;
                double d = Double.MAX_VALUE;
                double d2 = Double.MAX_VALUE;
                Tokenizer tokenizer = new Tokenizer(this, string, c);
                int n5 = 0;
                while (tokenizer.hasMoreTokens()) {
                    String string4 = tokenizer.nextToken();
                    if (n5 == n2) {
                        try {
                            d = new Double(string4);
                        }
                        catch (Exception exception) {}
                    } else if (n5 == n3) {
                        try {
                            d2 = new Double(string4);
                        }
                        catch (Exception exception) {}
                    } else {
                        String string5;
                        if (n5 == n) {
                            ((ErrorObject)object).setId(string4);
                        }
                        if ((string5 = (String)hashtable.get(new Integer(n5))) != null) {
                            stringBuffer.append(string5);
                            stringBuffer.append(": ");
                        }
                        stringBuffer.append(string4);
                        stringBuffer.append("\n");
                    }
                    ++n5;
                }
                ((TextBox)object).setText(stringBuffer.toString());
                if (d < Double.MAX_VALUE && d2 < Double.MAX_VALUE) {
                    if (d > 1000000.0) {
                        d %= 1.0E7;
                    }
                    ((ErrorObject)object).setPoint(new DPoint(d, d2));
                }
                this.ERR.addElement((TextBox)object, false);
                super.setFileProgress(l += (long)(string.length() + 1));
            }
        }
        catch (IOException iOException) {
            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber(), iOException.getMessage()));
        }
        catch (Exception exception) {
            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber(), exception.getMessage()));
        }
        finally {
            try {
                this.reader.close();
                super.setProgress(100);
            }
            catch (Exception exception) {}
        }
    }

    private class Tokenizer
    implements Enumeration {
        String s;
        int t;
        int currentIndex;
        int endIndex;

        public Tokenizer(CsvErrorReader csvErrorReader, String string, char c) {
            this.s = string;
            this.t = c;
            this.currentIndex = 0;
            this.endIndex = string.length();
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasMoreTokens();
        }

        public boolean hasMoreTokens() {
            return this.currentIndex < this.endIndex;
        }

        public Object nextElement() {
            return this.nextToken();
        }

        public String nextToken() {
            int n = this.currentIndex;
            this.currentIndex = this.nextIndex(n);
            return this.s.substring(n, this.currentIndex++);
        }

        private int nextIndex(int n) {
            boolean bl = false;
            for (int i = n; i < this.endIndex; ++i) {
                char c = this.s.charAt(i);
                if (c == '\"') {
                    bl = !bl;
                    continue;
                }
                if (c != this.t || bl) continue;
                return i;
            }
            return this.endIndex;
        }
    }
}

