/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IDialog;
import de.geocalc.awt.IException;
import de.geocalc.awt.IFrame;
import de.geocalc.io.FileCopier;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.Bedingung;
import de.geocalc.kafplot.DatContainer;
import de.geocalc.kafplot.DataContainerTable;
import de.geocalc.kafplot.Ebene;
import de.geocalc.kafplot.FlurstueckTable;
import de.geocalc.kafplot.GebaeudeTable;
import de.geocalc.kafplot.GeoFileImporter;
import de.geocalc.kafplot.KafDatProperties;
import de.geocalc.kafplot.KafPlotVersion;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.TopObjectTable;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.TrafoSystemTable;
import de.geocalc.kafplot.io.DatLine;
import de.geocalc.kafplot.io.GpsMessung;
import de.geocalc.kafplot.io.IFileReader;
import de.geocalc.kafplot.io.IFileWriter;
import de.geocalc.kafplot.io.IOProperties;
import de.geocalc.kafplot.io.IPolarReader;
import de.geocalc.kafplot.io.NivMessung;
import de.geocalc.kafplot.io.PolarMessung;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.kafplot.io.dat.SteuerDaten;
import de.geocalc.text.GeoNumberFormat;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class DatCreator {
    private static final String TITLE = "DatCreator";
    private static final String VERSION = "2.0";
    private static final int TITEL_DATEN = 0;
    private static final int STEUER_DATEN = 1;
    private static final int AUFTRAG_DATEN = 2;
    private static final int PUNKT_DATEN = 11;
    private static final int GPS_DATEN = 21;
    private static final int POLAR_DATEN = 22;
    private static final int FLUCHT_DATEN = 23;
    private static final int MESSBAND_DATEN = 24;
    private static final int EDM_DATEN = 25;
    private static final int ORTHO_DATEN = 26;
    private static final int BOGEN_DATEN = 27;
    private static final int HOEHEN_STEUER_DATEN = 30;
    private static final int NIVELLEMENT_DATEN = 31;
    private static final int POLARHOEHEN_DATEN = 32;
    private static final int DIGIT_DATEN = 40;
    private static final int FLST_DATEN = 51;
    private static final int GEB_DATEN = 52;
    private static final int TOP_DATEN = 53;
    private static final int BEMERKUNG_DATEN = 55;
    private static final int NUMBEZ_DATEN = 56;
    private static final int IDENT_DATEN = 57;
    private static final int UMNUM_DATEN = 58;
    private static final int BEDINGUNG_DATEN = 60;
    private static final int END_OF_FILE = 99;
    public static final int PUNKT_MODE_EINGABE = 0;
    public static final int PUNKT_MODE_MESSUNG = 1;
    public static final int PUNKT_MODE_TRAFO = 2;
    public static final String STEUER_DATEN_TEXT = "Steuerdaten";
    public static final String PUNKT_DATEN_TEXT = "Punktdaten";
    public static final String GPS_DATEN_TEXT = "Gps-Basislinien";
    public static final String POLAR_DATEN_TEXT = "Polare Messung";
    public static final String FLUCHT_DATEN_TEXT = "Fluchtungslinie";
    public static final String MESSBAND_DATEN_TEXT = "Messbandstrecke";
    public static final String EDM_DATEN_TEXT = "Edm-Messung";
    public static final String ORTHO_DATEN_TEXT = "Orthogonale Linie";
    public static final String BOGEN_DATEN_TEXT = "Bogenschnitt";
    public static final String DIGIT_DATEN_TEXT = "Transformation";
    public static final String HOEHEN_DATEN_TEXT = "H\u00f6hen";
    public static final String BEDINGUNG_DATEN_TEXT = "Bedingungen";
    public static final String FLST_DATEN_TEXT = "Flurst\u00fccke";
    public static final String GEB_DATEN_TEXT = "Geb\u00e4ude";
    public static final String TOP_DATEN_TEXT = "Topographie";
    public static final String BEMERKUNG_DATEN_TEXT = "Bemerkungen";
    public static final String NUMBEZ_DATEN_TEXT = "Nummerierungsbezirk";
    public static final String IDENT_DATEN_TEXT = "Identit\u00e4ten";
    public static final String UMNUM_DATEN_TEXT = "Umnummerierung";
    public boolean steuerDaten = false;
    public boolean punktDaten = false;
    public boolean polarDaten = false;
    public boolean fluchtDaten = false;
    public boolean messbandDaten = false;
    public boolean edmDaten = false;
    public boolean orthoDaten = false;
    public boolean bogenDaten = false;
    public boolean gpsDaten = false;
    public boolean hoehenDaten = false;
    public boolean digitDaten = false;
    public boolean bedingungDaten = false;
    public boolean flstDaten = false;
    public boolean gebDaten = false;
    public boolean topDaten = false;
    public boolean bemerkungDaten = false;
    public boolean numbezDaten = false;
    public boolean identDaten = false;
    public boolean umnumDaten = false;
    public boolean longFormat = false;
    public boolean m2d = true;
    public boolean m3D = false;
    public int punktMode = 0;
    private SteuerDaten st = null;
    public double ga = 1.0;
    public double plg = 0.025;
    public int ps = -3;
    public int pl = 5;
    private int inFileTyp = 0;
    private int block = -1;
    private LineNumberReader fIn = null;
    private LineNumberReader fBak = null;
    private PrintWriter fOut = null;
    private Vector P;
    private Vector M;
    private Vector B;
    private Vector H;
    private TrafoSystemTable T;
    private FlurstueckTable FLST;
    private DataContainerTable GEB;
    private DataContainerTable TOP;
    private Vector risse;
    File datFile = null;
    File bakFile = null;
    File inFile = null;
    private IFrame parent;
    private static final String HOEHE_STEUERDATEN_KENN = "C    GGH       GTH       GZ        GS        GDZ";
    private static final String HOEHE_STEUERDATEN = "9    1.0       1.0       1.0       1.0       1.0";
    private static final String PUNKT_LONG_INFO_ALKIS = "C KS   = KAFKA-Punktstatus  0=N\u00e4herung, 1=fest, 2=beweglich, 5=ung\u00fcltig\nC PKN  = Punktkennung\nC Y    = Rechtswert\nC X    = Hochwert\nC KL   = KAFKA-Punktlagefehler\nC HOE  = H\u00f6he\nC PA   = Punktart\nC           GP(U)= Grenzpunkt    (unabh\u00e4ngig)\nC           BG(U)= Geb\u00e4udepunkt  (unabh\u00e4ngig)\nC           BB(U)= Bauwerkspunkt (unabh\u00e4ngig)\nC           BT   = Topografischer Punkt\nC           AP   = Aufnahmepunkt\nC           SP   = Sicherungspunkt\nC           SV   = Sonstiger Vermessungspunkt\nC           LF   = Lagefestpunkt\nC           HF   = H\u00f6henfestpunkt\nC           SF   = Schwerefestpunkt\nC           RS   = Referenzstationspunkt\nC GST  = Genauigkeitsstufe           0000\nC           2100 = <=   3cm\nC           2200 = <=   6cm\nC           2300 = <=  10cm\nC           3000 = <=  30cm\nC           3100 = <=  60cm\nC           3200 = <= 100cm\nC           3300 = <= 500cm\nC GWT  = Genauigkeitswert             [m]\nC Z    = Lagezuverl\u00e4ssigkeit LZK\nC              1 = ungepr\u00fcft\nC              2 = festgestellt\nC P    = Prozess Erzeugung DES1\nC              E = Erhebung\nC              B = Berechnung\nC Q    = Quelle Erzeugung  DES2      0000\nC           1000 = aus Katastervermessung ermittelt\nC           2000 = aus Luftbildmessung ermittelt\nC           4200 = aus Katasterkarten digitalisiert\nC           9998 = ohne Angabe\nC ART  = Art Geb\u00e4udepunkt            0000\nC           1100 = First\nC           1200 = Traufe\nC           2100 = Eingang OFF\nC ABM  = Abmarkung Marke             0000\nC           1000 = Marke, allgemein\nC           1100 = Stein\nC           1140 = Kunststoffmarke\nC           1200 = Rohr\nC           1300 = Bolzen/Nagel\nC           1400 = Mei\u00dfelzeichen\nC           1500 = Pfahl\nC           1620 = Flasche\nC           1630 = Platte\nC           1640 = Hohlziegel\nC           1711 = Sockel (roh)\nC           1712 = Sockel (verputzt)\nC           1713 = Mauerecke (roh)\nC           1714 = Mauerecke (verputzt)\nC           1800 = Pfeiler\nC           2230 = Festlegung der Wasserstra\u00dfenverwaltung\nC           9500 = Ohne Marke\nC           9998 = ohne Angabe\nC BZA  = Bemerkung zur Abmarkung     0000\nC           1000 = Abmarkung unterirdisch gesichert\nC           4000 = ohne Sicherung\nC RHO  = Relative H\u00f6he der Abmarkung [dm]\nC KST  = Koordinatenstatus\nC           1000 = Amtliche Koordinate\n";
    private static final String PUNKT_LONG_INFO_ALK = "C KS   = KAFKA-Punktstatus  0=N\u00e4herung, 1=fest, 2=beweglich, 5=ung\u00fcltig\nC PKN  = Punktkennung\nC Y    = Rechtswert\nC X    = Hochwert\nC KL   = KAFKA-Punktlagefehler\nC HOE  = H\u00f6he\nC PA   = Punktart   0=TP, 1=AP, 2=GP, 3=HE, 4=ZP, 7=KP, 9=HP\nC LS   = Lagestatus 489=ETRS\nC L    = Art der Lagegenauigkeit\nC H    = Art der H\u00f6hengenauigkeit\nC EB   = Ebene\nC VT   = Tiefe der Vermarkung [dm]\nC VVA  = vorgefundene Vermarkung\nC Z    = Lagezuverl\u00e4ssigkeit\nC OSKA = Objektschl\u00fcssel\nC S    = Punktstatus (Kataster)\n";
    private static final String UMNUM_LONG_INFO_ALKIS = "C PKNA = Punktkennung Alt\nC PKNN = Punktkennung Neu\nC PA   = Punktart\nC           GP(U)= Grenzpunkt    (unabh\u00e4ngig)\nC           BG(U)= Geb\u00e4udepunkt  (unabh\u00e4ngig)\nC           BB(U)= Bauwerkspunkt (unabh\u00e4ngig)\nC           BT   = Topografischer Punkt\nC           AP   = Aufnahmepunkt\nC           SP   = Sicherungspunkt\nC           SV   = Sonstiger Vermessungspunkt\nC           LF   = Lagefestpunkt\nC           HF   = H\u00f6henfestpunkt\nC           SF   = Schwerefestpunkt\nC           RS   = Referenzstationspunkt\nC F      Fortf\u00fchrungskennung\nC           -    = Minus f\u00fcr L\u00f6schmarkierung\nC GST  = Genauigkeitsstufe           0000\nC           2100 = <=   3cm\nC           2200 = <=   6cm\nC           2300 = <=  10cm\nC           3000 = <=  30cm\nC           3100 = <=  60cm\nC           3200 = <= 100cm\nC           3300 = <= 500cm\nC GWT  = Genauigkeitswert             [m]\nC Z    = Lagezuverl\u00e4ssigkeit LZK\nC              1 = ungepr\u00fcft\nC              2 = festgestellt\nC P    = Prozess Erzeugung DES1\nC              E = Erhebung\nC              B = Berechnung\nC Q    = Quelle Erzeugung  DES2      0000\nC           1000 = aus Katastervermessung ermittelt\nC           2000 = aus Luftbildmessung ermittelt\nC           4200 = aus Katasterkarten digitalisiert\nC           9998 = ohne Angabe\nC ART  = Art Geb\u00e4udepunkt            0000\nC           1100 = First\nC           1200 = Traufe\nC           2100 = Eingang OFF\nC ABM  = Abmarkung Marke             0000\nC           1000 = Marke, allgemein\nC           1100 = Stein\nC           1140 = Kunststoffmarke\nC           1200 = Rohr\nC           1300 = Bolzen/Nagel\nC           1400 = Mei\u00dfelzeichen\nC           1500 = Pfahl\nC           1620 = Flasche\nC           1630 = Platte\nC           1640 = Hohlziegel\nC           1711 = Sockel (roh)\nC           1712 = Sockel (verputzt)\nC           1713 = Mauerecke (roh)\nC           1714 = Mauerecke (verputzt)\nC           1800 = Pfeiler\nC           2230 = Festlegung der Wasserstra\u00dfenverwaltung\nC           9500 = Ohne Marke\nC           9998 = ohne Angabe\nC BZA  = Bemerkung zur Abmarkung     0000\nC           1000 = Abmarkung unterirdisch gesichert\nC           4000 = ohne Sicherung\nC RHO  = Relative H\u00f6he der Abmarkung [dm]\nC ABMV = Abmarkung vorgefunden       0000\nC KST  = Koordinatenstatus\nC           1000 = Amtliche Koordinate\n";
    private static final String UMNUM_LONG_INFO_ALK = "C PNA  = Punktnummer alt\nC PNN  = Punktnummer neu           (optional)\nC PA   = Punktart                  (optional)\nC VA   = Vermarkungsart            (optional)\nC LS   = Lagestatus                (optional)\nC L    = Art der Lagegenauigkeit   (optional)\nC HS   = Hoehenstatus              (optional)\nC H    = Art der Hoehengenauigkeit (optional)\nC EB   = Ebene                     (optional)\nC VT   = Tiefe der Vermarkung [dm] (optional)\nC VVA  = Vorgefundene Vermarkung   (optional)\nC Z    = Lagezuverl\u00e4ssigkeit       (optional)\nC OSKA = Objektschl\u00fcssel           (optional)\nC S    = Punktstatus (Kataster)    (optional)\n";

    public DatCreator() {
        this(null, null, null);
    }

    public DatCreator(IFrame iFrame) {
        this(iFrame, null, null);
    }

    public DatCreator(IFrame iFrame, File file) {
        this(iFrame, file, null);
    }

    public DatCreator(IFrame iFrame, File file, File file2) {
        this.parent = iFrame;
        this.datFile = file;
        this.inFile = file2;
    }

    public void setParent(IFrame iFrame) {
        this.parent = iFrame;
    }

    public void setDatFile(File file) {
        this.datFile = file;
    }

    public File getDatFile() {
        return this.datFile;
    }

    public void setInFile(File file) {
        this.inFile = file;
    }

    public File getInFile() {
        return this.inFile;
    }

    public void setInFileTyp(int n) {
        this.inFileTyp = n;
    }

    public int getInFileTyp() {
        return this.inFileTyp;
    }

    public void setSteuerDaten(SteuerDaten steuerDaten) {
        this.st = steuerDaten;
    }

    public void setRisse(Vector vector) {
        this.risse = vector;
    }

    public void parse() throws IFileInputException {
        block127: {
            Object object;
            int n;
            Object object2;
            if (this.st == null) {
                this.st = KafDatProperties.getDefaultSteuerDaten();
            }
            if (this.inFile != null && !this.inFile.exists()) {
                throw new IFileInputException("Eingabedatei: " + this.inFile.getName() + " nicht vorhanden!");
            }
            try {
                if (this.datFile.exists()) {
                    this.bakFile = new File(this.datFile.getName().substring(0, this.datFile.getName().indexOf(46)) + ".bak");
                    object2 = new FileCopier(this.datFile, this.bakFile);
                }
            }
            catch (IOException iOException) {
                throw new IFileInputException("Fehler beim Sichern der Datei:" + this.datFile.getName());
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.P = new Vector();
            this.M = new Vector();
            this.B = new Vector();
            this.H = new Vector();
            this.T = new TrafoSystemTable();
            this.FLST = new FlurstueckTable();
            this.GEB = new GebaeudeTable();
            this.TOP = new TopObjectTable();
            if (this.inFile != null) {
                IOProperties.setHoeheModus(this.m3D ? IOProperties.MODUS_3D : IOProperties.MODUS_2D);
                object2 = new GeoFileImporter(this.parent, "ImportDaten lesen", this.P, this.M, this.B, this.T, this.FLST, this.GEB, this.TOP, this.inFile);
                ((IDialog)object2).setVisible(true);
                for (n = 0; n < this.P.size(); ++n) {
                    Punkt punkt = (Punkt)this.P.elementAt(n);
                    punkt.setPs(punkt.buildPunktStatus(this.ps));
                    punkt.nr = punkt.buildKatNr(this.pl);
                    object = punkt.getParameter();
                    ((PunktParameter)object).setEb(Ebene.getDefaultEbene(((PunktParameter)object).getModPa()));
                    punkt.initParameter((PunktParameter)object);
                }
            }
            boolean bl = this.datFile.exists() && this.datFile.length() > 0L;
            try {
                this.fOut = IFileWriter.createFileWriter(this.datFile);
            }
            catch (IOException iOException) {
                throw new IFileInputException("Fehler beim Anlegen der Datei: " + this.datFile.getName());
            }
            try {
                if (!bl) {
                    if (KafkaIOProperties.datVersion <= 0) {
                        KafkaIOProperties.datVersion = 3;
                    }
                    this.writeDat(this.fOut, 0);
                    this.writeDat(this.fOut, 1);
                    this.writeDat(this.fOut, 2);
                    this.fOut.println("C Punktdaten");
                    this.fOut.println("1 (I1,1X,1X,2I4,I1,F5.0,2F13.3,F6.3,F10.4,A)");
                    if (this.punktMode == 0) {
                        this.writePunkte(this.fOut, this.P);
                    }
                    if (this.punktDaten) {
                        this.writeDat(this.fOut, 11);
                    }
                    this.fOut.println("              -99");
                    this.fOut.println("C Messdaten");
                    this.fOut.println("2 (I1,1X,2(1X,2I4,I1,F5.0),2F11.4,4F6.3)");
                    this.fOut.println("C$Liste GPS-Basislinien");
                    if (this.inFileTyp == 400 && this.m2d) {
                        this.writeGpsDaten(this.fOut, this.M);
                    }
                    if (this.gpsDaten) {
                        this.writeDat(this.fOut, 21);
                    }
                    this.fOut.println("C$Ende GPS-Basislinien");
                    this.fOut.println("C$Liste Polare Messungen");
                    if (this.inFileTyp == 200 && this.m2d) {
                        this.writePolarDaten(this.fOut, this.M);
                    }
                    if (this.polarDaten) {
                        this.writeDat(this.fOut, 22);
                    }
                    this.fOut.println("C$Ende Polare Messungen");
                    this.fOut.println("C$Liste Messband-Messungen");
                    if (this.messbandDaten) {
                        this.writeDat(this.fOut, 24);
                    }
                    if (this.edmDaten) {
                        this.writeDat(this.fOut, 25);
                    }
                    if (this.orthoDaten) {
                        this.writeDat(this.fOut, 26);
                    }
                    if (this.bogenDaten) {
                        this.writeDat(this.fOut, 27);
                    }
                    this.fOut.println("C$Ende Messband-Messungen");
                    this.fOut.println("C$Liste KatasterNachweis");
                    if (this.risse != null && this.risse.size() > 0) {
                        Enumeration enumeration = this.risse.elements();
                        while (enumeration.hasMoreElements()) {
                            ((DatContainer)enumeration.nextElement()).writeDatContainer(this.fOut);
                        }
                    } else {
                        this.fOut.println("C!Riss:");
                    }
                    this.fOut.println("C$Ende KatasterNachweis");
                    this.fOut.println("C$Liste Vorgaben");
                    this.fOut.println("C$Ende Vorgaben");
                    this.fOut.println("C$Liste Einrechnung");
                    if (this.fluchtDaten) {
                        this.writeDat(this.fOut, 23);
                    }
                    this.fOut.println("C$Ende Einrechnung");
                    this.fOut.println("              -99");
                    this.fOut.println("C Hoehen");
                    this.fOut.println("3 (I1,1X,2(1X,2I4,I1,F5.0),2F11.4,3F8.3)");
                    this.fOut.println("C$Liste Nivellement");
                    if (this.inFileTyp == 400 && this.m3D) {
                        this.writeGpsHoehenDaten(this.fOut, this.M);
                    }
                    if (this.inFileTyp == 200 && this.m3D) {
                        this.writeNivHoehenDaten(this.fOut, this.M);
                    }
                    if (this.hoehenDaten) {
                        this.writeDat(this.fOut, 31);
                    }
                    this.fOut.println("C$Ende Nivellement");
                    this.fOut.println("C$Liste Polare H\u00f6hen");
                    if (this.inFileTyp == 200 && this.m3D) {
                        this.writeHoehenDaten(this.fOut, this.M);
                    }
                    if (this.hoehenDaten) {
                        this.writeDat(this.fOut, 32);
                    }
                    this.fOut.println("C$Ende Polare H\u00f6hen");
                    this.fOut.println("              -99");
                    this.fOut.println("C Transformation");
                    this.fOut.println("4 (I1,1X,1X,2I4,I1,F5.0,2F13.3,2F8.3)");
                    if (this.punktMode == 2) {
                        this.writePunkteAsDigit(this.fOut, this.P);
                    } else if (this.punktMode == 1) {
                        this.writePunkteAsMessung(this.fOut, this.P);
                    }
                    if (this.T.size() > 0) {
                        this.writeTrafoSystemeAsDigit(this.fOut, this.T);
                    }
                    if (this.digitDaten) {
                        this.writeDat(this.fOut, 40);
                    }
                    this.fOut.println("              -99");
                    this.fOut.println("C Bedingungen");
                    this.fOut.println("6 (I1,1X,3(1X,2I4,I1,F5.0),F6.3,F11.4)");
                    this.fOut.println("C$Liste Homogenisierung");
                    if (this.B.size() > 0) {
                        this.writeBedingungen(this.fOut, this.B);
                    }
                    this.fOut.println("C$Ende Homogenisierung");
                    this.fOut.println("C$Liste Bedingungen");
                    if (this.bedingungDaten) {
                        this.writeDat(this.fOut, 60);
                    }
                    this.fOut.println("C$Ende Bedingungen");
                    this.fOut.println("              -99");
                    this.fOut.println("C Zusaetzliche Angaben");
                    this.fOut.println("5 (I1,1X,2(1X,2I4,I1,F5.0))");
                    this.fOut.println("C$Liste Flurstuecke");
                    if (this.FLST.size() > 0) {
                        this.writeDatObjecte(this.fOut, this.FLST);
                    }
                    if (this.flstDaten) {
                        this.writeDat(this.fOut, 51);
                    }
                    this.fOut.println("C$Ende Flurstuecke");
                    this.fOut.println("C$Liste Bestand");
                    this.fOut.println("C$Ende Bestand");
                    this.fOut.println("C$Liste Nutzung");
                    this.fOut.println("C$Ende Nutzung");
                    this.fOut.println("C$Liste Boden");
                    this.fOut.println("C$Ende Boden");
                    this.fOut.println("C$Liste Gebaeude");
                    if (this.GEB.size() > 0) {
                        this.writeDatObjecte(this.fOut, this.GEB);
                    }
                    if (this.gebDaten) {
                        this.writeDat(this.fOut, 52);
                    }
                    this.fOut.println("C$Ende Gebaeude");
                    this.fOut.println("C$Liste Topographie");
                    if (this.TOP.size() > 0) {
                        this.writeDatObjecte(this.fOut, this.TOP);
                    }
                    if (this.topDaten) {
                        this.writeDat(this.fOut, 53);
                    }
                    this.fOut.println("C$Ende Topographie");
                    this.fOut.println("C$Liste Katalog");
                    this.fOut.println("C$Ende Katalog");
                    this.fOut.println("C$Liste Bemerkungen");
                    if (this.bemerkungDaten) {
                        this.writeDat(this.fOut, 55);
                    }
                    this.fOut.println("C$Ende Bemerkungen");
                    this.fOut.println("C$Liste NummerierungsBezirk");
                    if (this.numbezDaten) {
                        this.writeDat(this.fOut, 56);
                    }
                    this.fOut.println("C$Ende NummerierungsBezirk");
                    this.fOut.println("C$Liste Punktidentitaet");
                    if (this.identDaten) {
                        this.writeDat(this.fOut, 57);
                    }
                    this.fOut.println("C$Ende Punktidentitaet");
                    this.fOut.println("C$Liste Umnummerierung");
                    if (this.umnumDaten) {
                        this.writeDat(this.fOut, 58);
                    }
                    this.fOut.println("C$Ende Umnummerierung");
                    this.fOut.println("              -99");
                    this.fOut.println("0");
                    this.writeDat(this.fOut, 99);
                    break block127;
                }
                this.fBak = IFileReader.createFileReader(this.bakFile);
                n = -9;
                int n2 = -1;
                while (n != 0) {
                    try {
                        object = new DatLine(this.fBak.readLine());
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new IFileInputException("Fehler beim Lesen der Datei " + this.bakFile.getName() + "in Zeile: " + this.fBak.getLineNumber() + "\nvorzeitig Dateiende erreicht");
                    }
                    if (((de.geocalc.io.DatLine)object).length() == 0) continue;
                    if (this.fBak.getLineNumber() <= 4) {
                        if (this.steuerDaten) {
                            switch (this.fBak.getLineNumber()) {
                                case 1: {
                                    this.fOut.println(((DatLine)object).toString());
                                    break;
                                }
                                case 2: {
                                    this.writeDat(this.fOut, 1);
                                }
                            }
                            continue;
                        }
                        this.fOut.println(((DatLine)object).toString());
                        continue;
                    }
                    switch (((de.geocalc.io.DatLine)object).getKennung()) {
                        case 2: {
                            String string = ((de.geocalc.io.DatLine)object).getVariableWert();
                            if (((de.geocalc.io.DatLine)object).getVariable() != 2) break;
                            int n3 = Integer.parseInt(string.substring(0, 1));
                            int n4 = Integer.parseInt(string.substring(2, 3));
                            if (n3 == 2) {
                                KafkaIOProperties.datVersion = 3;
                                break;
                            }
                            if (n3 == 1) {
                                if (n4 < 1) {
                                    KafkaIOProperties.datVersion = 0;
                                    break;
                                }
                                if (n4 < 4) {
                                    KafkaIOProperties.datVersion = 1;
                                    break;
                                }
                                KafkaIOProperties.datVersion = 2;
                                break;
                            }
                            KafkaIOProperties.datVersion = 0;
                            break;
                        }
                        case 3: {
                            if (n == -9) {
                                n = ((de.geocalc.io.DatLine)object).getBlock();
                                break;
                            }
                            throw new IFileInputException("Fehler beim Lesen der Datei " + this.datFile.getName() + "in Zeile: " + this.fIn.getLineNumber() + "\nfehlendes Blockende");
                        }
                        case 4: {
                            if (n == -9) {
                                throw new IFileInputException("Fehler beim Lesen der Datei " + this.datFile.getName() + "in Zeile: " + this.fIn.getLineNumber() + "\nBlockende au\u00dferhalb von Block");
                            }
                            if (n == 1) {
                                if (this.punktMode == 0) {
                                    this.writePunkte(this.fOut, this.P);
                                }
                                if (this.punktDaten) {
                                    this.writeDat(this.fOut, 11);
                                }
                            } else if (n != 3) {
                                if (n == 4) {
                                    if (this.punktMode == 2) {
                                        this.writePunkteAsDigit(this.fOut, this.P);
                                    } else if (this.punktMode == 1) {
                                        this.writePunkteAsMessung(this.fOut, this.P);
                                    }
                                    if (this.T.size() > 0) {
                                        this.writeTrafoSystemeAsDigit(this.fOut, this.T);
                                    }
                                    if (this.digitDaten) {
                                        this.writeDat(this.fOut, 40);
                                    }
                                } else if (n == 5 || n == 6) {
                                    // empty if block
                                }
                            }
                            n = -9;
                            break;
                        }
                        case 5: {
                            if (n2 == -1) {
                                n2 = ((de.geocalc.io.DatLine)object).getListe();
                                break;
                            }
                            throw new IFileInputException("Fehler beim Lesen der Datei " + this.datFile.getName() + "in Zeile: " + this.fIn.getLineNumber() + "\nfehlendes Listenende");
                        }
                        case 6: {
                            if (n2 == -1) {
                                throw new IFileInputException("Fehler beim Lesen der Datei " + this.datFile.getName() + "in Zeile: " + this.fIn.getLineNumber() + "\nung\u00fcltiges Listenende");
                            }
                            switch (n2) {
                                case 201: {
                                    if (this.polarDaten) {
                                        this.writeDat(this.fOut, 22);
                                    }
                                    if (this.inFileTyp != 200 || !this.m2d) break;
                                    this.writePolarDaten(this.fOut, this.M);
                                    break;
                                }
                                case 202: {
                                    if (this.gpsDaten) {
                                        this.writeDat(this.fOut, 21);
                                    }
                                    if (this.inFileTyp != 400) break;
                                    this.writeGpsDaten(this.fOut, this.M);
                                    break;
                                }
                                case 203: {
                                    if (this.messbandDaten) {
                                        this.writeDat(this.fOut, 24);
                                    }
                                    if (this.edmDaten) {
                                        this.writeDat(this.fOut, 25);
                                    }
                                    if (this.orthoDaten) {
                                        this.writeDat(this.fOut, 26);
                                    }
                                    if (!this.bogenDaten) break;
                                    this.writeDat(this.fOut, 27);
                                    break;
                                }
                                case 204: {
                                    if (this.risse == null || this.risse.size() <= 0) break;
                                    Enumeration enumeration = this.risse.elements();
                                    while (enumeration.hasMoreElements()) {
                                        ((DatContainer)enumeration.nextElement()).writeDatContainer(this.fOut);
                                    }
                                    break;
                                }
                                case 206: {
                                    if (!this.fluchtDaten) break;
                                    this.writeDat(this.fOut, 23);
                                    break;
                                }
                                case 302: {
                                    if (this.inFileTyp == 200 && this.m3D) {
                                        this.writeHoehenDaten(this.fOut, this.M);
                                    }
                                    if (!this.hoehenDaten) break;
                                    this.writeDat(this.fOut, 32);
                                    break;
                                }
                                case 301: {
                                    if (this.inFileTyp == 400 && this.m3D) {
                                        this.writeGpsHoehenDaten(this.fOut, this.M);
                                    }
                                    if (this.inFileTyp == 200 && this.m3D) {
                                        this.writeNivHoehenDaten(this.fOut, this.M);
                                    }
                                    if (!this.hoehenDaten) break;
                                    this.writeDat(this.fOut, 31);
                                    break;
                                }
                                case 510: {
                                    if (this.FLST.size() > 0) {
                                        this.writeDatObjecte(this.fOut, this.FLST);
                                    }
                                    if (!this.flstDaten) break;
                                    this.writeDat(this.fOut, 51);
                                    break;
                                }
                                case 520: {
                                    if (this.GEB.size() > 0) {
                                        this.writeDatObjecte(this.fOut, this.GEB);
                                    }
                                    if (!this.gebDaten) break;
                                    this.writeDat(this.fOut, 52);
                                    break;
                                }
                                case 530: {
                                    if (this.TOP.size() > 0) {
                                        this.writeDatObjecte(this.fOut, this.TOP);
                                    }
                                    if (!this.topDaten) break;
                                    this.writeDat(this.fOut, 53);
                                    break;
                                }
                                case 550: {
                                    if (!this.bemerkungDaten) break;
                                    this.writeDat(this.fOut, 55);
                                    break;
                                }
                                case 560: {
                                    if (!this.numbezDaten) break;
                                    this.writeDat(this.fOut, 56);
                                    break;
                                }
                                case 570: {
                                    if (!this.identDaten) break;
                                    this.writeDat(this.fOut, 57);
                                    break;
                                }
                                case 580: {
                                    if (!this.umnumDaten) break;
                                    this.writeDat(this.fOut, 58);
                                    break;
                                }
                                case 602: {
                                    if (this.B.size() > 0) {
                                        this.writeBedingungen(this.fOut, this.B);
                                    }
                                    if (!this.bedingungDaten) break;
                                    this.writeDat(this.fOut, 60);
                                }
                            }
                            n2 = -1;
                            break;
                        }
                    }
                    this.fOut.println(((DatLine)object).toString());
                }
                this.writeDat(this.fOut, 99);
                this.fBak.close();
            }
            catch (IOException iOException) {
                throw new IFileInputException("Fehler beim Schreiben der Datei " + this.datFile.getName());
            }
            catch (IException iException) {
                throw new IFileInputException(iException.getMessage());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IFileInputException(exception.getMessage());
            }
            finally {
                try {
                    this.fOut.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void writePunkte(PrintWriter printWriter, Vector vector) {
        if (vector.size() > 0) {
            this.fOut.println("C Punktdaten aus Datei: " + this.inFile.getName());
            for (int i = 0; i < vector.size(); ++i) {
                Punkt punkt = (Punkt)vector.elementAt(i);
                this.fOut.println(punkt.toDatLine(this.plg, this.m3D));
            }
        }
    }

    private void writePunkteAsDigit(PrintWriter printWriter, Vector vector) {
        if (vector.size() > 0) {
            printWriter.println("C!Trafo: Transformation aus Datei: " + this.inFile.getName());
            for (int i = 0; i < vector.size(); ++i) {
                Punkt punkt = (Punkt)vector.elementAt(i);
                this.fOut.println(punkt.toDatDigitLine(this.plg * 2.0, this.plg, i == 0));
            }
        }
    }

    private void writePunkteAsMessung(PrintWriter printWriter, Vector vector) {
        if (vector.size() > 0) {
            printWriter.println("C!Trafo: Koordinatenbestimmung aus Datei: " + this.inFile.getName());
            printWriter.println("9  0  -1  1.000000");
            float f = 0.0f;
            for (int i = 0; i < vector.size(); ++i) {
                Punkt punkt = (Punkt)vector.elementAt(i);
                float f2 = (double)punkt.lsp != 0.0 ? punkt.lsp : (float)this.plg;
                float f3 = (double)punkt.lsp != 0.0 ? punkt.lsp * 0.9f : (float)this.plg * 0.5f;
                this.fOut.println(punkt.toDatDigitLine(f2, f3, 2, f2 != f));
                f = f2;
            }
        }
    }

    private void writePolarDaten(PrintWriter printWriter, Vector vector) {
        if (vector.size() > 0) {
            printWriter.println("C!Blatt: Polardaten aus Datei: " + this.inFile.getName());
            for (int i = 0; i < vector.size(); ++i) {
                PolarMessung polarMessung;
                String string;
                Object e = vector.elementAt(i);
                if (!(e instanceof PolarMessung) || (string = (polarMessung = (PolarMessung)e).toDatLine()) == null) continue;
                printWriter.println(string);
            }
        }
    }

    private void writeNivHoehenDaten(PrintWriter printWriter, Vector vector) throws IException {
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            NivMessung nivMessung;
            String string;
            Object e = vector.elementAt(i);
            if (!(e instanceof NivMessung) || (string = (nivMessung = (NivMessung)e).toDatHoeheLine()) == null) continue;
            if (!bl) {
                printWriter.println("C!Blatt: Nivellement aus Datei: " + this.inFile.getName());
                printWriter.println(HOEHE_STEUERDATEN_KENN);
                printWriter.println(HOEHE_STEUERDATEN);
                bl = true;
            }
            printWriter.println(string);
        }
    }

    private void writeGpsHoehenDaten(PrintWriter printWriter, Vector vector) throws IException {
        if (vector.size() > 0) {
            printWriter.println("C!Blatt: GPS-Basislinien aus Datei: " + this.inFile.getName());
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.elementAt(i);
                String string = null;
                if (e instanceof GpsMessung) {
                    GpsMessung gpsMessung = (GpsMessung)e;
                    if (i == 0) {
                        printWriter.println(HOEHE_STEUERDATEN_KENN);
                        printWriter.println(HOEHE_STEUERDATEN);
                    }
                    string = gpsMessung.toDatHoeheLine();
                }
                if (string == null) continue;
                printWriter.println(string);
            }
        }
    }

    private void writeHoehenDaten(PrintWriter printWriter, Vector vector) throws IException {
        if (vector.size() > 0) {
            printWriter.println("C!Blatt: Polardaten aus Datei: " + this.inFile.getName());
            long l = 0L;
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.elementAt(i);
                String string = null;
                if (!(e instanceof PolarMessung)) continue;
                PolarMessung polarMessung = (PolarMessung)e;
                if (IPolarReader.isTrigSteuerdaten() && polarMessung.pns > 0L) {
                    printWriter.println(HOEHE_STEUERDATEN_KENN);
                    printWriter.println(HOEHE_STEUERDATEN);
                }
                if (polarMessung.pns <= 0L && l > 0L) {
                    polarMessung.pns = l;
                }
                string = polarMessung.toDatHoeheLine();
                if (l > 0L && polarMessung.pns == l) {
                    polarMessung.pns = 0L;
                }
                if (string == null) {
                    if (polarMessung.pns <= 0L) continue;
                    l = polarMessung.pns;
                    continue;
                }
                printWriter.println(string);
                l = 0L;
            }
        }
    }

    private void writeGpsDaten(PrintWriter printWriter, Vector vector) {
        if (vector.size() > 0) {
            printWriter.println("C!Blatt: GPS-Basislinien aus Datei: " + this.inFile.getName());
            for (int i = 0; i < vector.size(); ++i) {
                GpsMessung gpsMessung = (GpsMessung)vector.elementAt(i);
                String string = gpsMessung.toDatLine();
                if (string == null) continue;
                printWriter.println(string);
            }
        }
    }

    private void writeTrafoSystemeAsDigit(PrintWriter printWriter, TrafoSystemTable trafoSystemTable) {
        Enumeration enumeration = trafoSystemTable.elements();
        while (enumeration.hasMoreElements()) {
            TrafoSystem trafoSystem = (TrafoSystem)enumeration.nextElement();
            printWriter.println("C!Trafo: " + trafoSystem.getName());
            boolean bl = true;
            Enumeration enumeration2 = trafoSystem.elements();
            while (enumeration2.hasMoreElements()) {
                Object e = enumeration2.nextElement();
                Punkt punkt = null;
                if (e instanceof TrafoPunkt) {
                    TrafoPunkt trafoPunkt = (TrafoPunkt)e;
                    punkt = new Punkt(trafoPunkt.getPunkt().nr, trafoPunkt.y, trafoPunkt.x);
                } else if (e instanceof Punkt) {
                    punkt = (Punkt)e;
                } else {
                    System.out.print(e);
                }
                if (bl) {
                    printWriter.println(punkt.toDatDigitLine(10.0, 5.0, trafoSystem.getParameter(), true));
                    bl = false;
                    continue;
                }
                printWriter.println(punkt.toDatDigitLine(10.0, 5.0, 2, false));
            }
        }
    }

    private void writeBedingungen(PrintWriter printWriter, Vector vector) {
        printWriter.println("C!Blatt: Bedingungen aus Datei: " + this.inFile.getName());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration2 = ((Riss)enumeration.nextElement()).elements();
            while (enumeration2.hasMoreElements()) {
                Bedingung bedingung = (Bedingung)enumeration2.nextElement();
                printWriter.println(bedingung.toDatLine());
            }
        }
    }

    private void writeDatObjecte(PrintWriter printWriter, Vector vector) throws IOException {
        printWriter.println("C Objekte aus Datei: " + this.inFile.getName());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((DatContainer)enumeration.nextElement()).writeDatContainer(printWriter);
        }
    }

    private boolean hasLicence(int n) {
        return !KafPlotVersion.isTestVersion() || n <= KafPlotVersion.testPoints();
    }

    private void writeDat(PrintWriter printWriter, int n) {
        String string = new String("  Schreibe ");
        switch (n) {
            case 0: {
                printWriter.println("PROJEKT");
                break;
            }
            case 1: {
                if (this.st == null) break;
                printWriter.println(this.st.toDatLine());
                printWriter.print("C!Steuerdaten  :");
                printWriter.print(" ");
                printWriter.println(this.st.getName());
                break;
            }
            case 2: {
                printWriter.print("C         Richtg  Strecke                                         Ziel         \nC         Messbd                  Prisma  Flucht          Masstab         Hoehe\nC\nC Kafka-Eingabedatei\nC!KafDatVersion: 2.0" + GeoNumberFormat.EOL + "C!Verm-Stelle  : " + KafDatProperties.getVermStelle() + GeoNumberFormat.EOL + "C!Adresse1     : " + KafDatProperties.getAdresse1() + GeoNumberFormat.EOL + "C!Adresse2     : " + KafDatProperties.getAdresse2() + GeoNumberFormat.EOL + "C!Adresse3     : " + KafDatProperties.getAdresse3() + GeoNumberFormat.EOL + "C!Bearbeiter   :" + GeoNumberFormat.EOL + "C!Gemeinde     :" + GeoNumberFormat.EOL + "C!Gemarkung    :" + GeoNumberFormat.EOL + "C!Flur         :" + GeoNumberFormat.EOL + "C!Flurstueck   :" + GeoNumberFormat.EOL + "C!Katasteramt  : " + KafDatProperties.getKatasteramt() + GeoNumberFormat.EOL + "C!Antragsnummer:" + GeoNumberFormat.EOL);
                if (KafkaIOProperties.datVersion == 3) {
                    printWriter.print("C!Modell       : ALKIS" + GeoNumberFormat.EOL);
                }
                printWriter.print("C!Daten        :" + GeoNumberFormat.EOL);
                break;
            }
            case 11: {
                printWriter.println("C Punktdaten manuelle Eingabe");
                if (KafkaIOProperties.datVersion == 3) {
                    if (this.longFormat) {
                        printWriter.print(PUNKT_LONG_INFO_ALKIS);
                    }
                    printWriter.print("C!ALKIS:" + GeoNumberFormat.EOL);
                    printWriter.print("C KS          PKN         Y           X     -KL--  --HOE--  PA--- GST-  GWT-- Z P Q--- ART- ABM- BZA- RHO KST-\n1               1 3471000.000  5754000.000  0.025   10.000  GP    2100  0.015 2 E 1000      1100 1000  -2 1000\n1               2 3471100.001  5754000.001  0.025           BGU   3200        1 B 4200 1100                   \n");
                    if (this.longFormat) {
                        printWriter.print(PUNKT_LONG_INFO_ALK);
                    }
                    printWriter.print("C!ALK:" + GeoNumberFormat.EOL);
                    printWriter.print("C PS           PN        Y            X      GL       HOE   PA VA  LS L  HS H EB  VT VVA Z OSKA S\n1               1 3471000.000  5754000.000  0.025   10.000  2 010 489 0 000 0 01 000 000 0 0000 0\n1               2 3471100.001  5754000.001  0.025           3 010 489 0 000 0 02\n");
                    break;
                }
                if (KafkaIOProperties.datVersion == 2) {
                    if (this.longFormat) {
                        printWriter.print(PUNKT_LONG_INFO_ALK);
                    }
                    printWriter.print("C PS           PN        Y            X      GL       HOE   PA VA  LS L  HS H EB  VT VVA Z OSKA S\n1               1 3471000.000  5754000.000  0.025   10.000  2 010 489 0 000 0 01 000 000 0 0000 0\n1               2 3471100.001  5754000.001  0.025           3 010 489 0 000 0 02\n");
                    break;
                }
                if (this.longFormat) {
                    printWriter.print(PUNKT_LONG_INFO_ALK);
                }
                printWriter.print("C PS         PN         Y            X     GL        HOE  A   VA   LS  L   HS  H  EB  VT  VVA  Z  OSKA\n1          1000  5471000.000  5754000.000 0.010    10.123 0  000  000  0  000  0  00           0  0000\n1             1  5471100.001  5754000.001 0.030           0  000  000  0  000  0  00           0  0000\n");
                break;
            }
            case 21: {
                printWriter.println("C GPS-Basislinien manuelle Eingabe");
                if (this.longFormat) {
                    printWriter.print("C PNS = Punktnummer Referenz\nC PNZ = Punktnummer Zielpunkt\nC Y   = Y-Differenz\nC X   = X-Differenz\nC GY  = Gewicht Y-Differenz\nC GX  = Gewicht X-Differenz\n");
                }
                if (KafkaIOProperties.datVersion >= 2) {
                    printWriter.print("C             PNS            PNZ      Y          X     GY    GX                                    BEMERKUNG\n7               1              2   100.000      0.000  1.00  1.00\n7                              3     0.000   -100.000  1.00  1.00\n");
                    break;
                }
                printWriter.print("C           PNS           PNZ        Y         X    GY    GX                   BEMERKUNG\n7             1             2     100.000     0.000 1.000 1.000\n7                           3       0.000   100.000 1.000 1.000\n");
                break;
            }
            case 22: {
                printWriter.println("C Polardaten manuelle Eingabe");
                if (this.longFormat) {
                    printWriter.print("C PNS = Punktnummer Standpunkt\nC PNZ = Punktnummer Zielpunkt\nC R   = Richtung\nC S   = Strecke\nC GR  = Gewicht Richtung\nC GS  = Gewicht Strecke\n");
                }
                if (KafkaIOProperties.datVersion >= 2) {
                    printWriter.print("C             PNS            PNZ      R          S     GR    GS                                    BEMERKUNG\n3               2              1     0.0000            1.00  1.00\n3                              4   300.0000   100.000  1.00  1.00\n");
                    break;
                }
                printWriter.print("C           PNS           PNZ      R          S      GR    GS                  BEMERKUNG\n3             2             1     0.0000     0.000   1.0   1.0\n3                           4   300.0000   100.000   1.0   1.0\n");
                break;
            }
            case 23: {
                printWriter.println("C Fluchtungslinie");
                if (this.longFormat) {
                    printWriter.print("C PN  = Punktnummer\nC GF  = Gewicht Fluchtung\n");
                }
                if (KafkaIOProperties.datVersion >= 2) {
                    printWriter.print("C              PN                                                  GF                              BEMERKUNG\n1               1                                                  1.00\n0               5\n9               2\n");
                    break;
                }
                printWriter.print("C            PN                                                  GF            BEMERKUNG\n1             1                                                  1.0\n0             5\n9             2\n");
                break;
            }
            case 24: {
                printWriter.println("C Messbandstrecken");
                if (this.longFormat) {
                    printWriter.print("C PN1 = Punkt 1\nC PN2 = Punkt 2\nC S   = Strecke\nC GS  = Gewicht Strecke\n");
                }
                if (KafkaIOProperties.datVersion >= 2) {
                    printWriter.println("C             PN1            PN2      S                GS                                          BEMERKUNG\n2               1              5    40.00              1.00");
                    break;
                }
                printWriter.print("C           PN1           PN2      S                 GS                        BEMERKUNG\n2             1             2     0.00               1.0\n");
                break;
            }
            case 25: {
                printWriter.println("C EDM-Strecken");
                if (this.longFormat) {
                    printWriter.print("C PN1 = Punkt 1\nC PN2 = Punkt 2\nC S   = Strecke\nC GS  = Gewicht Strecke\n");
                }
                if (KafkaIOProperties.datVersion >= 2) {
                    printWriter.print("C             PN1            PN2                 S           GS                                    BEMERKUNG\n3               2              6               40.000        1.00\n");
                    break;
                }
                printWriter.print("C           PN1           PN2                 S            GS                  BEMERKUNG\n3             2             6                0.000         1.0\n");
                break;
            }
            case 26: {
                printWriter.println("C Orthogonale Linie");
                if (this.longFormat) {
                    printWriter.print("C PN  = Punktnummer\nC PNF = Punktnummer Fusspunkt\nC A   = Abzisse\nC O   = Ordinate\nC GA  = Gewicht Abzisse\nC GO  = Gewicht Ordinate\nC GF  = Gewicht Fluchtung\nC GR  = Gewicht rechter Winkel\n");
                }
                if (KafkaIOProperties.datVersion >= 2) {
                    printWriter.print("C              PN            PNF      A          O     GA    GO    GF    GR                        BEMERKUNG\n1               1                    0.00       0.00   1.00  1.00  1.00  1.00\n0               7              5    40.00      20.00\n0               8              6    60.00      20.00\n9               2                  100.00       0.00\n");
                    break;
                }
                printWriter.print("C            PN           PNF      A          O      GA    GO    GF    GR      BEMERKUNG\n1             1                   0.00       0.00    1.0   1.0   1.0   1.0\n0             7             5    40.00      20.00\n0             8             6    60.00      20.00\n9             2                 100.00       0.00\n");
                break;
            }
            case 27: {
                printWriter.println("C Bogenschnitt");
                if (this.longFormat) {
                    printWriter.print("C PN1 = Punkt 1\nC PN2 = Punkt 2\nC PNS = Schnittpunkt rechtsliegend\nC S   = Strecke\nC GS  = Gewicht Strecke\n");
                }
                if (KafkaIOProperties.datVersion >= 2) {
                    printWriter.print("C             PN1            PNS      S                GS                                          BEMERKUNG\n6               7              8    20.00              1.00\n6               6              8    20.00\n");
                    break;
                }
                printWriter.print("C           PN1           PNS      S                 GS                        BEMERKUNG\n6             1             3     0.00               1.00\n6             2             3     0.00\n");
                break;
            }
            case 40: {
                printWriter.println("C Transformation");
                if (this.longFormat) {
                    printWriter.print("C S System 3,4,5,6 = erster Punkt im System (n-Parameter-Transformation)\nC                2 = alle folgenden Punkte in diesem System\nC PN  = Punktnummer\nC Y   = Rechtswert\nC X   = Hochwert\nC GL  = Lagegenauigkeit\nC GN  = Nachbarschaftsgenauigkeit\n");
                }
                if (KafkaIOProperties.datVersion >= 2) {
                    printWriter.print("C S          PN         Y            X       GL      GN\nC!Trafo: Transformation 1\n3               1    2000.000     5000.000   0.050   0.025\n2               2    2000.000     5100.000\n2               3    2100.000     5000.000\n");
                    break;
                }
                printWriter.print("C S          PN         Y            X     GL     GN\nC!Trafo: Transformation 1\n3             1     2000.000     5000.000 0.050  0.025\n2             2     2100.000     5000.000\n2             3     2000.000     5100.000\n");
                break;
            }
            case 51: {
                printWriter.println("C Angabe der Flurstuecke und Linienverbindungen");
                if (this.longFormat) {
                    printWriter.print("C PNA  = Punkt Linienanfang\nC PNE  = Punkt Linienende\nC R    = Radius\nC A    = Linienart\nC EB   = Ebene\nC OSKA = Objektschl\u00fcssel\n");
                }
                if (KafkaIOProperties.datVersion >= 2) {
                    printWriter.print("C             PNA            PNE                 R     A EB OSKA\nC!Flst: 000001-001-00001/001/000.0.00 F=00000 N=000 S=00000 L=Bezeichnung_der_Lage\n1               1                                      2  1 0233\n0               3                                      2 48\n0               4                             300.00   2  1\n0               2                                      2  1\n9               1                                      2  1\nC eine Verbindung:\n2               1              2                       2 48 0233\n");
                    break;
                }
                printWriter.print("C           PNA           PNE                 R     A  EB  OSKA\nC!Flst: 000000-000-00000/000/000.0.00 F=00000 N=000 S=00000 L=Bezeichnung_der_Lage\n1             1                                     2   1  0233\n0             3                                     2  48\n0             4                            300.00   2   1\n0             2                                     2   1\n9             1                                     2   1\nC eine Verbindung:\n2             1             2                       2  48\n");
                break;
            }
            case 52: {
                printWriter.println("C Angabe der Geb\u00e4ude und Linienverbindungen");
                if (this.longFormat) {
                    printWriter.print("C PNA  = Punkt Linienanfang\nC PNE  = Punkt Linienende\nC R    = Radius\nC A    = Linienart\nC EB   = Ebene\nC OSKA = Objektschl\u00fcssel\n");
                }
                if (KafkaIOProperties.datVersion >= 2) {
                    printWriter.print("C!Geb: 00000001-00001-P0001A-01 O=1311\n1               5                                      3  2 1013\n0               7                                      3  2\n0               8                                      3  2\n0               6                                      3  2\n9               5                                      3  2\n");
                    break;
                }
                printWriter.print("C           PNA           PNE                 R    LA  EB  OSKA\nC!Geb: 00000000-00000-P0000A-00 O=1311\n1             5                                     3   2  1013\n0             7                                     3   2\n0             8                              5.00   3   2\n0             6                                     3   2\n9             5                                     3   2\n");
                break;
            }
            case 53: {
                printWriter.println("C Angabe der Topographie");
                if (this.longFormat) {
                    printWriter.print("C PNA  = Punkt Linienanfang\nC PNE  = Punkt Linienende\nC R    = Radius\nC A    = Linienart\nC EB   = Ebene\nC OSKA = Objektschl\u00fcssel\n");
                }
                if (KafkaIOProperties.datVersion >= 2) {
                    printWriter.print("C!Top:\n1               1                                      4  6\n0               3                                      4  8\n0               4                                      4  6\n9               2                                      4  6\n");
                    break;
                }
                printWriter.print("C           PNA           PNE                 R    LA  EB  OSKA\nC!Top:\n1             1                                     4   6\n0             3                                     4   8\n0             4                              5.00   4   6\n9             2                                     4   6\n");
                break;
            }
            case 55: {
                printWriter.println("C Bemerkungstexte");
                if (this.longFormat) {
                    printWriter.print("C PNA = Punkt 1 zur Bemerkung\nC PNE = Punkt 2 zur Bemerkung (optional)\nC BEM = Bemerkung\n");
                }
                if (KafkaIOProperties.datVersion >= 2) {
                    printWriter.print("C             PNA            PNE BEM\n5               1                ST steht falsch\n5               7              8 falsches Ma\u00df\n");
                    break;
                }
                printWriter.print("C           PNA           PNE  BEM\n5             1                ST steht falsch\n5             7             8  falsches Ma\u00df\n");
                break;
            }
            case 56: {
                printWriter.println("C Freie Nummern im Nummerierungsbezirk");
                if (this.longFormat) {
                    printWriter.print("C PNA = erste  freie Punktnummer\nC PNE = letzte freie Punktnummer\nC NB  = Nummerierungsbezirk (8-stellig)\nC A   = umzunummerierende Art (optional)\n");
                }
                if (KafkaIOProperties.datVersion >= 2) {
                    printWriter.print("C             PNA            PNE       NB A\n6           30001          30200 34005700\n6          210001         210300 34005700 2\n");
                    break;
                }
                printWriter.print("C           PNA           PNE        NB A\n6         30001         30200  34005700\n6        210001        210300  34005700  2\n");
                break;
            }
            case 57: {
                printWriter.println("C Angabe der Punktidentit\u00e4ten");
                if (this.longFormat) {
                    printWriter.print("C PNI   = Punkt Ist\nC PNS   = Punkt Soll\nC BEM-I = Bemerkung Ist  (optional)\nC BEM-S = Bemerkung Soll (optional)\n");
                }
                if (KafkaIOProperties.datVersion >= 2) {
                    printWriter.print("C             PNI            PNS Ist-Bem ; Soll-Bem;\n7               1              2 ST steht falsch; ST umgesetzt;\n");
                    break;
                }
                printWriter.print("C           PNI           PNS  Ist-Bem ; Soll-Bem;\n7             1             2  ST steht falsch; ST umgesetzt;\n");
                break;
            }
            case 58: {
                printWriter.println("C Umnummerierung und Vergabe der Punkt- und Vermarkungsart");
                if (KafkaIOProperties.datVersion >= 3) {
                    if (this.longFormat) {
                        printWriter.print(UMNUM_LONG_INFO_ALKIS);
                    }
                    printWriter.print("C!ALKIS:" + GeoNumberFormat.EOL);
                    printWriter.print("C            PKNA           PKNN  PA-F- GST- GWT--- Z P Q--- ART- ABM- BZA- RHO ABMV KST-          BEMERKUNG\n8               1         100123  GP -  2100  0.015 2 E 1000      1100 1000  -2 9500 1000\n8               2         100124  GP    2100  0.015 2 E 1000      1100 1000  -2          \n");
                    break;
                }
                if (KafkaIOProperties.datVersion == 2) {
                    if (this.longFormat) {
                        printWriter.print(UMNUM_LONG_INFO_ALK);
                    }
                    printWriter.print("C             PNA            PNN A  VA  LS L  HS H EB  VT VVA Z OSKA S                             BEMERKUNG\n8               1          30000 2 010 489 2 000 0 01 000 000 0 0000\nC Neue Nummer wird aus Nummerierungsbezirk erzeugt:\n8               2              # 2 010 489 2 000 0 01\n");
                    break;
                }
                if (this.longFormat) {
                    printWriter.print(UMNUM_LONG_INFO_ALK);
                }
                printWriter.print("C           PNA           PNN PA   VA   LS  L   HS  H  EB  VT  VVA LZ  OSKA\n8             1         30000  2  000  489  2  000  0  00\nC Neue Nummer wird aus Nummerierungsbezirk erzeugt:      \n8             2             #  2  000  489  2  000  0  00\n");
                break;
            }
            case 31: {
                if (KafkaIOProperties.datVersion >= 2) {
                    printWriter.println("C Geometrisches Nivellement");
                    if (this.longFormat) {
                        printWriter.println("C PN1  = Punktnummer Anfangspunkt");
                        printWriter.println("C PN2  = Punktnummer Endpunkt");
                        printWriter.println("C DH   = H\u00f6henunterschied");
                        printWriter.println("C S    = L\u00e4nge Nivellementslinie [km]");
                        printWriter.println("C G    = Standardabweichung");
                    }
                    printWriter.println("C             PN1            PN2     DH          S       G");
                    printWriter.println("1               1              3     5.2501     0.1     0.005");
                    break;
                }
                printWriter.println("In dieser Dateiversion sind keine H\u00f6hen m\u00f6glich");
                break;
            }
            case 32: {
                if (KafkaIOProperties.datVersion >= 2) {
                    this.writeDat(printWriter, 30);
                    printWriter.println("C Polare H\u00f6henmessung");
                    if (this.longFormat) {
                        printWriter.println("C PNS  = Punktnummer Standpunkt");
                        printWriter.println("C PNZ  = Punktnummer Zielpunkt");
                        printWriter.println("C Z    = Zenitwinkel");
                        printWriter.println("C S    = Schr\u00e4gstrecke (optional)");
                        printWriter.println("C GZ   = Standardabweichung Zenitwinkel");
                        printWriter.println("C GZ   = Standardabweichung Schr\u00e4gstrecke");
                        printWriter.println("C DH   = Differenz Instrumenten - Reflektorh\u00f6he");
                    }
                    printWriter.println("C             PNS            PNZ      Z          S      GZ      GS      DZ");
                    printWriter.println("3               1              3   105.2501   112.512   0.005   0.005  -0.5");
                    break;
                }
                printWriter.println("In dieser Dateiversion sind keine H\u00f6hen m\u00f6glich");
                break;
            }
            case 30: {
                if (KafkaIOProperties.datVersion >= 2) {
                    printWriter.println("C Steuerdaten f\u00fcr H\u00f6henmessung");
                    if (this.longFormat) {
                        printWriter.println("C GGH  = Gewichtseinheit der geometrischen H\u00f6hendifferenzen");
                        printWriter.println("C GTH  = Gewichtseinheit der trigonometrischen H\u00f6hendifferenzen");
                        printWriter.println("C GZ   = Gewichtseinheit der Zenitdistanzen");
                        printWriter.println("C GS   = Gewichtseinheit der Strecken");
                        printWriter.println("C GDZ  = Gewichtseinheit der Differenzen aus Standpunkt- und Reflektorh\u00f6he");
                    }
                    printWriter.println(HOEHE_STEUERDATEN_KENN);
                    printWriter.println(HOEHE_STEUERDATEN);
                    break;
                }
                printWriter.println("In dieser Dateiversion sind keine H\u00f6hen m\u00f6glich");
                break;
            }
            case 60: {
                if (KafkaIOProperties.datVersion >= 2) {
                    printWriter.println("C             PN1            PN2            PN3  G         M                                       BEMERKUNG");
                    printWriter.println("C Geradenbedingung");
                    if (this.longFormat) {
                        printWriter.println("C Punkt PN2 liegt in der Geraden zwischen PN1 und PN3");
                    }
                    printWriter.println("1               1              5              6 1.00");
                    printWriter.println("C Bedingung Rechter Winkel");
                    if (this.longFormat) {
                        printWriter.println("C Der Rechte Winkel befindet sich in PN2");
                    }
                    printWriter.println("2               5              6              8 1.00");
                    printWriter.println("C Bedingung Parallele");
                    if (this.longFormat) {
                        printWriter.println("C 3 = Bezugsgerade PN1-PN2");
                    }
                    printWriter.println("3               5              6                1.00");
                    if (this.longFormat) {
                        printWriter.println("C 0 = Parallele mit oder ohne Abstandsbedingung");
                    }
                    printWriter.println("0               7              8                1.00     20.00");
                    printWriter.println("C Abstandbedingung Linie-Punkt");
                    if (this.longFormat) {
                        printWriter.println("C Bezugsgerade PN1-PN2, Punkt PN3 mit Abstandsbedingung");
                    }
                    printWriter.println("4               3              4              8 1.00     80.00");
                    printWriter.println("C Abstandbedingung Punkt-Punkt");
                    printWriter.println("5               7              8                1.00     20.00");
                    printWriter.println("C Bedingung Kreisbogen");
                    if (this.longFormat) {
                        printWriter.println("C 6 = Kreisbogen mit Mittelpunkt PN1 und Bogenpunkte PN2, PN3 mit und ohne Radius");
                    }
                    printWriter.println("6               8              7              6 1.00     20.00");
                    if (this.longFormat) {
                        printWriter.println("C 9 = weiterer Bogenpunkt PN1");
                    }
                    printWriter.println("9               7");
                    break;
                }
                printWriter.println("C           PN1           PN2           PN3     G        M");
                printWriter.println("C Geradenbedingung");
                if (this.longFormat) {
                    printWriter.println("C Punkt PN2 liegt in der Geraden zwischen PN1 und PN3");
                }
                printWriter.println("1             1             2             3    1.0");
                printWriter.println("C Bedingung Rechter Winkel");
                if (this.longFormat) {
                    printWriter.println("C Der Rechte Winkel befindet sich in PN2");
                }
                printWriter.println("2             1             2             3    1.0");
                printWriter.println("C Bedingung Parallele");
                if (this.longFormat) {
                    printWriter.println("C 3 = Bezugsgerade PN1-PN2");
                }
                printWriter.println("3             1             2                  1.0");
                if (this.longFormat) {
                    printWriter.println("C 0 = Parallele mit oder ohne Abstandsbedingung");
                }
                printWriter.println("0             3             4                  1.0      3.77");
                printWriter.println("C Abstandbedingung Linie-Punkt");
                if (this.longFormat) {
                    printWriter.println("C Bezugsgerade PN1-PN2, Punkt PN3 mit Abstandsbedingung");
                }
                printWriter.println("4             1             2             3    1.0      5.00");
                printWriter.println("C Abstandbedingung Punkt-Punkt");
                printWriter.println("5             1             2                  1.0      8.00");
                printWriter.println("C Bedingung Kreisbogen");
                if (this.longFormat) {
                    printWriter.println("C 6 = Kreisbogen mit Mittelpunkt PN1 und Bogenpunkte PN2, PN3 mit und ohne Radius");
                }
                printWriter.println("6             1             2             3    1.0      6.00");
                if (this.longFormat) {
                    printWriter.println("C 9 = weiterer Bogenpunkt PN1");
                }
                printWriter.println("9             4");
                break;
            }
            case 99: {
                printWriter.println("ENDE DER AUFTRAGSDATEI");
            }
        }
    }
}

