/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IException;
import de.geocalc.geom.DPoint;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.Bedingung;
import de.geocalc.kafplot.Bemerkung;
import de.geocalc.kafplot.EntstehungsArt;
import de.geocalc.kafplot.Hoehe;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.LinieParameter;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.MessungGewicht;
import de.geocalc.kafplot.NummerierungsBezirk;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktArt;
import de.geocalc.kafplot.PunktIdentitaet;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.PunktParameterALK;
import de.geocalc.kafplot.PunktParameterALKIS;
import de.geocalc.kafplot.PunktParameterVoid;
import de.geocalc.kafplot.TrafoGewicht;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.kataster.KatasterStatus;
import java.util.StringTokenizer;

public class DatLine
extends de.geocalc.io.DatLine {
    public DatLine() {
    }

    public DatLine(String string) {
        super(string);
    }

    public static String getElementString(int n, int n2, int n3) {
        switch (n) {
            case 3: {
                return "Block";
            }
            case 5: {
                return "Liste";
            }
            case 2: {
                return "Variable";
            }
            case 5001: {
                return "Zeilenkennung";
            }
        }
        block6 : switch (n2) {
            case 1: {
                switch (n) {
                    case 5002: {
                        return "PN";
                    }
                    case 5004: 
                    case 5005: {
                        return "XY";
                    }
                    case 5010: {
                        return "ZUSATZ";
                    }
                }
                break;
            }
            case 2: {
                switch (n3) {
                    case 3: 
                    case 8: {
                        switch (n) {
                            case 5002: {
                                return "PNS";
                            }
                            case 5003: {
                                return "PNZ";
                            }
                        }
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 7: {
                        switch (n) {
                            case 5002: {
                                return "PN1";
                            }
                            case 5003: {
                                return "PN2";
                            }
                        }
                        break;
                    }
                    case 6: {
                        switch (n) {
                            case 5002: {
                                return "PN12";
                            }
                            case 5003: {
                                return "PNS";
                            }
                        }
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 9: {
                        switch (n) {
                            case 5002: {
                                return "PN";
                            }
                            case 5003: {
                                return "PNF";
                            }
                        }
                    }
                }
                switch (n) {
                    case 5004: {
                        return "L1";
                    }
                    case 5005: {
                        return "L2";
                    }
                    case 5010: {
                        return "Bemerkung";
                    }
                }
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                switch (n) {
                    case 5002: {
                        return "PN";
                    }
                }
                break;
            }
            case 6: {
                switch (n) {
                    case 5006: {
                        return "P1";
                    }
                    case 5007: {
                        return "P2";
                    }
                    case 5008: {
                        return "P3";
                    }
                    case 5009: {
                        return "M";
                    }
                }
                break;
            }
            case 5: {
                switch (n3) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 9: {
                        switch (n) {
                            case 5002: {
                                return "PNA";
                            }
                            case 5003: {
                                return "PNE";
                            }
                            case 5010: {
                                return "ZUSATZ";
                            }
                        }
                        break block6;
                    }
                    case 5: {
                        switch (n) {
                            case 5006: {
                                return "P1";
                            }
                            case 5007: {
                                return "P2";
                            }
                        }
                        break block6;
                    }
                    case 7: {
                        switch (n) {
                            case 5002: {
                                return "PNI";
                            }
                            case 5003: {
                                return "PNS";
                            }
                        }
                        break block6;
                    }
                    case 8: {
                        switch (n) {
                            case 5002: {
                                return "PNA";
                            }
                            case 5003: {
                                return "PNN";
                            }
                            case 5010: {
                                return "ZUSATZ";
                            }
                        }
                    }
                }
            }
        }
        return "unbekannt";
    }

    public int getKennZiffer() throws IFileInputException {
        try {
            char c = this.line.charAt(0);
            if (c == 'C') {
                return -1;
            }
            return Integer.parseInt(this.line.substring(0, 1));
        }
        catch (Exception exception) {
            throw new IFileInputException("Fehler bei der Zeilenerkennung");
        }
    }

    public int getErrorKennZiffer() {
        try {
            char c = this.line.charAt(1);
            if (c == 'C') {
                return -1;
            }
            return Integer.parseInt(this.line.substring(1, 2));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getErrorKennZiffer(boolean bl) {
        int n = this.getErrorKennZiffer();
        switch (n) {
            case 1: 
            case 9: {
                return 0;
            }
        }
        return n;
    }

    public Punkt getPunktDifferenz(Punkt punkt) throws IFileInputException {
        try {
            punkt.dy = (float)(punkt.y - this.parseDouble(this.line, 2, 0.0));
            punkt.dx = (float)(punkt.x - this.parseDouble(this.line, 3, 0.0));
        }
        catch (Exception exception) {
            throw new IFileInputException("Fehler beim Lesen der Koordinaten");
        }
        return punkt;
    }

    public Punkt getPunktWerte(Punkt punkt) throws IFileInputException {
        try {
            int n = this.getKennZiffer();
            if (n == -1) {
                n = 5;
            }
            punkt.setPs(n);
        }
        catch (Exception exception) {
            punkt.setPs(-1);
        }
        try {
            if (!punkt.isOn()) {
                punkt.y = this.parseDouble(this.line, 2, 0.0);
                punkt.x = this.parseDouble(this.line, 3, 0.0);
            }
            punkt.g = this.parseFloat(this.line, 4, 0.0f);
            punkt.h = this.parseFloat(this.line, 5, 0.0f);
            if (KafkaIOProperties.datVersion >= 3 && this.length >= 120) {
                punkt.setBemerkung(this.line.substring(119).trim());
            } else if (KafkaIOProperties.datVersion == 2 && this.length >= 100) {
                punkt.setBemerkung(this.line.substring(99).trim());
            }
        }
        catch (Exception exception) {
            throw new IFileInputException("Fehler beim Lesen der Punktwerte");
        }
        return punkt;
    }

    public Punkt getPunktWerteBlock7(Punkt punkt) throws IFileInputException {
        try {
            int n = this.getKennZiffer();
            if (n == -1) {
                n = 5;
            }
            punkt.setPs(n);
        }
        catch (Exception exception) {
            punkt.setPs(-1);
        }
        try {
            if (!punkt.isOn()) {
                punkt.y = this.parseDouble(this.line, 2, 0.0);
                punkt.x = this.parseDouble(this.line, 3, 0.0);
            }
            punkt.g = this.parseFloat(this.line, 4, 0.0f);
            punkt.h = this.parseFloat(this.line, 5, 0.0f);
            if (KafkaIOProperties.datVersion >= 3 && this.length >= 120) {
                punkt.setBemerkung(this.line.substring(119).trim());
            } else if (KafkaIOProperties.datVersion == 2 && this.length >= 106) {
                punkt.setBemerkung(this.line.substring(105).trim());
            }
        }
        catch (Exception exception) {
            throw new IFileInputException("Fehler beim Lesen der Punktwerte");
        }
        return punkt;
    }

    public DPoint getCoordinates() {
        return new DPoint(this.parseDouble(this.line, 2, 0.0), this.parseDouble(this.line, 3, 0.0));
    }

    public PunktParameter getPunktParameter(int n) throws IFileInputException {
        if (this.line.length() < 60) {
            return PunktParameterVoid.VOID;
        }
        try {
            if (n == 2) {
                PunktParameterALKIS punktParameterALKIS = new PunktParameterALKIS();
                String string = this.parseString(60, 65, "");
                punktParameterALKIS.setPa(PunktArt.parseString(string));
                punktParameterALKIS.setPst(KatasterStatus.parseString(string));
                punktParameterALKIS.setLg(this.parseInt(66, 70, 0));
                punktParameterALKIS.setLl(this.parseFloat(71, 77, 0.0f));
                punktParameterALKIS.setLz(this.parseInt(78, 80, 0));
                punktParameterALKIS.setEa(EntstehungsArt.parseChar(this.parseChar(80, ' ')));
                punktParameterALKIS.setEq(this.parseInt(82, 86, 0));
                punktParameterALKIS.setArt(this.parseInt(87, 91, 0));
                punktParameterALKIS.setVa(this.parseInt(92, 96, 0));
                punktParameterALKIS.setVb(this.parseInt(97, 101, 0));
                punktParameterALKIS.setVvt(this.parseInt(102, 105, 0));
                punktParameterALKIS.setLs(this.parseInt(106, 110, 0));
                return punktParameterALKIS;
            }
            if (KafkaIOProperties.datVersion == 2) {
                PunktParameterALK punktParameterALK = new PunktParameterALK();
                punktParameterALK.setPa(this.parseInt(60, 61, -1));
                punktParameterALK.setVa(this.parseInt(62, 65, 0));
                punktParameterALK.setLs(this.parseInt(66, 69, 0));
                punktParameterALK.setLg(this.parseChar(70, '\u0000'));
                punktParameterALK.setHs(this.parseInt(72, 75, 0));
                punktParameterALK.setHg(this.parseInt(76, 77, 0));
                punktParameterALK.setEb(this.parseInt(78, 80, 0));
                punktParameterALK.setVvt(this.parseInt(81, 84, 0));
                punktParameterALK.setVva(this.parseInt(85, 88, 0));
                punktParameterALK.setLz(this.parseInt(89, 90, 0));
                punktParameterALK.setOska(this.parseInt(91, 95, 0));
                punktParameterALK.setPst(this.parseInt(96, 97, -1));
                return punktParameterALK;
            }
            if (KafkaIOProperties.datVersion == 1) {
                PunktParameterALK punktParameterALK = new PunktParameterALK();
                punktParameterALK.setPa(this.parseInt(58, 59, -1));
                punktParameterALK.setVa(this.parseInt(61, 64, 0));
                punktParameterALK.setLs(this.parseInt(66, 69, 0));
                punktParameterALK.setLg(this.parseChar(71, '\u0000'));
                punktParameterALK.setHs(this.parseInt(74, 77, 0));
                punktParameterALK.setHg(this.parseInt(79, 80, 0));
                punktParameterALK.setEb(this.parseInt(82, 84, 0));
                punktParameterALK.setVvt(this.parseInt(85, 88, 0));
                punktParameterALK.setVva(this.parseInt(90, 93, 0));
                punktParameterALK.setLz(this.parseInt(95, 96, 0));
                punktParameterALK.setOska(this.parseInt(98, 102, 0));
                return punktParameterALK;
            }
            return new PunktParameterVoid();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IFileInputException("Fehler beim Lesen der Punktparameter, " + exception.getMessage());
        }
    }

    public PunktParameter getPunktParameterBlock7() throws IFileInputException {
        if (KafkaIOProperties.datVersion == 3) {
            PunktParameterALKIS punktParameterALKIS = new PunktParameterALKIS();
            return punktParameterALKIS;
        }
        if (KafkaIOProperties.datVersion == 2) {
            PunktParameterALK punktParameterALK = new PunktParameterALK();
            try {
                punktParameterALK.setPa(this.parseInt(66, 67, -1));
                punktParameterALK.setVa(this.parseInt(68, 71, 0));
                punktParameterALK.setLs(this.parseInt(72, 75, 0));
                punktParameterALK.setLg(this.parseChar(76, '\u0000'));
                punktParameterALK.setHs(this.parseInt(78, 81, 0));
                punktParameterALK.setHg(this.parseInt(82, 83, 0));
                punktParameterALK.setEb(this.parseInt(84, 86, 0));
                punktParameterALK.setVvt(this.parseInt(87, 90, 0));
                punktParameterALK.setVva(this.parseInt(91, 94, 0));
                punktParameterALK.setLz(this.parseInt(95, 96, 0));
                punktParameterALK.setOska(this.parseInt(97, 101, 0));
                punktParameterALK.setPst(this.parseInt(102, 103, -1));
            }
            catch (Exception exception) {
                throw new IFileInputException("Fehler beim Lesen der Punktparameter");
            }
            return punktParameterALK;
        }
        throw new IFileInputException("Erweiterter Punktblock erst ab DatVersion 2 lesbar");
    }

    public Hoehe toHoehe() throws IFileInputException {
        Hoehe hoehe = new Hoehe();
        int n = this.getKennZiffer();
        if (n == -1) {
            hoehe.setOn(false);
            n = this.getErrorKennZiffer();
        }
        try {
            hoehe.setArt((byte)n);
            hoehe.setL1(this.parseDouble(this.line, 3, 0.0));
            hoehe.setL2(this.parseDouble(this.line, 4, 0.0));
            hoehe.setG1(this.parseFloat(this.line, 5, 0.0f));
            hoehe.setG2(this.parseFloat(this.line, 6, 0.0f));
            hoehe.setDz(this.parseFloat(this.line, 7, 0.0f));
            if (KafkaIOProperties.datVersion >= 2 && this.length >= 100) {
                hoehe.setBemerkung(this.line.substring(99).trim());
            }
        }
        catch (Exception exception) {
            throw new IFileInputException("Fehler beim Lesen der H\u00f6henwerte");
        }
        return hoehe;
    }

    public Messung toMessung() throws IFileInputException {
        Messung messung = new Messung();
        int n = 0;
        try {
            n = this.getKennZiffer();
            if (n == -1) {
                messung.setOn(false);
                n = this.getErrorKennZiffer();
            } else if (n == 5) {
                messung.eMa = 200 + this.getErrorKennZiffer() * 10;
            }
            messung.ma = 200 + n * 10;
        }
        catch (Exception exception) {
            messung.ma = -1;
        }
        try {
            double d = this.parseDouble(this.line, 3, Double.MAX_VALUE);
            if (d != Double.MAX_VALUE) {
                messung.l1 = d;
                ++messung.ma;
            }
            if ((d = this.parseDouble(this.line, 4, Double.MAX_VALUE)) != Double.MAX_VALUE) {
                messung.l2 = d;
                messung.ma += 2;
            }
            if (KafkaIOProperties.datVersion >= 2 && this.length >= 100) {
                messung.setBemerkung(this.line.substring(99).trim());
            } else if (KafkaIOProperties.datVersion == 1 && this.length >= 80) {
                messung.setBemerkung(this.line.substring(79).trim());
            }
        }
        catch (Exception exception) {
            throw new IFileInputException("Fehler beim Lesen der Messwerte");
        }
        return messung;
    }

    public MessungGewicht toMessungGewicht(MessungGewicht messungGewicht) throws IFileInputException {
        try {
            float f = this.parseFloat(this.line, 5, 0.0f);
            float f2 = this.parseFloat(this.line, 6, 0.0f);
            float f3 = this.parseFloat(this.line, 7, 0.0f);
            float f4 = this.parseFloat(this.line, 8, 0.0f);
            if (f == 0.0f && f2 == 0.0f && f3 == 0.0f && f4 == 0.0f) {
                return messungGewicht;
            }
            if (f == 0.0f) {
                f = messungGewicht.getG1();
            }
            if (f2 == 0.0f) {
                f2 = messungGewicht.getG2();
            }
            if (f3 == 0.0f) {
                f3 = messungGewicht.getG3();
            }
            if (f4 == 0.0f) {
                f4 = messungGewicht.getG4();
            }
            return MessungGewicht.intern(new MessungGewicht(f, f2, f3, f4));
        }
        catch (Exception exception) {
            throw new IFileInputException("Fehler beim Lesen der Gewichte");
        }
    }

    public TrafoSystem toTrafoSystem(int n) throws IFileInputException {
        TrafoSystem trafoSystem = new TrafoSystem(n);
        trafoSystem.setSuperSystem(true);
        int n2 = -1;
        int n3 = 0;
        double d = 0.0;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.line);
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                n2 = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                n3 = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                d = new Double(stringTokenizer.nextToken());
            }
        }
        catch (Exception exception) {
            throw new IFileInputException("Ung\u00fcltige Werte in Transformationsdefinition");
        }
        switch (n2) {
            case -3: 
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                trafoSystem.setParameter(n2);
                break;
            }
            default: {
                throw new IFileInputException("Ung\u00fcltige Systemparameter:" + n2);
            }
        }
        if (n3 != -1) {
            throw new IFileInputException("Ung\u00fcltige Parameter Resklaffe:" + n3);
        }
        if (d == 0.0) {
            throw new IFileInputException("Ung\u00fcltige Parameter Ma\u00dfstab");
        }
        trafoSystem.setSuperMasstab(d);
        return trafoSystem;
    }

    public TrafoPunkt toTrafoPunkt() throws IFileInputException {
        TrafoPunkt trafoPunkt = new TrafoPunkt();
        int n = this.getKennZiffer();
        if (n == -1) {
            trafoPunkt.setOn(false);
        } else {
            trafoPunkt.setOn(true);
            trafoPunkt.setFirst(n != 2);
        }
        try {
            trafoPunkt.y = this.parseDouble(this.line, 2, 0.0);
            trafoPunkt.x = this.parseDouble(this.line, 3, 0.0);
            if (KafkaIOProperties.datVersion >= 2 && this.length >= 100) {
                trafoPunkt.setBemerkung(this.line.substring(99).trim());
            } else if (KafkaIOProperties.datVersion == 1 && this.length >= 80) {
                trafoPunkt.setBemerkung(this.line.substring(79).trim());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IFileInputException("Fehler beim Lesen der Koordinaten");
        }
        return trafoPunkt;
    }

    public TrafoGewicht toTrafoGewicht(TrafoGewicht trafoGewicht) throws IFileInputException {
        try {
            float f = this.parseFloat(this.line, 4, 0.0f);
            float f2 = this.parseFloat(this.line, 5, 0.0f);
            if (f == 0.0f && f2 == 0.0f) {
                return trafoGewicht;
            }
            if (f == 0.0f) {
                f = trafoGewicht.getG1();
            }
            if (f2 == 0.0f) {
                f2 = trafoGewicht.getG2();
            }
            return TrafoGewicht.intern(new TrafoGewicht(f, f2));
        }
        catch (Exception exception) {
            throw new IFileInputException("Fehler beim Lesen der Gewichte");
        }
    }

    public Bedingung toBedingung() throws IFileInputException {
        Bedingung bedingung = new Bedingung();
        try {
            bedingung.ba = this.getKennZiffer();
            if (bedingung.ba == -1) {
                bedingung.setOn(false);
                bedingung.ba = this.getErrorKennZiffer();
            }
        }
        catch (Exception exception) {
            bedingung.ba = -1;
        }
        try {
            bedingung.g = this.parseFloat(this.line, 4, 0.0f);
            bedingung.l = this.parseDouble(this.line, 5, 0.0);
        }
        catch (Exception exception) {
            throw new IFileInputException("Fehler beim Lesen der Bedingungswerte");
        }
        if (this.length >= 100) {
            bedingung.setBemerkung(this.line.substring(99).trim());
        }
        return bedingung;
    }

    public Linie toLinie() throws IFileInputException {
        LinieParameter linieParameter;
        Linie linie;
        block27: {
            linie = new Linie();
            linieParameter = new LinieParameter();
            try {
                if (KafkaIOProperties.datVersion >= 2) {
                    linie.setLs(this.parseInt(0, 1, 0));
                    if (this.length <= 43) {
                        return linie;
                    }
                    linie.l2 = this.parseDouble(43, 54, 0.0);
                    if (this.length <= 54) {
                        return linie;
                    }
                    String string = this.parseString(55, 58, "");
                    if (string.equalsIgnoreCase("BOK")) {
                        linie.setBOK(true);
                    } else if (string.equalsIgnoreCase("BUK")) {
                        linie.setBUK(true);
                    } else {
                        linieParameter.setLa(this.parseInt(55, 56, 0));
                        linieParameter.setEb(this.parseInt(57, 59, 0));
                    }
                    if (this.length > 60) {
                        String string2 = this.line.substring(60, Math.min(this.length, 70)).trim();
                        int n = string2.indexOf(".");
                        if (n > 0) {
                            linieParameter.setFolie(Integer.parseInt(string2.substring(0, n)));
                            linieParameter.setOska(Integer.parseInt(string2.substring(n + 1)));
                        } else if (string2.length() > 0) {
                            linieParameter.setOska(Integer.parseInt(string2));
                        }
                    } else {
                        linieParameter.setOska(0);
                    }
                    if (this.length >= 100) {
                        linie.setBemerkung(this.line.substring(99).trim());
                    }
                    break block27;
                }
                try {
                    linie.setLs(Integer.parseInt(this.line.substring(0, 1)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.length < 16) {
                    return linie;
                }
                try {
                    linie.l2 = this.parseDouble(41, Math.min(this.length, 52), 0.0);
                }
                catch (Exception exception) {
                    linie.l2 = 0.0;
                }
                if (this.length < 50) {
                    return linie;
                }
                try {
                    linieParameter.setLa(Integer.parseInt(this.line.substring(52, 53)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    linieParameter.setEb(Integer.parseInt(this.line.substring(55, 57).trim()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    linieParameter.setOska(Integer.parseInt(this.line.substring(58, Math.min(this.length, 68)).trim()));
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                throw new IFileInputException("Fehler beim Lesen der Linienparameter");
            }
        }
        linie.setParameter(linieParameter);
        return linie;
    }

    public PunktIdentitaet getPunktIdentitaetParameter(PunktIdentitaet punktIdentitaet) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.line.substring(KafkaIOProperties.datVersion >= 2 ? 33 : 31, this.length).trim(), ";");
            punktIdentitaet.bemIst = new String(stringTokenizer.nextToken().trim());
            punktIdentitaet.bemSoll = new String(stringTokenizer.nextToken().trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return punktIdentitaet;
    }

    public Bemerkung toBemerkung() {
        Bemerkung bemerkung = new Bemerkung();
        try {
            if (this.length >= 30) {
                bemerkung.setText(this.line.substring(KafkaIOProperties.datVersion >= 2 ? 33 : 30).trim());
            } else {
                bemerkung.setText("");
            }
        }
        catch (Exception exception) {
            bemerkung.setText("");
        }
        return bemerkung;
    }

    public NummerierungsBezirk toNummerierungsBezirk() {
        long l = this.getP1();
        long l2 = this.getP2();
        int n = 0;
        int n2 = -1;
        if (KafkaIOProperties.datVersion >= 2) {
            n = this.parseInt(33, 41, 0);
            n2 = this.parseInt(42, 43, -1);
        } else {
            try {
                n = Integer.parseInt(this.line.substring(30, 39).trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                n2 = Integer.parseInt(this.line.substring(41, 42).trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new NummerierungsBezirk(n, l, l2, n2);
    }

    public void setPunktZusatz(Punkt punkt, int n) throws Exception {
        PunktParameter punktParameter = punkt.getParameter();
        if (KafkaIOProperties.datVersion >= 2) {
            if (this.length < 31) {
                punkt.setUmnum(this.parseLong(18, 32, 0L));
                punkt.setFlagUM_PNR(true);
                return;
            }
            if (this.line.charAt(31) == '#') {
                punkt.setUmnum(-9L);
            } else {
                punkt.setUmnum(this.parseLong(18, 32, 0L));
                punkt.setFlagUM_PNR(true);
            }
            if (n == 2) {
                float f;
                String string;
                int n2;
                if (!(punktParameter instanceof PunktParameterALKIS)) {
                    punktParameter = new PunktParameterALKIS();
                }
                if ((n2 = PunktArt.parseString(string = this.parseString(34, 39, ""))) != -1) {
                    punktParameter.setPa(n2);
                    punkt.setUmnumFlag(1);
                }
                if ((n2 = KatasterStatus.parseString(string)) != 10) {
                    punktParameter.setPst(n2);
                    punkt.setUmnumFlag(4096);
                }
                if ((n2 = this.parseInt(40, 45, -1)) != -1) {
                    punktParameter.setLg(n2);
                    punkt.setUmnumFlag(16);
                }
                if ((f = this.parseFloat(44, 51, 0.0f)) != 0.0f) {
                    punktParameter.setLl(f);
                    punkt.setUmnumFlag(32);
                }
                if ((n2 = this.parseInt(52, 53, -1)) != -1) {
                    punktParameter.setLz(n2);
                    punkt.setUmnumFlag(64);
                }
                if ((n2 = EntstehungsArt.parseString(this.parseString(54, 55, " "))) != 0) {
                    punktParameter.setEa(n2);
                    punkt.setUmnumFlag(32768);
                }
                if ((n2 = this.parseInt(56, 60, -1)) != -1) {
                    punktParameter.setEq(n2);
                    punkt.setUmnumFlag(65536);
                }
                if ((n2 = this.parseInt(61, 65, -1)) != -1) {
                    punktParameter.setArt(n2);
                    punkt.setUmnumFlag(131072);
                }
                if ((n2 = this.parseInt(66, 70, -1)) != -1) {
                    punktParameter.setVa(n2);
                    punkt.setUmnumFlag(4);
                }
                if ((n2 = this.parseInt(71, 75, -1)) != -1) {
                    punktParameter.setVb(n2);
                    punkt.setUmnumFlag(16384);
                }
                if ((n2 = this.parseInt(76, 79, 0)) != 0) {
                    punktParameter.setVvt(n2);
                    punkt.setUmnumFlag(1024);
                }
                if ((n2 = this.parseInt(80, 84, 0)) != 0) {
                    punktParameter.setVva(n2);
                    punkt.setUmnumFlag(512);
                }
                if ((n2 = this.parseInt(85, 89, 0)) != 0) {
                    punktParameter.setLs(n2);
                    punkt.setUmnumFlag(8);
                }
                if (punkt.isUmnumFlag(16) && !punkt.isUmnumFlag(32)) {
                    punktParameter.setLl(0.0f);
                    punkt.setUmnumFlag(32);
                } else if (punkt.isUmnumFlag(32) && !punkt.isUmnumFlag(16)) {
                    punktParameter.setLg(0);
                    punkt.setUmnumFlag(16);
                }
            } else {
                int n3;
                if (!(punktParameter instanceof PunktParameterALK)) {
                    punktParameter = new PunktParameterALK();
                }
                if ((n3 = this.parseInt(33, 34, -1)) != -1) {
                    punktParameter.setPa(n3);
                    punkt.setUmnumFlag(1);
                }
                if ((n3 = this.parseInt(35, 38, -1)) != -1) {
                    punktParameter.setVa(n3);
                    punkt.setUmnumFlag(4);
                }
                if ((n3 = this.parseInt(39, 42, 0)) != 0) {
                    punktParameter.setLs(n3);
                    punkt.setUmnumFlag(8);
                }
                char c = this.parseChar(43, ' ');
                n3 = c;
                if (c != ' ') {
                    punktParameter.setLg(n3);
                    punkt.setUmnumFlag(16);
                }
                if ((n3 = this.parseInt(45, 48, 0)) != 0) {
                    punktParameter.setHs(n3);
                    punkt.setUmnumFlag(128);
                }
                if ((n3 = this.parseInt(49, 50, 0)) != 0) {
                    punktParameter.setHg(n3);
                    punkt.setUmnumFlag(256);
                }
                if ((n3 = this.parseInt(51, 53, -1)) != -1) {
                    punktParameter.setEb(n3);
                    punkt.setUmnumFlag(2);
                }
                if (this.length > 54) {
                    n3 = this.parseInt(54, 57, 0);
                    if (n3 != 0) {
                        punktParameter.setVvt(n3);
                        punkt.setUmnumFlag(1024);
                    }
                    if ((n3 = this.parseInt(58, 61, 0)) != 0) {
                        punktParameter.setVva(n3);
                        punkt.setUmnumFlag(512);
                    }
                    if ((n3 = this.parseInt(62, 63, -1)) != -1) {
                        punktParameter.setLz(n3);
                        punkt.setUmnumFlag(64);
                    }
                    if ((n3 = this.parseInt(64, 68, -1)) != -1) {
                        punktParameter.setOska(n3);
                        punkt.setUmnumFlag(2048);
                    }
                    if ((n3 = this.parseInt(69, 70, -1)) != -1) {
                        punktParameter.setPst(n3);
                        punkt.setUmnumFlag(4096);
                    }
                }
            }
            if (this.length > 100) {
                punkt.addNewBemerkung(this.line.substring(99));
            }
        } else {
            if (!(punktParameter instanceof PunktParameterALK)) {
                punktParameter = new PunktParameterALK();
            }
            if (this.length < 28) {
                throw new IException("fehlende Angaben zum Punkt " + punkt.nr);
            }
            if (this.line.charAt(28) == '#') {
                punkt.setUmnum(-9L);
            } else {
                punkt.setUmnum(this.parseLong(16, 29, 0L));
                punkt.setFlagUM_PNR(true);
            }
            int n4 = this.parseInt(31, 32, -1);
            if (n4 != -1) {
                punktParameter.setPa(n4);
                punkt.setUmnumFlag(1);
            }
            if ((n4 = this.parseInt(34, 37, -1)) != -1) {
                punktParameter.setVa(n4);
                punkt.setUmnumFlag(4);
            }
            if ((n4 = this.parseInt(39, 42, 0)) != 0) {
                punktParameter.setLs(n4);
                punkt.setUmnumFlag(8);
            }
            char c = this.parseChar(44, ' ');
            n4 = c;
            if (c != ' ') {
                punktParameter.setLg(n4);
                punkt.setUmnumFlag(16);
            }
            if ((n4 = this.parseInt(47, 50, 0)) != 0) {
                punktParameter.setHs(n4);
                punkt.setUmnumFlag(128);
            }
            if ((n4 = this.parseInt(52, 53, 0)) != 0) {
                punktParameter.setHg(n4);
                punkt.setUmnumFlag(256);
            }
            if ((n4 = this.parseInt(55, 57, -1)) != -1) {
                punktParameter.setEb(n4);
                punkt.setUmnumFlag(2);
            }
            if ((n4 = this.parseInt(58, 61, 0)) != 0) {
                punktParameter.setVvt(n4);
                punkt.setUmnumFlag(1024);
            }
            if ((n4 = this.parseInt(63, 66, 0)) != 0) {
                punktParameter.setVva(n4);
                punkt.setUmnumFlag(512);
            }
            if ((n4 = this.parseInt(67, 69, -1)) != -1) {
                punktParameter.setLz(n4);
                punkt.setUmnumFlag(64);
            }
            if ((n4 = this.parseInt(72, 76, -1)) != -1) {
                punktParameter.setOska(n4);
                punkt.setUmnumFlag(2048);
            }
        }
        punkt.updateParameter(punktParameter);
    }

    public long getPunktNummer() {
        return this.getP1();
    }

    public long getStandPunktNummer() {
        return this.getP1();
    }

    public long getZielPunktNummer() {
        return this.getP2();
    }

    public long getP1() {
        try {
            return this.parseLong(this.line, 1, 0L);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public long getP2() {
        try {
            return this.parseLong(this.line, 2, 0L);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public long getP3() {
        try {
            return this.parseLong(this.line, 3, 0L);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public String toString() {
        return this.line;
    }

    private final char parseChar(int n, char c) {
        if (n >= this.length) {
            return c;
        }
        return this.line.charAt(n);
    }

    private final long parseLong(String string, int n, long l) {
        String string2 = format.parseValueAt(string, n);
        if (string2.length() == 0) {
            return l;
        }
        return Long.parseLong(string2);
    }

    private final long parseLong(int n, int n2, long l) {
        if (n >= this.length) {
            return l;
        }
        if (n2 > this.length) {
            n2 = this.length;
        }
        while (n < n2 && this.line.charAt(n) == ' ') {
            ++n;
        }
        while (n2 > n && this.line.charAt(n2 - 1) == ' ') {
            --n2;
        }
        if (n != n2) {
            return Long.parseLong(this.line.substring(n, n2));
        }
        return l;
    }

    private final int parseInt(String string, int n, int n2) {
        String string2 = format.parseValueAt(string, n);
        if (string2.length() == 0) {
            return n2;
        }
        return Integer.parseInt(string2);
    }

    private final int parseInt(int n, int n2, int n3) throws NumberFormatException {
        if (n >= this.length) {
            return n3;
        }
        if (n2 > this.length) {
            n2 = this.length;
        }
        while (n < n2) {
            if (this.line.charAt(n) == ' ') {
                ++n;
                continue;
            }
            if (this.line.charAt(n) != '+') break;
            ++n;
        }
        while (n2 > n && this.line.charAt(n2 - 1) == ' ') {
            --n2;
        }
        if (n != n2) {
            try {
                return Integer.parseInt(this.line.substring(n, n2));
            }
            catch (Exception exception) {
                throw new NumberFormatException("Ung\u00fcltiger Wert in Spalte " + n + "-" + n2);
            }
        }
        return n3;
    }

    private final float parseFloat(String string, int n, float f) {
        String string2 = format.parseValueAt(string, n);
        if (string2.length() == 0) {
            return f;
        }
        return Float.valueOf(string2).floatValue();
    }

    private final float parseFloat(int n, int n2, float f) {
        if (n >= this.length) {
            return f;
        }
        if (n2 > this.length) {
            n2 = this.length;
        }
        while (n < n2 && this.line.charAt(n) == ' ') {
            ++n;
        }
        while (n2 > n && this.line.charAt(n2 - 1) == ' ') {
            --n2;
        }
        if (n != n2) {
            return Float.valueOf(this.line.substring(n, n2)).floatValue();
        }
        return f;
    }

    private final double parseDouble(String string, int n, double d) {
        String string2 = format.parseValueAt(string, n);
        if (string2.length() == 0) {
            return d;
        }
        return Double.valueOf(string2);
    }

    private final double parseDouble(int n, int n2, double d) {
        if (n >= this.length) {
            return d;
        }
        if (n2 > this.length) {
            n2 = this.length;
        }
        while (n < n2 && this.line.charAt(n) == ' ') {
            ++n;
        }
        while (n2 > n && this.line.charAt(n2 - 1) == ' ') {
            --n2;
        }
        if (n != n2) {
            return Double.valueOf(this.line.substring(n, n2));
        }
        return d;
    }

    private final String parseString(int n, int n2, String string) {
        try {
            if (n >= this.length) {
                return string;
            }
            if (n2 > this.length) {
                n2 = this.length;
            }
            return this.line.substring(n, n2).trim();
        }
        catch (Exception exception) {
            return string;
        }
    }
}

