/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IException;
import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.DatLineFormat;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.Bedingung;
import de.geocalc.kafplot.Bemerkung;
import de.geocalc.kafplot.BodenSchaetzung;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.DataContainerTable;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.GebaeudeKennzeichen;
import de.geocalc.kafplot.Gemarkung;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.Grundbuchblatt;
import de.geocalc.kafplot.Hoehe;
import de.geocalc.kafplot.HoeheGewicht;
import de.geocalc.kafplot.Identitaet;
import de.geocalc.kafplot.KatAmt;
import de.geocalc.kafplot.KoordinatenSystem;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.LinieParameter;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.MessungGewicht;
import de.geocalc.kafplot.Name;
import de.geocalc.kafplot.NummerierungsBezirkException;
import de.geocalc.kafplot.Nutzung;
import de.geocalc.kafplot.ObjectDecor;
import de.geocalc.kafplot.ObjectSymbol;
import de.geocalc.kafplot.ObjectText;
import de.geocalc.kafplot.PropertyLoader;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktArt;
import de.geocalc.kafplot.PunktIdentitaet;
import de.geocalc.kafplot.PunktMove;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.PunktParameterALK;
import de.geocalc.kafplot.PunktParameterALKIS;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.Strasse;
import de.geocalc.kafplot.TagObject;
import de.geocalc.kafplot.TextBox;
import de.geocalc.kafplot.TopObject;
import de.geocalc.kafplot.TrafoGewicht;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.io.DatLine;
import de.geocalc.kafplot.io.IDataReader;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.kafplot.io.dat.SteuerDaten;
import de.geocalc.kafplot.io.edbs.EdbsIOProperties;
import de.geocalc.kataster.model.Alk;
import de.geocalc.kataster.model.Alkis;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.text.IFormat;
import de.geocalc.util.LongHashList;
import de.geocalc.util.LongHashObject;
import de.geocalc.util.sml.Body;
import de.geocalc.util.sml.Tag;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class DatReader
extends IDataReader {
    DataBase db;
    LongHashList P;
    LongHashList DAT_P;
    Hashtable P_IDENT;
    Hashtable UMNUM;
    private LineNumberReader reader = null;
    private int block = -9;
    private int liste = -1;
    private int elementKennung = -1;
    long readedBytes = 0L;
    Punkt referenzPunkt = null;
    Punkt standPunkt = null;
    Linie lastLinie = null;
    boolean orthoError = false;
    boolean trafoError = false;
    boolean linieError = false;
    boolean orthoStart = false;
    boolean bogenStart = false;
    boolean polyStart = false;
    int lastOrthoEndIndex = 0;
    int orthoPunktCount = 0;
    Riss lastOrthoRiss = null;
    Messung lastOrthoPunkt = null;
    Messung lastPolarMessung = null;
    Messung lastGpsMessung = null;
    MessungGewicht lastMGW = MessungGewicht.intern(new MessungGewicht(1.0f, 1.0f, 1.0f, 1.0f));
    TrafoGewicht lastTGW = TrafoGewicht.intern(new TrafoGewicht(0.3f, 0.3f));
    HoeheGewicht lastHGW = HoeheGewicht.intern(new HoeheGewicht());
    Bedingung lastBedingung = null;
    Bemerkung lastBemerkung = null;
    String kvzRiss = null;
    int kvzStatus = 0;
    Riss lastRiss = null;
    Riss polarRiss = null;
    Riss gpsRiss = null;
    Riss messbandRiss = null;
    Riss katasterRiss = null;
    Riss einrechenRiss = null;
    Riss vorgabeRiss = null;
    Riss bedingungRiss = null;
    Riss nivellementRiss = null;
    Riss polarhoehenRiss = null;
    Riss homogenisierungRiss = null;
    GObject gObj = null;
    TrafoSystem trafoSystem = null;
    int trafoSystemStatus = 0;
    String trafoSystemName = null;
    int currentPunktModel = 0;

    public DatReader(File file, DataBase dataBase) {
        this(file, dataBase, null);
    }

    public DatReader(File file, DataBase dataBase, IProgressViewer iProgressViewer) {
        super(file, iProgressViewer);
        this.db = dataBase;
        this.P = DataBase.P;
        this.P_IDENT = DataBase.P_IDENT;
        this.DAT_P = new LongHashList();
        this.UMNUM = new Hashtable();
    }

    @Override
    public void userAbort() throws IFileInputException {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception exception) {
            throw new IFileInputException(this.getErrorKey() + "Fehler beim Schlie\u00dfen der Datei: " + this.inFile.getName());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void read() {
        var1_1 = new String();
        try {
            this.reader = this.createReader();
        }
        catch (IOException var2_2) {
            this.addException("Datei nicht gefunden");
            return;
        }
        KafkaIOProperties.datVersion = 0;
        this.currentPunktModel = DataBase.model.getModel();
        while (this.block != 0) {
            try {
                block382: {
                    block381: {
                        try {
                            var1_1 = this.reader.readLine();
                            if (var1_1 == null) {
                                this.addException(5001, "Dateiende vorzeitig erreicht");
                            }
                            break block381;
                        }
                        catch (IOException var2_4) {
                            this.addException(5001, "Zeile konnte nicht gelesen werden");
                        }
                        break;
                    }
                    var2_3 = null;
                    var3_9 = null;
                    var4_10 = false;
                    if (this.reader.getLineNumber() < 4) {
                        if (this.reader.getLineNumber() == 1) {
                            DataBase.projekt = new String(var1_1);
                        } else {
                            DataBase.steuerDaten = SteuerDaten.parseDatLine(var1_1, this.reader.getLineNumber(), DataBase.steuerDaten);
                        }
                        if (this.reader.getLineNumber() != 3) continue;
                        if (DataBase.steuerDaten.getHoehe() == 0.0) {
                            this.addException(new IException("Fehler beim Lesen der Steuerdaten", "Es wurde keine Gel\u00e4ndeh\u00f6he in den Steuerdaten angegeben!"));
                        }
                        if (DataBase.P.size() > 0) {
                            var5_13 = DataBase.steuerDaten.getIGK();
                            v0 = this;
                            var6_16 = v0.db.getKooSystem();
                            if (!(var5_13 == 0 && var6_16 != 150 && var6_16 != 489 || var5_13 == 1 && var6_16 == 150 || var5_13 == 2 && var6_16 == 489)) {
                                this.addException(new IException("Das Koordinatensystem der Steuerdaten und der vorgefundene Koordinatenbereich passen nicht zusammen!", "IGK " + var5_13 + " != " + KoordinatenSystem.getSystemName(var6_16)));
                            }
                        }
                        if (DataBase.steuerDaten.getKPZ1() >= 3) continue;
                        var5_14 = new PunktTable(1.0f);
                        var6_17 = DataBase.P.elements();
                        while (var6_17.hasMoreElements()) {
                            var7_18 = (Punkt)var6_17.nextElement();
                            var7_18.nr %= 1000000L;
                            if (var5_14.put((LongHashObject)var7_18) == null) continue;
                            this.addException(new Exception("Es sind Punkte mit gleichen Punktnummern in unterschiedlichen Kilometerquadraten vorhanden. KafPlot kann diese nicht aufl\u00f6sen. Bitte Werten Sie mit Sortierungskennung KPZ1 = 3 aus"));
                        }
                        DataBase.P.clear();
                        var6_17 = var5_14.elements();
                        while (var6_17.hasMoreElements()) {
                            DataBase.P.put((Punkt)var6_17.nextElement());
                        }
                        continue;
                    }
                    if (var1_1.length() == 0) continue;
                    var5_15 = new DatLine(var1_1);
                    try {
                        var6_16 = var5_15.getKennung();
                    }
                    catch (Exception var7_19) {
                        this.addException(5001, var7_19.getMessage());
                        break;
                    }
                    block24 : switch (var6_16) {
                        case -9: 
                        case -1: {
                            break;
                        }
                        case 2: {
                            var7_18 = var5_15.getVariableWert();
                            block33 : switch (var5_15.getVariable()) {
                                case 2: {
                                    if (var7_18 == null || var7_18.length() == 0) {
                                        KafkaIOProperties.datVersion = 0;
                                        break;
                                    }
                                    try {
                                        DataBase.kafDatVersion = var7_18;
                                        var8_20 = Integer.parseInt(var7_18.substring(0, 1));
                                        var9_49 = Integer.parseInt(var7_18.substring(2, 3));
                                        if (var8_20 == 1) {
                                            KafkaIOProperties.datVersion = var9_49 < 1 ? 0 : (var9_49 < 4 ? 1 : 2);
                                            DataBase.model = Alk.getInstance();
                                        } else if (var8_20 == 2) {
                                            KafkaIOProperties.datVersion = 3;
                                            DataBase.model = Alkis.getInstance();
                                        } else {
                                            KafkaIOProperties.datVersion = 0;
                                            DataBase.model = Alk.getInstance();
                                        }
                                        this.currentPunktModel = DataBase.model.getModel();
                                    }
                                    catch (Exception var8_21) {
                                        this.addException(2, "Fehler beim Auswerten der Variablen C!KafDatVersion:");
                                    }
                                    break;
                                }
                                case 10: {
                                    DataBase.vermStelle = var7_18;
                                    break;
                                }
                                case 11: {
                                    DataBase.adresse_1 = var7_18;
                                    break;
                                }
                                case 12: {
                                    DataBase.adresse_2 = var7_18;
                                    break;
                                }
                                case 13: {
                                    DataBase.adresse_3 = var7_18;
                                    break;
                                }
                                case 14: {
                                    DataBase.bearbeiter = var7_18;
                                    break;
                                }
                                case 20: {
                                    DataBase.gemeinde = var7_18;
                                    break;
                                }
                                case 21: {
                                    DataBase.gemarkung = var7_18;
                                    break;
                                }
                                case 22: {
                                    DataBase.flur = var7_18;
                                    break;
                                }
                                case 23: {
                                    DataBase.flurstueck = var7_18;
                                    break;
                                }
                                case 31: {
                                    DataBase.setGelHoehe(Double.valueOf((String)var7_18));
                                    if (KafkaIOProperties.datVersion < 2) break;
                                    this.addException(2, "Die Gel\u00e4ndeh\u00f6he ist ab KafPlot-Version 1.4 in der zeiten Steuerdatenzeile vorzunehmen");
                                    break;
                                }
                                case 40: {
                                    if (var7_18 == null || var7_18.length() <= 0) break;
                                    DataBase.katasterAmt = var7_18;
                                    var8_22 = KatAmt.getKatAmt(DataBase.katasterAmt);
                                    if (var8_22 == null) {
                                        this.addException(2, "unbekanntes Katasteramt: " + DataBase.katasterAmt + ". \u00dcberp\u00fcfen Sie die Einstellungen in der Datei: aemter.properties.");
                                        break;
                                    }
                                    if (var8_22.vatProperties == null) break block24;
                                    new PropertyLoader().loadProperties("vermarkungen.properties", var8_22.vatProperties);
                                    break;
                                }
                                case 41: {
                                    DataBase.antrag = var7_18;
                                    break;
                                }
                                case 42: {
                                    DataBase.kooSystemName = var7_18;
                                    break;
                                }
                                case 43: {
                                    if (var7_18.equalsIgnoreCase("ALK")) {
                                        DataBase.model = Alk.getInstance();
                                    } else if (var7_18.equalsIgnoreCase("ALKIS")) {
                                        DataBase.model = Alkis.getInstance();
                                    } else if (var7_18.length() > 0) {
                                        this.addException("unbekanntes KatasterModell: " + (String)var7_18);
                                    }
                                    this.currentPunktModel = DataBase.model.getModel();
                                    break;
                                }
                                case 151: {
                                    this.currentPunktModel = 1;
                                    break;
                                }
                                case 152: {
                                    this.currentPunktModel = 2;
                                    break;
                                }
                                case 44: {
                                    try {
                                        KafkaIOProperties.setVars((String)var7_18);
                                    }
                                    catch (NumberFormatException var8_23) {
                                        this.addException(2, var8_23.getMessage());
                                    }
                                    DataBase.isTested = KafkaIOProperties.isFullTested();
                                    DataBase.daten = var7_18;
                                    break;
                                }
                                case 45: {
                                    try {
                                        if (var7_18 == null || var7_18.length() <= 0) break block24;
                                        DataBase.addNasFile((String)var7_18);
                                    }
                                    catch (Exception var8_24) {
                                        this.addException(2, var8_24.getMessage());
                                    }
                                    break;
                                }
                                case 101: {
                                    if (this.block != 1 && this.block != 7) {
                                        this.addException(2, "Angaben zum Koordinatenverzeichnis nur innerhalb des Punktblockes m\u00f6glich");
                                        break;
                                    }
                                    this.kvzRiss = var7_18;
                                    this.kvzStatus = 0;
                                    break;
                                }
                                case 102: {
                                    if (this.block != 1 && this.block != 7) {
                                        this.addException(2, "Angaben zum Koordinatenverzeichnis nur innerhalb des Punktblockes m\u00f6glich");
                                        break;
                                    }
                                    this.kvzRiss = var7_18;
                                    this.kvzStatus = 1;
                                    break;
                                }
                                case 103: {
                                    if (this.block != 1 && this.block != 7) {
                                        this.addException(2, "Angaben zum Koordinatenverzeichnis nur innerhalb des Punktblockes m\u00f6glich");
                                        break;
                                    }
                                    this.kvzRiss = var7_18;
                                    this.kvzStatus = 2;
                                    break;
                                }
                                case 201: {
                                    if (this.orthoStart || this.bogenStart) {
                                        if (this.orthoStart) {
                                            this.addException(2, "Blattwechsel innerhalb einer orthogonalen Linie  nicht m\u00f6glich");
                                        }
                                        if (!this.bogenStart) break;
                                        this.addException(2, "Blattwechsel innerhalb eines Bogenschlags nicht m\u00f6glich");
                                        break;
                                    }
                                    switch (this.liste) {
                                        case 201: {
                                            this.lastRiss = this.polarRiss = new Riss((String)var7_18, 1, 201);
                                            this.saveContainer(this.polarRiss, DataBase.MP);
                                            break block33;
                                        }
                                        case 202: {
                                            this.lastRiss = this.gpsRiss = new Riss((String)var7_18, 1, 202);
                                            this.saveContainer(this.gpsRiss, DataBase.MG);
                                            break block33;
                                        }
                                        case 203: {
                                            this.lastRiss = this.messbandRiss = new Riss((String)var7_18, 1, 203);
                                            this.saveContainer(this.messbandRiss, DataBase.MM);
                                            break block33;
                                        }
                                        case 206: {
                                            this.lastRiss = this.einrechenRiss = new Riss((String)var7_18, 1, 206);
                                            this.saveContainer(this.einrechenRiss, DataBase.ME);
                                            break block33;
                                        }
                                        case 205: {
                                            this.lastRiss = this.vorgabeRiss = new Riss((String)var7_18, 1, 205);
                                            this.saveContainer(this.vorgabeRiss, DataBase.MV);
                                            break block33;
                                        }
                                        case 301: {
                                            this.lastRiss = this.nivellementRiss = new Riss((String)var7_18, 3, 301);
                                            this.saveContainer(this.nivellementRiss, DataBase.HN);
                                            break block33;
                                        }
                                        case 302: {
                                            this.lastRiss = this.polarhoehenRiss = new Riss((String)var7_18, 3, 302);
                                            this.saveContainer(this.polarhoehenRiss, DataBase.HP);
                                            break block33;
                                        }
                                        case 601: {
                                            this.lastRiss = this.homogenisierungRiss = new Riss((String)var7_18, 6, 601);
                                            this.saveContainer(this.homogenisierungRiss, DataBase.BH);
                                            break block33;
                                        }
                                        case 602: {
                                            this.lastRiss = this.bedingungRiss = new Riss((String)var7_18, 6, 602);
                                            this.saveContainer(this.bedingungRiss, DataBase.BB);
                                            break block33;
                                        }
                                    }
                                    this.addException("Blatt au\u00dferhalb einer g\u00fcltigen Liste");
                                    break;
                                }
                                case 202: {
                                    if (this.block == 4) {
                                        this.trafoSystemStatus = 2;
                                        this.trafoSystemName = var7_18;
                                        break;
                                    }
                                    if (this.orthoStart || this.bogenStart) {
                                        if (this.orthoStart) {
                                            this.addException(2, "Risswechsel innerhalb einer orthogonalen Linie  nicht m\u00f6glich");
                                        }
                                        if (!this.bogenStart) break;
                                        this.addException(2, "Risswechsel innerhalb eines Bogenschlags nicht m\u00f6glich");
                                        break;
                                    }
                                    switch (this.liste) {
                                        case 204: {
                                            this.lastRiss = this.katasterRiss = new Riss((String)var7_18, 2, 204);
                                            this.saveContainer(this.katasterRiss, DataBase.MK);
                                            break block33;
                                        }
                                    }
                                    this.addException("Riss au\u00dferhalb einer g\u00fcltigen Liste");
                                    break;
                                }
                                case 1201: {
                                    this.lastRiss = this.polarRiss = new Riss((String)var7_18, 1, 201);
                                    this.saveContainer(this.polarRiss, DataBase.MP);
                                    this.liste = 201;
                                    break;
                                }
                                case 1202: {
                                    this.lastRiss = this.gpsRiss = new Riss((String)var7_18, 1, 202);
                                    this.saveContainer(this.gpsRiss, DataBase.MG);
                                    this.liste = 202;
                                    break;
                                }
                                case 1203: {
                                    this.lastRiss = this.messbandRiss = new Riss((String)var7_18, 1, 203);
                                    this.saveContainer(this.messbandRiss, DataBase.MM);
                                    this.liste = 203;
                                    break;
                                }
                                case 1204: {
                                    this.lastRiss = this.katasterRiss = new Riss((String)var7_18, 2, 204);
                                    this.saveContainer(this.katasterRiss, DataBase.MK);
                                    this.liste = 204;
                                    break;
                                }
                                case 1205: {
                                    this.lastRiss = this.einrechenRiss = new Riss((String)var7_18, 1, 206);
                                    this.saveContainer(this.einrechenRiss, DataBase.ME);
                                    this.liste = 206;
                                    break;
                                }
                                case 1206: {
                                    this.lastRiss = this.vorgabeRiss = new Riss((String)var7_18, 1, 205);
                                    this.saveContainer(this.vorgabeRiss, DataBase.MV);
                                    this.liste = 205;
                                    break;
                                }
                                case 1301: {
                                    this.lastRiss = this.nivellementRiss = new Riss((String)var7_18, 3, 301);
                                    this.saveContainer(this.nivellementRiss, DataBase.HN);
                                    this.liste = 301;
                                    break;
                                }
                                case 1303: {
                                    this.lastRiss = this.polarhoehenRiss = new Riss((String)var7_18, 3, 302);
                                    this.saveContainer(this.polarhoehenRiss, DataBase.HP);
                                    this.liste = 302;
                                    break;
                                }
                                case 1601: {
                                    this.lastRiss = this.homogenisierungRiss = new Riss((String)var7_18, 6, 601);
                                    this.saveContainer(this.homogenisierungRiss, DataBase.BH);
                                    this.liste = 601;
                                    break;
                                }
                                case 1602: {
                                    this.lastRiss = this.bedingungRiss = new Riss((String)var7_18, 6, 602);
                                    this.saveContainer(this.bedingungRiss, DataBase.BB);
                                    this.liste = 602;
                                    break;
                                }
                                case 401: {
                                    this.trafoSystemStatus = 8;
                                    this.trafoSystemName = var7_18;
                                    break;
                                }
                                case 402: {
                                    this.trafoSystemStatus = 9;
                                    this.trafoSystemName = var7_18;
                                    break;
                                }
                                case 501: {
                                    if (this.polyStart) {
                                        this.addException(2, "Objektwechsel innerhalb eines Umringpolygons nicht m\u00f6glich");
                                        break;
                                    }
                                    try {
                                        this.gObj = (Flurstueck)Flurstueck.parseDatLine((String)var7_18);
                                        this.saveContainer(this.gObj, DataBase.ALB);
                                    }
                                    catch (IException var8_25) {
                                        this.addException(2, var8_25.getMessage());
                                    }
                                    break;
                                }
                                case 502: {
                                    if (this.polyStart) {
                                        this.addException(2, "Objektwechsel innerhalb eines Umringpolygons nicht m\u00f6glich");
                                        break;
                                    }
                                    try {
                                        this.gObj = (Flurstueck)Flurstueck.parseDatLine((String)var7_18);
                                        this.saveContainer(this.gObj, DataBase.FLST);
                                    }
                                    catch (IException var8_26) {
                                        this.addException(2, var8_26.getMessage());
                                    }
                                    break;
                                }
                                case 503: {
                                    try {
                                        var8_27 = (Grundbuchblatt)Grundbuchblatt.parseDatLine((String)var7_18);
                                        if (DataBase.BUCH.get(var8_27) != null) {
                                            this.addException(2, "Grundbuchblatt " + var8_27.toString() + " ist doppelt vergeben");
                                        }
                                        DataBase.BUCH.put(var8_27);
                                    }
                                    catch (Exception var8_28) {
                                        this.addException(2, var8_28.getMessage());
                                    }
                                    break;
                                }
                                case 504: {
                                    try {
                                        var8_29 = Name.parseDatLine((String)var7_18);
                                        var9_50 = (Grundbuchblatt)DataBase.BUCH.get(var8_29.getGrundbuchblatt());
                                        if (var9_50 == null) {
                                            this.addException(2, "Grundbuchblattnummer " + var8_29.getGrundbuchblatt() + " nicht gefunden");
                                            break;
                                        }
                                        var9_50.addElement(var8_29);
                                    }
                                    catch (Exception var8_30) {
                                        this.addException(2, var8_30.getMessage());
                                    }
                                    break;
                                }
                                case 505: {
                                    if (this.polyStart) {
                                        this.addException(2, "Objektwechsel innerhalb eines Umringpolygons nicht m\u00f6glich");
                                        break;
                                    }
                                    try {
                                        this.gObj = (Nutzung)Nutzung.parseDatLine((String)var7_18);
                                        this.saveContainer(this.gObj, DataBase.NUTZ);
                                    }
                                    catch (Exception var8_31) {
                                        this.addException(2, var8_31.getMessage());
                                    }
                                    break;
                                }
                                case 506: {
                                    if (this.polyStart) {
                                        this.addException(2, "Objektwechsel innerhalb eines Umringpolygons nicht m\u00f6glich");
                                        break;
                                    }
                                    try {
                                        this.gObj = (BodenSchaetzung)BodenSchaetzung.parseDatLine((String)var7_18);
                                        this.saveContainer(this.gObj, DataBase.BODEN);
                                    }
                                    catch (Exception var8_32) {
                                        this.addException(2, var8_32.getMessage());
                                    }
                                    break;
                                }
                                case 510: {
                                    if (this.polyStart) {
                                        this.addException(2, "Objektwechsel innerhalb eines Umringpolygons nicht m\u00f6glich");
                                        break;
                                    }
                                    try {
                                        this.gObj = (Gebaeude)Gebaeude.parseDatLine((String)var7_18);
                                        this.saveContainer(this.gObj, DataBase.GEB);
                                    }
                                    catch (IException var8_33) {
                                        this.addException(2, var8_33.getMessage());
                                    }
                                    break;
                                }
                                case 511: {
                                    if (this.gObj == null) {
                                        this.addException(2, "Dem Geb\u00e4udekennzeichen mu\u00df die Angabe eines Geb\u00e4udes vorhergehen");
                                        break;
                                    }
                                    try {
                                        ((Gebaeude)this.gObj).addKennzeichen(GebaeudeKennzeichen.parseDatLine((String)var7_18));
                                    }
                                    catch (Exception var8_34) {
                                        this.addException(2, var8_34.getMessage());
                                    }
                                    break;
                                }
                                case 520: {
                                    if (this.polyStart) {
                                        this.addException(2, "Objektwechsel innerhalb eines Umringpolygons nicht m\u00f6glich");
                                        break;
                                    }
                                    try {
                                        this.gObj = (TopObject)TopObject.parseDatLine((String)var7_18);
                                        this.saveContainer(this.gObj, DataBase.TOP);
                                    }
                                    catch (IException var8_35) {
                                        this.addException(2, var8_35.getMessage());
                                    }
                                    break;
                                }
                                case 611: {
                                    if (this.gObj == null) {
                                        this.addException(2, "Dem Objekttext mu\u00df die Angabe eines Objektes vorhergehen");
                                        break;
                                    }
                                    try {
                                        this.gObj.addDecor((ObjectDecor)ObjectText.parseDatLine((String)var7_18));
                                    }
                                    catch (Exception var8_36) {
                                        this.addException(2, var8_36.getMessage());
                                    }
                                    break;
                                }
                                case 612: {
                                    if (this.gObj == null) {
                                        this.addException(2, "Dem Objektsymbol mu\u00df die Angabe eines Objektes vorhergehen");
                                        break;
                                    }
                                    try {
                                        this.gObj.addDecor((ObjectDecor)ObjectSymbol.parseDatLine((String)var7_18));
                                    }
                                    catch (Exception var8_37) {
                                        this.addException(2, var8_37.getMessage());
                                    }
                                    break;
                                }
                                case 619: {
                                    if (this.gObj == null) {
                                        this.addException(2, "Den Objektattributen mu\u00df die Angabe eines Objektes vorhergehen");
                                        break;
                                    }
                                    var8_38 = "";
                                    try {
                                        var9_51 = new StringTokenizer((String)var7_18);
                                        while (var9_51.hasMoreTokens()) {
                                            var8_38 = var9_51.nextToken();
                                            var11_64 = this.gObj.setAttribute(var8_38.substring(0, var10_58 = var8_38.indexOf(61)), var8_38.substring(var10_58 + 1).replace('_', ' '));
                                            if (var11_64 == null) continue;
                                            this.addException(2, "Attribute " + var8_38.substring(0, var10_58) + " mehrfach gesetzt");
                                        }
                                        break block24;
                                    }
                                    catch (Exception var9_52) {
                                        this.addException(2, "Fehler beim Auswerten des Attributes: " + var8_38);
                                        break;
                                    }
                                }
                                case 531: {
                                    Gemeinde.parseDatLine((String)var7_18);
                                    break;
                                }
                                case 532: {
                                    Gemarkung.parseDatLine((String)var7_18);
                                    break;
                                }
                                case 533: {
                                    Strasse.parseDatLine((String)var7_18);
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                                default: {
                                    this.addException(2, "ung\u00fcltiger Variablenname");
                                    break;
                                }
                            }
                            break;
                        }
                        case 3: {
                            if (this.block != -9) {
                                this.addException(3, "fehlendes Blockende");
                            }
                            this.block = var5_15.getBlock();
                            DatLine.setFormat(new DatLineFormat(var5_15.getFormatString(), DatLine.getFormatDef(this.block)));
                            break;
                        }
                        case 4: {
                            if (this.block == -9) {
                                this.addException(3, "Blockende au\u00dferhalb eines Blockes");
                            }
                            if (this.block == 4 && this.trafoSystem != null) {
                                DataBase.T.addElement(this.trafoSystem);
                            }
                            this.block = -9;
                            break;
                        }
                        case 5: {
                            if (this.liste != -1) {
                                this.addException(5, "fehlendes Listenende");
                            }
                            this.liste = var5_15.getListe();
                            break;
                        }
                        case 6: {
                            if (this.liste == -1) {
                                this.addException(5, "Listenende au\u00dferhalb einer Liste");
                            }
                            this.liste = -1;
                            this.lastLinie = null;
                            break;
                        }
                        case 1: {
                            this.elementKennung = var5_15.getKennZiffer();
                            block101 : switch (this.block) {
                                case 1: 
                                case 7: {
                                    var8_39 = var5_15.getPunktNummer();
                                    if (var8_39 == 0L) {
                                        this.addException(5002, var8_39);
                                        var4_10 = true;
                                        break;
                                    }
                                    var2_3 = (Punkt)this.P.get(var8_39);
                                    if (var2_3 == null) {
                                        var2_3 = new Punkt(var8_39);
                                        this.P.put((LongHashObject)var2_3);
                                        var2_3.setOn(false);
                                        this.DAT_P.put((LongHashObject)var2_3);
                                    } else {
                                        if (this.DAT_P.get(var8_39) != null) {
                                            this.addException(5002, "Der Punkt " + var8_39 + " ist doppelt vorhanden, erste Eingabe bleibt.");
                                            break;
                                        }
                                        this.DAT_P.put((LongHashObject)var2_3);
                                    }
                                    v1 = var2_3 = this.block == 7 ? var5_15.getPunktWerteBlock7((Punkt)var2_3) : var5_15.getPunktWerte((Punkt)var2_3);
                                    if (var2_3.getPs() == 5) {
                                        try {
                                            if (KafkaIOProperties.isErrPHS()) {
                                                var10_59 = var5_15.getErrorKennZiffer();
                                                if (var10_59 == 1 || var10_59 == 2) {
                                                    var2_3.setErrHoldKoo(true);
                                                    var11_65 = var5_15.getCoordinates();
                                                    var2_3 = var5_15.getPunktDifferenz((Punkt)var2_3);
                                                    var2_3.y = var11_65.y;
                                                    var2_3.x = var11_65.x;
                                                } else {
                                                    var2_3 = var5_15.getPunktDifferenz((Punkt)var2_3);
                                                }
                                            } else {
                                                var2_3 = var5_15.getPunktDifferenz((Punkt)var2_3);
                                            }
                                        }
                                        catch (IFileInputException var10_60) {
                                            this.addException(5004, var8_39);
                                        }
                                    }
                                    var2_3.initParameter(this.block == 7 ? var5_15.getPunktParameterBlock7() : var5_15.getPunktParameter(this.currentPunktModel));
                                    var2_3.setRiss(this.kvzRiss);
                                    var2_3.setInternalPs(this.kvzStatus);
                                    if (var2_3.getBemerkung() != null) {
                                        this.parseBemerkung(var2_3);
                                    }
                                    if (var2_3.getPs() != 3) {
                                        var10_61 = var5_15.getCoordinates();
                                        if (var2_3.getPs() == 1 || var2_3.getPs() == 2) {
                                            if (var2_3.y != var10_61.y || var2_3.x != var10_61.x) {
                                                this.addException(5002, "Der Punkt " + var8_39 + " hat ver\u00e4nderte Koordinaten, inkonsistente LT3!, D=" + var2_3.getDistance(var10_61));
                                                var2_3.y = var10_61.y;
                                                var2_3.x = var10_61.x;
                                            }
                                        } else if (var2_3.getPs() == 0 && (var11_66 = var2_3.getDistance(var10_61.y + (double)var2_3.dy, var10_61.x + (double)var2_3.dx)) > 5.0E-4) {
                                            this.addException(5002, "Der Punkt " + var8_39 + " hat ver\u00e4nderte Koordinaten, inkonsistente LT3!, D=" + var11_66);
                                            var2_3.dy = (float)(var2_3.y - var10_61.y);
                                            var2_3.dx = (float)(var2_3.x - var10_61.x);
                                        }
                                        if (!var2_3.isOn() || var2_3.getKafPa() <= 0 || var2_3.getPs() == 1 || var2_3.getPs() == 2 || var2_3.createNb() == Punkt.createNb(var10_61.y, var10_61.x)) break block24;
                                        var2_3.setSwitchNBZ(true);
                                        break;
                                    }
                                    break block382;
                                }
                                case 2: {
                                    if (this.elementKennung == 5) {
                                        this.elementKennung = var5_15.getErrorKennZiffer(true);
                                    }
                                    if (this.elementKennung == -1) {
                                        this.elementKennung = var5_15.getErrorKennZiffer();
                                    }
                                    var8_40 = var5_15.toMessung();
                                    this.lastMGW = var5_15.toMessungGewicht(this.lastMGW);
                                    var8_40.setGewichte(this.lastMGW);
                                    var9_53 = var5_15.getP1();
                                    var11_67 = var5_15.getP2();
                                    if (var9_53 != 0L && (var8_40.ps = (Punkt)this.P.get(var9_53)) == null) {
                                        this.addException(5002, var9_53);
                                        var4_10 = true;
                                    }
                                    if (var11_67 != 0L && (var8_40.pz = (Punkt)this.P.get(var11_67)) == null) {
                                        this.addException(5003, var11_67);
                                        var4_10 = true;
                                    }
                                    if (var8_40.ps != null) {
                                        var8_40.ps.setUsed(true);
                                    }
                                    if (var8_40.pz != null) {
                                        var8_40.pz.setUsed(true);
                                    }
                                    switch (this.elementKennung) {
                                        case 5: {
                                            var4_10 = true;
                                            break;
                                        }
                                        case 7: {
                                            if (var9_53 == 0L) {
                                                if (this.lastGpsMessung == null) {
                                                    this.addException(5002, var9_53);
                                                    var4_10 = true;
                                                }
                                            } else {
                                                this.lastGpsMessung = var8_40;
                                                if (var8_40.ps != null) {
                                                    var8_40.ps.setReferenzPunkt(true);
                                                }
                                            }
                                            if (var11_67 != 0L) break;
                                            this.addException(5003, var11_67);
                                            var4_10 = true;
                                            break;
                                        }
                                        case 3: 
                                        case 8: {
                                            if (var9_53 == 0L) {
                                                if (this.lastPolarMessung == null) {
                                                    this.addException(5002, var9_53);
                                                    var4_10 = true;
                                                }
                                            } else {
                                                this.lastPolarMessung = var8_40;
                                                if (var8_40.ps != null) {
                                                    var8_40.ps.setStandPunkt(true);
                                                }
                                            }
                                            if (var11_67 != 0L) break;
                                            this.addException(5003, var11_67);
                                            var4_10 = true;
                                            break;
                                        }
                                        case 2: 
                                        case 4: 
                                        case 6: {
                                            if (var11_67 != 0L) ** GOTO lbl677
                                            this.addException(5003, var5_15.getZielPunktNummer());
                                            var4_10 = true;
                                            ** GOTO lbl682
lbl677:
                                            // 1 sources

                                            if (var9_53 != var11_67) ** GOTO lbl680
                                            this.addException(5003, "Strecke mit gleichem Anfangs- und Endpunkt");
                                            ** GOTO lbl682
lbl680:
                                            // 1 sources

                                            if (var8_40.l1 == 0.0) {
                                                this.addException(5004, "Strecke ist 0.0");
                                            }
                                        }
lbl682:
                                        // 6 sources

                                        case 0: 
                                        case 1: 
                                        case 9: {
                                            if (var9_53 == 0L) {
                                                this.addException(5002, var5_15.getStandPunktNummer());
                                                var4_10 = true;
                                            }
                                            this.standPunkt = null;
                                        }
                                    }
                                    if (!var4_10) {
                                        if (this.orthoError) {
                                            if (this.elementKennung == 0) {
                                                var8_40.setMessungsArt(210);
                                            } else if (this.elementKennung == 9) {
                                                this.lastOrthoPunkt.setMessungsArt(-500);
                                            }
                                            this.orthoError = false;
                                        }
                                        if (!(this.orthoStart || var8_40.isFehler() || this.elementKennung != 0 && this.elementKennung != 4)) {
                                            if (this.lastOrthoRiss != null && this.lastOrthoEndIndex > 0) {
                                                this.lastOrthoRiss.insertElementAt(var8_40, this.lastOrthoEndIndex);
                                                ++this.lastOrthoEndIndex;
                                            } else {
                                                this.addException(5001, "Linienpunkt au\u00dferhalb einer Ortholinie");
                                            }
                                        } else {
                                            this.saveMessung(var8_40);
                                        }
                                    } else if (this.elementKennung == 1) {
                                        this.orthoError = true;
                                    } else if (this.elementKennung == 9) {
                                        this.lastOrthoPunkt.setMessungsArt(290);
                                    }
                                    switch (this.elementKennung) {
                                        case 1: {
                                            if (this.orthoStart) {
                                                this.addException(5001, "letzte Ortholinie wurde nicht beendet");
                                                if (this.lastOrthoPunkt.getMessungsArt() == 210) {
                                                    this.lastOrthoPunkt.setMessungsArt(-500);
                                                } else {
                                                    this.lastOrthoPunkt.setMessungsArt(290);
                                                }
                                            }
                                            this.orthoStart = true;
                                            this.orthoPunktCount = 0;
                                        }
                                        case 0: 
                                        case 4: {
                                            if (!var8_40.isFehler() && this.orthoPunktCount > 0 && var8_40.getWerteBelegung() > 0 && this.lastOrthoPunkt != null && var8_40.l1 == this.lastOrthoPunkt.l1 && !this.lastOrthoPunkt.isFehler()) {
                                                if (var8_40.pz == null) {
                                                    if (var8_40.ps != this.lastOrthoPunkt.pz) {
                                                        this.addException(5003, "Orthopunkt mit gleicher Abzisse, Fu\u00dfpunkt setzen");
                                                    }
                                                } else if (var8_40.pz != this.lastOrthoPunkt.ps && var8_40.pz != this.lastOrthoPunkt.pz) {
                                                    this.addException(5003, "Orthopunkt mit gleicher Abzisse, ungleicher Fu\u00dfpunkt");
                                                }
                                            }
                                            this.lastOrthoPunkt = var8_40;
                                            if (this.elementKennung == 5 || this.elementKennung == -1) break;
                                            ++this.orthoPunktCount;
                                            break;
                                        }
                                        case 9: {
                                            if (!this.orthoStart) {
                                                this.addException(5001, "Linienendpunkt au\u00dferhalb einer Ortholinie");
                                            }
                                            if (this.elementKennung != 5 && this.elementKennung != -1) {
                                                ++this.orthoPunktCount;
                                            }
                                            if (this.orthoPunktCount == 2 && var8_40.l1 == 0.0) {
                                                this.addException(5004, "Orthogonale Linie mit zwei Punkten hat kein Endma\u00df");
                                            }
                                            if (this.orthoPunktCount > 0 && var8_40.getWerteBelegung() > 0 && this.lastOrthoPunkt != null && var8_40.l1 == this.lastOrthoPunkt.l1) {
                                                if (var8_40.pz == null) {
                                                    if (var8_40.ps != this.lastOrthoPunkt.pz) {
                                                        this.addException(5003, "Orthopunkt mit gleicher Abzisse, Fu\u00dfpunkt setzen");
                                                    }
                                                } else if (var8_40.pz != this.lastOrthoPunkt.ps && var8_40.pz != this.lastOrthoPunkt.pz) {
                                                    this.addException(5003, "Orthopunkt mit gleicher Abzisse, ungleicher Fu\u00dfpunkt");
                                                }
                                            }
                                            this.orthoStart = false;
                                            this.lastOrthoPunkt = var8_40;
                                            this.lastOrthoRiss = this.lastRiss;
                                            this.lastOrthoEndIndex = this.lastRiss.size() - 1;
                                            break;
                                        }
                                        case 6: {
                                            v2 = this.bogenStart = this.bogenStart == false;
                                        }
                                    }
                                    if (var8_40.getBemerkung() != null) {
                                        this.parseBemerkung(var8_40);
                                        break;
                                    }
                                    break block382;
                                }
                                case 3: {
                                    if (this.elementKennung == -1) {
                                        this.elementKennung = var5_15.getErrorKennZiffer();
                                    }
                                    if (this.elementKennung == 9) break;
                                    var8_41 = var5_15.toHoehe();
                                    var9_54 = var5_15.getP1();
                                    var11_68 = var5_15.getP2();
                                    var13_76 = null;
                                    var14_80 = null;
                                    if (var9_54 != 0L && (var13_76 = (Punkt)this.P.get(var9_54)) == null) {
                                        this.addException(5002, var9_54);
                                        var4_10 = true;
                                    } else {
                                        var8_41.setPs(var13_76);
                                        if (var13_76 != null) {
                                            var13_76.setStandHoehe(true);
                                            var13_76.setUsed(true);
                                        }
                                    }
                                    if (var11_68 != 0L && (var14_80 = (Punkt)this.P.get(var11_68)) == null) {
                                        this.addException(5003, var11_68);
                                        var4_10 = true;
                                    } else {
                                        var8_41.setPz((Punkt)var14_80);
                                        if (var14_80 != null) {
                                            var14_80.setUsed(true);
                                        }
                                    }
                                    if (!var4_10) {
                                        this.saveHoehe(var8_41);
                                        break;
                                    }
                                    break block382;
                                }
                                case 4: {
                                    if (this.elementKennung == -1) {
                                        this.elementKennung = var5_15.getErrorKennZiffer();
                                    }
                                    if (this.elementKennung == 9) {
                                        if (this.trafoSystem != null) {
                                            DataBase.T.addElement(this.trafoSystem);
                                        }
                                        this.trafoSystem = var5_15.toTrafoSystem(0);
                                        this.trafoSystem.setStatus(this.trafoSystemStatus);
                                        this.trafoSystem.setName(this.trafoSystemName);
                                        this.lastTGW = var5_15.toTrafoGewicht(this.lastTGW);
                                        break;
                                    }
                                    var8_42 = var5_15.getP1();
                                    var10_62 = null;
                                    if (var8_42 != 0L && (var10_62 = (Punkt)this.P.get(var8_42)) == null) {
                                        this.addException(5002, var8_42);
                                    }
                                    switch (this.elementKennung) {
                                        case 2: {
                                            if (this.trafoSystem != null || this.trafoError) break;
                                            this.addException(5001, "fehlende Systemangabe");
                                            break;
                                        }
                                        default: {
                                            if (this.trafoSystem != null) {
                                                DataBase.T.addElement(this.trafoSystem);
                                            }
                                            this.trafoSystem = new TrafoSystem(0);
                                            this.trafoSystem.setStatus(this.trafoSystemStatus);
                                            this.trafoSystem.setName(this.trafoSystemName);
                                            if (this.elementKennung == 1) {
                                                this.trafoSystem.setParameter(4);
                                            } else {
                                                this.trafoSystem.setParameter(this.elementKennung);
                                            }
                                            if (this.elementKennung != 5 || var5_15.getErrorKennZiffer() == -1) break;
                                            this.addException(5001, "Trafopunkt kann nicht als Fehler (5) markiert werden");
                                        }
                                    }
                                    if (var10_62 == null) break block24;
                                    var10_62.setUsed(true);
                                    var11_69 = var5_15.toTrafoPunkt();
                                    var11_69.setPunkt(var10_62);
                                    this.lastTGW = var5_15.toTrafoGewicht(this.lastTGW);
                                    var11_69.setGewichte(this.lastTGW);
                                    this.trafoSystem.addElement(var11_69);
                                    if (var11_69.getBemerkung() == null) break block24;
                                    this.parseBemerkung(var11_69);
                                    break;
                                }
                                case 6: {
                                    if (this.elementKennung == -1) {
                                        this.elementKennung = var5_15.getErrorKennZiffer();
                                    }
                                    var8_43 = var5_15.toBedingung();
                                    var9_55 = var5_15.getP1();
                                    var11_70 = var5_15.getP2();
                                    var13_77 = var5_15.getP3();
                                    if (var9_55 != 0L && (var8_43.p1 = (Punkt)this.P.get(var9_55)) == null) {
                                        this.addException(5006, var9_55);
                                        var4_10 = true;
                                    }
                                    if (var11_70 != 0L && (var8_43.p2 = (Punkt)this.P.get(var11_70)) == null) {
                                        this.addException(5007, var11_70);
                                        var4_10 = true;
                                    }
                                    if (var13_77 != 0L && (var8_43.p3 = (Punkt)this.P.get(var13_77)) == null) {
                                        this.addException(5008, var13_77);
                                        var4_10 = true;
                                    }
                                    if (var8_43.p1 != null) {
                                        var8_43.p1.setUsed(true);
                                    }
                                    if (var8_43.p2 != null) {
                                        var8_43.p2.setUsed(true);
                                    }
                                    if (var8_43.p3 != null) {
                                        var8_43.p3.setUsed(true);
                                    }
                                    if (var4_10) break;
                                    switch (this.elementKennung) {
                                        case 1: 
                                        case 2: 
                                        case 4: 
                                        case 6: {
                                            if (var13_77 == 0L) {
                                                this.addException(5008, var13_77);
                                                var4_10 = true;
                                            }
                                        }
                                        case 0: 
                                        case 3: 
                                        case 5: {
                                            if (var11_70 == 0L) {
                                                this.addException(5007, var11_70);
                                                var4_10 = true;
                                            }
                                        }
                                        case 9: {
                                            if (var9_55 != 0L) break;
                                            this.addException(5006, var9_55);
                                            var4_10 = true;
                                            break;
                                        }
                                        default: {
                                            this.addException(5001, "ung\u00fcltige Bedingungsart");
                                            var4_10 = true;
                                        }
                                    }
                                    if (var4_10) break;
                                    if (var8_43.getBemerkung() != null) {
                                        this.parseBemerkung(var8_43);
                                    }
                                    switch (this.elementKennung) {
                                        case 1: 
                                        case 2: {
                                            if (var8_43.l == 0.0) break;
                                            this.addException(5009, "Ma\u00dfangabe ung\u00fcltig");
                                            break;
                                        }
                                        case 4: 
                                        case 5: {
                                            if (var8_43.l != 0.0) break;
                                            this.addException(5009, "Ma\u00dfangabe fehlt");
                                        }
                                    }
                                    switch (this.elementKennung) {
                                        case 0: {
                                            if (this.lastBedingung != null && this.lastBedingung.ba == 3) break;
                                            this.addException(5001, "Bezugsgerade fehlt");
                                            var4_10 = true;
                                            break;
                                        }
                                        case 9: {
                                            if (this.lastBedingung != null && this.lastBedingung.ba == 6) break;
                                            this.addException(5001, "Bezugsbogen fehlt");
                                            var4_10 = true;
                                            break;
                                        }
                                        default: {
                                            this.lastBedingung = var8_43;
                                        }
                                    }
                                    if (var4_10) break;
                                    this.saveBedingung(var8_43);
                                    break;
                                }
                                case 5: {
                                    if (KafkaIOProperties.datVersion == 0) break;
                                    switch (this.elementKennung) {
                                        case 2: {
                                            var3_9 = (Punkt)this.P.get(var5_15.getZielPunktNummer());
                                            if (var3_9 == null) {
                                                this.addException(5003, var5_15.getZielPunktNummer());
                                                var4_10 = true;
                                            } else {
                                                var3_9.setUsed(true);
                                            }
                                            var2_3 = (Punkt)this.P.get(var5_15.getStandPunktNummer());
                                            if (var2_3 == null) {
                                                this.addException(5002, var5_15.getStandPunktNummer());
                                                var4_10 = true;
                                            } else {
                                                var2_3.setUsed(true);
                                            }
                                            var8_44 = var5_15.toLinie();
                                            var8_44.pa = var2_3;
                                            var8_44.pe = var3_9;
                                            if (KafkaIOProperties.datVersion < 3 && !this.defLinie(var8_44, this.lastLinie)) {
                                                this.addException(5010, "Art und Ebene mu\u00df definiert sein");
                                            }
                                            if (var8_44.getBemerkung() != null) {
                                                this.parseBemerkung(var8_44);
                                            }
                                            if (!var4_10) {
                                                this.lastLinie = var8_44;
                                                this.saveLinie(var8_44);
                                                break block101;
                                            }
                                            break block382;
                                        }
                                        case 1: {
                                            if (this.polyStart) {
                                                this.addException(5001, "letztes Polygon wurde nicht beendet");
                                                if (!this.lastLinie.isEnde()) {
                                                    this.lastLinie.setEnde();
                                                } else {
                                                    this.lastLinie.setLinie();
                                                }
                                            }
                                            this.polyStart = true;
                                        }
                                        case 0: 
                                        case 9: {
                                            var2_3 = (Punkt)this.P.get(var5_15.getStandPunktNummer());
                                            if (var2_3 == null) {
                                                this.addException(5002, var5_15.getStandPunktNummer());
                                                var4_10 = true;
                                            } else {
                                                var2_3.setUsed(true);
                                            }
                                            var8_45 = var5_15.toLinie();
                                            var8_45.pa = var2_3;
                                            if (this.lastLinie != null && this.lastLinie.pe == null && this.elementKennung != 1) {
                                                this.lastLinie.pe = var8_45.pa;
                                            }
                                            if (KafkaIOProperties.datVersion < 3 && !this.defLinie(var8_45, this.lastLinie)) {
                                                this.addException(5010, "Art und Ebene mu\u00df definiert sein");
                                            }
                                            if (!this.polyStart) {
                                                this.addException(5001, "Polygonanfang fehlt");
                                                if (this.elementKennung == 0) {
                                                    var8_45.setStart();
                                                    this.polyStart = true;
                                                } else if (this.elementKennung == 9) {
                                                    var8_45.setLinie();
                                                }
                                            }
                                            if (var8_45.getBemerkung() != null) {
                                                this.parseBemerkung(var8_45);
                                                if (var8_45.hasTag("PI1") && this.lastLinie != null) {
                                                    this.lastLinie.addTag(Tag.toString("PI2", Tag.parseTag(var8_45.getBemerkung(), "PI1").getValue()));
                                                }
                                            }
                                            if (!var4_10) {
                                                if (this.linieError) {
                                                    if (this.elementKennung == 1 || this.elementKennung == 0) {
                                                        var8_45.setStart();
                                                        this.linieError = false;
                                                    } else if (this.elementKennung == 9) {
                                                        if (this.lastLinie != null) {
                                                            this.lastLinie.setLinie();
                                                        }
                                                        this.linieError = false;
                                                    }
                                                }
                                                this.lastLinie = var8_45;
                                                this.saveLinie(var8_45);
                                            } else if (this.elementKennung == 1) {
                                                this.linieError = true;
                                            } else if (this.elementKennung == 9 && this.lastLinie != null) {
                                                this.lastLinie.setEnde();
                                            }
                                            if (this.elementKennung == 9) {
                                                this.polyStart = false;
                                                break block101;
                                            }
                                            break block382;
                                        }
                                        case 5: {
                                            var8_46 = var5_15.getP1();
                                            var10_63 = var5_15.getP2();
                                            var12_72 = null;
                                            var13_78 = null;
                                            if (var8_46 != 0L && (var12_72 = (Punkt)this.P.get(var8_46)) == null) {
                                                this.addException(5006, var8_46);
                                                var4_10 = true;
                                            }
                                            if (var10_63 != 0L && (var13_78 = (Punkt)this.P.get(var10_63)) == null) {
                                                this.addException(5007, var10_63);
                                                var4_10 = true;
                                            }
                                            if (var8_46 == 0L && (var10_63 != 0L || this.lastBemerkung == null)) {
                                                this.addException(5006, var8_46);
                                                var4_10 = true;
                                            }
                                            if (var12_72 != null) {
                                                var12_72.setUsed(true);
                                            }
                                            if (var13_78 != null) {
                                                var13_78.setUsed(true);
                                            }
                                            if (var4_10) break block101;
                                            var14_80 = var5_15.toBemerkung();
                                            var14_80.p1 = var12_72;
                                            var14_80.p2 = var13_78;
                                            if (var8_46 == 0L) {
                                                this.lastBemerkung.addText(var14_80.getText());
                                                break block101;
                                            }
                                            if (DataBase.BEM.contains(var14_80)) {
                                                this.addException(5006, "Bemerkung " + var14_80.getLocationAsString() + " schon vorhanden");
                                                break block101;
                                            }
                                            DataBase.BEM.addElement((TextBox)var14_80);
                                            this.lastBemerkung = var14_80;
                                            break block101;
                                        }
                                        case 6: {
                                            var8_47 = var5_15.toNummerierungsBezirk();
                                            try {
                                                DataBase.NB.addElement(var8_47);
                                            }
                                            catch (NummerierungsBezirkException var9_56) {
                                                this.addException("Fehler beim lesen des NummerierungsBezirks: " + var8_47.getNb() + "\n" + var9_56.getMessage());
                                            }
                                            break block101;
                                        }
                                        case 7: {
                                            var8_48 = new PunktIdentitaet();
                                            var8_48.ist = (Punkt)this.P.get(var5_15.getStandPunktNummer());
                                            if (var8_48.ist == null) {
                                                this.addException(5002, var5_15.getStandPunktNummer());
                                                var4_10 = true;
                                            }
                                            if ((var8_48.soll = (Punkt)this.P.get(var5_15.getZielPunktNummer())) == null) {
                                                this.addException(5003, var5_15.getZielPunktNummer());
                                                var4_10 = true;
                                            }
                                            if (!var4_10) {
                                                var8_48 = var5_15.getPunktIdentitaetParameter(var8_48);
                                                this.P_IDENT.put(new Long(var8_48.soll.nr), var8_48);
                                                break block101;
                                            }
                                            break block382;
                                        }
                                        case 8: {
                                            var8_20 = 0;
                                            var9_57 = var5_15.getStandPunktNummer();
                                            var2_3 = (Punkt)this.P.get(var9_57);
                                            if (var2_3 == null) {
                                                this.addException(5002, var5_15.getStandPunktNummer());
                                                break block101;
                                            }
                                            if (this.UMNUM.containsKey(new Long(var2_3.nr))) {
                                                this.addException(5002, "Punkt " + var2_3.nr + " ist doppelt in der Liste enthalten");
                                                break block101;
                                            }
                                            var2_3.setUsed(true);
                                            var11_71 = var2_3.hasBemerkung() != false ? var2_3.getBemerkung().length() : 0;
                                            try {
                                                var5_15.setPunktZusatz((Punkt)var2_3, this.currentPunktModel);
                                            }
                                            catch (Exception var12_73) {
                                                this.addException(5010, var12_73.getMessage());
                                            }
                                            var2_3.setFortfuehrung(true);
                                            if (var2_3.getParameter() instanceof PunktParameterALKIS) {
                                                var12_72 = (PunktParameterALKIS)var2_3.getParameter();
                                                if (var2_3.getInternalPs() == 2) {
                                                    var12_72.setPst(14);
                                                    if (var12_72.getModEb() == 1) {
                                                        var12_72.setEb(48);
                                                    } else if (var12_72.getModEb() == 2) {
                                                        var12_72.setEb(42);
                                                    } else if (var12_72.getModEb() == 19) {
                                                        var12_72.setEb(59);
                                                    }
                                                    if (var12_72.getKafPa() == 0) {
                                                        if (var12_72.getLg() == 0) {
                                                            var12_72.setLg(2100);
                                                        }
                                                        if (var12_72.getEa() == 0) {
                                                            var12_72.setEa(1);
                                                        }
                                                        if (var12_72.getEa() == 0) {
                                                            var12_72.setEq(1000);
                                                        }
                                                        if (var12_72.getLs() == 0) {
                                                            var12_72.setLs(1000);
                                                        }
                                                    }
                                                    var2_3.updateParameter((PunktParameter)var12_72);
                                                } else if (var12_72.getPst() != 13) {
                                                    if (var12_72.getPst() == 15) {
                                                        var2_3.setFortfuehrung(false);
                                                    } else if (!var2_3.getOldParameter().equalsModel((PunktParameter)var12_72)) {
                                                        var12_72.setPst(12);
                                                        var2_3.updateParameter((PunktParameter)var12_72);
                                                    } else if (var2_3.getOldParameter().equalsModel((PunktParameter)var12_72)) {
                                                        var12_72.setPst(var2_3.isMoved() != false ? 12 : 11);
                                                        var2_3.updateParameter((PunktParameter)var12_72);
                                                    } else if (var12_72.getPst() == -1 && var12_72.getKafPa() != -1) {
                                                        var12_72.setPst(10);
                                                        var2_3.updateParameter((PunktParameter)var12_72);
                                                    }
                                                }
                                            }
                                            if (KafkaIOProperties.isPPTest()) {
                                                if (KafkaIOProperties.isPPPaTest()) {
                                                    var12_74 = var2_3.getOldParameter().getModPa();
                                                    var13_79 = var2_3.getParameter().getModPa();
                                                    if (PunktArt.isKatasterElement(var12_74) && PunktArt.isKatasterElement(var13_79) && var12_74 != var13_79) {
                                                        this.addException(new Exception("Punkt " + var2_3.nr + " hat falsche Parameter: PA \u00c4nderung unzul\u00e4ssig"));
                                                    }
                                                }
                                                try {
                                                    var2_3.getParameter().checkConsistency();
                                                }
                                                catch (Exception var12_75) {
                                                    this.addException(new Exception("Punkt " + var2_3.nr + " hat falsche Parameter: " + var12_75.getMessage()));
                                                }
                                            }
                                            if (var2_3.hasBemerkung() && var2_3.getBemerkung().length() > var11_71) {
                                                this.parseBemerkung(var2_3);
                                            }
                                            if (var2_3.getUmnum() > 0L) {
                                                if (this.UMNUM.contains(new Long(var2_3.getUmnum()))) {
                                                    this.addException(5003, "Punktnummer " + var2_3.getUmnum() + " wurde in der Liste schon vergeben");
                                                }
                                                if ((var3_9 = (Punkt)this.P.get(var2_3.getUmnum())) != null) {
                                                    this.addException(5003, "Punkt " + var3_9.nr + " schon vorhanden");
                                                }
                                                if (KafkaIOProperties.isPPNrTest() && var2_3.getInternalPs() == 0) {
                                                    this.addException(5003, "amtlicher Punkt " + var2_3.nr + " wird umnummeriert!");
                                                }
                                            }
                                            if (!var4_10) {
                                                this.UMNUM.put(new Long(var2_3.nr), new Long(var2_3.getUmnum()));
                                            }
                                            DataBase.UMNUM.addElement(var2_3);
                                            break block101;
                                        }
                                    }
                                }
                            }
                            break;
                        }
                    }
                }
                this.readedBytes += (long)(var1_1.length() + 1);
                super.setFileProgress(this.readedBytes);
            }
            catch (IFileInputException var2_5) {
                this.addException(5001, "Zeile kann nicht interpretiert werden, " + var2_5.getMessage());
            }
            catch (NumberFormatException var2_6) {
                this.addException(5001, "Zeile kann nicht interpretiert werden, " + var2_6.getMessage());
            }
            catch (Exception var2_7) {
                var2_7.printStackTrace();
            }
        }
        if (KafkaIOProperties.datVersion == 0 && KafkaIOProperties.isAutoPa()) {
            var2_3 = DataBase.P.elements();
            while (var2_3.hasMoreElements()) {
                var3_9 = (Punkt)var2_3.nextElement();
                if (var3_9.nr <= 99999L) continue;
                var4_12 = new PunktParameterALK();
                var4_12.setPa((int)(var3_9.nr % 1000000L / 100000L));
                var3_9.initParameter(var4_12);
            }
        }
        super.setProgress(100);
        try {
            this.reader.close();
        }
        catch (IOException var2_8) {
            this.addException("Datei konnte nicht ordnungsgem\u00e4\u00df geschlossen werden");
        }
    }

    @Override
    public int getKooSystem() {
        return KoordinatenSystem.getSystemFromKafka(DataBase.steuerDaten.getIGK());
    }

    private void addException(String string) {
        super.addException(new IFileInputException("Datei: " + this.inFile.getName() + "\n     " + string));
    }

    private void addException(int n, long l) {
        this.addException(n, "     Punkt: " + l + " nicht gefunden");
    }

    private void addException(int n, String string) {
        super.addException(new IFileInputException("Datei: " + this.inFile.getName() + "  Zeile: " + GeoNumberFormat.nr.format(this.reader.getLineNumber()) + "  Element: " + DatLine.getElementString(n, this.block, this.elementKennung) + "\n     " + string));
    }

    private void saveLinie(Linie linie) {
        if (this.gObj == null) {
            this.addException(5001, "Linie au\u00dferhalb eines Objektes");
        } else {
            try {
                this.gObj.addElement(linie);
            }
            catch (Exception exception) {
                this.addException(5001, "Linie au\u00dferhalb eines g\u00fcltigen Objektes");
            }
            this.regularLinieFolie(linie, this.gObj.getFolie());
        }
    }

    private void regularLinieFolie(Linie linie, int n) {
        if (n > 0 && linie.getFolie() <= 0) {
            LinieParameter linieParameter = linie.getParameter();
            linieParameter.setFolie(n);
            linie.setParameter(linieParameter);
        }
    }

    private void saveMessung(Messung messung) {
        switch (this.liste) {
            case -1: {
                switch (messung.getMessungsArt()) {
                    case 200: 
                    case 210: 
                    case 220: 
                    case 240: 
                    case 260: 
                    case 290: {
                        if (this.messbandRiss == null) {
                            this.lastRiss = this.messbandRiss = new Riss(1, 203);
                            this.saveContainer(this.messbandRiss, DataBase.MM);
                        }
                        this.messbandRiss.addElement(messung);
                        break;
                    }
                    case 230: 
                    case 280: {
                        if (this.polarRiss == null) {
                            this.lastRiss = this.polarRiss = new Riss(1, 201);
                            this.saveContainer(this.polarRiss, DataBase.MP);
                        }
                        this.polarRiss.addElement(messung);
                        break;
                    }
                    case 270: {
                        if (this.gpsRiss == null) {
                            this.lastRiss = this.gpsRiss = new Riss(1, 202);
                            this.saveContainer(this.gpsRiss, DataBase.MG);
                        }
                        this.gpsRiss.addElement(messung);
                    }
                }
                break;
            }
            case 201: {
                if (this.polarRiss == null) {
                    this.lastRiss = this.polarRiss = new Riss(1, 201);
                    this.saveContainer(this.polarRiss, DataBase.MP);
                }
                if (messung.ps != null) {
                    messung.ps.setPolarPunkt(true);
                }
                if (messung.pz != null) {
                    messung.pz.setPolarPunkt(true);
                }
                this.polarRiss.addElement(messung);
                break;
            }
            case 202: {
                if (this.gpsRiss == null) {
                    this.lastRiss = this.gpsRiss = new Riss(1, 202);
                    this.saveContainer(this.gpsRiss, DataBase.MG);
                }
                if (messung.ps != null) {
                    messung.ps.setGpsPunkt(true);
                }
                if (messung.pz != null) {
                    messung.pz.setGpsPunkt(true);
                }
                this.gpsRiss.addElement(messung);
                break;
            }
            case 203: {
                if (this.messbandRiss == null) {
                    this.lastRiss = this.messbandRiss = new Riss(1, 203);
                    this.saveContainer(this.messbandRiss, DataBase.MM);
                }
                if (messung.ps != null) {
                    messung.ps.setEigenePunkt(true);
                }
                if (messung.pz != null) {
                    messung.pz.setEigenePunkt(true);
                }
                this.messbandRiss.addElement(messung);
                break;
            }
            case 204: {
                if (this.katasterRiss == null) {
                    this.lastRiss = this.katasterRiss = new Riss(2, 204);
                    this.saveContainer(this.katasterRiss, DataBase.MK);
                }
                if (messung.ps != null) {
                    messung.ps.setNachweisPunkt(true);
                }
                if (messung.pz != null) {
                    messung.pz.setNachweisPunkt(true);
                }
                this.katasterRiss.addElement(messung);
                break;
            }
            case 206: {
                if (this.einrechenRiss == null) {
                    this.lastRiss = this.einrechenRiss = new Riss(1, 206);
                    this.saveContainer(this.einrechenRiss, DataBase.ME);
                }
                this.einrechenRiss.addElement(messung);
                break;
            }
            case 205: {
                if (this.vorgabeRiss == null) {
                    this.lastRiss = this.vorgabeRiss = new Riss(1, 205);
                    this.saveContainer(this.vorgabeRiss, DataBase.MV);
                }
                this.vorgabeRiss.addElement(messung);
                break;
            }
            default: {
                this.addException(5001, "Messung au\u00dferhalb einer g\u00fcltigen Liste");
            }
        }
    }

    private void saveBedingung(Bedingung bedingung) {
        switch (this.liste) {
            case 601: {
                if (this.homogenisierungRiss == null) {
                    this.lastRiss = this.homogenisierungRiss = new Riss(6, 601);
                    this.saveContainer(this.homogenisierungRiss, DataBase.BH);
                }
                this.homogenisierungRiss.addElement(bedingung);
                break;
            }
            case -1: 
            case 602: {
                if (this.bedingungRiss == null) {
                    this.lastRiss = this.bedingungRiss = new Riss(6, 602);
                    this.saveContainer(this.bedingungRiss, DataBase.BB);
                }
                this.bedingungRiss.addElement(bedingung);
                break;
            }
            default: {
                this.addException(5001, "Bedingung au\u00dferhalb einer g\u00fcltigen Liste");
            }
        }
    }

    private void saveHoehe(Hoehe hoehe) {
        switch (this.liste) {
            case -1: {
                switch (hoehe.getArt()) {
                    case 1: {
                        if (this.nivellementRiss == null) {
                            this.lastRiss = this.nivellementRiss = new Riss(3, 301);
                            this.saveContainer(this.nivellementRiss, DataBase.HN);
                        }
                        this.nivellementRiss.addElement(hoehe);
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (this.polarhoehenRiss == null) {
                            this.lastRiss = this.polarhoehenRiss = new Riss(3, 302);
                            this.saveContainer(this.polarhoehenRiss, DataBase.HP);
                        }
                        this.polarhoehenRiss.addElement(hoehe);
                    }
                }
                break;
            }
            case 301: {
                if (this.nivellementRiss == null) {
                    this.lastRiss = this.nivellementRiss = new Riss(3, 301);
                    this.saveContainer(this.nivellementRiss, DataBase.HN);
                }
                this.nivellementRiss.addElement(hoehe);
                break;
            }
            case 302: {
                if (this.polarhoehenRiss == null) {
                    this.lastRiss = this.polarhoehenRiss = new Riss(3, 302);
                    this.saveContainer(this.polarhoehenRiss, DataBase.HP);
                }
                this.polarhoehenRiss.addElement(hoehe);
                break;
            }
            default: {
                this.addException(5001, "H\u00f6he au\u00dferhalb einer g\u00fcltigen Liste");
            }
        }
    }

    private void saveContainer(DataContainer dataContainer, DataContainerTable dataContainerTable) {
        try {
            dataContainerTable.put(dataContainer);
        }
        catch (Exception exception) {
            this.addException(2, exception.getMessage());
        }
    }

    private boolean defLinie(Linie linie, Linie linie2) {
        boolean bl = true;
        if (linie2 != null) {
            LinieParameter linieParameter = linie.getParameter();
            if (linie.getLa() == -2) {
                if (linie2.getLa() != -2) {
                    linieParameter.setLa(linie2.getLa());
                } else {
                    bl = false;
                }
            }
            if (linie.getEb() == -1) {
                if (linie2.getEb() != -1) {
                    linieParameter.setEb(linie2.getEb());
                } else {
                    bl = false;
                }
            }
            if (linie.getOska() == 0 && linie2.getOska() != 0) {
                linieParameter.setOska(linie2.getOska());
            }
            linie.setParameter(linieParameter);
        }
        return bl;
    }

    private void parseBemerkung(Object object) {
        block85: {
            TagObject tagObject;
            if (!(object instanceof TagObject) || !Tag.hasTag((tagObject = (TagObject)object).getBemerkung())) break block85;
            Enumeration enumeration = new Body(tagObject.getBemerkung()).tags();
            while (enumeration.hasMoreElements()) {
                Identitaet identitaet;
                Identitaet identitaet2;
                block87: {
                    Object object2;
                    Tag tag;
                    block93: {
                        block94: {
                            block92: {
                                block91: {
                                    block90: {
                                        block89: {
                                            block88: {
                                                block86: {
                                                    tag = (Tag)enumeration.nextElement();
                                                    identitaet2 = null;
                                                    identitaet = null;
                                                    if (!tag.equals("PM")) break block86;
                                                    if (tagObject instanceof Punkt) {
                                                        object2 = PunktMove.parseTag(tag.getValue());
                                                        ((PunktMove)object2).setPunkt((Punkt)tagObject);
                                                        DataBase.PM.put((LongHashObject)object2);
                                                    } else {
                                                        this.addException(5001, "Bemerkungstext enth\u00e4lt ung\u00fcltige Tags");
                                                    }
                                                    break block87;
                                                }
                                                if (!tag.equals("PI1")) break block88;
                                                try {
                                                    object2 = (Punkt)DataBase.P.get(Long.parseLong(tag.getValue()));
                                                    if (object2 == null) {
                                                        this.addException(5001, "Identit\u00e4t Punkt " + Long.parseLong(tag.getValue()) + " nicht gefunden");
                                                        continue;
                                                    }
                                                    identitaet2 = new Identitaet((Punkt)object2, null, 0);
                                                    if (tagObject instanceof Messung) {
                                                        identitaet2.setP2(((Messung)tagObject).ps);
                                                    } else if (tagObject instanceof Hoehe) {
                                                        identitaet2.setP2(((Hoehe)tagObject).getPs());
                                                    } else if (tagObject instanceof TrafoPunkt) {
                                                        identitaet2.setP2(((TrafoPunkt)tagObject).getPunkt());
                                                    } else if (tagObject instanceof Bedingung) {
                                                        identitaet2.setP2(((Bedingung)tagObject).p1);
                                                    } else if (tagObject instanceof Linie) {
                                                        identitaet2.setP2(((Linie)tagObject).pa);
                                                    } else {
                                                        this.addException(5001, "Bemerkungstext enth\u00e4lt ung\u00fcltige Tags");
                                                    }
                                                    identitaet = (Identitaet)DataBase.PI.put(identitaet2);
                                                }
                                                catch (Exception exception) {
                                                    this.addException(5001, "Bemerkungstext enth\u00e4lt ung\u00fcltigen Taginhalt");
                                                }
                                                break block87;
                                            }
                                            if (!tag.equals("PI2")) break block89;
                                            try {
                                                identitaet2 = new Identitaet((Punkt)DataBase.P.get(Long.parseLong(tag.getValue())), null, 0);
                                                if (tagObject instanceof Messung) {
                                                    identitaet2.setP2(((Messung)tagObject).pz);
                                                } else if (tagObject instanceof Hoehe) {
                                                    identitaet2.setP2(((Hoehe)tagObject).getPz());
                                                } else if (tagObject instanceof Bedingung) {
                                                    identitaet2.setP2(((Bedingung)tagObject).p2);
                                                } else if (tagObject instanceof Linie) {
                                                    identitaet2.setP2(((Linie)tagObject).pe);
                                                } else {
                                                    this.addException(5001, "Bemerkungstext enth\u00e4lt ung\u00fcltige Tags");
                                                }
                                                identitaet = (Identitaet)DataBase.PI.put(identitaet2);
                                            }
                                            catch (Exception exception) {
                                                this.addException(5001, "Bemerkungstext enth\u00e4lt ung\u00fcltigen Taginhalt");
                                            }
                                            break block87;
                                        }
                                        if (!tag.equals("PI3")) break block90;
                                        try {
                                            identitaet2 = new Identitaet((Punkt)DataBase.P.get(Long.parseLong(tag.getValue())), null, 0);
                                            if (tagObject instanceof Bedingung) {
                                                identitaet2.setP2(((Bedingung)tagObject).p3);
                                            } else {
                                                this.addException(5001, "Bemerkungstext enth\u00e4lt ung\u00fcltige Tags");
                                            }
                                            identitaet = (Identitaet)DataBase.PI.put(identitaet2);
                                        }
                                        catch (Exception exception) {
                                            this.addException(5001, "Bemerkungstext enth\u00e4lt ung\u00fcltigen Taginhalt");
                                        }
                                        break block87;
                                    }
                                    if (!tag.equals("NO")) break block91;
                                    if (tagObject instanceof Messung) {
                                        object2 = (Messung)tagObject;
                                        switch (((Messung)object2).getMessungsArt(true)) {
                                            case 210: {
                                                this.addException(5010, "Bemerkungstext enth\u00e4lt ung\u00fcltige Tags, der Nachweis eines Linienanfangspunktes kann nicht vollst\u00e4ndig abgeschalten werden");
                                                break;
                                            }
                                            case 290: {
                                                this.addException(5010, "Bemerkungstext enth\u00e4lt ung\u00fcltige Tags, der Nachweis eines Linienendpunkt kann nicht vollst\u00e4ndig abgeschalten werden");
                                            }
                                        }
                                    } else {
                                        this.addException(5010, "Bemerkungstext enth\u00e4lt ung\u00fcltige Tags");
                                    }
                                    break block87;
                                }
                                if (!tag.equals("NO1")) break block92;
                                if (tagObject instanceof Messung) {
                                    object2 = (Messung)tagObject;
                                    switch (((Messung)object2).getMessungsArt(true)) {
                                        case 210: {
                                            this.addException(5010, "Bemerkungstext enth\u00e4lt ung\u00fcltige Tags, der Nachweis eines Linienanfangspunktes kann nicht vollst\u00e4ndig abgeschalten werden");
                                            break;
                                        }
                                        case 290: {
                                            this.addException(5010, "Bemerkungstext enth\u00e4lt ung\u00fcltige Tags, der Nachweis eines Linienendpunkt kann nicht vollst\u00e4ndig abgeschalten werden");
                                            break;
                                        }
                                        case 200: 
                                        case 240: {
                                            break;
                                        }
                                        default: {
                                            this.addException(5010, "Bemerkungstext enth\u00e4lt ung\u00fcltige Tags, der Nachweis dieser Messung kann nur vollst\u00e4ndig abgeschalten werden");
                                            break;
                                        }
                                    }
                                } else {
                                    this.addException(5010, "Bemerkungstext enth\u00e4lt ung\u00fcltige Tags");
                                }
                                break block87;
                            }
                            if (!tag.equals("NO2")) break block93;
                            if (!(tagObject instanceof Messung)) break block94;
                            object2 = (Messung)tagObject;
                            switch (((Messung)object2).getMessungsArt(true)) {
                                case 200: 
                                case 210: 
                                case 290: {
                                    if (((Messung)object2).pz == null) {
                                        this.addException(5010, "Bemerkungstext enth\u00e4lt ung\u00fcltige Tags, kein Fu\u00dfpunkt in der Messung vorhanden");
                                        break;
                                    }
                                    break block87;
                                }
                                case 240: {
                                    break;
                                }
                                default: {
                                    this.addException(5010, "Bemerkungstext enth\u00e4lt ung\u00fcltige Tags, der Nachweis dieser Messung kann nur vollst\u00e4ndig abgeschalten werden");
                                    break;
                                }
                            }
                            break block87;
                        }
                        this.addException(5010, "Bemerkungstext enth\u00e4lt ung\u00fcltige Tags");
                        break block87;
                    }
                    if (tag.equals("edbs.ent")) {
                        if (tagObject instanceof Punkt) {
                            try {
                                EdbsIOProperties.testTag(tag, tagObject);
                            }
                            catch (IException iException) {
                                this.addException(5010, "Tag " + tag.getName() + " hat ung\u00fcltigen Inhalt: " + iException.getMessage());
                            }
                        } else {
                            this.addException(5010, "Bemerkungstext enth\u00e4lt ung\u00fcltige Tags");
                        }
                    } else if (tag.equals("ENT")) {
                        if (!(tagObject instanceof Punkt)) {
                            this.addException(5010, "Bemerkungstext enth\u00e4lt ung\u00fcltige Tags");
                        }
                    } else if (tag.equals("REF")) {
                        if (tagObject instanceof Punkt) {
                            object2 = tag.getValue();
                            if (!IFormat.isNumber((String)object2)) {
                                this.addException(5010, "REF enth\u00e4lt nicht numerische Punktnummer: " + (String)object2);
                            } else {
                                ((Punkt)tagObject).setSlavePoint(true);
                            }
                        } else {
                            this.addException(5010, "Bemerkungstext enth\u00e4lt ung\u00fcltige Tags");
                        }
                    } else if (tag.equals("IND")) {
                        if (tagObject instanceof Punkt) {
                            object2 = tag.getValue();
                            if (!IFormat.isNumber((String)object2)) {
                                this.addException(5010, "IND enth\u00e4lt nicht numerische Punktnummer: " + (String)object2);
                            } else {
                                ((Punkt)tagObject).setZeigtAufPoint(true);
                            }
                        } else {
                            this.addException(5010, "Bemerkungstext enth\u00e4lt ung\u00fcltige Tags");
                        }
                    } else if (tag.equals("PKN")) {
                        if (!(tagObject instanceof Punkt)) {
                            this.addException(5010, "Bemerkungstext enth\u00e4lt ung\u00fcltige Tags");
                        }
                    } else if (tag.equals("NBZ")) {
                        if (tagObject instanceof Punkt) {
                            object2 = tag.getValue();
                            if (!IFormat.isNumber((String)object2) || ((String)object2).length() != 8) {
                                this.addException(5010, "NBZ enth\u00e4lt ung\u00fcltigen Nummerierungsbezirk: " + (String)object2);
                            }
                        } else {
                            this.addException(5010, "Bemerkungstext enth\u00e4lt ung\u00fcltige Tags");
                        }
                    } else if (tag.equals("rissliste.bem")) {
                        if (!(tagObject instanceof Punkt)) {
                            this.addException(5010, "Bemerkungstext enth\u00e4lt ung\u00fcltige Tags");
                        }
                    } else if (tag.equals("npi.bem")) {
                        if (!(tagObject instanceof Punkt)) {
                            this.addException(5010, "Bemerkungstext enth\u00e4lt ung\u00fcltige Tags");
                        }
                    } else {
                        this.addException(5010, "Bemerkungstext enth\u00e4lt ung\u00fcltiges Tag: " + String.valueOf(tag));
                    }
                }
                if (identitaet2 == null || identitaet != null || !KafkaIOProperties.isPPPiTest()) continue;
                try {
                    this.testPunktIdent(identitaet2);
                }
                catch (Exception exception) {
                    this.addException(5001, exception.getMessage());
                }
            }
        }
    }

    private void testPunktIdent(Identitaet identitaet) throws Exception {
        Punkt punkt = identitaet.getP1();
        Punkt punkt2 = identitaet.getP2();
        if (punkt == null) {
            throw new Exception("Punktidentit\u00e4t: Punkt ist nicht vorhanden");
        }
    }
}

