/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.geom.DPoint;
import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DatContainer;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.DataContainerTable;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.Identitaet;
import de.geocalc.kafplot.KafDatProperties;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktMove;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.io.IFileWriter;
import de.geocalc.kafplot.io.IOProperties;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.text.IFormat;
import de.geocalc.util.LongHashObject;
import de.geocalc.util.SortableVector;
import de.geocalc.util.sml.Tag;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DatWriter
extends IFileWriter {
    private boolean isCorrectSaved = false;
    private static final String ENDE_DATEN = "              -99";
    private static String fileVersionDelim = "-";
    protected PunktTable P;
    protected DataBase db;
    private Hashtable risse = new Hashtable();

    public DatWriter(File file, DataBase dataBase) {
        super(file);
        this.db = dataBase;
    }

    public static void setFileVersionDelim(String string) {
        fileVersionDelim = string;
    }

    public static String getFileVersionDelim() {
        return fileVersionDelim;
    }

    @Override
    public void write() throws IFileOutputException {
        String string = "2.0";
        this.isCorrectSaved = false;
        PrintWriter printWriter = null;
        KafkaIOProperties.init();
        KafkaIOProperties.datVersion = 3;
        KafkaIOProperties.writeFullParameter = false;
        this.P = this.createPunktTable();
        if (KafkaIOProperties.writeMenge) {
            KafkaIOProperties.setMenge(DataBase.MENGE);
        }
        IOProperties.setHoeheModus(KafkaIOProperties.writeHoehe);
        try {
            Object object;
            Cloneable cloneable;
            printWriter = this.createWriter();
            super.setProgress(10);
            printWriter.println("PROJEKT");
            printWriter.println(DataBase.steuerDaten != null ? DataBase.steuerDaten.toDatLine() : KafDatProperties.getDefaultSteuerDaten().toDatLine());
            printWriter.println("C         Richtg  Strecke                                         Ziel");
            printWriter.println("C         Messbd                  Prisma  Flucht          Masstab     ");
            printWriter.println("C");
            printWriter.println("C Kafka-Eingabedatei");
            printWriter.println("C!KafDatVersion: " + string);
            printWriter.println("C!Verm-Stelle  : " + (DataBase.vermStelle != null ? DataBase.vermStelle : KafDatProperties.getVermStelle()));
            printWriter.println("C!Adresse1     : " + (DataBase.adresse_1 != null ? DataBase.adresse_1 : KafDatProperties.getAdresse1()));
            printWriter.println("C!Adresse2     : " + (DataBase.adresse_2 != null ? DataBase.adresse_2 : KafDatProperties.getAdresse2()));
            printWriter.println("C!Adresse3     : " + (DataBase.adresse_3 != null ? DataBase.adresse_3 : KafDatProperties.getAdresse3()));
            printWriter.println("C!Bearbeiter   : " + (DataBase.bearbeiter != null ? DataBase.bearbeiter : ""));
            printWriter.println("C!Gemeinde     : " + (DataBase.gemeinde != null ? DataBase.gemeinde : ""));
            printWriter.println("C!Gemarkung    : " + (DataBase.gemarkung != null ? DataBase.gemarkung : ""));
            printWriter.println("C!Flur         : " + (DataBase.flur != null ? DataBase.flur : ""));
            printWriter.println("C!Flurstueck   : " + (DataBase.flurstueck != null ? DataBase.flurstueck : ""));
            printWriter.println("C!Katasteramt  : " + (DataBase.katasterAmt != null ? DataBase.katasterAmt : ""));
            printWriter.println("C!Antragsnummer: " + (DataBase.antrag != null ? DataBase.antrag : ""));
            printWriter.println("C!Modell       : " + (DataBase.model.getModel() == 2 ? "ALKIS" : "ALK"));
            Enumeration enumeration = this.db.nasFiles();
            while (enumeration.hasMoreElements()) {
                printWriter.println("C!NasImport    : " + enumeration.nextElement().toString());
            }
            printWriter.println("C!Daten        : " + (DataBase.daten != null ? DataBase.daten : ""));
            if (DataBase.kooSystemName != null) {
                printWriter.println("C!Daten        : " + DataBase.kooSystemName);
            }
            printWriter.println("C Punktdaten");
            printWriter.println("1 (I1,1X,1X,2I4,I1,F5.0,2F13.3,F6.3,F10.4,A)");
            int n = -99;
            Object object2 = null;
            this.createSortedPunktList();
            this.setProgress(20);
            int n2 = DataBase.model.getModel();
            Enumeration<Object> enumeration2 = this.risse.elements();
            while (enumeration2.hasMoreElements()) {
                cloneable = (Vector)enumeration2.nextElement();
                object = ((Vector)cloneable).elements();
                while (object.hasMoreElements()) {
                    int n3;
                    Object object3;
                    Punkt punkt = (Punkt)object.nextElement();
                    Identitaet identitaet = (Identitaet)DataBase.PI.get(punkt.nr);
                    if (identitaet != null && identitaet.getOperation() == 2) continue;
                    PunktMove punktMove = (PunktMove)DataBase.PM.get(punkt.nr);
                    Punkt punkt2 = null;
                    if (punktMove != null) {
                        punkt2 = (Punkt)punkt.clone();
                        if (punktMove.getOperation() == 1) {
                            object3 = punkt2.getOriginal();
                            if (punkt2.getBemerkung() != null && Tag.hasTag(punkt2.getBemerkung(), "PM")) {
                                object3 = new DPoint(((DPoint)object3).y, ((DPoint)object3).x);
                                PunktMove punktMove2 = PunktMove.parseTag(Tag.parseTag(punkt2.getBemerkung(), "PM").getValue());
                                ((DPoint)object3).y += (double)punktMove2.getMoveY();
                                ((DPoint)object3).x += (double)punktMove2.getMoveX();
                                punkt2.setPs(punktMove2.getPunktStatus());
                                punkt2.setBemerkung(Tag.removeTag(punkt2.getBemerkung(), "PM"));
                            }
                            punkt2.y += (double)punktMove.getMoveY();
                            punkt2.x += (double)punktMove.getMoveX();
                            punkt2.addTag(Tag.toString("PM", punkt2.getPs() + "," + IFormat.f_3.format(((DPoint)object3).y - punkt2.y) + "," + IFormat.f_3.format(((DPoint)object3).x - punkt2.x)));
                            punkt2.setPs(punktMove.getPunktStatus());
                        } else if (punktMove.getOperation() == 3) {
                            punkt2.setBemerkung(Tag.removeTag(punkt2.getBemerkung(), "PM"));
                            punkt2.y += (double)punktMove.getMoveY();
                            punkt2.x += (double)punktMove.getMoveX();
                            punkt2.dy = 0.0f;
                            punkt2.dx = 0.0f;
                            punkt2.setPs(punktMove.getPunktStatus());
                        } else if (punktMove.getOperation() == 2) {
                            punkt2.setBemerkung(Tag.removeTag(punkt2.getBemerkung(), "PM"));
                        }
                    } else {
                        punkt2 = punkt;
                    }
                    object3 = punkt2.getRiss();
                    if (object3 == null) {
                        object3 = "";
                    }
                    if (punkt2.getInternalPs() != n || object3 != object2) {
                        n = punkt2.getInternalPs();
                        switch (n) {
                            case 0: {
                                printWriter.println("C!Kvz: " + (punkt2.getRiss() != null ? punkt2.getRiss() : ""));
                                break;
                            }
                            case 1: {
                                printWriter.println("C!SAP: " + (punkt2.getRiss() != null ? punkt2.getRiss() : ""));
                                break;
                            }
                            case 2: {
                                printWriter.println("C!Neu: " + (punkt2.getRiss() != null ? punkt2.getRiss() : ""));
                            }
                        }
                        printWriter.println("C KS          PKN         Y           X     -KL--  --HOE--  PA--- GST-  GWT-- Z P Q--- ART- ABM- BZA- RHO KST-");
                        object2 = object3;
                    }
                    if (KafkaIOProperties.changeKat) {
                        punkt2 = (Punkt)punkt2.createKatasterElement();
                        punkt2.setOldParameter(punkt2.getParameter());
                    }
                    if ((n3 = punkt2.getParameter().getModel()) != 0 && n3 != n2) {
                        n2 = n3;
                        if (n2 == 1) {
                            printWriter.println("C!ALK:");
                        } else if (n2 == 2) {
                            printWriter.println("C!ALKIS:");
                        }
                    }
                    printWriter.println(punkt2.toDatLine());
                }
            }
            printWriter.println(ENDE_DATEN);
            this.setProgress(30);
            printWriter.println("C Messdaten");
            printWriter.println("2 (I1,1X,2(1X,2I4,I1,F5.0),2F11.4,4F6.3)");
            printWriter.println("C$Liste GPS-Basislinien");
            printWriter.println("C             PNS            PNZ      Y          X     GY    GX                                    BEMERKUNG");
            this.writeDatContainer(printWriter, DataBase.MG);
            printWriter.println("C$Ende GPS-Basislinien");
            printWriter.println("C$Liste Polare Messungen");
            printWriter.println("C             PNS            PNZ      R          S     GR    GS                                    BEMERKUNG");
            this.writeDatContainer(printWriter, DataBase.MP);
            printWriter.println("C$Ende Polare Messungen");
            this.setProgress(40);
            printWriter.println("C$Liste Messband-Messungen");
            printWriter.println("C              PN            PNF      A          O     GA    GO    GF    GR                        BEMERKUNG");
            this.writeDatContainer(printWriter, DataBase.MM);
            printWriter.println("C$Ende Messband-Messungen");
            printWriter.println("C$Liste KatasterNachweis");
            printWriter.println("C              PN            PNF      A          O     GA    GO    GF    GR                        BEMERKUNG");
            this.writeDatContainer(printWriter, DataBase.MK);
            printWriter.println("C$Ende KatasterNachweis");
            printWriter.println("C$Liste Vorgaben");
            printWriter.println("C              PN            PNF      A          O     GA    GO    GF    GR                        BEMERKUNG");
            this.writeDatContainer(printWriter, DataBase.MV);
            printWriter.println("C$Ende Vorgaben");
            printWriter.println("C$Liste Einrechnung");
            printWriter.println("C              PN                                                  GF                              BEMERKUNG");
            this.writeDatContainer(printWriter, DataBase.ME);
            printWriter.println("C$Ende Einrechnung");
            printWriter.println(ENDE_DATEN);
            this.setProgress(50);
            printWriter.println("C Hoehen");
            printWriter.println("3 (I1,1X,2(1X,2I4,I1,F5.0),2F11.4,3F8.3)");
            printWriter.println("C$Liste Nivellement");
            if (KafkaIOProperties.writeHoehe) {
                this.writeDatContainer(printWriter, DataBase.HN);
            }
            printWriter.println("C$Ende Nivellement");
            printWriter.println("C$Liste Polare H\u00f6hen");
            if (KafkaIOProperties.writeHoehe) {
                this.writeDatContainer(printWriter, DataBase.HP);
            }
            printWriter.println("C$Ende Polare H\u00f6hen");
            printWriter.println(ENDE_DATEN);
            printWriter.println("C Transformationen");
            printWriter.println("4 (I1,1X,1X,2I4,I1,F5.0,2F13.3,2F8.3)");
            printWriter.println("C S            PN         Y           X       GL      GN                                           BEMERKUNG");
            this.writeDatContainer(printWriter, DataBase.T);
            printWriter.println(ENDE_DATEN);
            this.setProgress(60);
            printWriter.println("C Bedingungen");
            printWriter.println("6 (I1,1X,3(1X,2I4,I1,F5.0),F6.3,F11.4)");
            printWriter.println("C$Liste Homogenisierung");
            this.writeDatContainer(printWriter, DataBase.BH);
            printWriter.println("C$Ende Homogenisierung");
            printWriter.println("C$Liste Bedingungen");
            this.writeDatContainer(printWriter, DataBase.BB);
            printWriter.println("C$Ende Bedingungen");
            printWriter.println(ENDE_DATEN);
            this.setProgress(70);
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            printWriter.println("C Zusaetzliche Angaben");
            printWriter.println("5 (I1,1X,2(1X,2I4,I1,F5.0))");
            printWriter.println("C$Liste Flurstuecke");
            this.writeFlurstuecke(printWriter);
            printWriter.println("C$Ende Flurstuecke");
            this.setProgress(80);
            printWriter.println("C$Liste Bestand");
            DataBase.BUCH.writeDatContainer(printWriter);
            printWriter.println("C$Ende Bestand");
            printWriter.println("C$Liste Nutzung");
            DataBase.NUTZ.writeDatContainer(printWriter);
            printWriter.println("C$Ende Nutzung");
            printWriter.println("C$Liste Boden");
            DataBase.BODEN.writeDatContainer(printWriter);
            printWriter.println("C$Ende Boden");
            printWriter.println("C$Liste Gebaeude");
            DataBase.GEB.writeDatContainer(printWriter);
            printWriter.println("C$Ende Gebaeude");
            this.setProgress(90);
            printWriter.println("C$Liste Topographie");
            DataBase.TOP.writeDatContainer(printWriter);
            printWriter.println("C$Ende Topographie");
            printWriter.println("C$Liste Katalog");
            if (DataBase.model.getModel() == 2) {
                Gemeinde.writeDatContainerTable(printWriter);
            }
            printWriter.println("C$Ende Katalog");
            printWriter.println("C$Liste Bemerkungen");
            printWriter.println("C             PNA            PNE BEM");
            DataBase.BEM.writeDatContainer(printWriter);
            printWriter.println("C$Ende Bemerkungen");
            printWriter.println("C$Liste NummerierungsBezirk");
            printWriter.println("C             PNA            PNE       NB A");
            DataBase.NB.writeDatContainer(printWriter);
            printWriter.println("C$Ende NummerierungsBezirk");
            printWriter.println("C$Liste Punktidentitaet");
            printWriter.println("C             PNI            PNS Ist-Bem ; Soll-Bem;");
            DataBase.P_IDENT.writeDatContainer(printWriter);
            printWriter.println("C$Ende Punktidentitaet");
            printWriter.println("C$Liste Umnummerierung");
            printWriter.println("C            PKNA           PKNN  PA-F- GST- GWT--- Z P Q--- ART- ABM- BZA- RHO ABMV KST-          BEMERKUNG");
            enumeration2 = DataBase.UMNUM.elements();
            while (enumeration2.hasMoreElements()) {
                cloneable = (Punkt)enumeration2.nextElement();
                if (KafkaIOProperties.writeMenge && !KafkaIOProperties.getMenge().contains((LongHashObject)((Object)cloneable))) continue;
                if (KafkaIOProperties.changeKat && ((Punkt)cloneable).hasBemerkung()) {
                    object = new Punkt();
                    ((Punkt)object).nr = ((Punkt)cloneable).getNr();
                    ((Punkt)object).setBemerkung(((Punkt)cloneable).getBemerkung());
                    printWriter.println(((Punkt)object).toUmnumLine());
                    continue;
                }
                printWriter.println(((Punkt)cloneable).toUmnumLine());
            }
            printWriter.println("C$Ende Umnummerierung");
            printWriter.println(ENDE_DATEN);
            printWriter.println("0");
            printWriter.println("ENDE DER AUFTRAGSDATEI");
            this.setProgress(100);
            this.isCorrectSaved = true;
        }
        catch (IOException iOException) {
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
        finally {
            try {
                printWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    public boolean isCorrectSaved() {
        return this.isCorrectSaved;
    }

    private void writeDatContainer(PrintWriter printWriter, DataContainerTable dataContainerTable) throws IOException {
        Enumeration enumeration = dataContainerTable.elements();
        while (enumeration.hasMoreElements()) {
            ((DatContainer)enumeration.nextElement()).writeDatContainer(printWriter);
        }
    }

    private void writeFlurstuecke(PrintWriter printWriter) throws IOException {
        Enumeration enumeration = DataBase.ALB.elements();
        Enumeration enumeration2 = DataBase.FLST.elements();
        Flurstueck flurstueck = this.getNextFlst(enumeration);
        Flurstueck flurstueck2 = this.getNextFlst(enumeration2);
        while (flurstueck != null || flurstueck2 != null) {
            if (flurstueck != null && (flurstueck2 == null || flurstueck.compareTo(flurstueck2) <= 0)) {
                KafkaIOProperties.flstAsAlb = true;
                DataBase.ALB.writeFlurstueck(printWriter, flurstueck);
                flurstueck = this.getNextFlst(enumeration);
                KafkaIOProperties.flstAsAlb = false;
                continue;
            }
            DataBase.FLST.writeFlurstueck(printWriter, flurstueck2);
            flurstueck2 = this.getNextFlst(enumeration2);
        }
    }

    private Flurstueck getNextFlst(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            if (flurstueck.isTeilstueck() || flurstueck.isNutzstueck()) continue;
            return flurstueck;
        }
        return null;
    }

    private void createSortedPunktList() {
        String string = "DieserRissSollteNichtVorkommen";
        int n = -1;
        SortableVector sortableVector = null;
        Enumeration enumeration = this.P.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = this.getKatPunkt((Punkt)enumeration.nextElement());
            if (punkt.getPs() < 0 && !KafkaIOProperties.writeNeupunkte) continue;
            String string2 = punkt.getRiss();
            int n2 = punkt.getInternalPs();
            if (string2 == null) {
                string2 = "";
            }
            if (string2 != string || n2 != n) {
                sortableVector = (SortableVector)this.risse.get(string2 + n2);
                if (sortableVector == null) {
                    sortableVector = new SortableVector(200);
                    this.risse.put(string2 + n2, sortableVector);
                }
                string = string2;
                n = n2;
            }
            sortableVector.addElement(punkt);
        }
        enumeration = this.risse.elements();
        while (enumeration.hasMoreElements()) {
            sortableVector = (SortableVector)enumeration.nextElement();
            sortableVector.sort();
        }
    }

    private void insert(Vector vector, Punkt punkt) {
        if (vector.size() > 0) {
            Punkt punkt2 = (Punkt)vector.lastElement();
            if (punkt.nr > punkt2.nr) {
                vector.addElement(punkt);
            } else {
                vector.addElement(punkt2);
                for (int i = vector.size() - 2; i >= 0; --i) {
                    punkt2 = (Punkt)vector.elementAt(i);
                    if (punkt.nr > punkt2.nr) {
                        vector.setElementAt(punkt, i + 1);
                        return;
                    }
                    vector.setElementAt(punkt2, i + 1);
                }
                vector.setElementAt(punkt, 0);
            }
        } else {
            vector.addElement(punkt);
        }
    }

    protected PunktTable createPunktTable() {
        Cloneable cloneable;
        Enumeration enumeration;
        PunktTable punktTable = new PunktTable();
        if (KafkaIOProperties.writeMenge) {
            enumeration = DataBase.MENGE.elements();
            while (enumeration.hasMoreElements()) {
                cloneable = (Punkt)enumeration.nextElement();
                if (!KafkaIOProperties.writeOffline && !((Punkt)cloneable).isUsed()) continue;
                punktTable.put((LongHashObject)((Object)cloneable));
            }
        } else {
            enumeration = DataBase.P.elements();
            while (enumeration.hasMoreElements()) {
                cloneable = (Punkt)enumeration.nextElement();
                if (!KafkaIOProperties.writeOffline && !((Punkt)cloneable).isUsed()) continue;
                punktTable.put((LongHashObject)((Object)cloneable));
            }
        }
        if (KafkaIOProperties.writeMenge || KafkaIOProperties.writeOffline) {
            enumeration = DataBase.objekte();
            while (enumeration.hasMoreElements()) {
                Flurstueck flurstueck;
                cloneable = (DataContainer)enumeration.nextElement();
                if (!KafkaIOProperties.writeOffline && !((DataContainer)cloneable).isOn()) continue;
                PunktTable punktTable2 = ((DataContainer)cloneable).getPunkte();
                if (cloneable instanceof Flurstueck && (flurstueck = (Flurstueck)cloneable).hasTeile()) {
                    Enumeration enumeration2 = DataBase.FLST.getTeileFrom(flurstueck).elements();
                    while (enumeration2.hasMoreElements()) {
                        Flurstueck flurstueck2 = (Flurstueck)enumeration2.nextElement();
                        punktTable2.insert(flurstueck2.getPunkte());
                    }
                }
                if (KafkaIOProperties.writeMenge && !DataBase.MENGE.intersect(punktTable2, KafkaIOProperties.writeFullMengeObjects ? PunktTable.INTERSECT_ALL : PunktTable.INTERSECT_ONE)) continue;
                punktTable.insert(punktTable2);
            }
        }
        return punktTable;
    }

    private Punkt getKatPunkt(Punkt punkt) {
        if (KafkaIOProperties.changeKat && punkt.getInternalPs() == 2 && punkt.isKatasterElement()) {
            punkt = (Punkt)punkt.clone();
            punkt.setPs(2);
            punkt.setInternalPs(0);
            punkt.setRiss(DataBase.antrag);
        }
        return punkt;
    }
}

