/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.geom.DPoint;
import de.geocalc.io.DxfConstants;
import de.geocalc.io.DxfFileWriter;
import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.Ebene;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.OrthoLinie;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.Symbol;
import de.geocalc.kafplot.io.IFileWriter;
import de.geocalc.text.GeoNumberFormat;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class DxfWriter
extends IFileWriter {
    public static final String TITLE = "DxfWriter";
    public static final String VERSION = "1.0";
    protected static final String LTYPE_CONTINOUS = "CONTINUOUS";
    protected static final String LTYPE_MESSUNGLINIE = "MESSUNGSLINIE";
    protected static final String LTYPE_POLYGONLINIE = "POLYGONLINIE";
    protected double masstab = 500.0;
    protected DataBase db;

    public DxfWriter(File file, DataBase dataBase) {
        super(file);
        this.db = dataBase;
        this.setParameter();
    }

    protected void setParameter() {
    }

    @Override
    public void write() throws IFileOutputException {
        DxfFileWriter dxfFileWriter = null;
        try {
            Enumeration<Object> enumeration;
            dxfFileWriter = new DxfFileWriter(this.createWriter());
            dxfFileWriter.writeVar(0, "SECTION");
            dxfFileWriter.writeVar(2, "HEADER");
            dxfFileWriter.writeVar(9, "$ATTMODE");
            dxfFileWriter.writeVar(70, 1);
            dxfFileWriter.writeVar(9, "$FILLMODE");
            dxfFileWriter.writeVar(70, 1);
            dxfFileWriter.writeVar(9, "$LTSCALE");
            dxfFileWriter.writeVar(40, 1.0);
            dxfFileWriter.writeVar(9, "$PDMODE");
            dxfFileWriter.writeVar(70, 0);
            dxfFileWriter.writeVar(9, "$PDSIZE");
            dxfFileWriter.writeVar(40, 0.0);
            dxfFileWriter.writeVar(9, "$PSLTSCALE");
            dxfFileWriter.writeVar(70, 0);
            dxfFileWriter.writeVar(9, "$QTEXTMODE");
            dxfFileWriter.writeVar(70, 0);
            dxfFileWriter.writeVar(9, "$SPLFRAME");
            dxfFileWriter.writeVar(70, 0);
            dxfFileWriter.writeVar(9, "$TILEMODE");
            dxfFileWriter.writeVar(70, 1);
            dxfFileWriter.writeVar(9, "$VISRETAIN");
            dxfFileWriter.writeVar(70, 0);
            dxfFileWriter.writeVar(0, "ENDSEC");
            dxfFileWriter.writeVar(0, "SECTION");
            dxfFileWriter.writeVar(2, "TABLES");
            dxfFileWriter.writeVar(0, "TABLE");
            dxfFileWriter.writeVar(2, "VPORT");
            dxfFileWriter.writeVar(70, 2);
            dxfFileWriter.writeVar(0, "ENDTAB");
            dxfFileWriter.writeVar(0, "TABLE");
            dxfFileWriter.writeVar(2, "LTYPE");
            dxfFileWriter.writeVar(70, 1);
            dxfFileWriter.writeVar(0, "LTYPE");
            dxfFileWriter.writeVar(2, LTYPE_CONTINOUS);
            dxfFileWriter.writeVar(70, 0);
            dxfFileWriter.writeVar(3, "Solid line");
            dxfFileWriter.writeVar(72, 65);
            dxfFileWriter.writeVar(73, 0);
            dxfFileWriter.writeVar(40, 0.0);
            dxfFileWriter.writeVar(0, "LTYPE");
            dxfFileWriter.writeVar(2, LTYPE_MESSUNGLINIE);
            dxfFileWriter.writeVar(70, 0);
            dxfFileWriter.writeVar(3, "_ _");
            dxfFileWriter.writeVar(72, 65);
            dxfFileWriter.writeVar(73, 2);
            dxfFileWriter.writeVar(40, 2.0);
            dxfFileWriter.writeVar(49, 1.0);
            dxfFileWriter.writeVar(49, -1.0);
            dxfFileWriter.writeVar(0, "ENDTAB");
            dxfFileWriter.writeVar(0, "TABLE");
            dxfFileWriter.writeVar(2, "LAYER");
            dxfFileWriter.writeVar(70, 1);
            Object object = Ebene.ebenen();
            while (object.hasMoreElements()) {
                enumeration = (Ebene)object.nextElement();
                this.writeLayer(dxfFileWriter, ((Ebene)((Object)enumeration)).getNummer());
            }
            dxfFileWriter.writeVar(0, "ENDTAB");
            dxfFileWriter.writeVar(0, "TABLE");
            dxfFileWriter.writeVar(2, "STYLE");
            dxfFileWriter.writeVar(70, 1);
            dxfFileWriter.writeVar(0, "STYLE");
            dxfFileWriter.writeVar(2, "STANDARD");
            dxfFileWriter.writeVar(70, 0);
            dxfFileWriter.writeVar(40, 0.0);
            dxfFileWriter.writeVar(41, 1.0);
            dxfFileWriter.writeVar(50, 0.0);
            dxfFileWriter.writeVar(71, 0);
            dxfFileWriter.writeVar(42, 2.5);
            dxfFileWriter.writeVar(3, "txt");
            dxfFileWriter.writeVar(4, "");
            dxfFileWriter.writeVar(0, "ENDTAB");
            dxfFileWriter.writeVar(0, "TABLE");
            dxfFileWriter.writeVar(2, "VIEW");
            dxfFileWriter.writeVar(70, 0);
            dxfFileWriter.writeVar(0, "ENDTAB");
            dxfFileWriter.writeVar(0, "TABLE");
            dxfFileWriter.writeVar(2, "UCS");
            dxfFileWriter.writeVar(70, 0);
            dxfFileWriter.writeVar(0, "ENDTAB");
            dxfFileWriter.writeVar(0, "TABLE");
            dxfFileWriter.writeVar(2, "APPID");
            dxfFileWriter.writeVar(70, 1);
            dxfFileWriter.writeVar(0, "APPID");
            dxfFileWriter.writeVar(2, "ACAD");
            dxfFileWriter.writeVar(70, 0);
            dxfFileWriter.writeVar(0, "ENDTAB");
            dxfFileWriter.writeVar(0, "TABLE");
            dxfFileWriter.writeVar(2, "DIMSTYLE");
            dxfFileWriter.writeVar(70, 1);
            dxfFileWriter.writeVar(0, "DIMSTYLE");
            dxfFileWriter.writeVar(2, "ISO-25");
            dxfFileWriter.writeVar(70, 0);
            dxfFileWriter.writeVar(3, "");
            dxfFileWriter.writeVar(4, "");
            dxfFileWriter.writeVar(5, "");
            dxfFileWriter.writeVar(6, "");
            dxfFileWriter.writeVar(7, "");
            dxfFileWriter.writeVar(40, 1.0);
            dxfFileWriter.writeVar(41, 2.5);
            dxfFileWriter.writeVar(42, 0.625);
            dxfFileWriter.writeVar(43, 3.75);
            dxfFileWriter.writeVar(44, 1.25);
            dxfFileWriter.writeVar(45, 0.0);
            dxfFileWriter.writeVar(46, 0.0);
            dxfFileWriter.writeVar(47, 0.0);
            dxfFileWriter.writeVar(48, 0.0);
            dxfFileWriter.writeVar(140, 2.5);
            dxfFileWriter.writeVar(141, 2.5);
            dxfFileWriter.writeVar(142, 0.0);
            dxfFileWriter.writeVar(143, 0.3937007874016);
            dxfFileWriter.writeVar(144, 1.0);
            dxfFileWriter.writeVar(145, 0.0);
            dxfFileWriter.writeVar(146, 1.0);
            dxfFileWriter.writeVar(147, 0.625);
            dxfFileWriter.writeVar(71, 0);
            dxfFileWriter.writeVar(72, 0);
            dxfFileWriter.writeVar(73, 0);
            dxfFileWriter.writeVar(74, 0);
            dxfFileWriter.writeVar(75, 0);
            dxfFileWriter.writeVar(76, 0);
            dxfFileWriter.writeVar(77, 1);
            dxfFileWriter.writeVar(78, 8);
            dxfFileWriter.writeVar(170, 0);
            dxfFileWriter.writeVar(171, 3);
            dxfFileWriter.writeVar(172, 1);
            dxfFileWriter.writeVar(173, 0);
            dxfFileWriter.writeVar(174, 0);
            dxfFileWriter.writeVar(175, 0);
            dxfFileWriter.writeVar(176, 0);
            dxfFileWriter.writeVar(177, 0);
            dxfFileWriter.writeVar(178, 0);
            dxfFileWriter.writeVar(0, "ENDTAB");
            dxfFileWriter.writeVar(0, "ENDSEC");
            dxfFileWriter.writeVar(0, "SECTION");
            dxfFileWriter.writeVar(2, "BLOCKS");
            object = Symbol.elements();
            while (object.hasMoreElements()) {
                enumeration = (Symbol)object.nextElement();
                ((Symbol)((Object)enumeration)).writeAsDxfBlock(dxfFileWriter, this.masstab);
            }
            dxfFileWriter.writeVar(0, "ENDSEC");
            dxfFileWriter.writeVar(0, "SECTION");
            dxfFileWriter.writeVar(2, "ENTITIES");
            object = DataBase.P.elements();
            while (object.hasMoreElements()) {
                enumeration = (Punkt)object.nextElement();
                ((Punkt)((Object)enumeration)).writeSymbol(dxfFileWriter);
            }
            object = this.db.getLinien();
            enumeration = ((Hashtable)object).elements();
            while (enumeration.hasMoreElements()) {
                Linie linie = (Linie)enumeration.nextElement();
                if (linie.isBogen()) continue;
                dxfFileWriter.writeLine(linie.pa, linie.pe, DxfConstants.getDxfString(Ebene.getEbeneName(linie.getEb())));
            }
            enumeration = DataBase.MP.elements();
            while (enumeration.hasMoreElements()) {
                this.writeMessungen(dxfFileWriter, (DataContainer)enumeration.nextElement());
            }
            enumeration = DataBase.MM.elements();
            while (enumeration.hasMoreElements()) {
                this.writeMessungen(dxfFileWriter, (DataContainer)enumeration.nextElement());
            }
            dxfFileWriter.writeVar(0, "ENDSEC");
            dxfFileWriter.writeVar(0, "EOF");
            dxfFileWriter.close();
        }
        catch (IOException iOException) {
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
    }

    private void writeMessungen(DxfFileWriter dxfFileWriter, DataContainer dataContainer) {
        String string = DxfConstants.getDxfString(Ebene.getEbeneName(50));
        OrthoLinie orthoLinie = null;
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        block7: for (int i = 0; i < dataContainer.size(); ++i) {
            Messung messung = (Messung)dataContainer.elementAt(i);
            d = messung.pz != null ? new Linie(messung.ps != null ? messung.ps : messung.getReferenz().ps, messung.pz).getRichtung() * -180.0 / Math.PI + 90.0 : 0.0;
            int n3 = messung.getMessungsArt(false);
            switch (n3) {
                case 230: {
                    messung.writeSymbol(dxfFileWriter, this.masstab);
                    continue block7;
                }
                case 220: 
                case 260: {
                    dxfFileWriter.writeLine((DPoint)messung.ps, (DPoint)messung.pz, string, LTYPE_MESSUNGLINIE);
                    dxfFileWriter.writeText(GeoNumberFormat.m02.format(messung.l1).toString(), new DPoint((messung.ps.y + messung.pz.y) / 2.0, (messung.ps.x + messung.pz.x) / 2.0), 1, 0.002 * this.masstab, d, string);
                    continue block7;
                }
                case 240: {
                    dxfFileWriter.writeLine((DPoint)messung.ps, (DPoint)messung.pz, string, LTYPE_MESSUNGLINIE);
                    continue block7;
                }
                case 210: {
                    orthoLinie = new OrthoLinie();
                    orthoLinie.addElement(messung.pz != null ? messung.pz : messung.ps);
                    n = i;
                    continue block7;
                }
                case 290: {
                    orthoLinie.addElement(messung.pz != null ? messung.pz : messung.ps);
                    d = (new Linie(orthoLinie.getAnfangsPunkt(), orthoLinie.getEndPunkt()).getRichtung() + 1.5707963267948966) * -180.0 / Math.PI + 90.0;
                    n2 = i;
                    for (int j = n; j <= n2; ++j) {
                        Messung messung2 = (Messung)dataContainer.elementAt(j);
                        int n4 = messung2.getMessungsArt(false);
                        if (messung2.getMessungsArt(false) != 240 && messung2.l2 != 0.0) {
                            messung2.writeSymbol(dxfFileWriter, this.masstab);
                            dxfFileWriter.writeLine((DPoint)messung2.ps, (DPoint)messung2.pz, string, LTYPE_MESSUNGLINIE);
                            dxfFileWriter.writeText(GeoNumberFormat.m02.format(Math.abs(messung2.l2)).toString(), new DPoint((messung2.ps.y + messung2.pz.y) / 2.0, (messung2.ps.x + messung2.pz.x) / 2.0), 1, 0.002 * this.masstab, d, string);
                        }
                        if (messung2.getWerteBelegung() <= 0) continue;
                        dxfFileWriter.writeText(GeoNumberFormat.m02.format(messung2.l1).toString(), messung2.pz != null ? messung2.pz : messung2.ps, messung2.l2 < 0.0 ? -10 : 10, 0.002 * this.masstab, d, string);
                    }
                    dxfFileWriter.writeLine((DPoint)orthoLinie.getAnfangsPunkt(), (DPoint)orthoLinie.getEndPunkt(), string, LTYPE_MESSUNGLINIE);
                }
            }
        }
    }

    private void writeLayer(DxfFileWriter dxfFileWriter, int n) {
        dxfFileWriter.writeVar(0, "LAYER");
        dxfFileWriter.writeVar(2, DxfConstants.getDxfString(Ebene.getEbeneName(n)));
        dxfFileWriter.writeVar(70, 0);
        dxfFileWriter.writeVar(62, DxfConstants.getDxfColor(Ebene.getColor(n)));
        dxfFileWriter.writeVar(6, LTYPE_CONTINOUS);
    }
}

