/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.Hoehestatus;
import de.geocalc.kafplot.Lagestatus;
import de.geocalc.kafplot.io.IDataReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class EdbsParser
extends IDataReader {
    private Hashtable HP = null;
    private Hashtable HH = null;
    private LineNumberReader reader = null;

    public EdbsParser(File file, Hashtable hashtable, Hashtable hashtable2, IProgressViewer iProgressViewer) {
        super(file, iProgressViewer);
        this.HP = hashtable;
        this.HH = hashtable2;
    }

    @Override
    public void userAbort() throws IFileInputException {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception exception) {
            throw new IFileInputException(this.getErrorKey() + "Fehler beim Schlie\u00dfen der Datei: " + this.inFile.getName());
        }
    }

    @Override
    public void read() throws IFileInputException {
        String string = new String();
        try {
            this.reader = this.createReader();
            long l = 0L;
            while ((string = this.reader.readLine()) != null) {
                try {
                    int n;
                    if (!string.startsWith("EDBS") || string.substring(12, 16).equals("AEND") || !string.substring(28, 36).equals("ULPUNN  ") && !string.substring(28, 36).equals("ULP8ALK ")) continue;
                    int n2 = Integer.parseInt(string.substring(113, 117));
                    int n3 = 117;
                    for (n = 0; n < n2; ++n) {
                        Lagestatus lagestatus = new Lagestatus(Integer.parseInt(string.substring(n3, n3 + 3).trim()));
                        this.HP.put(lagestatus, lagestatus);
                        n3 += 45;
                    }
                    n = Integer.parseInt(string.substring(n3, n3 += 4));
                    for (int i = 0; i < n; ++i) {
                        if (Integer.parseInt(string.substring(n3 + 3, n3 + 11).trim()) != 0) {
                            Hoehestatus hoehestatus = new Hoehestatus(Integer.parseInt(string.substring(n3, n3 + 3).trim()));
                            this.HH.put(hoehestatus, hoehestatus);
                        }
                        n3 += 34;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.addException(new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber() + ", ung\u00fcltige Zeichen vorgefunden.", "Zeile wurde ignoriert"));
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    this.addException(new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber() + ", vorzeitig Zeilenende erreicht.", "Zeile wurde ignoriert"));
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.addException(new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber() + ", vorzeitig Zeilenende erreicht.", "Zeile wurde ignoriert"));
                }
                super.setFileProgress(l += (long)(string.length() + 1));
            }
            this.reader.close();
            super.setProgress(100);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IFileInputException("Datei " + this.inFile.getName() + " nicht gefunden");
        }
        catch (IOException iOException) {
            throw new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber());
        }
    }
}

