/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.kafplot.Ebene;
import de.geocalc.kafplot.Hoehestatus;
import de.geocalc.kafplot.Lagestatus;
import de.geocalc.kafplot.Oska;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktParameterALK;
import de.geocalc.kafplot.io.IKatPunktReader;
import de.geocalc.kafplot.io.edbs.EdbsIOProperties;
import de.geocalc.util.LongHashList;
import java.io.File;
import java.util.Vector;

public class EdbsReader
extends IKatPunktReader {
    public EdbsReader(File file, LongHashList longHashList) {
        super(file, longHashList, null);
    }

    public EdbsReader(File file, LongHashList longHashList, IProgressViewer iProgressViewer) {
        super(file, longHashList, iProgressViewer);
    }

    public EdbsReader(File file, Vector vector) {
        super(file, vector, null);
    }

    public EdbsReader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, vector, iProgressViewer);
    }

    @Override
    protected Punkt lineToPunkt(String string) {
        int n;
        int n2;
        int n3;
        if (!string.startsWith("EDBS")) {
            return null;
        }
        if (string.substring(12, 16).equals("AEND")) {
            return null;
        }
        if (!string.substring(28, 36).equals("ULPUNN  ") && !string.substring(28, 36).equals("ULP8ALK ")) {
            return null;
        }
        Punkt punkt = new Punkt();
        PunktParameterALK punktParameterALK = new PunktParameterALK();
        punktParameterALK.setPa(Integer.parseInt(string.substring(52, 53).trim()));
        punkt.nr = Long.parseLong(string.substring(53, 58).trim());
        if (string.charAt(59) != ' ') {
            punktParameterALK.setPst(Integer.parseInt(string.substring(59, 60)));
            if (punktParameterALK.getModPst() != 0) {
                punkt.setOn(false);
            }
        }
        if (string.charAt(73) != ' ') {
            punktParameterALK.setVa(Integer.parseInt(string.substring(71, 74).trim()));
        }
        try {
            if (string.charAt(74) != ' ') {
                String string2 = string.substring(74, 78);
                if (string2.indexOf(46) > 0) {
                    punktParameterALK.setVvt((int)(new Double(string2) * 10.0));
                } else {
                    punktParameterALK.setOska(Integer.parseInt(string2.trim()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        punktParameterALK.setLs(-1);
        int n4 = Integer.parseInt(string.substring(113, 117).trim());
        int n5 = 117;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = Integer.parseInt(string.substring(n5, n5 + 3).trim());
            if (n2 >= punktParameterALK.getModLs() && (lstatusTable == null || lstatusTable.get(new Lagestatus(n2)) != null)) {
                punktParameterALK.setLs(n2);
                Double d = new Double(string.substring(n5 + 3, n5 + 10).trim());
                punkt.y = d;
                d = new Double("." + string.substring(n5 + 10, n5 + 13).trim());
                punkt.y += d.doubleValue();
                d = new Double(string.substring(n5 + 13, n5 + 20).trim());
                punkt.x = d;
                d = new Double("." + string.substring(n5 + 20, n5 + 23).trim());
                punkt.x += d.doubleValue();
                punkt.a = 0;
                punkt.b = 0;
                punkt.t = 0;
                punktParameterALK.setLg(0);
                n = string.charAt(n5 + 23);
                try {
                    switch (n) {
                        case 75: {
                            punkt.a = (short)Integer.parseInt(string.substring(n5 + 24, n5 + 28).trim());
                            punkt.b = (short)Integer.parseInt(string.substring(n5 + 28, n5 + 32).trim());
                            break;
                        }
                        case 80: {
                            int n6 = Integer.parseInt(string.substring(n5 + 24, n5 + 32).trim());
                            punkt.lsp = punkt.g = (float)((double)n6 / 1000.0);
                            punkt.b = punkt.a = (int)((short)Math.rint(Math.sqrt((double)(n6 * n6) / 2.0)));
                            punktParameterALK.setLg(n);
                            break;
                        }
                        case 90: {
                            int n7 = Integer.parseInt(string.substring(n5 + 24, n5 + 28).trim());
                            punkt.b = punkt.a = (int)((short)Math.rint(Math.sqrt((double)(n7 * n7) / 2.0)));
                            break;
                        }
                        default: {
                            punktParameterALK.setLg(n);
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (string.charAt(n5 + 32) != ' ') {
                        punktParameterALK.setLz(Integer.parseInt(string.substring(n5 + 32, n5 + 33)));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            n5 += 45;
        }
        if (punktParameterALK.getModLs() < 0) {
            return null;
        }
        punktParameterALK.setEb(Ebene.getDefaultEbene(punktParameterALK.getKafPa()));
        if (EdbsIOProperties.isInGenerateOska()) {
            punktParameterALK.setOska(Oska.createOska(punktParameterALK.getModPa(), punktParameterALK.getModVa()));
        }
        punktParameterALK.setHs(-1);
        n3 = Integer.parseInt(string.substring(n5, n5 += 4).trim());
        for (n2 = 0; n2 < n3; ++n2) {
            n = Integer.parseInt(string.substring(n5 + 3, n5 + 11).trim());
            if (n == 0) continue;
            int n8 = Integer.parseInt(string.substring(n5, n5 + 3).trim());
            if (n8 >= punktParameterALK.getModHs() && (hstatusTable == null || hstatusTable.get(new Hoehestatus(n8)) != null)) {
                punktParameterALK.setHs(n8);
                punkt.h = new Float(string.substring(n5 + 3, n5 + 7).trim() + "." + string.substring(n5 + 7, n5 + 11).trim()).floatValue();
                punktParameterALK.setHg(-1);
                char c = string.charAt(n5 + 16);
                try {
                    switch (c) {
                        case 'H': {
                            punkt.hsp = (float)Integer.parseInt(string.substring(n5 + 17, n5 + 21).trim()) / 1000.0f;
                            break;
                        }
                        default: {
                            punktParameterALK.setHg(Integer.parseInt(string.substring(n5 + 16, n5 + 17).trim()));
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            n5 += 34;
        }
        punkt.initParameter(punktParameterALK);
        punkt.nr = punkt.buildKatNr(this.getPnrModus());
        return punkt;
    }
}

