/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.io.IPunktWriter;
import de.geocalc.kafplot.io.edbs.EdbsIOProperties;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.util.LongHashList;
import java.io.File;
import java.util.GregorianCalendar;
import java.util.Vector;

public class EdbsWriter
extends IPunktWriter {
    private int lineNr = 0;
    private int amt = 0;
    private int jahr = 0;
    private String antrag;

    public EdbsWriter(File file, LongHashList longHashList) {
        super(file, longHashList);
        this.setParameter();
    }

    public EdbsWriter(File file, Vector vector) {
        super(file, vector);
        this.setParameter();
    }

    @Override
    protected void setParameter() {
        super.setSortModus(22);
    }

    @Override
    protected void initValues() {
        this.amt = super.getAmt();
        this.antrag = GeoNumberFormat.getLeftString(super.getAntrag(), 15);
        this.jahr = new GregorianCalendar().get(1) % 1000;
    }

    @Override
    protected String punktToLine(Punkt punkt) {
        return punkt.toEdbsLine(++this.lineNr, this.amt, this.antrag, this.jahr, EdbsIOProperties.isOutOska(), EdbsIOProperties.getOutLga());
    }

    @Override
    protected String getHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EDBS03120287AKND000000  0000ULQA00000001");
        stringBuffer.append(GeoNumberFormat.nr07n.format(this.amt).toString());
        stringBuffer.append("       ");
        stringBuffer.append("00001     016");
        stringBuffer.append("           ");
        stringBuffer.append("F");
        stringBuffer.append("               ");
        stringBuffer.append("               ");
        stringBuffer.append("          ");
        stringBuffer.append("8801");
        stringBuffer.append("               ");
        stringBuffer.append("               ");
        stringBuffer.append("               ");
        stringBuffer.append("               ");
        stringBuffer.append("               ");
        stringBuffer.append("          ");
        stringBuffer.append("          ");
        stringBuffer.append(GeoNumberFormat.nr07n.format(this.amt).toString());
        stringBuffer.append("          ");
        stringBuffer.append("          ");
        stringBuffer.append("GIAPGSB LK9802  DZENTRALLK9802    3STD172");
        stringBuffer.append("            ");
        stringBuffer.append("ASDLBE0005EQLVERMA BBG");
        return stringBuffer.toString();
    }

    @Override
    protected String getEndOfFile() {
        return "EDBS00240000AEND000000  0000";
    }
}

