/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IException;
import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Gemarkung;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.io.RtfWriter;
import de.geocalc.text.DecimalFormat;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.text.IFormat;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

public class EinrechnungListeWriter
extends RtfWriter {
    protected String gemarkung;
    protected static final DecimalFormat d13 = new DecimalFormat("0.000");
    protected static final DecimalFormat d33 = new DecimalFormat("000.000");
    protected static final DecimalFormat d02 = new DecimalFormat("#0.00");
    protected static final DecimalFormat d03 = new DecimalFormat("#0.000");
    protected static final DecimalFormat i0 = new DecimalFormat("#");
    private static final String EOL = "\n";
    private static final String RTF_HEADER = "{\\rtf1\\ansi\\ansicpg1252\\uc1 \\deff0\\deflang1033\\deflangfe1031\n{\\fonttbl{\\f0\\froman\\fcharset0\\fprq2{\\*\\panose 02020603050405020304}Times New Roman;}}\n\\paperw11907\\paperh16840\\margl1588\\margr567\\margt851\\margb1021\n\\deftab708\\widowctrl\\ftnbj\\aenddoc\\hyphhotz425\\hyphcaps0\\formshade\\viewkind1\\pgbrdrhead\\pgbrdrfoot \\fet0\\sectd \\psz9\\linex0\\headery709\\footery709\\colsx709\\endnhere\\sectdefaultcl";
    private static final String RISS_HEADER = "{\\header \\pard\\plain \\widctlpar\\adjustright\\fs20\\lang1031\\cgrid {\\b\\fs28 Einrechnung - Liste (}\n{\\field{\\*\\fldinst {\\cs17\\b\\fs28  PAGE }}{\\fldrslt {\\cs17\\b\\fs28\\lang1024 1}}}{\\cs17\\b\\fs28 /}{\\field{\\*\\fldinst {\\cs17\\b\\fs28  NUMPAGES }}{\\fldrslt {\\cs17\\b\\fs28\\lang1024 1}}}{\\b\\fs28 )\\par }";
    private static final String RISS_TABLE = "\\trowd \\trgaph70\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrr\n\\brdrs\\brdrw10 \\cltxlrtb \\cellx1276\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx4395\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx6096\\clvertalt\\clbrdrt\n\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx6946\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx9923\n{\\trwd}\n\\pard \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright {\\b\\fs16 PAT/\\line PNR\\cell endg\\'fcltige Koordinaten\\cell Qualit\\'e4t\\cell }\n\\pard\\plain \\s2\\qc\\sb60\\sa60\\keepn\\widctlpar\\intbl\\outlinelevel1\\adjustright \\b\\fs16\\lang1031\\cgrid {Abw.\\cell }\n\\pard\\plain \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {\\b\\fs16 Bemerkung\\cell}\n\\pard \\widctlpar\\intbl\\adjustright\n{\\row }\n\\trowd \\trgaph70\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10\n\\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx1276\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx2835\\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10\n\\cltxlrtb \\cellx4395\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx6096\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx6946\\clvertalt\\clbrdrl\\brdrs\\brdrw10\n\\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx9923\n{\\trwd}\n\\pard \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright {\\b\\fs16 \\cell }\n\\pard\\plain \\s2\\qc\\sb60\\sa60\\keepn\\widctlpar\\intbl\\outlinelevel1\\adjustright \\b\\fs16\\lang1031\\cgrid {y\\cell }\n\\pard\\plain \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {\\b\\fs16 x\\cell }\n\\pard\\plain \\s2\\qc\\sb60\\sa60\\keepn\\widctlpar\\intbl\\outlinelevel1\\adjustright \\b\\fs16\\lang1031\\cgrid {S}{\\sub L}{ }{\\b0 oder/und}{ d}{\\sub k}{/d}{\\sub s}{\\cell }\n\\pard\\plain \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {\\b\\fs16 d\\cell \\cell }\n{\\row }\n\\trowd \\trgaph70\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10\n\\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx1276\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10\n\\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx2835\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx4395\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10\n\\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx5245\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx6096\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10\n\\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx6946\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx9923\n{\\trwd}\n\\pard \\qc\\sb20\\sa20\\widctlpar\\intbl\\adjustright {\\fs12 1\\cell 2\\cell 3\\cell 4\\cell 5\\cell 6\\cell 7\\cell }\n\\pard \\widctlpar\\intbl\\adjustright\n{\\row }\n\\pard\\plain \\s15\\widctlpar\\tqc\\tx4536\\tqr\\tx9072\\adjustright \\fs20\\lang1031\\cgrid {\\par }}{\\*\\pnseclvl1\\pnucrm\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}{\\*\\pnseclvl2\\pnucltr\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}\n{\\*\\pnseclvl3\\pndec\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}{\\*\\pnseclvl4\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxta )}}\n{\\*\\pnseclvl5\\pndec\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}{\\*\\pnseclvl6\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}{\\*\\pnseclvl7\\pnlcrm\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}{\\*\\pnseclvl8\n\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}{\\*\\pnseclvl9\\pnlcrm\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}";
    private static final String CELL = "\\cell";
    private static final String END_OF_HEADER = "{\\par}}";
    private static final String END_OF_FILE = "}";
    private static final String SPACE = " ";

    public EinrechnungListeWriter(File file, DataBase dataBase) {
        super(file, dataBase);
    }

    @Override
    public void write() throws IFileOutputException {
        PrintWriter printWriter = null;
        try {
            this.checkDatVars();
            StringBuffer stringBuffer = new StringBuffer();
            if (DataBase.gemarkung != null) {
                stringBuffer.append(DataBase.gemarkung);
                Gemarkung gemarkung = Gemarkung.getGemarkung(DataBase.gemeinde, DataBase.gemarkung);
                if (gemarkung != null) {
                    stringBuffer.append(" (");
                    stringBuffer.append(GeoNumberFormat.nr06n.format(gemarkung.getNummer()).toString());
                    stringBuffer.append(")");
                } else {
                    this.addException(new IException("Keine Gemarkungsnummer f\u00fcr die Gemarkung: " + DataBase.gemarkung + " gefunden.", "\u00dcberpr\u00fcfen Sie die Einstellungen in der Konfigurationsdatei \"gemarkungen.properties\""));
                }
                this.gemarkung = stringBuffer.toString();
            }
            super.setLabelText("Sortiere...");
            super.showProgress();
            printWriter = this.createWriter();
            int n = 0;
            super.setEndValue(DataBase.P.size());
            super.setProgressBreak();
            super.setValue(0L);
            super.setLabelText("Koordinatenliste erstellen...");
            printWriter.println(RTF_HEADER);
            printWriter.println(RISS_HEADER);
            this.writeKopfTable(printWriter);
            printWriter.println(RISS_TABLE);
            printWriter.println(END_OF_HEADER);
            int n2 = 0;
            int n3 = 0;
            Messung messung = null;
            Enumeration enumeration = DataBase.ME.elements();
            while (enumeration.hasMoreElements()) {
                Riss riss = (Riss)enumeration.nextElement();
                this.writeRissLine(printWriter, riss.hasName() ? riss.getName() : null);
                for (int i = 0; i < riss.size(); ++i) {
                    Messung messung2 = (Messung)riss.elementAt(i);
                    int n4 = messung2.getMessungsArt();
                    if (n4 == 210) {
                        n2 = i;
                        n3 = 0;
                        messung = messung2;
                    } else if (n4 == 200) {
                        if (this.isKatPunkt(messung2.ps)) {
                            ++n3;
                        }
                    } else if (n4 == 290 && n3 > 0) {
                        this.writeRissLine(printWriter, "Linie von " + this.getPunktName(messung.ps) + " nach " + this.getPunktName(messung2.ps));
                        for (int j = n2 + 1; j < i; ++j) {
                            Messung messung3 = (Messung)riss.elementAt(j);
                            if (!this.isKatPunkt(messung3.ps)) continue;
                            this.writePunktLine(printWriter, messung3.ps, DataBase.isSchnittPunkt(messung3.ps) ? "Schnittpunkt" : null);
                        }
                    }
                    stringBuffer = new StringBuffer();
                    if ((long)i % super.getProgressBreak() != 0L) continue;
                    super.setProgress(n);
                }
            }
            this.writeRissLine(printWriter, null);
            printWriter.println(END_OF_FILE);
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
    }

    private String getPunktName(Punkt punkt) {
        StringBuffer stringBuffer = new StringBuffer();
        if (punkt.getKafPa() != -1) {
            stringBuffer.append(punkt.getNumPa() + SPACE);
            if (punkt.getKatNr() > 99999L) {
                stringBuffer.append(punkt.getKatNr());
            } else {
                stringBuffer.append(IFormat.i05.format(punkt.getKatNr()));
            }
        } else {
            stringBuffer.append(punkt.getKatNr());
        }
        return stringBuffer.toString();
    }

    private boolean isKatPunkt(Punkt punkt) {
        if (!punkt.isOn()) {
            return false;
        }
        switch (punkt.getInternalPs()) {
            case 0: {
                switch (punkt.getPs()) {
                    case 1: 
                    case 2: {
                        return true;
                    }
                }
                if (punkt.isKatasterPunkt()) break;
                return false;
            }
            case 1: 
            case 2: {
                if (punkt.isKatasterPunkt()) break;
                return false;
            }
        }
        return true;
    }

    private void writeKopfTable(PrintWriter printWriter) {
        printWriter.println("\\trowd \\trgaph70\\trrh400\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb");
        printWriter.println("\\brdrs\\brdrw10 \\cltxlrtb \\cellx1134\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx3402\\clvmgf\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb");
        printWriter.println("\\cellx5954\\clvmgf\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx7797\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\cltxlrtb \\cellx9923");
        printWriter.println("{\\trwd}");
        printWriter.println("\\pard \\widctlpar\\intbl\\adjustright {\\fs16 Gemeinde }{\\cell }");
        printWriter.print("\\pard\\plain \\s1\\keepn\\widctlpar\\intbl\\outlinelevel0\\adjustright \\b\\fs20\\lang1031\\cgrid {");
        if (DataBase.gemeinde != null) {
            printWriter.print(EinrechnungListeWriter.getRtfString(DataBase.gemeinde));
        }
        printWriter.println("\\cell }");
        printWriter.println("\\pard\\plain \\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {\\fs16 Vermessungsstelle\\par }");
        printWriter.print("\\pard \\qc\\widctlpar\\intbl\\adjustright {\\b\\fs16 ");
        if (DataBase.vermStelle != null) {
            printWriter.print(EinrechnungListeWriter.getRtfString(DataBase.vermStelle));
        }
        printWriter.println("}{\\fs16 \\cell }");
        printWriter.println("\\pard \\widctlpar\\intbl\\adjustright {\\fs16 Katasteramt\\par }");
        printWriter.print("\\pard \\qc\\widctlpar\\intbl\\adjustright {");
        if (DataBase.katasterAmt != null) {
            printWriter.print(EinrechnungListeWriter.getRtfString(DataBase.katasterAmt));
        }
        printWriter.println("\\cell }");
        printWriter.println("\\pard \\widctlpar\\intbl\\adjustright {\\fs16 Archivblatt*:\\cell }");
        printWriter.println("{\\row }");
        printWriter.println("\\trowd \\trgaph70\\trrh400\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr");
        printWriter.println("\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\cltxlrtb \\cellx1134\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb");
        printWriter.println("\\cellx3402\\clvmrg\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx5954\\clvmrg\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10");
        printWriter.println("\\cltxlrtb \\cellx7797\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\cltxlrtb \\cellx9923");
        printWriter.println("{\\trwd}");
        printWriter.println("\\pard \\widctlpar\\intbl\\adjustright {\\fs16 Gemarkung\\cell }");
        printWriter.print("\\pard\\plain \\s1\\keepn\\widctlpar\\intbl\\outlinelevel0\\adjustright\\b\\fs20\\lang1031\\cgrid {");
        if (this.gemarkung != null) {
            printWriter.print(EinrechnungListeWriter.getRtfString(this.gemarkung));
        }
        printWriter.println("\\cell }");
        printWriter.println("\\pard\\plain \\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {\\cell \\cell }{\\fs16 Antrags-Nr.*:\\cell }");
        printWriter.println("{\\row }");
        printWriter.println("\\trowd \\trgaph70\\trrh400\\trleft-70\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl");
        printWriter.println("\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx1134\\clvertalt\\clbrdrt");
        printWriter.println("\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx3402\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\cltxlrtb \\cellx5954\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\cltxlrtb \\cellx7797\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\cltxlrtb");
        printWriter.println("\\cellx9923");
        printWriter.println("{\\trwd}");
        printWriter.print("\\pard \\widctlpar\\intbl\\adjustright {\\fs16 Flur}{ }{\\b ");
        if (DataBase.flur != null) {
            printWriter.print(EinrechnungListeWriter.getRtfString(DataBase.flur));
        }
        printWriter.println("}{\\cell }");
        printWriter.print("{\\fs16 Flurst\\'fcck }{\\b ");
        if (DataBase.flurstueck != null) {
            printWriter.print(EinrechnungListeWriter.getRtfString(DataBase.flurstueck));
        }
        printWriter.println("}{\\fs16 \\cell }");
        printWriter.println("{\\cell \\cell }{\\fs12 * wird vom Katasteramt ausgef\\'fcllt\\cell }");
        printWriter.println("{\\row }");
        printWriter.println("\\pard \\widctlpar\\adjustright");
        printWriter.println("{\\par\\par}");
    }

    private void writeRissLine(PrintWriter printWriter, String string) {
        printWriter.println("\\trowd \\trgaph70\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10\\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx9923");
        printWriter.println("{\\trwd}");
        printWriter.print("\\pard\\plain \\s1\\keepn\\widctlpar\\intbl\\outlinelevel0\\adjustright\\fs20\\lang1031\\cgrid { ");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("\\cell }");
        printWriter.println("\\pard\\plain \\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid");
        printWriter.println("{\\row }");
        printWriter.println("\\trowd \\trgaph70\\trleft-70\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10\\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx1276\\clvertalt\\cltxlrtb");
        printWriter.println("\\cellx2835\\clvertalt\\cltxlrtb \\cellx4395\\clvertalt\\cltxlrtb \\cellx5245\\clvertalt\\cltxlrtb \\cellx6096\\clvertalt\\cltxlrtb \\cellx6946\\clvertalt\\cltxlrtb \\cellx9923");
    }

    private void writePunktLine(PrintWriter printWriter, Punkt punkt, String string) {
        printWriter.println("{\\trwd}");
        printWriter.print("\\pard \\qc\\widctlpar\\intbl\\adjustright {");
        if (punkt.getKafPa() > -1) {
            printWriter.print(punkt.getNumPa() + SPACE);
            if (punkt.getKatNr() > 99999L) {
                printWriter.print(punkt.getKatNr() + CELL);
            } else {
                printWriter.print(IFormat.i05.format(punkt.getKatNr()).toString() + CELL);
            }
        } else {
            printWriter.print(punkt.getKatNr() + CELL);
        }
        printWriter.print(SPACE + d33.format(punkt.y - (double)((int)punkt.y / 1000 * 1000)).toString() + CELL);
        printWriter.print(SPACE + d33.format(punkt.x - (double)((int)punkt.x / 1000 * 1000)).toString() + CELL);
        printWriter.print(SPACE);
        if (punkt.getInternalPs() != 0 || punkt.getPs() != 1 && punkt.getPs() != 2) {
            printWriter.print(d13.format(punkt.getSP()).toString());
        }
        printWriter.print("\\cell \\cell ");
        printWriter.print(IFormat.f1_3.format(punkt.dl));
        printWriter.println("\\cell}\\pard\\widctlpar\\intbl\\adjustright{");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("\\cell}");
        printWriter.println("{\\row }");
    }

    private void writeVoidAsRissLengthLine(PrintWriter printWriter) {
        printWriter.println("{\\trwd}\\pard \\qc\\widctlpar\\intbl\\adjustright {\\cell\\cell \\cell \\cell \\cell \\cell \\cell }{\\row }");
    }
}

