/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DPolygon;
import de.geocalc.geom.GeomElement;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.BemerkungTable;
import de.geocalc.kafplot.ErrorObject;
import de.geocalc.kafplot.io.IDataReader;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.StringTokenizer;

public class ErrorReader
extends IDataReader {
    LineNumberReader reader = null;
    protected BemerkungTable ERR = null;

    public ErrorReader(File file, BemerkungTable bemerkungTable) {
        this(file, bemerkungTable, null);
    }

    public ErrorReader(File file, BemerkungTable bemerkungTable, IProgressViewer iProgressViewer) {
        super(file, iProgressViewer);
        this.ERR = bemerkungTable;
        try {
            this.reader = this.createReader();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ErrorReader(URL uRL, BemerkungTable bemerkungTable, IProgressViewer iProgressViewer) {
        super(null, iProgressViewer);
        this.ERR = bemerkungTable;
        try {
            this.reader = this.createReader(uRL);
            this.setFileLength(uRL.openConnection().getContentLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void userAbort() throws IFileInputException {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception exception) {
            throw new IFileInputException(this.getErrorKey() + "Fehler beim Schlie\u00dfen der Datei: " + this.inFile.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void read() throws IFileInputException {
        String string = null;
        if (this.reader == null) {
            throw new IFileInputException("Datei nicht gefunden: " + this.getFile().getName());
        }
        try {
            long l = 0L;
            ErrorObject errorObject = null;
            boolean bl = false;
            while ((string = this.reader.readLine()) != null) {
                if (string.startsWith("#") || string.length() == 0) continue;
                if (string.startsWith("FATAL")) {
                    errorObject = new ErrorObject(this.getFile().getName());
                } else if (string.startsWith("ERROR")) {
                    errorObject = new ErrorObject(this.getFile().getName());
                } else if (string.startsWith("WARNING")) {
                    errorObject = new ErrorObject(this.getFile().getName());
                } else if (string.startsWith("MESSAGE")) {
                    errorObject = new ErrorObject(this.getFile().getName());
                } else if (string.startsWith("LOC")) {
                    var6_12 = this.readGeom(string.substring(string.indexOf(58) + 1));
                    if (!(var6_12 instanceof DPoint)) throw new IFileInputException("Ung\u00fcltiges Geometrieelement in LOC");
                    if (errorObject == null) throw new IFileInputException("Angabe eines LOC ohne ERROR-Object");
                    errorObject.setPoint((DPoint)var6_12);
                } else if (string.startsWith("ELEM")) {
                    var6_12 = new StringTokenizer(string.substring(string.indexOf(58) + 1), ";");
                    while (((StringTokenizer)var6_12).hasMoreTokens()) {
                        GeomElement geomElement = this.readGeom(((StringTokenizer)var6_12).nextToken());
                        if (errorObject == null) throw new IFileInputException("Angabe eines ELEM ohne ERROR-Object");
                        errorObject.addGeom(geomElement);
                    }
                } else if (string.startsWith("TEXT")) {
                    var6_12 = string.substring(string.indexOf(58) + 1).trim();
                    if (errorObject == null) throw new IFileInputException("Angabe eines TEXT ohne ERROR-Object");
                    errorObject.addText(((String)var6_12).replace("\\n", "\n"));
                } else if (string.startsWith("END")) {
                    this.ERR.addElement(errorObject);
                }
                super.setFileProgress(l += (long)(string.length() + 1));
            }
            return;
        }
        catch (IFileInputException iFileInputException) {
            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber(), iFileInputException.getMessage()));
            return;
        }
        catch (IOException iOException) {
            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber(), iOException.getMessage()));
            return;
        }
        catch (Exception exception) {
            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber(), exception.getMessage()));
            return;
        }
        finally {
            try {
                this.reader.close();
                super.setProgress(100);
            }
            catch (Exception exception) {}
        }
    }

    private GeomElement readGeom(String string) throws IFileInputException {
        int n = string.indexOf(40);
        int n2 = string.indexOf(41);
        if (n < 0) {
            throw new IFileInputException("Geometrieangaben fehlen");
        }
        if (n == 0) {
            throw new IFileInputException("Angabe der Geometrieart fehlt");
        }
        if (n2 < 0) {
            throw new IFileInputException("Geometrieangaben nicht ordungsgem\u00e4\u00df angeschlossen");
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1, n2), ",");
            switch (string.charAt(n - 1)) {
                case 'P': {
                    DPoint dPoint = new DPoint();
                    dPoint.y = Double.valueOf(stringTokenizer.nextToken());
                    dPoint.x = Double.valueOf(stringTokenizer.nextToken());
                    return dPoint;
                }
                case 'L': {
                    DLine dLine = new DLine();
                    dLine.ya = Double.valueOf(stringTokenizer.nextToken());
                    dLine.xa = Double.valueOf(stringTokenizer.nextToken());
                    dLine.ye = Double.valueOf(stringTokenizer.nextToken());
                    dLine.xe = Double.valueOf(stringTokenizer.nextToken());
                    return dLine;
                }
                case 'A': {
                    DPolygon dPolygon = new DPolygon();
                    while (stringTokenizer.hasMoreTokens()) {
                        dPolygon.addPoint(Double.valueOf(stringTokenizer.nextToken()), Double.valueOf(stringTokenizer.nextToken()));
                    }
                    return dPolygon;
                }
            }
            throw new IFileInputException("ung\u00fcltige Geometrieart: " + string.charAt(n - 1));
        }
        catch (Exception exception) {
            throw new IFileInputException("Fehler bei der Formaterkennung");
        }
    }
}

