/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.io.IFileWriter;
import de.geocalc.lang.ErrorMessage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class ErrorWriter
extends IFileWriter {
    public static final String TITLE = "ErrorWriter";
    public static final String VERSION = "1.0";
    protected PrintWriter writer = null;
    protected Vector ERR = null;
    protected String header = null;

    public ErrorWriter(File file, Vector vector) {
        super(file);
        this.ERR = vector;
        this.setParameter();
    }

    protected void setParameter() {
    }

    public void setHeader(String string) {
        this.header = string;
    }

    @Override
    public void write() throws IFileOutputException {
        try {
            this.writer = this.createWriter();
            this.writer.println("#KafPlot-Fehlermeldungen");
            if (this.header != null) {
                this.writer.println(this.header);
            }
            Enumeration enumeration = this.ERR.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof ErrorMessage) {
                    ErrorMessage errorMessage = (ErrorMessage)e;
                    this.writer.println(errorMessage.toFileMessage());
                    continue;
                }
                if (e instanceof Exception) {
                    this.writer.println("# " + ((Exception)e).getMessage());
                    continue;
                }
                this.writer.println("# " + e.toString());
            }
            this.writer.close();
            super.setProgress(100);
        }
        catch (IOException iOException) {
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
    }
}

