/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.KoordinatenSystem;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.TrafoGewicht;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.io.IDataReader;
import de.geocalc.kafplot.io.dat.SteuerDaten;
import de.geocalc.text.IFormat;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.StringTokenizer;

public class EsriDigitReader
extends IDataReader {
    private DataBase db = null;
    private LineNumberReader reader = null;
    private Riss riss = null;

    public EsriDigitReader(File file, DataBase dataBase) {
        this(file, dataBase, null);
    }

    public EsriDigitReader(File file, DataBase dataBase, IProgressViewer iProgressViewer) {
        super(file, iProgressViewer);
        this.db = dataBase;
        if (DataBase.steuerDaten == null) {
            DataBase.steuerDaten = new SteuerDaten("AutoCreate");
        }
    }

    public static boolean detectLine(String string) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        int n = 0;
        while (stringTokenizer.hasMoreTokens() && IFormat.hasOnlyFloats(string2 = stringTokenizer.nextToken())) {
            ++n;
        }
        return n == 4;
    }

    @Override
    public void userAbort() throws IFileInputException {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception exception) {
            throw new IFileInputException(this.getErrorKey() + "Fehler beim Schlie\u00dfen der Datei: " + this.inFile.getName());
        }
    }

    @Override
    public void read() throws IFileInputException {
        long l = this.getFreeStartNumber();
        TrafoSystem trafoSystem = new TrafoSystem(9);
        TrafoGewicht trafoGewicht = new TrafoGewicht(4.0f, 2.0f);
        trafoSystem.setParameter(6);
        trafoSystem.setName(this.inFile.getName());
        String string = null;
        try {
            boolean bl = false;
            this.reader = this.createReader();
            long l2 = 0L;
            while ((string = this.reader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
                double d = Double.parseDouble(stringTokenizer.nextToken());
                double d2 = Double.parseDouble(stringTokenizer.nextToken());
                double d3 = Double.parseDouble(stringTokenizer.nextToken());
                double d4 = Double.parseDouble(stringTokenizer.nextToken());
                EsriDigitReader esriDigitReader = this;
                d3 = KoordinatenSystem.regularY(d3, esriDigitReader.db.getKooSystem());
                Punkt punkt = new Punkt(l, d3, d4);
                TrafoPunkt trafoPunkt = new TrafoPunkt(punkt, d, d2, trafoGewicht);
                if (DataBase.P.get(l) != null) {
                    this.addException(new IFileInputException("Punkt " + l + " ist bereits vorhanden, Zeile wird ignoriert"));
                } else {
                    trafoSystem.addElement(trafoPunkt);
                    DataBase.P.put(punkt);
                }
                ++l;
                super.setFileProgress(l2 += (long)(string.length() + 1));
            }
        }
        catch (IOException iOException) {
            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber(), iOException.getMessage()));
        }
        catch (Exception exception) {
            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber(), exception.getMessage()));
            System.out.println("Zeile: " + this.reader.getLineNumber());
            exception.printStackTrace();
        }
        if (trafoSystem.size() > 0) {
            DataBase.T.addElement(trafoSystem);
        }
        try {
            this.reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

