/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.io.IFileWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

public class EsriDigitWriter
extends IFileWriter {
    public static final String TITLE = "EsriDigitWriter";
    public static final String VERSION = "1.0";
    protected DataBase db;

    public EsriDigitWriter(File file, DataBase dataBase) {
        super(file);
        this.db = dataBase;
        this.setParameter();
    }

    protected void setParameter() {
    }

    @Override
    public void write() throws IFileOutputException {
        PrintWriter printWriter = null;
        String string = this.outFile.getName();
        int n = string.lastIndexOf(".");
        String string2 = "";
        String string3 = ".bla";
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n);
        }
        try {
            int n2 = 0;
            Enumeration enumeration = DataBase.T.elements();
            while (enumeration.hasMoreElements()) {
                TrafoSystem trafoSystem = (TrafoSystem)enumeration.nextElement();
                String string4 = trafoSystem.getName();
                printWriter = this.createWriter(new File(string2 + "." + string4 + string3));
                Enumeration enumeration2 = trafoSystem.elements();
                while (enumeration2.hasMoreElements()) {
                    TrafoPunkt trafoPunkt = (TrafoPunkt)enumeration2.nextElement();
                    Punkt punkt = trafoPunkt.getPunkt();
                    if (!this.punktFilter.isPunktEnabled(punkt)) continue;
                    StringBuffer stringBuffer = new StringBuffer(255);
                    stringBuffer.append(Double.toString(trafoPunkt.y));
                    stringBuffer.append("\t");
                    stringBuffer.append(Double.toString(trafoPunkt.x));
                    stringBuffer.append("\t");
                    stringBuffer.append(Double.toString(punkt.y % 1000000.0));
                    stringBuffer.append("\t");
                    stringBuffer.append(Double.toString(punkt.x));
                    printWriter.println(stringBuffer.toString());
                }
                printWriter.close();
                super.setProgress(n2 * 100 / DataBase.T.size());
            }
            super.setProgress(100);
        }
        catch (IOException iOException) {
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
        finally {
            try {
                printWriter.close();
            }
            catch (Exception exception) {}
        }
    }
}

