/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.GebaeudeKennzeichen;
import de.geocalc.kafplot.ObjectDecor;
import de.geocalc.kafplot.OskaObject;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.TopObject;
import de.geocalc.kafplot.io.IDataReader;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.StringTokenizer;

public class EtrReader
extends IDataReader {
    private DataBase db;
    private Punkt p = new Punkt();
    private LineNumberReader reader = null;

    public EtrReader(File file, DataBase dataBase) {
        this(file, dataBase, null);
    }

    public EtrReader(File file, DataBase dataBase, IProgressViewer iProgressViewer) {
        super(file, iProgressViewer);
        this.db = dataBase;
    }

    @Override
    public void userAbort() throws IFileInputException {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception exception) {
            throw new IFileInputException(this.getErrorKey() + "Fehler beim Schlie\u00dfen der Datei: " + this.inFile.getName());
        }
    }

    @Override
    public void read() throws IFileInputException {
        String string = new String();
        try {
            this.reader = this.createReader();
            long l = 0L;
            GObject gObject = null;
            while ((string = this.reader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                if (stringTokenizer.countTokens() < 3) {
                    throw new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber() + ", fehlender Wert");
                }
                String string2 = stringTokenizer.nextToken();
                double d = Double.valueOf(stringTokenizer.nextToken());
                double d2 = Double.valueOf(stringTokenizer.nextToken());
                char c = string2.charAt(0);
                if (Character.isLetter(c)) {
                    int n = Integer.parseInt(string2.substring(1));
                    switch (c) {
                        case 'F': {
                            gObject = (Flurstueck)DataBase.FLST.elementAt(n);
                            gObject.y = d;
                            gObject.x = d2;
                            break;
                        }
                        case 'f': {
                            gObject = (Flurstueck)DataBase.FLST.elementAt(n);
                            gObject.yt = d;
                            gObject.xt = d2;
                            break;
                        }
                        case 'G': {
                            gObject = (Gebaeude)DataBase.GEB.elementAt(n);
                            gObject.y = d;
                            gObject.x = d2;
                            break;
                        }
                        case 'g': {
                            gObject = (Gebaeude)DataBase.GEB.elementAt(n);
                            gObject.yt = d;
                            gObject.xt = d2;
                            break;
                        }
                        case 'T': {
                            gObject = (TopObject)DataBase.TOP.elementAt(n);
                            gObject.y = d;
                            gObject.x = d2;
                            break;
                        }
                        case 't': {
                            gObject = (TopObject)DataBase.TOP.elementAt(n);
                            gObject.yt = d;
                            gObject.xt = d2;
                            break;
                        }
                        case 'K': {
                            OskaObject oskaObject = (Gebaeude)gObject;
                            if (gObject == null) break;
                            GebaeudeKennzeichen gebaeudeKennzeichen = oskaObject.kennzeichenAt(n);
                            gebaeudeKennzeichen.y = d;
                            gebaeudeKennzeichen.x = d2;
                            break;
                        }
                        case 'k': {
                            OskaObject oskaObject = (Gebaeude)gObject;
                            if (gObject == null) break;
                            GebaeudeKennzeichen gebaeudeKennzeichen = oskaObject.kennzeichenAt(n);
                            gebaeudeKennzeichen.yt = d;
                            gebaeudeKennzeichen.xt = d2;
                            break;
                        }
                        case 'D': {
                            if (gObject == null) break;
                            OskaObject oskaObject = gObject.decorAt(n);
                            ((ObjectDecor)oskaObject).y = d;
                            ((ObjectDecor)oskaObject).x = d2;
                            break;
                        }
                        case 'd': {
                            if (gObject == null) break;
                            OskaObject oskaObject = gObject.decorAt(n);
                            ((ObjectDecor)oskaObject).y = d;
                            ((ObjectDecor)oskaObject).x = d2;
                        }
                    }
                } else {
                    this.p.nr = Long.parseLong(string2);
                    this.p.y = d;
                    this.p.x = d2;
                    Punkt punkt = (Punkt)DataBase.P.get(this.p.nr);
                    if (punkt != null && this.isMode(2)) {
                        punkt.set2dKoordinaten(this.p.y, this.p.x);
                    } else if (this.isMode(1)) {
                        DataBase.P.put(this.p);
                    }
                }
                super.setFileProgress(l += (long)(string.length() + 1));
            }
            this.reader.close();
            super.setProgress(100);
        }
        catch (IOException iOException) {
            throw new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IFileInputException("Fehlender oder falscher Wert in Zeile: " + this.reader.getLineNumber());
        }
    }

    public Punkt getLastReadedPunkt() {
        return this.p;
    }
}

