/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.GebaeudeKennzeichen;
import de.geocalc.kafplot.ObjectDecor;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.TopObject;
import de.geocalc.kafplot.io.IFileWriter;
import de.geocalc.text.GeoNumberFormat;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

public class EtrWriter
extends IFileWriter {
    private DataBase db;

    public EtrWriter(File file, DataBase dataBase) {
        super(file);
        this.db = dataBase;
        this.setParameter();
    }

    protected void setParameter() {
    }

    @Override
    public void write() throws IFileOutputException {
        PrintWriter printWriter = null;
        try {
            Cloneable cloneable;
            printWriter = this.createWriter();
            Enumeration enumeration = DataBase.P.elements();
            while (enumeration.hasMoreElements()) {
                cloneable = (Punkt)enumeration.nextElement();
                if (!((Punkt)cloneable).hasLocation()) continue;
                printWriter.println(this.punktToLine((Punkt)cloneable));
            }
            super.setProgress(30);
            int n = 0;
            while (true) {
                if (n >= DataBase.FLST.size()) break;
                cloneable = (Flurstueck)DataBase.FLST.elementAt(n);
                if (((DataContainer)cloneable).hasLocation()) {
                    StringBuffer stringBuffer = new StringBuffer(50);
                    stringBuffer.append("F");
                    stringBuffer.append(n);
                    stringBuffer.append("  ");
                    stringBuffer.append(GeoNumberFormat.koo73.format(((Flurstueck)cloneable).y).toString());
                    stringBuffer.append("  ");
                    stringBuffer.append(GeoNumberFormat.koo73.format(((Flurstueck)cloneable).x).toString());
                    printWriter.println(stringBuffer.toString());
                    if (((DataContainer)cloneable).hasTextLocation()) {
                        stringBuffer = new StringBuffer(50);
                        stringBuffer.append("f");
                        stringBuffer.append(n);
                        stringBuffer.append("  ");
                        stringBuffer.append(GeoNumberFormat.koo73.format(((Flurstueck)cloneable).yt).toString());
                        stringBuffer.append("  ");
                        stringBuffer.append(GeoNumberFormat.koo73.format(((Flurstueck)cloneable).xt).toString());
                        printWriter.println(stringBuffer.toString());
                    }
                }
                ++n;
            }
            super.setProgress(60);
            n = 0;
            while (true) {
                StringBuffer stringBuffer;
                Object object;
                Enumeration enumeration2;
                if (n >= DataBase.GEB.size()) break;
                cloneable = (Gebaeude)DataBase.GEB.elementAt(n);
                if (((DataContainer)cloneable).hasLocation()) {
                    StringBuffer stringBuffer2 = new StringBuffer(50);
                    stringBuffer2.append("G");
                    stringBuffer2.append(n);
                    stringBuffer2.append("  ");
                    stringBuffer2.append(GeoNumberFormat.koo73.format(((Gebaeude)cloneable).y).toString());
                    stringBuffer2.append("  ");
                    stringBuffer2.append(GeoNumberFormat.koo73.format(((Gebaeude)cloneable).x).toString());
                    printWriter.println(stringBuffer2.toString());
                }
                if (((Gebaeude)cloneable).hasKennzeichen()) {
                    int n2 = 0;
                    enumeration2 = ((Gebaeude)cloneable).kennzeichen();
                    while (enumeration2.hasMoreElements()) {
                        object = (GebaeudeKennzeichen)enumeration2.nextElement();
                        if (((GebaeudeKennzeichen)object).hasLocation()) {
                            stringBuffer = new StringBuffer(50);
                            stringBuffer.append("K");
                            stringBuffer.append(n2);
                            stringBuffer.append("  ");
                            stringBuffer.append(GeoNumberFormat.koo73.format(((GebaeudeKennzeichen)object).y).toString());
                            stringBuffer.append("  ");
                            stringBuffer.append(GeoNumberFormat.koo73.format(((GebaeudeKennzeichen)object).x).toString());
                            printWriter.println(stringBuffer.toString());
                        }
                        if (((GebaeudeKennzeichen)object).hasTextLocation()) {
                            stringBuffer = new StringBuffer(50);
                            stringBuffer.append("k");
                            stringBuffer.append(n2);
                            stringBuffer.append("  ");
                            stringBuffer.append(GeoNumberFormat.koo73.format(((GebaeudeKennzeichen)object).yt).toString());
                            stringBuffer.append("  ");
                            stringBuffer.append(GeoNumberFormat.koo73.format(((GebaeudeKennzeichen)object).xt).toString());
                            printWriter.println(stringBuffer.toString());
                        }
                        ++n2;
                    }
                }
                if (((GObject)cloneable).hasDecor()) {
                    int n3 = 0;
                    enumeration2 = ((GObject)cloneable).decors();
                    while (enumeration2.hasMoreElements()) {
                        object = (ObjectDecor)enumeration2.nextElement();
                        if (((ObjectDecor)object).hasLocation()) {
                            stringBuffer = new StringBuffer(50);
                            stringBuffer.append("D");
                            stringBuffer.append(n3);
                            stringBuffer.append("  ");
                            stringBuffer.append(GeoNumberFormat.koo73.format(((ObjectDecor)object).y).toString());
                            stringBuffer.append("  ");
                            stringBuffer.append(GeoNumberFormat.koo73.format(((ObjectDecor)object).x).toString());
                            printWriter.println(stringBuffer.toString());
                        }
                        if (((ObjectDecor)object).hasDecorLocation()) {
                            stringBuffer = new StringBuffer(50);
                            stringBuffer.append("d");
                            stringBuffer.append(n3);
                            stringBuffer.append("  ");
                            stringBuffer.append(GeoNumberFormat.koo73.format(((ObjectDecor)object).yt).toString());
                            stringBuffer.append("  ");
                            stringBuffer.append(GeoNumberFormat.koo73.format(((ObjectDecor)object).xt).toString());
                            printWriter.println(stringBuffer.toString());
                        }
                        ++n3;
                    }
                }
                ++n;
            }
            super.setProgress(90);
            n = 0;
            while (true) {
                if (n >= DataBase.TOP.size()) break;
                cloneable = (TopObject)DataBase.TOP.elementAt(n);
                if (((DataContainer)cloneable).hasLocation()) {
                    StringBuffer stringBuffer = new StringBuffer(50);
                    stringBuffer.append("T");
                    stringBuffer.append(n);
                    stringBuffer.append("  ");
                    stringBuffer.append(GeoNumberFormat.koo73.format(((TopObject)cloneable).y).toString());
                    stringBuffer.append("  ");
                    stringBuffer.append(GeoNumberFormat.koo73.format(((TopObject)cloneable).x).toString());
                    printWriter.println(stringBuffer.toString());
                    if (((DataContainer)cloneable).hasTextLocation()) {
                        stringBuffer = new StringBuffer(50);
                        stringBuffer.append("t");
                        stringBuffer.append(n);
                        stringBuffer.append("  ");
                        stringBuffer.append(GeoNumberFormat.koo73.format(((TopObject)cloneable).yt).toString());
                        stringBuffer.append("  ");
                        stringBuffer.append(GeoNumberFormat.koo73.format(((TopObject)cloneable).xt).toString());
                        printWriter.println(stringBuffer.toString());
                    }
                }
                ++n;
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
    }

    protected void initValues() {
    }

    protected String getHeader() {
        return null;
    }

    protected String punktToLine(Punkt punkt) {
        return punkt.toQuickLine();
    }

    protected String getEndOfFile() {
        return null;
    }
}

