/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.Gemarkung;
import de.geocalc.kafplot.KatasterParameter;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.io.FlaechenbelegIOProperties;
import de.geocalc.kafplot.io.RtfWriter;
import de.geocalc.kafplot.io.rtf.RtfIOConstants;
import de.geocalc.text.IFormat;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;

public class FlaechenbelegWriter
extends RtfWriter {
    protected DataBase db;
    protected String date = RtfIOConstants.getString(new SimpleDateFormat("dd.MMM. yyyy").format(new Date()));
    private static final int[] oneRows = new int[]{9900};
    private static final int[] flstRows = new int[]{1440, 4860, 6840, 9900};
    private static final int[] lageRows = new int[]{1440, 2160, 9900};
    private static final int[] amtPunktRows = new int[]{1080, 1440, 2160, 3510, 4860, 5850, 6840, 7200, 7984, 8820, 9900};
    private static final int[] lokPunktRows = new int[]{2160, 3510, 4860, 5850, 6840, 7200, 7984, 8820, 9900};
    private static final int[] ergVorRows = new int[]{6840, 8640, 9900};
    private static final int[] ergRows = new int[]{2160, 3600, 5400, 6840, 8640, 9900};
    private static final char OHNE = '\u0000';
    private static final char EIGENE = 'E';
    private static final char KATASTER = 'K';
    private static final String EOL = "\n";
    private static final String RTF_HEADER = "{\\rtf1\\ansi\\ansicpg1252\\uc1 \\deff0\\deflang1033\\deflangfe1031\n{\\fonttbl\n{\\f0\\froman\\fcharset0\\fprq2{\\*\\panose 02020603050405020304}Times New Roman;}\n{\\f19\\froman\\fcharset238\\fprq2 Times New Roman CE;}\n{\\f20\\froman\\fcharset204\\fprq2 Times New Roman Cyr;}\n{\\f22\\froman\\fcharset161\\fprq2 Times New Roman Greek;}\n{\\f23\\froman\\fcharset162\\fprq2 Times New Roman Tur;}\n{\\f24\\froman\\fcharset186\\fprq2 Times New Roman Baltic;}\n}\n{\\colortbl;\n\\red0\\green0\\blue0;\n\\red0\\green0\\blue255;\n\\red0\\green255\\blue255;\n\\red0\\green255\\blue0;\n\\red255\\green0\\blue255;\n\\red255\\green0\\blue0;\n\\red255\\green255\\blue0;\n\\red255\\green255\\blue255;\n\\red0\\green0\\blue128;\n\\red0\\green128\\blue128;\n\\red0\\green128\\blue0;\n\\red128\\green0\\blue128;\n\\red128\\green0\\blue0;\n\\red128\\green128\\blue0;\n\\red128\\green128\\blue128;\n\\red192\\green192\\blue192;\n}\n{\\stylesheet{\\widctlpar\\adjustright \\lang1031\\cgrid \\snext0 Normal;}{\\*\\cs10 \\additive Default Paragraph Font;}\n{\\s15\\widctlpar\\tqc\\tx4536\\tqr\\tx9072\\adjustright \\lang1031\\cgrid \\sbasedon0 \\snext15 header;}\n{\\s16\\widctlpar\\tqc\\tx4536\\tqr\\tx9072\\adjustright \\lang1031\\cgrid \\sbasedon0 \\snext16 footer;}\n}\n{\\info\n{\\title Berechnung}{\\author KafPlot}\n{\\version2}{\\edmins0}{\\nofpages2}{\\nofwords98}{\\nofchars561}{\\*\\company  }\n{\\nofcharsws688}{\\vern113}\n}\n\\paperw11906\\paperh16838\\margl1418\\margr567\\margt1418\\margb1134 \\deftab708\\widowctrl\\ftnbj\\aenddoc\\hyphhotz425\\noxlattoyen\\expshrtn\\noultrlspc\\dntblnsbdb\\nospaceforul\\hyphcaps0\\formshade\\viewkind1\\viewscale100\\pgbrdrhead\\pgbrdrfoot \\fet0\\sectd\n\\linex0\\headery709\\footery709\\colsx708\\endnhere\\sectlinegrid360\\sectdefaultcl";
    private static final String FIRST_PAGE_HEADER = "{\\*\\pnseclvl1\\pnucrm\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}\n{\\*\\pnseclvl2\\pnucltr\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}\n{\\*\\pnseclvl3\\pndec\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}\n{\\*\\pnseclvl4\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxta )}}\n{\\*\\pnseclvl5\\pndec\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}\n{\\*\\pnseclvl6\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}\n{\\*\\pnseclvl7\\pnlcrm\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}\n{\\*\\pnseclvl8\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}\n{\\*\\pnseclvl9\\pnlcrm\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}";
    private static final String TABLE_HEADER = "\\trowd \\trkeep\\trhdr\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10\n\\trpaddl57\\trpaddr57\\trpaddfl3\\trpaddft3\\trpaddfb3\\trpaddfr3\n\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx2160\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx4860\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx6840\\clvmgf\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx7200\\clvmgf\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx7984\\clvmgf\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx8820\\clvmgf\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx9900\n\\pard\\plain \\qc\\widctlpar\\intbl\\adjustright \\lang1031\\cgrid {\\fs16 Punktnummer\\cell Koordinaten\\cell Strecke\\cell E\\line K\\cell Differenz\\cell Grenz-\\line wert\\cell Radius\\cell }\n\\pard \\widctlpar\\intbl\\adjustright {\\row }\n\\trowd \\trkeep\\trhdr\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10\n\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx900\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx1440\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx2160\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx3510\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx4860\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx5850\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx6840\\clvmrg\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx7200\\clvmrg\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx7984\\clvmrg\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx8820\\clvmrg\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx9900\n\\pard \\qc\\widctlpar\\intbl\\adjustright {\\fs16 NBZ\\cell PAT\\cell PNR\\cell R\\cell H\\cell (ger.)\\cell (gem.)\\cell \\cell \\cell \\cell \\cell }\n\\pard \\widctlpar\\intbl\\adjustright {\\row }\n\\trowd \\trhdr\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\cltxlrtb\n\\cellx9900\n\\pard \\qc\\widctlpar\\intbl\\adjustright {\\fs20 \\cell }\n\\pard \\widctlpar\\intbl\\adjustright {\\fs20 \\row }";
    private static final String ROW_HEADER = "\\trowd \\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalc\\cltxlrtb\\trpaddl57\\trpaddr57\\trpaddfl3\\trpaddft3\\trpaddfb3\\trpaddfr3";
    private static final String ROW_FEATER = "\\pard \\widctlpar\\intbl\\adjustright {\\fs20 \\row }";
    private static final String RH = "\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright ";
    private static final String RF = "{\\row }";
    private static final String CELL = "\\cell";
    private static final String TABLE_FEATER = "\\pard \\widctlpar\\adjustright {\\fs20 \\par }";
    private static final String END_OF_FILE = "}";

    public FlaechenbelegWriter(File file, DataBase dataBase) {
        super(file, dataBase);
    }

    private double searchMessStrecke(Punkt punkt, Punkt punkt2, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            Messung messung = (Messung)enumeration.nextElement();
            switch (messung.getMessungsArt(true)) {
                case 240: {
                    if ((messung.ps != punkt || messung.pz != punkt2) && (messung.pz != punkt || messung.ps != punkt2)) break;
                    return messung.l2;
                }
                case 220: 
                case 260: {
                    if ((messung.ps != punkt || messung.pz != punkt2) && (messung.pz != punkt || messung.ps != punkt2)) break;
                    return messung.l1;
                }
            }
        }
        return 0.0;
    }

    @Override
    public void write() throws IFileOutputException {
        PrintWriter printWriter = null;
        try {
            printWriter = this.createWriter();
            int n = 0;
            super.setEndValue(DataBase.FLST.size());
            super.setProgressBreak();
            super.setValue(0L);
            super.setLabelText("Liste erstellen...");
            this.checkDatVars();
            printWriter.println(RTF_HEADER);
            this.writePageHeader(printWriter);
            this.writeStartPage(printWriter);
            printWriter.println(TABLE_HEADER);
            Enumeration enumeration = DataBase.FLST.elements();
            while (enumeration.hasMoreElements()) {
                Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
                if (FlaechenbelegIOProperties.writeOnlyFortfuehrung() && !flurstueck.isFortfuehrung()) continue;
                this.writeFlstName(printWriter, flurstueck);
                switch (flurstueck.getBerechnungsArt()) {
                    default: {
                        this.writeVorgabeErgebnis(printWriter, "ohne Fl\u00e4chenberechnung", flurstueck.getRoundedFlaeche());
                        break;
                    }
                    case 1: {
                        this.writeVorgabeErgebnis(printWriter, "\u00dcbernahme aus dem Liegenschaftsbuch", flurstueck.getRoundedFlaeche());
                        break;
                    }
                    case 2: {
                        this.writeVorgabeErgebnis(printWriter, "Rest durch Abzug", flurstueck.getRoundedFlaeche());
                        break;
                    }
                    case 3: {
                        this.writeVorgabeErgebnis(printWriter, "Berechnung aus Kartenma\u00dfen", flurstueck.getRoundedFlaeche());
                        break;
                    }
                    case 4: {
                        this.writeVorgabeErgebnis(printWriter, "Berechnung aus Feld- und Kartenma\u00dfen", flurstueck.getRoundedFlaeche());
                        break;
                    }
                    case 5: {
                        this.writeVorgabeErgebnis(printWriter, "Berechnung aus Feldma\u00dfen", flurstueck.getRoundedFlaeche());
                        break;
                    }
                    case 6: {
                        Punkt punkt = null;
                        double d = 0.0;
                        Enumeration enumeration2 = flurstueck.elements();
                        while (enumeration2.hasMoreElements()) {
                            Linie linie = (Linie)enumeration2.nextElement();
                            byte by = linie.getLs();
                            if (by == 1) {
                                this.writePunkt(printWriter, linie.pa, 0.0, 0.0, '\u0000', 0.0);
                            } else if (by == 0 || by == 9) {
                                char c = '\u0000';
                                FlaechenbelegWriter flaechenbelegWriter = this;
                                double d2 = this.searchMessStrecke(punkt, linie.pa, flaechenbelegWriter.db.messbandMessungen());
                                if (d2 != 0.0) {
                                    c = 'E';
                                } else {
                                    FlaechenbelegWriter flaechenbelegWriter2 = this;
                                    d2 = this.searchMessStrecke(punkt, linie.pa, flaechenbelegWriter2.db.katasterMessungen());
                                    if (d2 != 0.0) {
                                        c = 'K';
                                    }
                                }
                                this.writePunkt(printWriter, linie.pa, DataBase.getStrecke(punkt, linie.pa), d2, c, d);
                                if (by == 9) break;
                            }
                            punkt = linie.pa;
                            d = linie.l2;
                        }
                        double d3 = Math.abs(flurstueck.getPolygonFlaeche());
                        double d4 = d3 * DataBase.getFlaecheMasstab(flurstueck.y);
                        this.writeErgebnis(printWriter, d3, d4 - d3, d4);
                        break;
                    }
                    case 10: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: {
                        this.writeVorgabeErgebnis(printWriter, "Berechnung durch Sollfl\u00e4chenverteilung", flurstueck.getRoundedFlaeche());
                    }
                }
                this.writeSingleRow(printWriter);
                if ((long)n++ % super.getProgressBreak() != 0L) continue;
                super.setProgress(n);
            }
            printWriter.println(TABLE_FEATER);
            printWriter.println(END_OF_FILE);
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
    }

    private void writePageHeader(PrintWriter printWriter) {
        printWriter.println("{\\header");
        printWriter.println("\\trowd \\trgaph70\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10");
        printWriter.println("\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb");
        printWriter.println("\\cellx2962\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb");
        printWriter.println("\\cellx6033\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb");
        printWriter.println("\\cellx9900");
        printWriter.print("\\pard\\plain \\widctlpar\\intbl\\adjustright \\lang1031\\cgrid {\\fs20 Fl\\'e4chenberechnung\\cell Datum: ");
        printWriter.print(this.date);
        printWriter.println("\\cell Seite: }");
        printWriter.println("{\\field{\\*\\fldinst {\\fs20 PAGE  \\\\* ARABIC  \\\\* MERGEFORMAT }}{\\fldrslt {\\fs20\\lang1024 1}}}{\\fs20 /}");
        printWriter.println("{\\field{\\*\\fldinst {\\fs20 NUMPAGES  \\\\* ARABIC  \\\\* MERGEFORMAT }}{\\fldrslt {\\fs20\\lang1024 1}}}{\\fs20 \\cell }");
        printWriter.println(ROW_FEATER);
        printWriter.println("\\trowd \\trgaph70\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10");
        printWriter.println("\\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb");
        printWriter.println("\\cellx9900");
        printWriter.print("\\pard \\widctlpar\\intbl\\adjustright {\\fs20 ");
        if (DataBase.vermStelle != null) {
            printWriter.println(RtfIOConstants.getString(DataBase.vermStelle));
        }
        printWriter.println("\\cell }");
        printWriter.println(ROW_FEATER);
        printWriter.println("\\pard\\plain \\s15\\widctlpar\\tqc\\tx4536\\tqr\\tx9072\\adjustright \\lang1031\\cgrid {\\par }");
        printWriter.println(END_OF_FILE);
    }

    private void writeStartPage(PrintWriter printWriter) {
        printWriter.println(FIRST_PAGE_HEADER);
        printWriter.print("\\pard\\plain \\nowidctlpar\\widctlpar\\adjustright \\lang1031\\cgrid {");
        if (DataBase.vermStelle != null) {
            printWriter.println(RtfIOConstants.getString(DataBase.vermStelle));
        }
        printWriter.print("\\par ");
        if (DataBase.adresse_1 != null) {
            printWriter.println(RtfIOConstants.getString(DataBase.adresse_1));
        }
        printWriter.print("\\par ");
        if (DataBase.adresse_2 != null) {
            printWriter.println(RtfIOConstants.getString(DataBase.adresse_2));
        }
        printWriter.print("\\par ");
        if (DataBase.adresse_3 != null) {
            printWriter.println(RtfIOConstants.getString(DataBase.adresse_3));
        }
        printWriter.println("{\\par }");
        printWriter.println("\\pard \\sb240\\sa240\\nowidctlpar\\widctlpar\\adjustright {\\par }");
        printWriter.println("\\trowd \\trgaph70\\trleft-108\\trbrdrt\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\cltxlrtb \\cellx2880\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\cltxlrtb \\cellx9104");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\cell \\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\trowd \\trgaph70\\trleft-108\\trbrdrt\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\clvertalt\\cltxlrtb \\cellx2880\\clvertalt\\cltxlrtb \\cellx9104");
        printWriter.print("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {Katasteramt:\\cell ");
        if (DataBase.katasterAmt != null) {
            printWriter.print(RtfIOConstants.getString(DataBase.katasterAmt));
        }
        printWriter.println("\\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.print("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {Gemarkung:\\cell ");
        if (DataBase.gemarkung != null) {
            printWriter.print(RtfIOConstants.getString(DataBase.gemarkung));
            Gemarkung gemarkung = Gemarkung.getGemarkung(DataBase.gemeinde, DataBase.gemarkung);
            if (gemarkung != null) {
                printWriter.print(" (" + gemarkung.getNummer() + ")");
            }
        }
        printWriter.println("\\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.print("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {Flur:\\cell ");
        if (DataBase.flur != null) {
            printWriter.print(DataBase.flur);
        }
        printWriter.println("\\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.print("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {Flurst\\'fcck");
        if (DataBase.flurstueck != null) {
            if (DataBase.flurstueck.indexOf(",") > 0) {
                printWriter.print("e");
            }
        }
        printWriter.print(":");
        printWriter.print("\\cell ");
        if (DataBase.flurstueck != null) {
            printWriter.print(RtfIOConstants.getString(DataBase.flurstueck));
        }
        printWriter.println("\\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\cell \\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.print("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {Abbildungskorrektion:\\cell ");
        FlaechenbelegWriter flaechenbelegWriter = this;
        if (flaechenbelegWriter.db.getKooSystem() == 150) {
            printWriter.print("Gau\u00df-Kr\u00fcger");
        } else {
            FlaechenbelegWriter flaechenbelegWriter2 = this;
            if (flaechenbelegWriter2.db.getKooSystem() == 489) {
                printWriter.print("ETRS");
            } else {
                printWriter.print("ohne");
            }
        }
        printWriter.println("\\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.print("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {Lagestatus:\\cell ");
        printWriter.print("000");
        printWriter.println("\\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\cell \\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\trowd \\trgaph70\\trleft-108\\trbrdrt\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\clvertalt\\cltxlrtb \\cellx2880\\clvertalt\\cltxlrtb \\cellx3270\\clvertalt\\cltxlrtb \\cellx3622\\clvertalt\\cltxlrtb \\cellx9104");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {Kennung bei gem. Strecke:\\cell E\\cell =\\cell Eigene Messung\\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\cell K \\cell =\\cell Katasternachweis\\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }\\trowd \\trgaph70\\trleft-108\\trbrdrt\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\clvertalt\\cltxlrtb \\cellx2880\\clvertalt\\cltxlrtb \\cellx9104");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\cell \\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\trowd \\trgaph70\\trleft-108\\trbrdrt\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\clvertalt\\cltxlrtb \\cellx2880\\clvertalt\\cltxlrtb \\cellx3270\\clvertalt\\cltxlrtb \\cellx3622\\clvertalt\\cltxlrtb \\cellx9104");
        printWriter.print("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {Fehlergrenze:\\cell E\\cell =\\cell ");
        printWriter.print(this.getStreckePars(KatasterParameter.E1, KatasterParameter.E2, KatasterParameter.E3, KatasterParameter.EF));
        printWriter.println("\\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.print("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\cell K \\cell =\\cell ");
        printWriter.print(this.getStreckePars(KatasterParameter.A1, KatasterParameter.A2, KatasterParameter.A3, KatasterParameter.AF));
        printWriter.println("\\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\trowd \\trgaph70\\trleft-108\\trbrdrt\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\clvertalt\\cltxlrtb \\cellx2880\\clvertalt\\cltxlrtb \\cellx9104");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\cell \\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\trowd \\trgaph70\\trrh1360\\trleft-108\\trbrdrt\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\clvertalc\\clbrdrt\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\cltxlrtb \\cellx9104");
        printWriter.println("\\pard \\qc\\nowidctlpar\\widctlpar\\intbl\\adjustright {\\b\\fs36 Fl\\'e4chenberechnung\\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\pard \\sb240\\sa240\\nowidctlpar\\widctlpar\\adjustright {\\par }");
        printWriter.println("\\trowd \\trgaph70\\trleft1800 \\clvertalt\\cltxlrtb \\cellx4140\\clvertalt\\clbrdrb\\brdrdash\\brdrw10 \\cltxlrtb \\cellx6480");
        printWriter.println("\\pard \\nowidctlpar\\qc\\widctlpar\\intbl\\adjustright {Berechnet am:\\cell " + this.date + "\\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\trowd \\trgaph70\\trrh1080\\trleft1800 \\clvertalb\\clbrdrb\\brdrdash\\brdrw20 \\cltxlrtb \\cellx6480");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\trowd \\trgaph70\\trleft1800 \\clvertalt\\clbrdrt \\brdrdash\\brdrw20 \\cltxlrtb \\cellx6480");
        printWriter.println("\\pard \\qc\\nowidctlpar\\widctlpar\\intbl\\adjustright {\\fs18 (Unterschrift)\\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\trowd \\trgaph70\\trleft1800 \\clvertalt\\cltxlrtb \\cellx4140\\clvertalt\\cltxlrtb \\cellx6480");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\cell \\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\trowd \\trgaph70\\trleft1800 \\clvertalt\\cltxlrtb \\cellx4140\\clvertalt\\clbrdrb\\brdrdash\\brdrw20 \\cltxlrtb \\cellx6480");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {Gepr\\'fcft am:\\cell \\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\trowd \\trgaph70\\trrh1080\\trleft1800 \\clvertalt\\cltxlrtb \\cellx6480");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\trowd \\trgaph70\\trleft1800 \\clvertalt\\clbrdrt\\brdrdash\\brdrw20 \\cltxlrtb \\cellx6480");
        printWriter.println("\\pard \\qc\\nowidctlpar\\widctlpar\\intbl\\adjustright {\\fs18 (Unterschrift)\\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\trowd \\trgaph70\\trleft1800 \\clvertalt\\cltxlrtb \\cellx4140\\clvertalt\\cltxlrtb \\cellx6480");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\cell \\cell }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\pard \\nowidctlpar\\widctlpar\\adjustright {\\par \\page\\par }}");
    }

    private String getStreckePars(double d, double d2, double d3, double d4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(IFormat.f_3.format(d));
        if (d2 != 0.0) {
            stringBuffer.append(" + ");
            stringBuffer.append(IFormat.f_4.format(d2));
            stringBuffer.append("\\bullet s");
        }
        if (d3 != 0.0) {
            stringBuffer.append(" + ");
            stringBuffer.append(IFormat.f_4.format(d3));
            stringBuffer.append("\\bullet \\u8730\\'76s");
        }
        if (d4 != 1.0) {
            stringBuffer.insert(0, "(");
            stringBuffer.append(") \\bullet ");
            stringBuffer.append(IFormat.f_4.format(d4));
        }
        stringBuffer.append(" m");
        return stringBuffer.toString();
    }

    private void writeFlstName(PrintWriter printWriter, Flurstueck flurstueck) {
        this.writeTableHeader(printWriter, flstRows);
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("\\pard \\widctlpar\\intbl\\adjustright {\\b\\fs20 ");
        if (flurstueck.isNutzstueck()) {
            stringBuffer.append("Nutzung:");
        } else if (flurstueck.isTeilstueck()) {
            stringBuffer.append("Teilst\\'fcck:");
        } else {
            stringBuffer.append("Flurst\\'fcck:");
        }
        stringBuffer.append("\\cell }{\\fs20 ");
        stringBuffer.append(flurstueck.toLongString());
        stringBuffer.append(CELL);
        if (flurstueck.getNutzung() > 0) {
            stringBuffer.append(" N=");
            stringBuffer.append(flurstueck.getNutzungAsString());
        }
        stringBuffer.append(CELL);
        if (flurstueck.getBuchFlaeche() != 0.0) {
            stringBuffer.append(" Buchfl\\'e4che=");
            stringBuffer.append(flurstueck.getBuchFlaecheAsString());
            stringBuffer.append("m\\'b2");
        }
        stringBuffer.append("\\cell }");
        printWriter.println(stringBuffer);
        printWriter.println(ROW_FEATER);
    }

    private void writeLage(PrintWriter printWriter, Flurstueck flurstueck) {
        this.writeTableHeader(printWriter, lageRows);
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("\\pard \\widctlpar\\intbl\\adjustright {\\fs20 \\cell ");
        stringBuffer.append(flurstueck.getStrasseAsString());
        stringBuffer.append(" \\cell ");
        stringBuffer.append(RtfIOConstants.getString(flurstueck.getLageBezeichnung()));
        stringBuffer.append(CELL);
        stringBuffer.append(" }");
        printWriter.println(stringBuffer);
        printWriter.println(ROW_FEATER);
    }

    private void writePunkt(PrintWriter printWriter, Punkt punkt, double d, double d2, char c, double d3) {
        StringBuffer stringBuffer = null;
        if (punkt.isLokalPunkt()) {
            this.writeTableHeader(printWriter, lokPunktRows);
        } else {
            this.writeTableHeader(printWriter, amtPunktRows);
            stringBuffer = new StringBuffer(256);
            stringBuffer.append("\\pard \\qc\\widctlpar\\intbl\\adjustright {\\fs20 ");
            stringBuffer.append(punkt.createNb());
            stringBuffer.append("\\cell ");
            stringBuffer.append(punkt.getNumPa());
            stringBuffer.append("\\cell }");
            printWriter.println(stringBuffer);
        }
        stringBuffer = new StringBuffer(256);
        stringBuffer.append("\\pard \\qr\\widctlpar\\intbl\\adjustright {\\fs20 ");
        stringBuffer.append(punkt.isLokalPunkt() ? punkt.getNr() : punkt.getNr5());
        stringBuffer.append("\\cell ");
        stringBuffer.append(IFormat.f_3.format(punkt.y));
        stringBuffer.append("\\cell ");
        stringBuffer.append(IFormat.f_3.format(punkt.x));
        stringBuffer.append("\\cell ");
        if (d != 0.0) {
            stringBuffer.append(IFormat.f_3.format(d));
        }
        stringBuffer.append("\\cell ");
        if (d2 != 0.0) {
            stringBuffer.append(IFormat.f_3.format(d2));
        }
        stringBuffer.append("\\cell }");
        printWriter.println(stringBuffer);
        stringBuffer = new StringBuffer(256);
        stringBuffer.append("\\pard \\qc\\widctlpar\\intbl\\adjustright {\\fs20 ");
        if (c != '\u0000') {
            stringBuffer.append(c);
        }
        stringBuffer.append("\\cell }");
        printWriter.println(stringBuffer);
        stringBuffer = new StringBuffer(256);
        stringBuffer.append("\\pard \\qr\\widctlpar\\intbl\\adjustright {\\fs20 ");
        if (c != '\u0000') {
            stringBuffer.append(IFormat.f_3.format(d - d2));
        }
        stringBuffer.append("\\cell ");
        if (c != '\u0000') {
            stringBuffer.append(IFormat.f_3.format(this.createGrenzwert(d, c)));
        }
        stringBuffer.append("\\cell ");
        if (d3 != 0.0) {
            stringBuffer.append(IFormat.f_3.format(d3));
        }
        stringBuffer.append("\\cell }");
        printWriter.println(stringBuffer);
        printWriter.println(ROW_FEATER);
    }

    private void writeErgebnis(PrintWriter printWriter, double d, double d2, double d3) {
        this.writeTableHeader(printWriter, ergRows);
        printWriter.println("\\pard \\widctlpar\\intbl\\adjustright {\\fs20 Fl\\'e4che aus Koordinaten:\\cell }");
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("\\pard \\qr\\widctlpar\\intbl\\adjustright {\\fs20 ");
        stringBuffer.append(IFormat.f_2.format(d));
        stringBuffer.append(" m\\'b2\\cell Reduktion:\\cell ");
        stringBuffer.append(IFormat.f_2.format(d2));
        stringBuffer.append(" m\\'b2\\cell }{\\b\\fs20 endg\\'fcltige Fl\\'e4che:\\cell }{\\b\\fs20\\uldb ");
        stringBuffer.append(IFormat.f_2.format(d3));
        stringBuffer.append(" m\\'b2\\cell }");
        printWriter.println(stringBuffer);
        printWriter.println(ROW_FEATER);
    }

    private void writeVorgabeErgebnis(PrintWriter printWriter, String string, int n) {
        this.writeTableHeader(printWriter, ergVorRows);
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("\\pard \\widctlpar\\intbl\\adjustright {\\fs20 ");
        stringBuffer.append(RtfIOConstants.getString(string));
        stringBuffer.append("\\cell }");
        printWriter.println(stringBuffer);
        stringBuffer = new StringBuffer(256);
        stringBuffer.append("\\pard \\qr\\widctlpar\\intbl\\adjustright {\\b\\fs20 ");
        if ((double)n != 0.0) {
            stringBuffer.append("endg\\'fcltige Fl\\'e4che:");
        }
        stringBuffer.append("\\cell }{\\b\\fs20\\uldb ");
        if ((double)n != 0.0) {
            stringBuffer.append(IFormat.i.format(n));
            stringBuffer.append(" m\\'b2");
        }
        stringBuffer.append("\\cell }");
        printWriter.println(stringBuffer);
        printWriter.println(ROW_FEATER);
    }

    private void writeSingleRow(PrintWriter printWriter) {
        this.writeSingleRow(printWriter, null);
    }

    private void writeSingleRow(PrintWriter printWriter, String string) {
        this.writeTableHeader(printWriter, oneRows);
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("\\pard \\qr\\widctlpar\\intbl\\adjustright {\\fs20 ");
        if (string != null) {
            stringBuffer.append(RtfIOConstants.getString(string));
        }
        stringBuffer.append("\\cell }");
        printWriter.println(stringBuffer);
        printWriter.println(ROW_FEATER);
    }

    private double createGrenzwert(double d, char c) {
        if (c == 'K') {
            return KatasterParameter.getKatasterStreckengenauigkeit(d);
        }
        return KatasterParameter.getEigeneStreckengenauigkeit(d);
    }

    private void writeTableHeader(PrintWriter printWriter, int[] nArray) {
        printWriter.println(ROW_HEADER);
        for (int i = 0; i < nArray.length; ++i) {
            StringBuffer stringBuffer = new StringBuffer(40);
            stringBuffer.append("\\cellx");
            stringBuffer.append(nArray[i]);
            if (i < nArray.length - 1) {
                stringBuffer.append("\\clvertalc\\cltxlrtb");
            }
            printWriter.println(stringBuffer);
        }
    }
}

