/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IException;
import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.Gemarkung;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.Nutzung;
import de.geocalc.kafplot.NutzungTable;
import de.geocalc.kafplot.io.FortfuehrungIOProperties;
import de.geocalc.kafplot.io.FortfuehrungWriter;
import de.geocalc.kafplot.io.rtf.RtfIOConstants;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.text.IFormat;
import de.geocalc.util.SortableVector;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class FortfuehrungBrbAlkisWriter
extends FortfuehrungWriter {
    private static final String EOL = "\n";
    private static final String RTF_HEADER = "{\\rtf1\\ansi\\deff0\\deflang1031\n{\\fonttbl\n{\\f0\\fswiss\\fprq2\\fcharset0 Arial Narrow;}\n}\n{\\colortbl;\\red0\\green0\\blue0;\\red230\\green230\\blue230;\\red128\\green128\\blue128;}\n{\\stylesheet\n{\\s1\\aspalpha\\ql\\ltrch\\dbch\\fs24\\snext1\\f0 Normal;}\n{\\s2\\aspalpha\\ql\\ltrch\\dbch\\fs24\\snext2\\f0 Table Contents;}\n}";
    private static final String CONTENT_HEADER = "{\\*\\SeitenDefinition OpenOffice}\n{\\*\\pgdsctbl\n{\\pgdsc0\\pgdscuse195\\pgwsxn11906\\pghsxn16838\\marglsxn1417\\margrsxn567\\margtsxn567\\margbsxn567\\pgdscnxt0 Standard;}\n{\\pgdsc1\\pgdscuse195\\lndscpsxn\\pgwsxn16838\\pghsxn11906\\marglsxn567\\margrsxn567\\margtsxn1417\\margbsxn1417\\footery0\n{\\*\\footeryt283\\footerxl0\\footerxr0\\footeryh566}\n\\pgdscnxt1 Konvert 1;}\n{\\pgdsc2\\pgdscuse195\\pgwsxn11906\\pghsxn16838\\marglsxn1134\\margrsxn567\\margtsxn567\\margbsxn567\\pgdscnxt2 HTML;}\n}\n{\\*\\pgdscno0}\n{\\*\\SeitenDefinition MSWord}\n\\paperh16838\\paperw11906\\margl1417\\margr567\\margt567\\margb567\\sectd\\sbknone\\pgwsxn11906\\pghsxn16838\\marglsxn1417\\margrsxn567\\margtsxn567\\margbsxn567\\ftnbj\\ftnstart1\\ftnrstcont\\ftnnar\\aenddoc\\aftnrstcont\\aftnstart1\\aftnnrlc\n\\pard\\plain \\s1\\qc\\aspalpha\\sa120 {\\ltrch\\f0\\fs16\\i0\\b0 Seite: {\\field{\\*\\fldinst PAGE}{\\fldrslt 1}}}\n\\par";
    private static final String TABLE11 = "{\\*\\Tabelle Kopfzeile}\n\\trowd\\trql\\trpaddft3\\trpaddt55\\trpaddfl3\\trpaddl55\\trpaddfb3\\trpaddb55\\trpaddfr3\\trpaddr55\\cellx567\\clcbpat2\\cellx9355\\cellx9922\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\qc\\ltrch\\f0\\fs16\\i0\\b0 {\\cell grau hinterlegte Felder werden durch die Katasterbeh\\'f6rde erg\\'e4nzt\\cell\\cell}\\row\\pard\n\\pard\\plain \\s1\\ql\\ltrch\\f0\\fs20\n\\par";
    private static final String HEADING11 = "{\\*\\Ueberschrift FF}\n\\pard\\plain \\s1\\qc\\sb480\\sa480\\rtlch\\af5\\afs32\\ab\\ltrch\\dbch\\af3\\hich\\f0\\fs32\\b\\f0\\fs32\\b {\\ltrch\\f0\\fs32\\i0\\b FORTF\\'dcHRUNGSBELEG}\n\\par";
    private static final String TABLE13 = "{\\*\\Tabelle Namen}\n{\\*\\Erste Zeile}\n\\trowd\\trql\\trpaddft3\\trpaddt55\\trpaddfl3\\trpaddl55\\trpaddfb3\\trpaddb55\\trpaddfr3\\trpaddr55\\cellx1106\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\cellx4883\\cellx5042\\clcbpat2\\cellx6318\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clcbpat2\\cellx9922\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\sb113\\ql\\f0\\fs20\\i0\\b0 {aufgestellt:\\cell\\cell\\cell gepr\\'fcft/erg\\'e4nzt:\\cell\\cell}\\row\\pard\n{\\*\\Zweite Zeile}\n\\trowd\\trql\\trpaddft3\\trpaddt55\\trpaddfl3\\trpaddl55\\trpaddfb3\\trpaddb55\\trpaddfr3\\trpaddr55\\cellx1106\\cellx4883\\cellx5042\\clcbpat2\\cellx6318\\clcbpat2\\cellx9922\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\ql\\f0\\fs12\\i0\\b0 {\\cell\\qr (Datum, Unterschrift, Vermessungsstelle)\\cell\\ql\\cell\\cell\\qr (Datum, Unterschrift, Amts- o. Berufsgruppenbezeichnung)\\cell}\\row\\pard";
    private static final String HEADING12 = "{\\*\\Ueberschrift Angaben}\n\\pard\\plain \\s1\\sb164\\sa164\\ql {\\ltrch\\f0\\fs28\\i0\\b Angaben der Fortf\\'fchrungsbearbeitung}\n\\par";
    private static final String TABLE14 = "{\\*\\Tabelle Angaben}\n\\trowd\\trql\\trpaddft3\\trpaddt55\\trpaddfl3\\trpaddl55\\trpaddfb3\\trpaddb55\\trpaddfr3\\trpaddr55\\clcbpat2\\cellx4876\\cellx5045\\clcbpat2\\cellx9922\n\\pard\\intbl\\pard\\plain \\intbl\\s2\\tx227\\sb72\\sa240\\ql\\ltrch\\f0\\fs16\\i0\\b0 1.\\tab Vermessungsschriften sind zur \\'dcbernahme geeignet:\n\\par \\pard\\plain \\intbl\\s2\\tx227\\tlul\\tqr\\tx4638\\sb144\\ql\\ltrch\\f0\\fs16\\i0\\b0 \\tab \\tab \n\\par \\pard\\plain \\intbl\\s2\\tx227\\tqr\\tx4631\\sa28\\ql\\f0\\fs12\\ltrch\\f0\\fs12\\i0\\b0 \\tab \\tab (Datum, Unterschrift, Amts- bzw. Berufsgruppenbezeichnung)\n\\par \\pard\\plain \\intbl\\s2\\tx227\\sb144\\sa240\\ql\\ltrch\\f0\\fs16\\i0\\b0 2.\\tab Ergebnis der Fortf\\'fchrungssimulation gepr\\'fcft:\n\\par \\pard\\plain \\intbl\\s2\\tx227\\tlul\\tqr\\tx4638\\sb142\\ql\\ltrch\\f0\\fs16\\i0\\b0 \\tab \\tab \n\\par \\pard\\plain \\intbl\\s2\\tx227\\tqr\\tx4631\\sa28\\ql\\f0\\fs12\\ltrch\\f0\\fs12\\i0\\b0 \\tab \\tab (Datum, Unterschrift, Amts- bzw. Berufsgruppenbezeichnung)\n\\par \\pard\\plain \\intbl\\s2\\tx227\\sb144\\sa240\\ql\\ltrch\\f0\\fs16\\i0\\b0 3.\\tab Fortf\\'fchrungsentscheidung gem\\'e4\\'df VVFortEnt wird getroffen und bescheinigt:\n\\par \\pard\\plain \\intbl\\s2\\tx227\\tlul\\tqr\\tx4638\\sb142\\ql\\ltrch\\f0\\fs16\\i0\\b0 \\tab \\tab \n\\par \\pard\\plain \\intbl\\s2\\tx227\\tqr\\tx4631\\sa28\\ql\\f0\\fs12\\ltrch\\f0\\fs12\\i0\\b0 \\tab \\tab (Datum, Unterschrift, Amts- bzw. Berufsgruppenbezeichnung)\n\\par \\pard\\plain \\intbl\\s2\\tx227\\sb144\\sa240\\ql\\ltrch\\f0\\fs16\\i0\\b0 4.\\tab ALKIS{\\super \\'ae} fortgef\\'fchrt. (erfolgreiche Absenkung in die ALKIS{\\super \\'ae}-DHK):\n\\par \\pard\\plain \\intbl\\s2\\tx227\\tlul\\tqr\\tx4638\\sb142\\ql\\ltrch\\f0\\fs16\\i0\\b0 \\tab \\tab \n\\par \\pard\\plain \\intbl\\s2\\tx227\\tqr\\tx4631\\sa28\\ql\\f0\\fs12\\ltrch\\f0\\fs12\\i0\\b0 \\tab \\tab (Datum, Unterschrift, Amts- bzw. Berufsgruppenbezeichnung)\n\\cell\\pard\\plain \\intbl\\s2\\ql\n\\cell\\pard\\plain \\intbl\\s2\\tx227\\tlul\\tx1656\\tlul\\tqr\\tx4750\\sb72\\sa142\\ql\\ltrch\\f0\\fs16\\i0\\b0 5.\\tab Fortf\\'fchrungsmitteilungen abgesandt:\n\\par \\pard\\plain \\intbl\\s2\\tlul\\tx1656\\tlul\\tqr\\tx4750\\sb144\\sa144\\ql\\ltrch\\f0\\fs16\\i0\\b0 am: \\tab  an das Grundbuchamt\n\\par \\pard\\plain \\intbl\\s2\\tlul\\tx1656\\tlul\\tqr\\tx4750\\sb144\\sa144\\ql\\ltrch\\f0\\fs16\\i0\\b0 am: \\tab  an: \\tab\n\\par \\pard\\plain \\intbl\\s2\\tlul\\tx1656\\tlul\\tqr\\tx4750\\sb144\\sa144\\ql\\ltrch\\f0\\fs16\\i0\\b0 am: \\tab  an: \\tab\n\\par \\pard\\plain \\intbl\\s2\\tlul\\tx1656\\tlul\\tqr\\tx4750\\sb144\\sa144\\ql\\ltrch\\f0\\fs16\\i0\\b0 am: \\tab  an: \\tab\n\\par \\pard\\plain \\intbl\\s2\\tlul\\tx1656\\tlul\\tqr\\tx4750\\sb144\\sa144\\ql\\ltrch\\f0\\fs16\\i0\\b0 am: \\tab  an: \\tab\n\\par \\pard\\plain \\intbl\\s2\\tlul\\tx1656\\tlul\\tqr\\tx4750\\sb144\\sa144\\ql\\ltrch\\f0\\fs16\\i0\\b0 am: \\tab  an: \\tab\n\\par \\pard\\plain \\intbl\\s2\\tlul\\tx1656\\tlul\\tqr\\tx4750\\sb144\\sa144\\ql\\ltrch\\f0\\fs16\\i0\\b0 am: \\tab  an: \\tab\n\\par \\pard\\plain \\intbl\\s2\\tlul\\tx1656\\tlul\\tqr\\tx4750\\sb144\\sa144\\ql\\ltrch\\f0\\fs16\\i0\\b0 am: \\tab  an: \\tab\n\\cell\\row\\pard \\pard\\plain \\s1\\sb72\\sa72\\ql\\rtlch\\f0\\fs14\n\\par";
    private static final String TABLE15 = "{\\*\\Tabelle Prozesse}\n{\\*\\Erste Zeile}\n\\trowd\\trql\\trpaddft3\\trpaddt55\\trpaddfl3\\trpaddl55\\trpaddfb3\\trpaddb55\\trpaddfr3\\trpaddr55\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clbrdrr\\brdrs\\brdrw10\\brdrcf1\\clcbpat2\\clvertalc\\cellx9922\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\qc\\ab\\f0\\fs24\\i0\\b {\\ltrch\\f0\\fs24\\i0\\b Notwendige Gesch\\'e4ftsprozesse}\\cell\\row\\pard\n{\\*\\Folge Zeilen}\n\\trowd\\trql\\trpaddft3\\trpaddt55\\trpaddfl3\\trpaddl55\\trpaddfb3\\trpaddb55\\trpaddfr3\\trpaddr55\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clcbpat2\\clvertalt\\cellx372\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clcbpat2\\clvertalt\\cellx4703\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clcbpat2\\clvertalt\\cellx4961\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clcbpat2\\clvertalt\\cellx5333\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clcbpat2\\clvertalt\\cellx9664\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clbrdrr\\brdrs\\brdrw10\\brdrcf1\\clcbpat2\\clvertalt\\cellx9922\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\ql\\f0\\fs20\\i0\\b0 {{\\qc GP}\\cell\\cell\\cell{\\qc GP}\\cell\\cell\\cell}\\row\\pard\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\ql\\f0\\fs20\\i0\\b0 {{\\qc 03}\\cell Grenzvermessung\\cell\\cell{\\qc 09}\\cell Topografie und Bauwerke\\cell\\cell}\\row\\pard\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\ql\\f0\\fs20\\i0\\b0 {{\\qc 04}\\cell Verschmelzung oder Zerlegung\\cell\\cell{\\qc 05}\\cell Angaben zum Flurst\\'fcck\\cell\\cell}\\row\\pard\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\ql\\f0\\fs20\\i0\\b0 {{\\qc 17}\\cell Angaben zur Lage\\cell\\cell{\\qc 10}\\cell \\'d6ffentlich-rechtliche Festlegungen\\cell\\cell}\\row\\pard\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\ql\\f0\\fs20\\i0\\b0 {{\\qc 08}\\cell Angaben zu baulichen Anlagen\\cell\\cell{\\qc 11}\\cell Gebietseinheiten\\cell\\cell}\\row\\pard\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\ql\\f0\\fs20\\i0\\b0 {{\\qc 18}\\cell Tats\\'e4chliche Nutzung\\cell\\cell{\\qc 12}\\cell Katasteramtsbezirk\\cell\\cell}\\row\\pard\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\ql\\f0\\fs20\\i0\\b0 {{\\qc 14}\\cell Berichtigung ohne \\'c4nderung FKZ\\cell\\cell{\\qc 01}\\cell Vermessungspunktfeld\\cell\\cell}\\row\\pard\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\ql\\f0\\fs20\\i0\\b0 {{\\qc 15}\\cell Berichtigung mit \\'c4nderung FKZ\\cell\\cell\\cell\\cell\\cell}\\row\\pard\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\ql\\f0\\fs20\\i0\\b0 {{\\qc 13}\\cell \\ul\\'dcbernahme von Verfahren:\\cell\\ul0\\cell\\cell\\ul Homogenisierung:\\cell\\ul0\\cell}\\row\\pard\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\ql\\f0\\fs20\\i0\\b0 {\\cell a) Bodenordnungsma\\'dfnahmen\\cell\\cell\\cell Koordinatentausch ohne Bedingungen\\cell\\cell}\\row\\pard\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\ql\\f0\\fs20\\i0\\b0 {\\cell b) Flurbereinigungsverfahren / LwAnpG\\cell\\cell\\cell Koordinatentausch mit Bedingungen\\cell\\cell}\\row\\pard\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\ql\\f0\\fs20\\i0\\b0 {\\cell c) Verfahren nach Baugesetzbuch\\cell\\cell\\cell Homogenisierung\\cell\\cell}\\row\\pard\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\ql\\f0\\fs20\\i0\\b0 {{\\qc 16}\\cell Verbesserung der geometrischen Lagegenauigkeit der LK\\cell\\cell\\cell\\cell\\cell}\\row\\pard\n\\pard\\plain \\s1\\ql\\sb0\\sa0\\f0\\fs14\n\\par";
    private static final String PAGE2_HEADER = "{\\*\\Zweite Seite}\n{\\*\\pgdscno1}\\sect\\sectd\\lndscpsxn\\pgwsxn16838\\pghsxn11906\\marglsxn567\\margrsxn567\\margtsxn1417\\margbsxn1983\\footery1417\n{\\*\\Fusszeile}\n{\\footer\n\\trowd\\trql\\trpaddft3\\trpaddt0\\trpaddfl3\\trpaddl113\\trpaddfb3\\trpaddb0\\trpaddfr3\\trpaddr113\\cellx2243\\cellx4486\\cellx6730\\cellx8973\\cellx11217\\cellx13460\\cellx15704\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\f0\\fs16\\i0\\b0 {\\b Art der Fl\\'e4chenermittlung:\\cell\\b0 bestimmende Punkte (bP)\\cell grafisch (gra)\\cell proportional (pr)\\cell durch Eingabe (E)\\cell Rest durch Abzug (RdA)\\cell Buchfl\\'e4che (BF)\\cell}\\row\\pard\n\\pard\\plain \\s1\\qc\\sb120\\margtsxn142\\margbsxn566 {\\ltrch\\f0\\fs16\\i0\\b0 Seite: {\\field{\\*\\fldinst PAGE}}}\n\\par }";
    private static final String TABLE21_HEADER = "{\\*\\Tabelle Vor der Fortfuehung}\n{\\*\\Erste Zeile}\n\\trowd\\trql\\trleft0\\trhdr\\trkeep\\trpaddft3\\trpaddt55\\trpaddfl3\\trpaddl55\\trpaddfb3\\trpaddb55\\trpaddfr3\\trpaddr55\\clbrdrt\\brdrs\\brdrw20\\brdrcf1\\clbrdrl\\brdrs\\brdrw20\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx6121\\clbrdrt\\brdrs\\brdrw20\\brdrcf1\\clbrdrl\\brdrs\\brdrw20\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clbrdrr\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx15705\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\ql\\f0\\fs28\\i0\\b0 {Angaben zum Fortf\\'fchrungsfall\\cell Vor der Fortf\\'fchrung\\cell}\\row\\pard\n{\\*\\Zweite Zeile}\n\\trowd\\trql\\trleft0\\trhdr\\trkeep\\trpaddft3\\trpaddt55\\trpaddfl3\\trpaddl55\\trpaddfb3\\trpaddb55\\trpaddfr3\\trpaddr55\\clbrdrl\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx679\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx4307\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx6121\\clbrdrl\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx12357\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrr\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx15705\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\qc\\f0\\fs16\\i0\\b0 {Laufende\\cell Anzahl der\\cell Fl\\'e4chendifferenz\\cell Flurst\\'fcckskennzeichen\\cell Fl\\'e4che\\cell}\\row\\pard\n{\\*\\Dritte Zeile}\n\\trowd\\trql\\trleft0\\trhdr\\trkeep\\trpaddft3\\trpaddt55\\trpaddfl3\\trpaddl55\\trpaddfb3\\trpaddb55\\trpaddfr3\\trpaddr55\\clbrdrl\\brdrs\\brdrw20\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx679\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx2493\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx4307\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx6121\\clbrdrl\\brdrs\\brdrw20\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx12357\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clbrdrr\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx15705\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\qc\\f0\\fs16\\i0\\b0 {Nummer\\cell FM-GBA\\cell FM\\cell m{\\super 2}\\cell (Schl\\'fcssel des Landes - Schl\\'fcssel der Gemarkung - Flur - Flurst\\'fcck)\\cell m{\\super 2}\\cell}\\row\\pard\n{\\*\\Vierte Zeile}\n\\trowd\\trql\\trleft0\\trhdr\\trkeep\\trpaddft3\\trpaddt55\\trpaddfl3\\trpaddl55\\trpaddfb3\\trpaddb55\\trpaddfr3\\trpaddr55\\clbrdrl\\brdrs\\brdrw20\\brdrcf1\\clbrdrb\\brdrdb\\brdrw15\\brdrcf1\\clvertalc\\cellx679\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrdb\\brdrw15\\brdrcf1\\clvertalc\\cellx2493\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrdb\\brdrw15\\brdrcf1\\clvertalc\\cellx4307\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrdb\\brdrw15\\brdrcf1\\clvertalc\\cellx6121\\clbrdrt\\brdrs\\brdrw20\\brdrcf1\\clbrdrl\\brdrs\\brdrw20\\brdrcf1\\clbrdrb\\brdrdb\\brdrw15\\brdrcf1\\clvertalc\\cellx12357\\clbrdrt\\brdrs\\brdrw20\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrdb\\brdrw15\\brdrcf1\\clbrdrr\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx15705\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\qc\\f0\\fs12 {\\f0\\fs12\\i0\\b0 1\\cell 2\\cell 3\\cell 4\\cell 5\\cell 6\\cell}\\row\\pard";
    private static final String TABLE21_DATA_HEADER = "{\\*\\InhaltsZeile}\n\\trowd\\trql\\trleft0\\trkeep\\trpaddft3\\trpaddt57\\trpaddfl3\\trpaddl170\\trpaddfb3\\trpaddb57\\trpaddfr3\\trpaddr170\\clbrdrl\\brdrs\\brdrw20\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx679\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clcbpat2\\clvertalc\\cellx2493\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clcbpat2\\clvertalc\\cellx4307\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clcbpat2\\clvertalc\\cellx6121\\clbrdrl\\brdrs\\brdrw20\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx12357\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clbrdrr\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx15705";
    private static final String TABLE21_FEATER = "{\\*\\TabEnde LeerZeile}\n\\trowd\\trql\\trleft0\\trkeep\\trpaddft3\\trpaddt57\\trpaddfl3\\trpaddl170\\trpaddfb3\\trpaddb57\\trpaddfr3\\trpaddr170\\clbrdrl\\brdrs\\brdrw20\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx679\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clcbpat2\\clvertalc\\cellx2493\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clcbpat2\\clvertalc\\cellx4307\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clcbpat2\\clvertalc\\cellx6121\\clbrdrl\\brdrs\\brdrw20\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx12357\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clbrdrr\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx15705\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\qc\\f0\\fs22 {\\cell\\cell\\cell\\qr\\cell\\ql\\cell\\qr\\cell}\\row\\pard\n\\pard\\plain \\s1\\ql\\f0\\fs22\n\\par";
    private static final String TABLE22_HEADER = "{\\*\\Tabelle Nach der Fortfuehung}\n{\\*\\Erste Zeile}\n\\trowd\\trql\\trhdr\\trkeep\\trpaddft3\\trpaddt55\\trpaddfl3\\trpaddl55\\trpaddfb3\\trpaddb55\\trpaddfr3\\trpaddr55\\clbrdrt\\brdrs\\brdrw20\\brdrcf1\\clbrdrl\\brdrs\\brdrw20\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clbrdrr\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx15704\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\ql\\f0\\fs28 {\\f0\\fs28\\i0\\b0 Nach der Fortf\\'fchrung}\n\\cell\\row\\pard \\trowd\\trql\\trhdr\\trkeep\\trpaddft3\\trpaddt55\\trpaddfl3\\trpaddl55\\trpaddfb3\\trpaddb55\\trpaddfr3\\trpaddr55\\clbrdrt\\brdrs\\brdrw20\\brdrcf1\\clbrdrl\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx660\\clbrdrt\\brdrs\\brdrw20\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx4110\\clbrdrt\\brdrs\\brdrw20\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx5190\\clbrdrt\\brdrs\\brdrw20\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx9323\\clbrdrt\\brdrs\\brdrw20\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx10320\\clbrdrt\\brdrs\\brdrw20\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx11318\\clbrdrt\\brdrs\\brdrw20\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx12488\\clbrdrt\\brdrs\\brdrw20\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx13209\\clbrdrt\\brdrs\\brdrw20\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrr\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx15704\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\qc\\f0\\fs16\\i0\\b0 {\\cell Flurst\\'fcckskennzeichen\\cell vorl\\'e4ufige\\cell Lagebezeichnung, Hausnummer\\cell TN\\cell Klassifizierung\\cell endg\\'fcltige\\cell Art der\\cell Bemerkung\\cell}\\row\\pard\n{\\*\\Zweite Zeile}\n\\trowd\\trql\\trhdr\\trkeep\\trpaddft3\\trpaddt55\\trpaddfl3\\trpaddl55\\trpaddfb3\\trpaddb55\\trpaddfr3\\trpaddr55\\clbrdrl\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx660\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx2016\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx4110\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx5190\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx8325\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx9323\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx10320\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx11318\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx12488\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx13209\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrr\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx15704\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\qc\\f0\\fs16\\i0\\b0 {zu lfd.\\cell Land - Schl\\'fcssel\\cell Flurst\\'fccksnummer\\cell Fl\\'e4che Flurst\\'fcck\\cell\\cell\\cell\\cell Kennung und\\cell Fl\\'e4che\\cell Fl\\'e4chen-\\cell\\cell}\\row\\pard\n{\\*\\Dritte Zeile}\n\\trowd\\trql\\trhdr\\trkeep\\trpaddft3\\trpaddt55\\trpaddfl3\\trpaddl55\\trpaddfb3\\trpaddb55\\trpaddfr3\\trpaddr55\\clbrdrl\\brdrs\\brdrw20\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx660\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx2016\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx3028\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx4110\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx5190\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx8325\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx9323\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx10320\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx11318\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx12488\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx13209\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clbrdrr\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx15704\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\qc\\f0\\fs16\\i0\\b0 {Nr.\\cell Gemarkung-Flur\\cell vorl\\'e4ufig\\cell endg\\'fcltig\\cell m{\\super 2}\\cell Name der Stra\\'dfe, Hausnummer\\cell Str.-Schl\\'fcssel\\cell Schl\\'fcssel\\cell Schl\\'fcssel\\cell m{\\super 2}\\cell ermittlung\\cell\\cell}\\row\\pard\n{\\*\\Vierte Zeile}\n\\trowd\\trql\\trhdr\\trkeep\\trpaddft3\\trpaddt55\\trpaddfl3\\trpaddl55\\trpaddfb3\\trpaddb55\\trpaddfr3\\trpaddr55\\clbrdrl\\brdrs\\brdrw20\\brdrcf1\\clbrdrb\\brdrdb\\brdrw15\\brdrcf1\\clvertalc\\cellx660\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrdb\\brdrw15\\brdrcf1\\clvertalc\\cellx2016\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrdb\\brdrw15\\brdrcf1\\clvertalc\\cellx3028\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrdb\\brdrw15\\brdrcf1\\clvertalc\\cellx4110\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrdb\\brdrw15\\brdrcf1\\clvertalc\\cellx5190\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrdb\\brdrw15\\brdrcf1\\clvertalc\\cellx8325\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrdb\\brdrw15\\brdrcf1\\clvertalc\\cellx9323\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrdb\\brdrw15\\brdrcf1\\clvertalc\\cellx10320\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrdb\\brdrw15\\brdrcf1\\clvertalc\\cellx11318\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrdb\\brdrw15\\brdrcf1\\clvertalc\\cellx12488\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrdb\\brdrw15\\brdrcf1\\clvertalc\\cellx13209\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrdb\\brdrw15\\brdrcf1\\clbrdrr\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx15704\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\qc {\\f0\\fs12\\i0\\b0 7\\cell 8\\cell 9\\cell 10\\cell 11\\cell 12\\cell 13\\cell 14\\cell 15\\cell 16\\cell 17\\cell 18\\cell}\\row\\pard";
    private static final String TABLE22_DATA_HEADER = "{\\*\\InhaltsZeile}\n\\trowd\\trql\\trkeep\\trpaddft3\\trpaddt55\\trpaddfl3\\trpaddl55\\trpaddfb3\\trpaddb55\\trpaddfr3\\trpaddr55\\clbrdrl\\brdrs\\brdrw20\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx660\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx2016\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx3028\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clcbpat2\\clvertalc\\cellx4110\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx5190\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx8325\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx9323\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx10320\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx11318\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clcbpat2\\clvertalc\\cellx12488\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx13209\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clbrdrr\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx15704";
    private static final String TABLE22_FEATER = "{\\*\\TabEnde LeerZeile}\n\\trowd\\trql\\trkeep\\trpaddft3\\trpaddt55\\trpaddfl3\\trpaddl55\\trpaddfb3\\trpaddb55\\trpaddfr3\\trpaddr55\\clbrdrl\\brdrs\\brdrw20\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx660\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx2016\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx3028\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clcbpat2\\clvertalc\\cellx4110\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx5190\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx8325\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx9323\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx10320\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx11318\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clcbpat2\\clvertalc\\cellx12488\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx13209\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw20\\brdrcf1\\clbrdrr\\brdrs\\brdrw20\\brdrcf1\\clvertalc\\cellx15704\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\qc\\f0\\fs22\\i0\\b0 {\\cell\\cell\\cell\\cell\\qr\\cell\\ql\\cell\\qc\\cell\\cell\\cell\\qr\\cell\\qc\\cell\\ql\\cell}\\row\\pard\n\\pard\\plain \\s1\\ql\\f0\\fs22\n\\par";
    private static final String RTF_FEATER = "}";

    public FortfuehrungBrbAlkisWriter(File file, DataBase dataBase) {
        super(file, dataBase);
    }

    @Override
    public void write() throws IFileOutputException {
        int n = 0;
        super.setEndValue(this.FLST.size());
        super.setProgressBreak();
        this.checkDatVars();
        PrintWriter printWriter = null;
        boolean bl = false;
        try {
            String string = this.outFile.getAbsolutePath();
            int n2 = -1;
            int n3 = -1;
            int n4 = DataBase.FLST.countFortfuehrungFluren();
            for (int i = 0; i < n4; ++i) {
                Object object;
                Object object2;
                Flurstueck flurstueck;
                Object object3 = DataBase.FLST.elements();
                while (object3.hasMoreElements()) {
                    Flurstueck flurstueck2 = (Flurstueck)object3.nextElement();
                    if (flurstueck2.getGemarkung() <= n2 && (flurstueck2.getGemarkung() != n2 || flurstueck2.getFlur() <= n3)) continue;
                    n2 = flurstueck2.getGemarkung();
                    n3 = flurstueck2.getFlur();
                    if (DataBase.FLST.countFaelle(n2, n3) <= 0) continue;
                }
                if (n4 <= 1) {
                    printWriter = this.createWriter();
                } else {
                    object3 = new StringBuffer(string);
                    printWriter = this.createWriter(new File(((StringBuffer)object3).insert(string.lastIndexOf("."), "." + n2 + "-" + IFormat.i03.format(n3)).toString()));
                }
                object3 = DataBase.FLST.getStammstueckeFrom(n2, n3);
                n = 0;
                super.setLabelText("Fortf\u00fchrungsbeleg(" + (i + 1) + ") erstellen...");
                super.setEndValue(((Vector)object3).size() * 1);
                super.setProgressBreak();
                int n5 = 0;
                printWriter.println(RTF_HEADER);
                printWriter.println(CONTENT_HEADER);
                printWriter.println(TABLE11);
                this.writeBelegHeader(printWriter, n2, n3);
                printWriter.println(HEADING11);
                printWriter.println(TABLE13);
                printWriter.println(HEADING12);
                printWriter.println(TABLE14);
                printWriter.println(TABLE15);
                printWriter.println(PAGE2_HEADER);
                bl = false;
                printWriter.println(TABLE21_HEADER);
                printWriter.println(TABLE21_DATA_HEADER);
                n5 = 0;
                Enumeration enumeration = ((Vector)object3).elements();
                while (enumeration.hasMoreElements()) {
                    flurstueck = (Flurstueck)enumeration.nextElement();
                    if (flurstueck.isStammstueck() && flurstueck.isFortfuehrung()) {
                        ++n5;
                        if (flurstueck.isVereinigungStammstueck()) {
                            object2 = this.FLST.getVereinigungTeilstueckeFrom(flurstueck);
                            for (int j = 0; j < ((Vector)object2).size(); ++j) {
                                object = (Flurstueck)((Vector)object2).elementAt(j);
                                this.writeVorFortf(printWriter, (Flurstueck)object, j == 0 ? n5 : 0);
                            }
                        } else {
                            this.writeVorFortf(printWriter, flurstueck, n5);
                        }
                        if ((long)n % super.getProgressBreak() == 0L) {
                            super.setProgress(n);
                        }
                    }
                    ++n;
                }
                printWriter.println(TABLE21_FEATER);
                enumeration = null;
                flurstueck = null;
                n5 = 0;
                printWriter.println(TABLE22_HEADER);
                printWriter.println(TABLE22_DATA_HEADER);
                object2 = ((Vector)object3).elements();
                while (object2.hasMoreElements()) {
                    Flurstueck flurstueck3 = (Flurstueck)object2.nextElement();
                    if (flurstueck3.isFortfuehrung() && flurstueck3.isStammstueck()) {
                        Object object4;
                        int n6;
                        Vector vector;
                        ++n5;
                        object = null;
                        if (flurstueck3.isVereinigungStammstueck()) {
                            vector = DataBase.FLST.getVereinigungTeilstueckeFrom(flurstueck3);
                            StringBuffer stringBuffer = new StringBuffer();
                            for (n6 = 0; n6 < vector.size(); ++n6) {
                                object4 = (Flurstueck)vector.elementAt(n6);
                                if (n6 != 0) {
                                    stringBuffer.append(", ");
                                }
                                stringBuffer.append(((Flurstueck)object4).getNummer());
                            }
                            object = stringBuffer.toString();
                        } else {
                            object = null;
                        }
                        if (!flurstueck3.hasTeile()) {
                            this.writeNachFortf(printWriter, flurstueck3, (String)(object != null ? object : flurstueck3.toMiniString()), flurstueck3.getVorgabeNummer(), n5, true, 0);
                        } else {
                            vector = this.FLST.getTeilstueckeFrom(flurstueck3);
                            boolean bl2 = true;
                            n6 = 0;
                            object4 = vector.elements();
                            while (object4.hasMoreElements()) {
                                Flurstueck flurstueck4 = (Flurstueck)object4.nextElement();
                                if (flurstueck4.isStammTeilstueck()) {
                                    Vector vector2 = this.FLST.getNutzstueckeFrom(flurstueck4);
                                    Flurstueck flurstueck5 = null;
                                    int n7 = 0;
                                    if (FortfuehrungIOProperties.writeEndArea()) {
                                        int n8 = 0;
                                        double d = 0.0;
                                        Enumeration enumeration2 = vector2.elements();
                                        while (enumeration2.hasMoreElements()) {
                                            Flurstueck flurstueck6 = (Flurstueck)enumeration2.nextElement();
                                            if (flurstueck3.getGeoFlaeche() > d) {
                                                flurstueck5 = flurstueck6;
                                                d = flurstueck3.getGeoFlaeche();
                                            }
                                            n8 += (int)Math.rint(flurstueck6.getGeoFlaeche());
                                        }
                                        n7 = (int)Math.rint(flurstueck4.getGeoFlaeche()) - n8;
                                        if (Math.abs(n7) > 1) {
                                            flurstueck5 = null;
                                            this.addException(new IException("Fehler beim Verteilen der Rundungsdifferenzen bei " + flurstueck4.getExceptionableName() + ", Fl\u00e4chendifferenz von " + n7 + "m\u02db wird nicht angebracht"));
                                            n7 = 0;
                                        }
                                    }
                                    Enumeration enumeration3 = vector2.elements();
                                    while (enumeration3.hasMoreElements()) {
                                        Flurstueck flurstueck7 = (Flurstueck)enumeration3.nextElement();
                                        this.writeNachFortf(printWriter, flurstueck7, (String)(object != null ? (String)object + " " + flurstueck4.getTeilAsString() : flurstueck4.toMiniString()), flurstueck4.getVorgabeNummer(), n5, bl2, flurstueck7 == flurstueck5 ? n7 : 0);
                                        bl2 = false;
                                    }
                                    this.writeNachFortf(printWriter, flurstueck4, null, null, n5, bl2, 0);
                                    bl2 = false;
                                } else {
                                    this.writeNachFortf(printWriter, flurstueck4, (String)(object != null ? (String)object + " " + flurstueck4.getTeilAsString() : flurstueck4.toMiniString()), flurstueck4.isNutzstueck() ? flurstueck3.getVorgabeNummer() : flurstueck4.getVorgabeNummer(), n5, bl2, 0);
                                    bl2 = false;
                                }
                                n6 += (int)Math.rint(flurstueck4.getGeoFlaeche());
                            }
                            int n9 = 0;
                            if (FortfuehrungIOProperties.writeEndArea() && Math.abs(n9 = n6 - (int)Math.rint(flurstueck3.getGeoFlaeche())) > 1) {
                                this.addException(new IException("Fehler beim Verteilen der Rundungsdifferenzen bei " + flurstueck3.getExceptionableName() + ", Fl\u00e4chendifferenz von " + n9 + "m\u02db wird nicht angebracht"));
                                n9 = 0;
                            }
                            this.writeNachFortf(printWriter, flurstueck3, null, null, n5, false, n9);
                            if (FortfuehrungIOProperties.writeVoidLine()) {
                                this.writeNachFortfVoidLine(printWriter);
                            }
                        }
                        if ((long)n % super.getProgressBreak() == 0L) {
                            super.showProgress(n);
                        }
                    }
                    ++n;
                }
                printWriter.println(TABLE22_FEATER);
                printWriter.println(RTF_FEATER);
                printWriter.close();
            }
        }
        catch (IOException iOException) {
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
    }

    private void writeBelegHeader(PrintWriter printWriter, int n, int n2) {
        Object object = null;
        String string = null;
        Gemarkung gemarkung = Gemarkung.getGemarkung(n);
        if (gemarkung != null) {
            object = gemarkung.getName() + " (" + gemarkung.getNummerAsString() + ")";
            Gemeinde gemeinde = gemarkung.getGemeinde();
            String string2 = string = gemeinde != null ? gemeinde.getName() : "";
        }
        if (object == null) {
            this.addException(new IException("keine Gemarkungsname f\u00fcr die Gemarkung: " + GeoNumberFormat.nr.format(n).toString() + " gefunden.", "\u00dcberpr\u00fcfen Sie die Einstellungen in der Konfigurationsdatei: \"gemarkungen.properties\"."));
            object = DataBase.gemarkung != null ? DataBase.gemarkung : "";
            string = DataBase.gemeinde != null ? DataBase.gemeinde : "";
        }
        printWriter.println("{\\*\\Tabelle Antrag}");
        printWriter.println("{\\*\\Erste Zeile}");
        printWriter.println("\\trowd\\trql\\trpaddft3\\trpaddt55\\trpaddfl3\\trpaddl55\\trpaddfb3\\trpaddb55\\trpaddfr3\\trpaddr55\\cellx9922");
        printWriter.println("\\pard\\intbl\\pard\\plain \\intbl\\s1\\tx4983\\tlul\\tx9864\\sb113\\ql\\rtlch\\afs20\\ltrch\\dbch\\af3\\hich\\f0\\fs20\\f0\\fs20 {\\ltrch\\f0\\fs20\\i0\\b0 Katasterbeh\\'f6rde des Landkreises / der kreisfreien Stadt:\\tab " + (DataBase.katasterAmt != null ? FortfuehrungBrbAlkisWriter.getRtfString(DataBase.katasterAmt) : "") + "}\\cell\\row\\pard");
        printWriter.println("{\\*\\Folge Zeilen}");
        printWriter.println("\\trowd\\trql\\trpaddft3\\trpaddt55\\trpaddfl3\\trpaddl55\\trpaddfb3\\trpaddb55\\trpaddfr3\\trpaddr55\\cellx1106\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\cellx4884\\cellx5045\\clcbpat2\\cellx7086\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clcbpat2\\cellx9922");
        printWriter.println("\\pard\\intbl\\pard\\plain \\intbl\\s1\\sb113\\ql\\ltrch\\f0\\fs20\\i0\\b0 {Gemeinde:\\cell " + FortfuehrungBrbAlkisWriter.getRtfString(string) + "\\cell\\cell Jahrgang:\\cell\\cell}\\row\\pard");
        printWriter.println("\\pard\\intbl\\pard\\plain \\intbl\\s1\\sb113\\ql\\ltrch\\f0\\fs20\\i0\\b0 {Gemarkung:\\cell " + FortfuehrungBrbAlkisWriter.getRtfString((String)object) + "\\cell\\cell Fortf\\'fchrungsnachweisnr.:\\cell\\cell}\\row\\pard");
        printWriter.println("\\pard\\intbl\\pard\\plain \\intbl\\s1\\sb113\\ql\\ltrch\\f0\\fs20\\i0\\b0 {Flur:\\cell " + Integer.toString(n2) + "\\cell\\cell OK Gesch\\'e4ftsbuch:\\cell\\cell}\\row\\pard");
        printWriter.println("{\\*\\Letzte Zeile}");
        printWriter.println("\\trowd\\trql\\trpaddft3\\trpaddt55\\trpaddfl3\\trpaddl55\\trpaddfb3\\trpaddb55\\trpaddfr3\\trpaddr55\\cellx1106\\cellx4884\\cellx5045\\clcbpat2\\cellx7086\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clcbpat2\\cellx9922");
        printWriter.println("\\pard\\intbl\\pard\\plain \\intbl\\s1\\sb113\\ql\\ltrch\\f0\\fs20\\i0\\b0 {\\cell\\cell\\cell ALKIS-Antragskennz.:\\cell " + FortfuehrungBrbAlkisWriter.getRtfString(DataBase.antrag) + "\\cell}\\row\\pard");
    }

    private void writeVorFortf(PrintWriter printWriter, Flurstueck flurstueck, int n) {
        printWriter.print("\\pard\\intbl\\pard\\plain \\intbl\\s1\\qc\\f0\\fs22 {");
        printWriter.print(n != 0 ? Integer.toString(n) : "");
        printWriter.print("\\cell\\cell\\cell\\qr\\cell\\ql ");
        int n2 = flurstueck.getGemarkung();
        printWriter.print(n2 / 10000);
        printWriter.print(" - ");
        printWriter.print(IFormat.i04.format(n2 % 10000));
        printWriter.print(" - ");
        printWriter.print(IFormat.i03.format(flurstueck.getFlur()));
        printWriter.print(" - ");
        printWriter.print(flurstueck.getZaehler());
        if (flurstueck.getNenner() > 0) {
            printWriter.print("/");
            printWriter.print(flurstueck.getNenner());
        }
        printWriter.print("\\cell\\qr ");
        printWriter.print(flurstueck.getBuchFlaecheAsString());
        printWriter.print("\\cell}\\row\\pard");
    }

    private void writeNachFortf(PrintWriter printWriter, Flurstueck flurstueck, String string, String string2, int n, boolean bl, int n2) {
        printWriter.print("\\pard\\intbl\\pard\\plain \\intbl\\s1\\qc\\f0\\fs22\\i0\\b0 {");
        if (bl) {
            printWriter.print(Integer.toString(n));
            printWriter.print("\\cell ");
            int n3 = flurstueck.getGemarkung();
            printWriter.print(n3 / 10000);
            printWriter.print("-");
            printWriter.print(IFormat.i04.format(n3 % 10000));
            printWriter.print("-");
            printWriter.print(IFormat.i03.format(flurstueck.getFlur()));
            printWriter.print("\\cell");
        } else {
            printWriter.print("\\cell");
            printWriter.print("\\cell");
        }
        if (flurstueck.hasTeile()) {
            printWriter.print("\\cell");
            printWriter.print("\\cell");
        } else if (FortfuehrungIOProperties.writeEndNummer()) {
            printWriter.print(" ");
            printWriter.print(string != null ? string : "");
            printWriter.print("\\cell");
            printWriter.print(" ");
            printWriter.print(string2 != null ? string2 : "");
            printWriter.print("\\cell");
        } else {
            printWriter.print(" ");
            if (string2 != null) {
                printWriter.print(string2);
            } else if (string != null) {
                printWriter.print(string);
            } else {
                printWriter.print("");
            }
            printWriter.print("\\cell");
            printWriter.print("\\cell");
        }
        printWriter.print("\\qr");
        if (flurstueck.isStammTeilstueck()) {
            printWriter.print("\\ul");
        } else if (flurstueck.isStammstueck() && flurstueck.hasTeile()) {
            printWriter.print("\\uldb");
        }
        printWriter.print(" ");
        if (FortfuehrungIOProperties.writeEndNummer()) {
            if (flurstueck.getGeoFlaeche() > 0.0) {
                printWriter.print("" + ((int)Math.rint(flurstueck.getGeoFlaeche()) + n2));
            } else {
                printWriter.print(flurstueck.getRoundedFlaecheAsString());
            }
        } else {
            printWriter.print(flurstueck.getRoundedFlaecheAsString());
        }
        printWriter.print("\\cell\\ul0");
        printWriter.print("\\ql ");
        printWriter.print(RtfIOConstants.getString(flurstueck.getLageBezeichnungAsString()));
        printWriter.print("\\cell\\qc ");
        printWriter.print(flurstueck.hasStrasse() ? flurstueck.getStrasseAsString() : "");
        printWriter.print("\\cell\\qc ");
        try {
            if (!flurstueck.isStammstueck() || !flurstueck.hasTeile()) {
                printWriter.print(this.getNutzungenString(flurstueck, DataBase.NUTZ));
            }
        }
        catch (Exception exception) {
            this.addException(exception);
        }
        printWriter.print("\\cell\\qc ");
        printWriter.print("\\cell");
        printWriter.print("\\qr");
        if (flurstueck.isStammstueck() && flurstueck.hasTeile()) {
            printWriter.print("\\uldb ");
        }
        if (FortfuehrungIOProperties.writeEndNummer() || FortfuehrungIOProperties.writeEndArea()) {
            printWriter.print(" ");
            printWriter.print(flurstueck.getRoundedFlaecheAsString());
        }
        printWriter.print("\\cell");
        printWriter.print("\\ul0\\qc ");
        if (!flurstueck.isStammstueck() || !flurstueck.hasTeile()) {
            printWriter.print(this.createBerString(flurstueck.getBerechnungsArt()));
        }
        printWriter.print("\\cell");
        printWriter.print("\\ql ");
        if (flurstueck.getRoundedFlaeche() == 0) {
            printWriter.print("Fl=" + GeoNumberFormat.m02.format(flurstueck.getFlaeche()).toString() + "m\\'b2 ");
        }
        if (flurstueck.isStammstueck() && FortfuehrungIOProperties.writeEndArea()) {
            this.writeAreaDiff(printWriter, (int)Math.rint(flurstueck.getBuchFlaeche()), flurstueck.getRoundedFlaeche());
        }
        if (FortfuehrungIOProperties.writeEndArea() && flurstueck.getBerechnungsArt() >= 10) {
            int n4 = (int)Math.rint(flurstueck.getGeoFlaeche());
            int n5 = n4 - flurstueck.getRoundedFlaeche();
            if (!FortfuehrungIOProperties.writeEndNummer() && n5 != 0) {
                printWriter.print(RtfIOConstants.getString("Istfl\u00e4che: ") + flurstueck.getGeoFlaecheAsString() + "m\\'b2 ");
            }
            this.writeAreaDiff(printWriter, flurstueck.getRoundedFlaeche(), (int)Math.rint(flurstueck.getGeoFlaeche()));
        }
        printWriter.print("\\cell");
        printWriter.println("}\\row\\pard");
    }

    private void writeNachFortfVoidLine(PrintWriter printWriter) {
        printWriter.println("\\pard\\intbl\\pard\\plain \\intbl\\s1\\qc\\f0\\fs22\\i0\\b0 {\\cell\\cell\\cell\\cell\\qr\\cell\\ql\\cell\\qc\\cell\\cell\\cell\\qr\\cell\\qc\\cell\\ql\\cell}\\row\\pard");
    }

    private String getNutzungenString(Flurstueck flurstueck, NutzungTable nutzungTable) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = this.getNutzungen(flurstueck, nutzungTable);
        if (vector.size() == 0) {
            throw new Exception(String.valueOf(flurstueck) + " hat keine Nutzungsart");
        }
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Nutzung nutzung = (Nutzung)enumeration.nextElement();
            int n2 = nutzung.getArt();
            if (n2 == n) continue;
            n = n2;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(n2);
        }
        return stringBuffer.toString();
    }

    private Vector getNutzungen(Flurstueck flurstueck, NutzungTable nutzungTable) {
        double d = flurstueck.getGeoFlaeche();
        SortableVector sortableVector = new SortableVector();
        Enumeration enumeration = flurstueck.intersectObjects(nutzungTable.elements()).elements();
        while (enumeration.hasMoreElements()) {
            Nutzung nutzung = (Nutzung)enumeration.nextElement();
            double d2 = nutzung.getPolygonFlaeche() * DataBase.getFlaecheMasstab(nutzung.y);
            if (!(d2 > FortfuehrungIOProperties.getIntersectMinAbsArea()) && !(d2 * 100.0 / d > FortfuehrungIOProperties.getIntersectMinPercArea())) continue;
            sortableVector.addElement(nutzung);
        }
        sortableVector.sort(Nutzung.getDefaultComparator());
        return sortableVector;
    }

    private void writeAreaDiff(PrintWriter printWriter, int n, int n2) {
        int n3 = n2 - n;
        if (n3 != 0) {
            double d;
            printWriter.print("(");
            if (n3 > 0) {
                printWriter.print("+");
            }
            printWriter.print(n3 + "m\\'b2");
            if (FortfuehrungIOProperties.writeAreaDiffMessage() && Math.abs(d = 100.0 * (double)n3 / (double)n) > FortfuehrungIOProperties.getAreaDiff()) {
                printWriter.print(((double)n3 > 0.5 ? " : +" : " : ") + (int)Math.rint(d) + "%");
            }
            printWriter.print(")");
        }
    }

    private String createBerString(int n) {
        switch (n) {
            case 2: {
                return "RdA";
            }
            case 3: 
            case 4: 
            case 13: 
            case 14: {
                return "gra";
            }
            case 5: 
            case 10: 
            case 15: {
                return "E";
            }
            case 6: 
            case 16: {
                return "bP";
            }
            case 0: {
                return "ohne";
            }
            case 1: {
                return "BF";
            }
        }
        return "ohne";
    }
}

