/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.Gemarkung;
import de.geocalc.kafplot.NutzungsArt;
import de.geocalc.kafplot.io.FortfuehrungWriter;
import de.geocalc.kafplot.io.rtf.RtfIOConstants;
import de.geocalc.text.IFormat;
import de.geocalc.text.StringList;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class FortfuehrungNrwWriter
extends FortfuehrungWriter {
    private int[] lx = new int[]{794, 2101, 2782, 3464, 4145, 4943, 6250, 6931, 7613, 8294, 8976, 9657, 10318};
    private static final String EOL = "\n";
    private static final String TAB = "\\tab";
    private static final String RTF_HEADER = "{\\rtf1\\ansi\\ansicpg1252\\uc1 \\deff0\\deflang1033\\deflangfe1031\n{\\fonttbl{\\f0\\froman\\fcharset0\\fprq2 Times New Roman;}}\n{\\colortbl;\\red0\\green0\\blue0;\\red0\\green0\\blue255;\\red0\\green255\\blue255;\\red0\\green255\\blue0;\\red255\\green0\\blue255;\\red255\\green0\\blue0;\\red255\\green255\\blue0;\\red255\\green255\\blue255;\\red0\\green0\\blue128;\\red0\\green128\\blue128;\\red0\\green128\\blue0;\\red128\\green0\\blue128;\\red128\\green0\\blue0;\\red128\\green128\\blue0;\\red128\\green128\\blue128;\\red192\\green192\\blue192;}\n{\\stylesheet\n{\\nowidctlpar\\adjustright \\cf1\\lang255 \\snext0 Normal;}\n{\\*\\cs10 \\additive Default Paragraph Font;}\n{\\s15\\sa120\\nowidctlpar\\adjustright \\cf1\\lang255 \\sbasedon0 \\snext15 Body Text;}\n{\\s16\\sa120\\nowidctlpar\\adjustright \\cf1\\lang255 \\sbasedon15 \\snext16 Tabellen Inhalt;}\n{\\s17\\qc\\sa120\\nowidctlpar\\adjustright \\b\\i\\cf1\\lang255 \\sbasedon16 \\snext17 Tabellen \\'dcberschrift;}\n{\\s18\\nowidctlpar\\tqc\\tx4818\\tqr\\tx9637\\adjustright \\sbasedon0 \\snext18 header;}\n{\\s19\\nowidctlpar\\tqc\\tx4818\\tqr\\tx9637\\adjustright \\sbasedon0 \\snext19 footer;}}\n{\\info{\\author GeoCalc}{\\version2}{\\edmins0}{\\nofpages1}{\\nofwords50}{\\nofchars288}{\\nofcharsws353}{\\vern113}}\n\\paperw11906\\paperh16838\\margl1134\\margr454\\margt1134\\margb1406 \\deftab1250\\widowctrl\\ftnbj\\aenddoc\\hyphhotz425\\hyphcaps0\\viewkind1\\viewscale150 \\fet0 \\sectd \\sbknone\\linex0\\headery709\\footery709\\colsx709\\sectdefaultcl\n{\\header \\pard\\plain \\s18\\nowidctlpar\\tqc\\tx4818\\tqr\\tx9637\\adjustright {\\par }}\n{\\footer \\pard\\plain \\s19\\nowidctlpar\\tqc\\tx4818\\tqr\\tx9637\\adjustright {\\par }}\n{\\*\\pnseclvl1\\pnucrm\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}\n{\\*\\pnseclvl2\\pnucltr\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}\n{\\*\\pnseclvl3\\pndec\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}\n{\\*\\pnseclvl4\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxta )}}\n{\\*\\pnseclvl5\\pndec\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}\n{\\*\\pnseclvl6\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}\n{\\*\\pnseclvl7\\pnlcrm\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}\n{\\*\\pnseclvl8\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}\n{\\*\\pnseclvl9\\pnlcrm\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}";
    private static final String CELL_RAHMEN = "\\clvertalt\\clbrdrl\\brdrs\\brdrw5\\brdrcf1 \\clbrdrb\\brdrs\\brdrw5\\brdrcf1 ";
    private static final String END_OF_FILE = "\\pard \\nowidctlpar\\adjustright {\\fs20 \\par }}\n";

    public FortfuehrungNrwWriter(File file, DataBase dataBase) {
        super(file, dataBase);
    }

    @Override
    public void write() throws IFileOutputException {
        int n = 0;
        super.setEndValue(this.FLST.size());
        super.setProgressBreak();
        PrintWriter printWriter = null;
        try {
            String string = this.outFile.getAbsolutePath();
            int n2 = -1;
            int n3 = -1;
            int n4 = 0;
            int n5 = DataBase.FLST.countFluren();
            Enumeration enumeration = DataBase.FLST.elements();
            while (enumeration.hasMoreElements()) {
                Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
                if (!flurstueck.isFortfuehrung() || !flurstueck.isStammstueck()) continue;
                if (flurstueck.getGemarkung() > n2 || flurstueck.getFlur() > n3) {
                    Flurstueck flurstueck2;
                    Object object;
                    n2 = flurstueck.getGemarkung();
                    n3 = flurstueck.getFlur();
                    printWriter = n5 > 1 ? this.createWriter(new File(new StringBuffer(string).insert(string.lastIndexOf("."), n4 + 1).toString())) : this.createWriter();
                    printWriter.println(RTF_HEADER);
                    Vector vector = DataBase.FLST.getStammstueckeFrom(n2, n3);
                    n = 0;
                    super.setLabelText("Fortf\u00fchrungsbeleg(" + (n4 + 1) + ") erstellen...");
                    super.setEndValue(vector.size() * 2);
                    super.setProgressBreak();
                    Hashtable<Integer, Flurstueck> hashtable = new Hashtable<Integer, Flurstueck>();
                    Object object2 = vector.elements();
                    while (object2.hasMoreElements()) {
                        object = (Flurstueck)object2.nextElement();
                        if (((Flurstueck)object).isFortfuehrung() && ((Flurstueck)object).isStammstueck()) {
                            hashtable.put(new Integer(((Flurstueck)object).getBerechnungsArt()), (Flurstueck)object);
                            Vector vector2 = DataBase.FLST.getTeilstueckeFrom((Flurstueck)object);
                            Enumeration enumeration2 = DataBase.FLST.getTeilstueckeFrom((Flurstueck)object).elements();
                            while (enumeration2.hasMoreElements()) {
                                flurstueck2 = (Flurstueck)enumeration2.nextElement();
                                hashtable.put(new Integer(flurstueck2.getBerechnungsArt()), flurstueck2);
                            }
                            if ((long)n % super.getProgressBreak() == 0L) {
                                super.setProgress(n);
                            }
                        }
                        ++n;
                    }
                    object2 = new StringList();
                    if (hashtable.get(new Integer(6)) != null) {
                        ((StringList)object2).append("P");
                    }
                    if (hashtable.get(new Integer(5)) != null) {
                        ((StringList)object2).append("F");
                    }
                    if (hashtable.get(new Integer(4)) != null) {
                        ((StringList)object2).append("FK");
                    }
                    if (hashtable.get(new Integer(3)) != null) {
                        ((StringList)object2).append("K");
                    }
                    this.writeTitel(printWriter, Gemarkung.getGemarkung(n2), n3, ((StringList)object2).toString());
                    this.writeTableHeader(printWriter);
                    this.writeLineDef(printWriter, "\\trowd \\trqc", true);
                    object = vector.elements();
                    while (object.hasMoreElements()) {
                        int n6 = 0;
                        int n7 = 0;
                        flurstueck2 = (Flurstueck)object.nextElement();
                        if (flurstueck2.isFortfuehrung() && flurstueck2.isStammstueck()) {
                            Object object3;
                            Object object4;
                            Flurstueck flurstueck3 = (Flurstueck)DataBase.ALB.get(flurstueck2);
                            Vector vector3 = DataBase.FLST.getTeileFrom(flurstueck2);
                            Vector<Object> vector4 = new Vector<Object>();
                            Line line = new Line(this);
                            if (flurstueck3 != null) {
                                line.s1 = flurstueck3.getNenner() > 0 ? flurstueck3.getZaehler() + "/" + flurstueck3.getNenner() : Integer.toString(flurstueck3.getZaehler());
                                if (flurstueck3.getNutzung() != -1) {
                                    line.s2 = this.getNutzungString(flurstueck3.getNutzung());
                                }
                                line.s3 = Integer.toString((int)Math.rint(flurstueck3.getBuchFlaeche()));
                                n6 += (int)Math.rint(flurstueck3.getBuchFlaeche());
                                vector4.addElement(line);
                                if (flurstueck3.hasTeile()) {
                                    object4 = DataBase.ALB.getTeileFrom(flurstueck3).elements();
                                    while (object4.hasMoreElements()) {
                                        Flurstueck flurstueck4 = (Flurstueck)object4.nextElement();
                                        line = new Line(this);
                                        vector4.addElement(line);
                                        line.s2 = this.getNutzungString(flurstueck4.getNutzung());
                                        line.s3 = Integer.toString((int)Math.rint(flurstueck4.getBuchFlaeche()));
                                    }
                                }
                            } else {
                                line.s1 = flurstueck2.getNenner() > 0 ? flurstueck2.getZaehler() + "/" + flurstueck2.getNenner() : Integer.toString(flurstueck2.getZaehler());
                                line.s3 = Integer.toString((int)Math.rint(flurstueck2.getBuchFlaeche()));
                                n6 += (int)Math.rint(flurstueck2.getBuchFlaeche());
                                vector4.addElement(line);
                            }
                            for (int i = 0; i < 5; ++i) {
                                vector4.addElement(new Line(this));
                            }
                            object4 = null;
                            if (flurstueck2.hasTeile()) {
                                object4 = DataBase.FLST.getTeileFrom(flurstueck2);
                            } else {
                                object4 = new Vector();
                                ((Vector)object4).addElement(flurstueck2);
                            }
                            int n8 = 0;
                            Object object5 = ((Vector)object4).elements();
                            while (object5.hasMoreElements()) {
                                if (n8 < vector4.size()) {
                                    line = (Line)vector4.elementAt(n8);
                                } else {
                                    line = new Line(this);
                                    vector4.addElement(line);
                                }
                                ++n8;
                                object3 = (Flurstueck)object5.nextElement();
                                if (!((Flurstueck)object3).isNutzstueck()) {
                                    line.s4 = ((Flurstueck)object3).hasVorgabeNummer() ? ((Flurstueck)object3).getVorgabeNummer() : (((Flurstueck)object3).isStammstueck() ? (((Flurstueck)object3).getNenner() > 0 ? ((Flurstueck)object3).getZaehler() + "/" + ((Flurstueck)object3).getNenner() : Integer.toString(((Flurstueck)object3).getZaehler())) : ((Flurstueck)object3).getTeilAsString());
                                    n7 += ((Flurstueck)object3).getRoundedFlaeche();
                                }
                                if (((Flurstueck)object3).getNutzung() != -1) {
                                    line.s5 = this.getNutzungString(((Flurstueck)object3).getNutzung());
                                }
                                line.s6 = ((Flurstueck)object3).getRoundedFlaecheAsString();
                                for (int i = 0; i < 5; ++i) {
                                    if (n8 > vector4.size()) {
                                        vector4.addElement(new Line(this));
                                    }
                                    ++n8;
                                }
                            }
                            object5 = new Line(this);
                            ((Line)object5).s3 = Integer.toString(n6);
                            ((Line)object5).s6 = Integer.toString(n7);
                            vector4.addElement(object5);
                            for (int i = 0; i < 5; ++i) {
                                vector4.addElement(new Line(this));
                                ++n8;
                            }
                            object3 = vector4.elements();
                            while (object3.hasMoreElements()) {
                                this.writeFlurstueckLine(printWriter, (Line)object3.nextElement());
                            }
                        }
                        ++n;
                    }
                    printWriter.print(END_OF_FILE);
                    printWriter.close();
                }
                ++n4;
            }
        }
        catch (IOException iOException) {
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
    }

    private String getNutzungString(int n) {
        if (n != -1) {
            StringBuffer stringBuffer = new StringBuffer();
            NutzungsArt nutzungsArt = NutzungsArt.getNutzungsArt(n);
            if (nutzungsArt != null) {
                stringBuffer.append(nutzungsArt.getAbkuerzung());
                stringBuffer.append(" ");
            }
            stringBuffer.append("(");
            stringBuffer.append(IFormat.i03.format(n));
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
        return IFormat.i03.format(n).toString();
    }

    private void writeTitel(PrintWriter printWriter, Gemarkung gemarkung, int n, String string) {
        printWriter.print("\\pard\\plain \\s15\\sa120\\nowidctlpar\\tqr\\tldot\\tx4935\\tx5295\\tqr\\tldot\\tx9921\\adjustright \\cf1\\lang255 {Vermessungsstelle\\tab ");
        if (DataBase.vermStelle != null) {
            printWriter.print(RtfIOConstants.getString(DataBase.vermStelle));
        }
        printWriter.print("\\tab Katasteramt\\tab ");
        if (DataBase.katasterAmt != null) {
            printWriter.print(RtfIOConstants.getString(DataBase.katasterAmt));
        }
        printWriter.print("\\par Gemarkung (Nr.)\\tab ");
        if (gemarkung != null) {
            printWriter.print(RtfIOConstants.getString(gemarkung.getName()) + " (" + IFormat.i06.format(gemarkung.getNummer()) + ")");
        }
        printWriter.print("\\par Flur\\tab ");
        if (n > 0) {
            printWriter.print(Integer.toString(n));
        }
        printWriter.print("\\tab Antrag-Nr.\\tab ");
        if (DataBase.antrag != null) {
            printWriter.print(RtfIOConstants.getString(DataBase.antrag));
        }
        printWriter.print("\\par Berechnungsart (P,F,FK,K)\\tab ");
        if (string != null) {
            printWriter.print(RtfIOConstants.getString(string));
        }
        printWriter.print("\\tab lfd. Nr. d. Fortf\\'fchrung\\tab ");
        printWriter.println("\\par }\\pard \\s15\\sb1247\\sa119\\nowidctlpar\\tqr\\tldot\\tx4935\\tx5295\\tqr\\tldot\\tx9921\\adjustright {\\b\\fs28 Fl\\'e4chenberechnungsprotokoll\\par }");
    }

    private void writeFlurstueckLine(PrintWriter printWriter, Line line) {
        printWriter.print("\\pard \\qc\\nowidctlpar\\intbl\\adjustright {\\fs20\\cf0 ");
        if (line.s1 != null) {
            printWriter.print(line.s1);
        }
        printWriter.print("\\cell ");
        if (line.s2 != null) {
            printWriter.print(line.s2);
        }
        printWriter.print("\\cell }");
        printWriter.print("\\pard \\qr\\ri227\\nowidctlpar\\intbl\\adjustright {\\fs20\\cf0 ");
        if (line.s3 != null && line.s3.length() > 4) {
            printWriter.print(line.s3.substring(0, line.s3.length() - 4));
        }
        printWriter.print("\\cell ");
        if (line.s3 != null && line.s3.length() > 2) {
            printWriter.print(line.s3.substring(Math.max(0, line.s3.length() - 4), line.s3.length() - 2));
        }
        printWriter.print("\\cell ");
        if (line.s3 != null) {
            printWriter.print(line.s3.substring(Math.max(0, line.s3.length() - 2)));
        }
        printWriter.print("\\cell }");
        printWriter.print("\\pard \\qc\\nowidctlpar\\intbl\\adjustright {\\fs20\\cf16 ");
        if (line.s4 != null) {
            printWriter.print(line.s4);
        }
        printWriter.print("\\cell }");
        printWriter.print("\\pard \\qc\\nowidctlpar\\intbl\\adjustright {\\fs20\\cf0 ");
        if (line.s5 != null) {
            printWriter.print(line.s5);
        }
        printWriter.print("\\cell }");
        printWriter.print("\\pard \\qr\\ri227\\nowidctlpar\\intbl\\adjustright {\\fs20\\cf0 ");
        if (line.s6 != null && line.s6.length() > 4) {
            printWriter.print(line.s6.substring(0, line.s6.length() - 4));
        }
        printWriter.print("\\cell ");
        if (line.s6 != null && line.s6.length() > 2) {
            printWriter.print(line.s6.substring(Math.max(0, line.s6.length() - 4), line.s6.length() - 2));
        }
        printWriter.print("\\cell ");
        if (line.s6 != null) {
            printWriter.print(line.s6.substring(Math.max(0, line.s6.length() - 2)));
        }
        printWriter.print("\\cell ");
        if (line.s7 != null && line.s7.length() > 4) {
            printWriter.print(line.s7.substring(0, line.s7.length() - 4));
        }
        printWriter.print("\\cell ");
        if (line.s7 != null && line.s7.length() > 2) {
            printWriter.print(line.s7.substring(Math.max(0, line.s7.length() - 4), line.s7.length() - 2));
        }
        printWriter.print("\\cell ");
        if (line.s7 != null) {
            printWriter.print(line.s7.substring(Math.max(0, line.s7.length() - 2)));
        }
        printWriter.println("\\cell }");
        printWriter.println("\\pard \\widctlpar\\intbl\\adjustright {\\fs20\\cf0 \\row }");
    }

    private void writeLineDef(PrintWriter printWriter, String string, boolean bl) {
        printWriter.println(string);
        block3: for (int i = 0; i < this.lx.length; ++i) {
            switch (i) {
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 10: 
                case 11: {
                    if (!bl) continue block3;
                }
                default: {
                    printWriter.print(CELL_RAHMEN);
                    if (i == 4 || i == 12) {
                        printWriter.print("\\clbrdrr\\brdrs\\brdrw20\\brdrcf1");
                    }
                    printWriter.print("\\cltxlrtb \\cellx");
                    printWriter.println(this.lx[i]);
                }
            }
        }
    }

    private void writeLine(PrintWriter printWriter) {
        printWriter.println("\\pard \\qc\\nowidctlpar\\intbl\\adjustright {\\fs20\\cf0 \\cell \\cell \\cell \\cell \\cell \\cell \\cell \\cell \\cell \\cell \\cell \\cell \\cell }");
        printWriter.println("\\pard \\widctlpar\\intbl\\adjustright {\\fs20\\cf0 \\row }");
    }

    private void writeTableHeader(PrintWriter printWriter) {
        printWriter.println("\\trowd \\trqc\\trhdr \\clvertalt\\clbrdrt\\brdrs\\brdrw5\\brdrcf1 \\clbrdrl\\brdrs\\brdrw5\\brdrcf1 \\clbrdrb\\brdrs\\brdrw5\\brdrcf1 \\clbrdrr\\brdrs\\brdrw20\\brdrcf1 \\cltxlrtb \\cellx4145\\clvertalt\\clbrdrt\\brdrs\\brdrw5\\brdrcf1 \\clbrdrl\\brdrs\\brdrw5\\brdrcf1 \\clbrdrb\\brdrs\\brdrw5\\brdrcf1 \\clbrdrr\\brdrs\\brdrw5\\brdrcf1 \\cltxlrtb \\cellx10318\n\\pard\\plain \\qc\\nowidctlpar\\intbl\\adjustright \\cf1\\lang255 {\\fs22\\cf0 Alter Bestand\\cell Neuer Bestand\\cell }\n\\pard \\widctlpar\\intbl\\adjustright {\\fs22\\cf0 \\row }");
        this.writeLineDef(printWriter, "\\trowd \\trqc\\trrh-567\\trhdr", false);
        printWriter.println("\\pard \\qc\\nowidctlpar\\intbl\\adjustright {\\fs22\\cf0 Flur-st\\'fcck\\cell Nutzungsart\\cell Fl\\'e4che\\cell Flur-st\\'fcck\\cell Nutzungsart\\cell Fl\\'e4che\\cell Abgleich Eng\\'fcltige Fl\\'e4che\\cell }\n\\pard \\widctlpar\\intbl\\adjustright {\\fs22\\cf0 \\row }");
        this.writeLineDef(printWriter, "\\trowd \\trqc\\trhdr", true);
        printWriter.println("\\pard \\qc\\nowidctlpar\\intbl\\adjustright {\\fs22\\cf0 \\cell \\cell ha\\cell a\\cell }{\\fs22\\cf0 m}{\\fs22\\cf0\\super 2}{\\fs22\\cf0 \\cell \\cell \\cell ha\\cell a\\cell }{\\fs22\\cf0 m}{\\fs22\\cf0\\super 2}{\\fs22\\cf0 \\cell ha\\cell a\\cell }{\\fs22\\cf0 m}{\\fs22\\cf0\\super 2}{\\fs22\\cf0 \\cell }\n\\pard \\widctlpar\\intbl\\adjustright {\\fs22\\cf0 \\row }");
        this.writeLineDef(printWriter, "\\trowd \\trqc\\trhdr", false);
        printWriter.println("\\pard \\qc\\nowidctlpar\\intbl\\adjustright {\\fs16\\cf0 1\\cell 2\\cell 3\\cell 4\\cell 5\\cell 6\\cell 7\\cell }\n\\pard \\widctlpar\\intbl\\adjustright {\\fs16\\cf0 \\row }");
    }

    class Line {
        String s1;
        String s2;
        String s3;
        String s4;
        String s5;
        String s6;
        String s7;

        Line(FortfuehrungNrwWriter fortfuehrungNrwWriter) {
        }
    }
}

