/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.io.IFreePunktReader;
import de.geocalc.text.IFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.StringTokenizer;
import java.util.Vector;

public class FreeFormatReader
extends IFreePunktReader {
    boolean isReadable = this.isReadableFile();
    private long newNumber = 0L;
    int N = -1;
    int Y = -1;
    int X = -1;
    int H = -1;
    int rL;
    int uL;
    int nN;

    public FreeFormatReader(File file, PunktTable punktTable) {
        this(file, punktTable, null);
    }

    public FreeFormatReader(File file, PunktTable punktTable, IProgressViewer iProgressViewer) {
        super(file, punktTable, iProgressViewer);
    }

    public FreeFormatReader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, vector, iProgressViewer);
    }

    @Override
    public String getFinalMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Freies Punktformat, ");
        stringBuffer.append(this.rL + " Punkte gelesen");
        if (this.nN > 0) {
            stringBuffer.append(", " + this.nN + " neu nummeriert");
        }
        if (this.uL > 0) {
            stringBuffer.append(", " + this.uL + " Zeilen ignoriert");
        }
        return stringBuffer.toString();
    }

    public boolean isReadable() {
        return this.isReadable;
    }

    private boolean isReadableFile() {
        int n;
        int n2;
        Reader reader;
        try {
            reader = new FileReader(this.inFile);
            n2 = 0;
            int n3 = 0;
            int n4 = 0;
            n = 0;
            while ((n3 = ((InputStreamReader)reader).read()) != -1) {
                if (n3 < 10 || n3 > 125) {
                    ++n4;
                } else {
                    ++n;
                }
                if (n4 > 100) {
                    return false;
                }
                if (n <= 500) continue;
            }
            ((InputStreamReader)reader).close();
        }
        catch (Exception exception) {
            return false;
        }
        try {
            int n5;
            String string;
            reader = this.createReader();
            n2 = 0;
            Vector vector = new Vector();
            n = 0;
            int n6 = 0;
            LineEntry lineEntry = new LineEntry();
            while ((string = ((LineNumberReader)reader).readLine()) != null) {
                LineEntry lineEntry2 = new LineEntry(string);
                if (lineEntry2.isReadable()) {
                    ++n;
                    for (int i = 0; i < lineEntry2.size(); ++i) {
                        Entry entry = (Entry)lineEntry2.elementAt(i);
                        ++entry.count;
                        if (lineEntry2.size() > lineEntry.size()) {
                            lineEntry.addElement(entry);
                            continue;
                        }
                        Entry entry2 = (Entry)lineEntry.elementAt(i);
                        entry2.typ += entry.typ;
                        entry2.min = Math.min(entry2.min, entry.min);
                        entry2.max = Math.max(entry2.max, entry.max);
                        entry2.minVk = Math.min(entry2.minVk, entry.minVk);
                        entry2.maxVk = Math.min(entry2.maxVk, entry.maxVk);
                        entry2.minNk = Math.min(entry2.minNk, entry.minNk);
                        entry2.maxVk = Math.max(entry2.maxNk, entry.maxNk);
                        ++entry2.count;
                    }
                } else {
                    ++n6;
                }
                if (++n2 <= 100) continue;
                break;
            }
            for (n5 = 0; n5 < lineEntry.size(); ++n5) {
                Entry entry = (Entry)lineEntry.elementAt(n5);
                int n7 = this.getTyp(entry.typ, n2);
                if (n7 != 2) continue;
                if (this.Y < 0) {
                    this.Y = n5;
                    continue;
                }
                if (this.X < 0) {
                    this.X = n5;
                    continue;
                }
                if (this.H >= 0) break;
                this.H = n5;
            }
            for (n5 = 0; n5 < lineEntry.size(); ++n5) {
                if (n5 == this.Y || n5 == this.X || n5 == this.H) continue;
                Entry entry = (Entry)lineEntry.elementAt(n5);
                int n8 = this.getTyp(entry.typ, n2);
                if (n8 == 0 || entry.max - entry.min < (double)n2) continue;
                if (n8 == 1) {
                    this.N = n5;
                    break;
                }
                if (n8 != 2) continue;
                this.N = n5;
            }
            ((BufferedReader)reader).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.Y >= 0 && this.X >= 0;
    }

    private int getTyp(int n, int n2) {
        double d = (double)n / (double)n2;
        if (d > 0.8 && d < 1.2) {
            return 1;
        }
        if (d > 1.8 && d < 2.2) {
            return 2;
        }
        return 0;
    }

    @Override
    protected Punkt lineToPunkt(String string) {
        Punkt punkt = new Punkt();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (n == this.N) {
                    punkt.nr = Long.parseLong(IFormat.getNumbers(string2));
                } else if (n == this.Y) {
                    punkt.y = new Double(string2);
                } else if (n == this.X) {
                    punkt.x = new Double(string2);
                } else if (n == this.H) {
                    punkt.h = new Float(string2).floatValue();
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (punkt.y == 0.0 || punkt.x == 0.0) {
            ++this.uL;
            return null;
        }
        if (punkt.nr == 0L) {
            punkt.nr = ++this.newNumber;
            ++this.nN;
        }
        ++this.rL;
        return punkt;
    }

    class LineEntry
    extends Vector {
        int d;
        int i;
        int s;

        LineEntry() {
        }

        LineEntry(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                Entry entry = new Entry(FreeFormatReader.this, stringTokenizer.nextToken());
                switch (entry.getTyp()) {
                    case 1: {
                        ++this.i;
                        break;
                    }
                    case 2: {
                        ++this.d;
                        break;
                    }
                    default: {
                        ++this.s;
                    }
                }
                this.addElement(entry);
            }
        }

        int getDCount() {
            return this.d;
        }

        int getICount() {
            return this.i;
        }

        boolean isReadable() {
            return this.d >= 2;
        }
    }

    class Entry {
        static final int STRING = 0;
        static final int INT = 1;
        static final int DOUBLE = 2;
        double min;
        double max;
        int typ = 0;
        int minVk = 0;
        int maxVk = 0;
        int minNk = 0;
        int maxNk = 0;
        int count = 0;

        int getTyp() {
            return this.typ;
        }

        Entry(FreeFormatReader freeFormatReader) {
        }

        Entry(FreeFormatReader freeFormatReader, String string) {
            int n = string.indexOf(46);
            if (n >= 0) {
                double d = 0.0;
                try {
                    this.min = this.max = (d = new Double(string).doubleValue());
                    this.minVk = this.maxVk = n;
                    this.minNk = this.maxNk = string.length() - n - 1;
                    this.typ = 2;
                }
                catch (Exception exception) {
                    this.typ = 0;
                }
            } else if (IFormat.isNumber(string)) {
                long l = 0L;
                try {
                    l = Long.parseLong(string);
                    this.min = this.max = (double)l;
                    this.minVk = this.maxVk = string.length();
                    this.typ = 1;
                }
                catch (Exception exception) {
                    this.typ = 0;
                }
            } else {
                this.typ = 0;
            }
        }

        public String toString() {
            return this.typ + "(" + this.minVk + "-" + this.maxVk + ")(" + this.minNk + "-" + this.maxNk + "):" + this.min + ":" + this.max;
        }
    }
}

