/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.geom.DPoint;
import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.GebaeudeKennzeichen;
import de.geocalc.kafplot.GeografProperties;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.ObjectDecor;
import de.geocalc.kafplot.Oska;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.TopObject;
import de.geocalc.kafplot.io.GeografOutWriter;
import de.geocalc.kafplot.io.gg.GGIOProperties;
import de.geocalc.text.IFormat;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.TimeZone;

public class GeografAlkWriter
extends GeografOutWriter {
    public static final String TITLE = "GeografAlkWriter";
    public static final String VERSION = "1.0";

    public GeografAlkWriter(File file, DataBase dataBase) {
        super(file, dataBase);
        this.oskaIsId = true;
    }

    @Override
    protected void setParameter() {
        FOLIE_GEMARKUNG = 2;
        FOLIE_NUTZUNG = 21;
        FOLIE_FLURSTUECKE = 1;
        TA_GEMARKUNG = 231;
        TA_FLUR = 232;
        TA_FLST = 233;
        TA_FLST_STR = 239;
        TA_NUTZUNG = 241;
        TA_ONAME_PSNR = 1034;
        TA_ONAME_HSNR = 1031;
        TA_ONAME_LNR = 1032;
        TA_GEB_NAME = 0;
        TA_GEB_DECOR = 0;
    }

    @Override
    protected String getDefaultEncoding() {
        return "ISO-8859-1";
    }

    @Override
    public void write() throws IFileOutputException {
        this.pNr = 0;
        this.sNr = 0;
        this.lNr = 0;
        this.tNr = 0;
        this.oNr = 0;
        PrintWriter printWriter = null;
        try {
            Cloneable cloneable;
            Object object;
            this.PNR.clear();
            this.LNR.clear();
            printWriter = this.createWriter();
            this.writeOutHeader(printWriter);
            printWriter.println("TYP: GRAFBAT V8 f\u00fcr GEOgraf f\u00fcr Windows V1");
            String string = GGIOProperties.getCooSystem();
            if (string != null && string.length() > 0) {
                printWriter.println("System: " + string);
            }
            printWriter.println("PAR: \"" + GeografProperties.getGrafArtFileName() + "\",\"" + GeografProperties.getGrafSymFileName() + "\",\"GEOGRAF\",500");
            this.eb = -1;
            this.lOska = -1;
            int n = 0;
            super.setLabelText("ausgegebene Punkte: ");
            super.setEndValue(DataBase.P.size());
            super.setProgressBreak();
            super.setProgress(0);
            Object object2 = DataBase.P.elements();
            while (object2.hasMoreElements()) {
                object = (Punkt)object2.nextElement();
                if (this.punktFilter.isPunktEnabled((Punkt)object)) {
                    this.writePunkt(printWriter, (Punkt)object);
                    if ((long)n % super.getProgressBreak() == 0L) {
                        super.setLabelValue(this.pNr);
                        super.showProgress(n);
                    }
                }
                ++n;
            }
            n = 0;
            object2 = this.db.getOskaLinien();
            super.setLabelText("ausgegebene Linien: ");
            super.setEndValue(((Hashtable)object2).size());
            super.setProgressBreak();
            super.showProgress(this.lNr);
            object = ((Hashtable)object2).elements();
            while (object.hasMoreElements()) {
                cloneable = (Linie)object.nextElement();
                if (this.PNR.get(((Linie)cloneable).pa) == null) {
                    this.writePunkt(printWriter, ((Linie)cloneable).pa);
                }
                if (this.PNR.get(((Linie)cloneable).pe) == null) {
                    this.writePunkt(printWriter, ((Linie)cloneable).pe);
                }
                if (this.LNR.get(((Linie)cloneable).getArtEbeneOskaHashKey()) == null) {
                    int n2;
                    if (((Linie)cloneable).getOska() != this.lOska && (n2 = Oska.getFolie(this.lOska = ((Linie)cloneable).getOska())) != this.eb) {
                        this.eb = n2;
                        this.writeEbene(printWriter, this.eb);
                    }
                    this.LNR.put(((Linie)cloneable).getArtEbeneOskaHashKey(), new Integer(++this.lNr));
                    printWriter.println(((Linie)cloneable).toGeografOutLine(this.lNr, ((Linie)cloneable).getOska()));
                }
                if ((long)n % super.getProgressBreak() == 0L) {
                    super.setLabelValue(this.lNr);
                    super.setProgress(n);
                }
                ++n;
            }
            n = 0;
            super.setLabelText("ausgegebene Objekte: ");
            super.setEndValue(DataBase.FLST.size() + DataBase.GEB.size() + DataBase.TOP.size());
            super.setProgressBreak();
            super.showProgress(this.oNr);
            object = DataBase.FLST.elements();
            while (object.hasMoreElements()) {
                block65: {
                    block62: {
                        DPoint dPoint;
                        block64: {
                            block63: {
                                block61: {
                                    cloneable = (Flurstueck)object.nextElement();
                                    if (!((Flurstueck)cloneable).isGemarkung()) break block61;
                                    this.eb = 2;
                                    this.writeEbene(printWriter, 2);
                                    this.writeFlst(printWriter, (Flurstueck)cloneable, this.LNR);
                                    if (((GObject)cloneable).hasDecor()) {
                                        this.writeDecors(printWriter, (GObject)cloneable);
                                    }
                                    break block62;
                                }
                                if (!((Flurstueck)cloneable).isFlur()) break block63;
                                this.eb = 2;
                                this.writeEbene(printWriter, 2);
                                this.writeFlst(printWriter, (Flurstueck)cloneable, this.LNR);
                                if (((GObject)cloneable).hasDecor()) {
                                    this.writeDecors(printWriter, (GObject)cloneable);
                                }
                                break block62;
                            }
                            if (!((Flurstueck)cloneable).isNutzstueck()) break block64;
                            if (this.eb != 21) {
                                this.eb = 21;
                                this.writeEbene(printWriter, 21);
                            }
                            if (((DataContainer)cloneable).hasLocation()) {
                                printWriter.print("OA");
                            } else {
                                printWriter.print("OAX");
                            }
                            printWriter.print(Integer.toString(++this.oNr));
                            printWriter.print(": \"\",");
                            printWriter.print(((Flurstueck)cloneable).getNutzung() * 10);
                            printWriter.print(",");
                            if (((DataContainer)cloneable).hasLocation()) {
                                dPoint = this.createObjectPoint((GObject)cloneable);
                                printWriter.print(IFormat.f_3.format(dPoint.y).toString());
                                printWriter.print(",");
                                printWriter.print(IFormat.f_3.format(dPoint.x).toString());
                            } else {
                                printWriter.print(",");
                            }
                            printWriter.print(",");
                            printWriter.print(Integer.toString(0));
                            printWriter.println(",");
                            this.writeObjectLinien(printWriter, (GObject)cloneable, this.LNR);
                            if (((GObject)cloneable).hasDecor()) {
                                this.writeDecors(printWriter, (GObject)cloneable);
                            }
                            printWriter.println("OE" + this.oNr + ":");
                            break block62;
                        }
                        if (((Flurstueck)cloneable).getArt() == 709 || ((Flurstueck)cloneable).getArt() == 781) break block65;
                        if (this.eb != 1) {
                            this.eb = 1;
                            this.writeEbene(printWriter, 1);
                        }
                        this.writeFlst(printWriter, (Flurstueck)cloneable, this.LNR);
                        if (((Flurstueck)cloneable).getNutzung() != -1) {
                            this.eb = 21;
                            this.writeEbene(printWriter, 21);
                            if (((DataContainer)cloneable).hasLocation()) {
                                printWriter.print("OA");
                            } else {
                                printWriter.print("OAX");
                            }
                            printWriter.print(Integer.toString(++this.oNr));
                            printWriter.print(": \"\",");
                            printWriter.print(((Flurstueck)cloneable).getNutzung() * 10);
                            printWriter.print(",");
                            if (((DataContainer)cloneable).hasLocation()) {
                                dPoint = null;
                                if (((GObject)cloneable).hasDecor()) {
                                    ObjectDecor objectDecor = ((GObject)cloneable).decorAt(0);
                                    dPoint = this.createObjectPoint(objectDecor.y, objectDecor.x, (GObject)cloneable);
                                } else {
                                    dPoint = this.createObjectPoint((GObject)cloneable);
                                }
                                printWriter.print(IFormat.f_3.format(dPoint.y).toString());
                                printWriter.print(",");
                                printWriter.print(IFormat.f_3.format(dPoint.x).toString());
                            } else {
                                printWriter.print(",");
                            }
                            printWriter.print(",");
                            printWriter.print(Integer.toString(0));
                            printWriter.println(",");
                            printWriter.print("  OG: ");
                            printWriter.println(Integer.toString(this.oNr - 1));
                            printWriter.println("OD:");
                            if (((GObject)cloneable).hasDecor()) {
                                this.writeDecors(printWriter, (GObject)cloneable);
                            }
                            printWriter.println("OE" + this.oNr + ":");
                        }
                    }
                    if ((long)n % super.getProgressBreak() == 0L) {
                        super.setLabelValue(this.oNr);
                        super.setProgress(n);
                    }
                }
                ++n;
            }
            this.eb = 11;
            this.writeEbene(printWriter, 11);
            object = DataBase.GEB.elements();
            while (object.hasMoreElements()) {
                Object object3;
                cloneable = (Gebaeude)object.nextElement();
                printWriter.print("OA");
                printWriter.print(Integer.toString(++this.oNr));
                printWriter.print(": \"");
                if (((Gebaeude)cloneable).hasLeitzeichen()) {
                    object3 = ((Gebaeude)cloneable).getLeitzeichen();
                    printWriter.write(IFormat.i08.format(((GebaeudeKennzeichen)object3).getGemeinde()));
                    printWriter.write(IFormat.i05.format(((GebaeudeKennzeichen)object3).getStrasse()));
                    printWriter.write(IFormat.i04.format(((GebaeudeKennzeichen)object3).getHausNummer()));
                    printWriter.write(" ");
                    if (((GebaeudeKennzeichen)object3).getAdressenZusatz() != null) {
                        printWriter.write(IFormat.getRightString(((GebaeudeKennzeichen)object3).getAdressenZusatz(), 3));
                    } else {
                        printWriter.write("   ");
                    }
                    if (((GebaeudeKennzeichen)object3).isPseudoNummer()) {
                        printWriter.write(80);
                    } else {
                        printWriter.write(" ");
                    }
                    printWriter.write(IFormat.i02.format(((GebaeudeKennzeichen)object3).getLfdNummer()));
                }
                printWriter.print("\",");
                printWriter.print(Integer.toString(((DataContainer)cloneable).getOska() == 0 ? 1001 : ((DataContainer)cloneable).getOska()));
                printWriter.print(",");
                if (((DataContainer)cloneable).hasLocation()) {
                    object3 = this.createObjectPoint((GObject)cloneable);
                    printWriter.print(IFormat.f_3.format(((DPoint)object3).y).toString());
                    printWriter.print(",");
                    printWriter.print(IFormat.f_3.format(((DPoint)object3).x).toString());
                } else {
                    printWriter.print(",");
                }
                printWriter.print(",");
                printWriter.print(Integer.toString(0));
                printWriter.println(",");
                this.writeObjectLinien(printWriter, (GObject)cloneable, this.LNR);
                if (((Gebaeude)cloneable).hasLeitzeichen()) {
                    this.writeGebaeudeKennzeichen(printWriter, ((Gebaeude)cloneable).getLeitzeichen(), (GObject)cloneable);
                }
                if (((Gebaeude)cloneable).hasKennzeichen()) {
                    object3 = ((Gebaeude)cloneable).kennzeichen();
                    while (object3.hasMoreElements()) {
                        this.writeGebaeudeKennzeichen(printWriter, (GebaeudeKennzeichen)object3.nextElement(), (GObject)cloneable);
                    }
                }
                if (((GObject)cloneable).hasDecor()) {
                    this.writeDecors(printWriter, (GObject)cloneable);
                }
                printWriter.println("OE" + this.oNr + ":");
                if ((long)n % super.getProgressBreak() == 0L) {
                    super.setLabelValue(this.oNr);
                    super.setProgress(n);
                }
                ++n;
            }
            object = DataBase.TOP.elements();
            while (object.hasMoreElements()) {
                this.eb = 82;
                this.writeEbene(printWriter, 82);
                cloneable = (TopObject)object.nextElement();
                printWriter.print("OA");
                printWriter.print(Integer.toString(++this.oNr));
                printWriter.print(": \"");
                printWriter.print("\",");
                printWriter.print(Integer.toString(((DataContainer)cloneable).getOska()));
                printWriter.print(",");
                if (((DataContainer)cloneable).hasLocation()) {
                    DPoint dPoint = this.createObjectPoint((GObject)cloneable);
                    printWriter.print(IFormat.f_3.format(dPoint.y).toString());
                    printWriter.print(",");
                    printWriter.print(IFormat.f_3.format(dPoint.x).toString());
                } else {
                    printWriter.print(",");
                }
                printWriter.print(",");
                printWriter.print(Integer.toString(0));
                printWriter.println(",");
                this.writeObjectLinien(printWriter, (GObject)cloneable, this.LNR);
                if (((GObject)cloneable).hasDecor()) {
                    this.writeDecors(printWriter, (GObject)cloneable);
                }
                printWriter.println("OE" + this.oNr + ":");
                if ((long)n % super.getProgressBreak() == 0L) {
                    super.setLabelValue(this.oNr);
                    super.setProgress(n);
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
        finally {
            try {
                printWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    protected int getFlstTextArt(Flurstueck flurstueck) {
        return flurstueck.getOska();
    }

    private void writePunkt(PrintWriter printWriter, Punkt punkt) {
        int n = punkt.getOska();
        switch (n) {
            case 118: 
            case 119: 
            case 151: {
                if (punkt.getKafPa() <= -1) {
                    n += 8000;
                    if (this.eb == 85) break;
                    this.eb = 85;
                    this.writeEbene(printWriter, 85);
                    break;
                }
            }
            default: {
                int n2;
                if (n == this.lOska || (n2 = Oska.getFolie(this.lOska = n)) == this.eb) break;
                this.eb = n2;
                this.writeEbene(printWriter, this.eb);
            }
        }
        this.PNR.put(punkt, new Integer(++this.pNr));
        printWriter.println(punkt.toGeografOutLine(this.pNr, n));
    }

    @Override
    protected void writeOutHeader(PrintWriter printWriter) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeZone(TimeZone.getTimeZone("ECT"));
        printWriter.println("* ");
        printWriter.println("* GRAFBAT - D A T E I  GEOgraf");
        printWriter.println("* ");
        printWriter.println("* erstellt mit GeografAlkWriter 1.0");
        printWriter.println("* Datum: " + gregorianCalendar.get(5) + "/" + gregorianCalendar.get(2) + "/" + gregorianCalendar.get(1));
        printWriter.println("* ");
    }
}

