/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IException;
import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.io.IFileWriter;
import de.geocalc.util.LongHashObject;
import de.geocalc.util.sml.Tag;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class GeografHomWriter
extends IFileWriter {
    protected DataBase db;

    public GeografHomWriter(File file, DataBase dataBase) {
        super(file);
        this.db = dataBase;
        this.setParameter();
    }

    protected void setParameter() {
    }

    @Override
    protected String getDefaultEncoding() {
        return "ISO-8859-1";
    }

    @Override
    public void write() throws IFileOutputException {
        PrintWriter printWriter = null;
        try {
            Cloneable cloneable;
            printWriter = this.createWriter();
            Hashtable<Cloneable, Cloneable> hashtable = new Hashtable<Cloneable, Cloneable>();
            Enumeration<Object> enumeration = DataBase.P.elements();
            while (enumeration.hasMoreElements()) {
                cloneable = (Punkt)enumeration.nextElement();
                if (!DataBase.PM.contains((LongHashObject)((Object)cloneable))) continue;
                GeografHomWriter geografHomWriter = this;
                if (geografHomWriter.db.hasMenge()) {
                    if (!DataBase.MENGE.contains((LongHashObject)((Object)cloneable))) continue;
                }
                hashtable.put(cloneable, cloneable);
            }
            enumeration = DataBase.T.elements();
            while (enumeration.hasMoreElements()) {
                cloneable = (TrafoSystem)enumeration.nextElement();
                Enumeration enumeration2 = ((DataContainer)cloneable).elements();
                while (enumeration2.hasMoreElements()) {
                    TrafoPunkt trafoPunkt = (TrafoPunkt)enumeration2.nextElement();
                    Punkt punkt = trafoPunkt.getPunkt();
                    GeografHomWriter geografHomWriter = this;
                    if (geografHomWriter.db.hasMenge()) {
                        if (!DataBase.MENGE.contains(punkt)) continue;
                    }
                    if (trafoPunkt.hasTag("PI1")) {
                        Tag tag = Tag.parseTag(trafoPunkt.getBemerkung(), "PI1");
                        long l = Long.parseLong(tag.getValue());
                        punkt = (Punkt)punkt.clone();
                        punkt.nr = l;
                    }
                    printWriter.println(punkt.toGeografLine(0, 0));
                    hashtable.remove(punkt);
                }
            }
            enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                cloneable = (Punkt)enumeration.nextElement();
                printWriter.println(((Punkt)cloneable).toGeografLine(0, 0));
                this.addException(new IException("Verschobener Punkt " + ((Punkt)cloneable).nr + " ist ohne Digitalisiersystem"));
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
    }
}

