/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.ArtKey;
import de.geocalc.kafplot.GeografProperties;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.Oska;
import de.geocalc.kafplot.io.IFileWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class GeografLinienWriter
extends IFileWriter {
    Hashtable L;

    public GeografLinienWriter(File file, Hashtable hashtable) {
        super(file);
        this.L = hashtable;
        this.setParameter();
    }

    protected void setParameter() {
    }

    @Override
    protected String getDefaultEncoding() {
        return "ISO-8859-1";
    }

    @Override
    public void write() throws IFileOutputException {
        PrintWriter printWriter = null;
        try {
            printWriter = this.createWriter();
            int n = 0;
            int n2 = 0;
            super.setLabelText("ausgegebene Linien: ");
            super.setEndValue(this.L.size());
            super.setProgressBreak();
            super.showProgress(0L);
            Enumeration enumeration = this.L.elements();
            while (enumeration.hasMoreElements()) {
                Linie linie = (Linie)enumeration.nextElement();
                if (this.punktFilter.isPunktEnabled(linie.pa) && this.punktFilter.isPunktEnabled(linie.pe)) {
                    ArtKey artKey = null;
                    if (GeografProperties.getArtExport() || GeografProperties.getEbeneExport()) {
                        artKey = GeografProperties.isOskaModus() ? new ArtKey(Oska.getFolie(linie.getOska()), linie.getOska()) : GeografProperties.getGrafKey(linie);
                    }
                    printWriter.println(linie.toGeografLine(GeografProperties.getEbeneExport() ? artKey.getEbene() : GeografProperties.getDefaultEbene(), GeografProperties.getArtExport() ? artKey.getArt() : GeografProperties.getDefaultLinieArt()));
                    ++n2;
                    if ((long)n % super.getProgressBreak() == 0L) {
                        super.setLabelValue(n2);
                        super.setProgress(n);
                    }
                }
                ++n;
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
    }
}

