/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.kafplot.Bedingung;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.LinieParameter;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktParameterALK;
import de.geocalc.kafplot.Text;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.io.gg.GGIOConstants;
import de.geocalc.kafplot.io.gg.GGIOProperties;
import de.geocalc.kafplot.io.gg.GGObject;
import de.geocalc.text.IFormat;
import java.util.Enumeration;
import java.util.Hashtable;

public class GeografOutLine
implements GGIOConstants {
    public static final long LKEY_CONST = 1000000000000000L;
    private static long internNr = 0L;
    private static Hashtable internNrHash = new Hashtable();
    private String line;
    private int length;
    private static Bedingung bed2 = null;

    public GeografOutLine() {
        this.line = null;
        this.length = 0;
    }

    public GeografOutLine(String string) {
        this.line = string;
        this.length = this.line.length();
    }

    public void setLine(String string) {
        this.line = string;
        this.length = this.line.length();
    }

    public int length() {
        return this.length;
    }

    public int getKennung() {
        int n;
        for (n = 0; n < this.length && this.line.charAt(n) == ' '; ++n) {
        }
        switch (this.line.charAt(n)) {
            case '*': {
                return 0;
            }
            case 'B': {
                if (this.line.startsWith("BE", n)) {
                    return 180;
                }
                if (!this.line.startsWith("BO", n)) break;
                return 160;
            }
            case 'D': {
                if (this.line.startsWith("DART", n)) {
                    return 192;
                }
                if (this.line.startsWith("DA", n)) {
                    return 190;
                }
                if (this.line.startsWith("DEL", n)) {
                    return 40;
                }
                if (this.line.startsWith("DE", n)) {
                    return 199;
                }
                if (this.line.startsWith("DDEF", n)) {
                    return 191;
                }
                if (this.line.startsWith("DGM", n)) {
                    return 50;
                }
                if (!this.line.startsWith("DTXT", n)) break;
                return 193;
            }
            case 'E': {
                if (!this.line.startsWith("EB", n)) break;
                return 10;
            }
            case 'K': {
                if (this.line.startsWith("KEY", n)) {
                    return 30;
                }
                if (this.line.startsWith("KO", n)) {
                    return 111;
                }
                if (!this.line.startsWith("KS", n)) break;
                return 112;
            }
            case 'L': {
                if (this.line.startsWith("LI", n)) {
                    return 120;
                }
                if (!this.line.startsWith("LN", n)) break;
                return 121;
            }
            case 'O': {
                if (this.line.startsWith("OAX", n)) {
                    return 171;
                }
                if (this.line.startsWith("OA", n)) {
                    return 170;
                }
                if (this.line.startsWith("OD", n)) {
                    return 172;
                }
                if (this.line.startsWith("OG", n)) {
                    return 175;
                }
                if (this.line.startsWith("OT", n)) {
                    return 174;
                }
                if (!this.line.startsWith("OE", n)) break;
                return 179;
            }
            case 'P': {
                if (this.line.startsWith("PKNUM", n)) {
                    return 101;
                }
                if (this.line.startsWith("PK", n)) {
                    return 100;
                }
                if (this.line.startsWith("Par", n)) {
                    return 2;
                }
                if (!this.line.startsWith("PB", n)) break;
                return 60;
            }
            case 'R': {
                if (!this.line.startsWith("RA", n)) break;
                return 300;
            }
            case 'S': {
                if (this.line.startsWith("SC", n)) {
                    return 150;
                }
                if (this.line.startsWith("SPZ", n)) {
                    return 141;
                }
                if (this.line.startsWith("SP", n)) {
                    return 140;
                }
                if (this.line.startsWith("SIZ", n)) {
                    return 143;
                }
                if (this.line.startsWith("SI", n)) {
                    return 142;
                }
                if (this.line.startsWith("SNZ", n)) {
                    return 145;
                }
                if (!this.line.startsWith("SN", n)) break;
                return 144;
            }
            case 'T': {
                if (this.line.startsWith("TA", n)) {
                    return 130;
                }
                if (this.line.startsWith("TF", n)) {
                    return 131;
                }
                if (this.line.startsWith("TE", n)) {
                    return 139;
                }
                if (this.line.startsWith("TYP", n)) {
                    return 1;
                }
                if (!this.line.startsWith("Typ", n)) break;
                return 1;
            }
            case 'M': {
                if (this.line.startsWith("MA", n)) {
                    return 200;
                }
                if (this.line.startsWith("ME", n)) {
                    return 209;
                }
                if (!this.line.startsWith("MODEL", n)) break;
                return 20;
            }
        }
        return -1;
    }

    public int getKey() {
        int n = 0;
        try {
            while (!Character.isDigit(this.line.charAt(n++))) {
            }
        }
        catch (Exception exception) {
            return 0;
        }
        return Integer.parseInt(this.line.substring(n - 1, this.line.indexOf(58)));
    }

    public boolean hasValues() {
        return this.getValueString().trim().length() > 0;
    }

    public Punkt readPK() throws Exception {
        Punkt punkt = new Punkt();
        PunktParameterALK punktParameterALK = new PunktParameterALK();
        int n = 0;
        ValueEnumerator valueEnumerator = new ValueEnumerator(this, this.getValueString());
        while (valueEnumerator.hasMoreElements()) {
            String string = (String)valueEnumerator.nextElement();
            switch (n) {
                case 0: {
                    try {
                        if (string.startsWith("#") && string.endsWith("#")) {
                            punkt.nr = --internNr;
                            internNrHash.put(string, new Long(punkt.nr));
                            break;
                        }
                        punkt.nr = Long.parseLong(string);
                    }
                    catch (Exception exception) {
                        punkt.nr = --internNr;
                        internNrHash.put(string, new Long(punkt.nr));
                    }
                    break;
                }
                case 1: {
                    punktParameterALK.setOska(Integer.parseInt(string));
                    break;
                }
                case 2: {
                    punkt.y = Double.valueOf(string);
                    break;
                }
                case 3: {
                    punkt.x = Double.valueOf(string);
                    break;
                }
                case 5: {
                    if (string.length() <= 0) break;
                    punkt.setSymbolWinkel(Double.valueOf(string));
                    break;
                }
                case 6: {
                    if (string.length() == 0) {
                        punkt.setPs(2);
                        break;
                    }
                    int n2 = Integer.parseInt(string);
                    switch (n2) {
                        case 0: 
                        case 1: {
                            punkt.setPs(0);
                            break;
                        }
                        case 2: {
                            punkt.setPs(2);
                            break;
                        }
                        case 3: {
                            punkt.setPs(1);
                        }
                    }
                    break;
                }
            }
            if (n >= 6) break;
            ++n;
        }
        punkt.initParameter(punktParameterALK);
        return punkt;
    }

    public int readEB() {
        return Integer.parseInt(this.getValueString().trim());
    }

    public Punkt readKS() {
        Punkt punkt = new Punkt();
        int n = 0;
        ValueEnumerator valueEnumerator = new ValueEnumerator(this, this.getValueString());
        while (valueEnumerator.hasMoreElements()) {
            String string = ((String)valueEnumerator.nextElement()).trim();
            switch (n) {
                case 0: {
                    punkt.sw = Integer.parseInt(string);
                    break;
                }
                case 1: {
                    punkt.y = Double.valueOf(string);
                    break;
                }
                case 2: {
                    punkt.x = Double.valueOf(string);
                }
            }
            ++n;
        }
        return punkt;
    }

    public TrafoSystem readMODEL() {
        TrafoSystem trafoSystem = new TrafoSystem(9);
        int n = 0;
        ValueEnumerator valueEnumerator = new ValueEnumerator(this, this.getValueString());
        while (valueEnumerator.hasMoreElements()) {
            String string = ((String)valueEnumerator.nextElement()).trim();
            switch (n) {
                case 0: {
                    trafoSystem.setName("Digitalisiersystem " + string);
                    break;
                }
                case 9: {
                    trafoSystem.setNummer(Integer.parseInt(string));
                    break;
                }
                case 10: {
                    trafoSystem.setParameter(Integer.parseInt(string));
                }
            }
            ++n;
        }
        return trafoSystem;
    }

    public Linie readLI() throws Exception {
        Linie linie = null;
        LinieParameter linieParameter = null;
        int n = 0;
        double d = 0.0;
        ValueEnumerator valueEnumerator = new ValueEnumerator(this, this.getValueString());
        while (valueEnumerator.hasMoreElements()) {
            String string = ((String)valueEnumerator.nextElement()).trim();
            switch (n) {
                case 0: {
                    try {
                        linie = new Linie();
                        linieParameter = new LinieParameter();
                        linie.pa = new Punkt(this.parseLIPunkt(string));
                        break;
                    }
                    catch (Exception exception) {
                        throw new NumberFormatException("Nummer P1 nicht numerisch");
                    }
                }
                case 1: {
                    try {
                        linie.pe = new Punkt(this.parseLIPunkt(string));
                        break;
                    }
                    catch (Exception exception) {
                        throw new NumberFormatException("Nummer P2 nicht numerisch");
                    }
                }
                case 2: {
                    try {
                        linieParameter.setOska(Integer.parseInt(string));
                        break;
                    }
                    catch (Exception exception) {
                        throw new NumberFormatException("Linienart fehlerhaft");
                    }
                }
                case 3: {
                    if (string.length() <= 0) break;
                    try {
                        linie.setRadius(new Double(string));
                        break;
                    }
                    catch (Exception exception) {
                        throw new NumberFormatException("Radius fehlerhaft");
                    }
                }
                case 4: {
                    if (string.length() <= 0) break;
                    try {
                        double d2 = new Double(string);
                        if (d2 == 0.0 || d2 == 1.0) break;
                        linie.setRadius(Double.NaN);
                        break;
                    }
                    catch (Exception exception) {
                        throw new NumberFormatException("Endradius fehlerhaft");
                    }
                }
            }
            if (n >= 4) break;
            ++n;
        }
        linie.setParameter(linieParameter);
        return linie;
    }

    private long parseLIPunkt(String string) {
        if (string.startsWith("#") && string.endsWith("#")) {
            return (Long)internNrHash.get(string);
        }
        return Long.parseLong(string);
    }

    public Text readTA() {
        String string = this.getValueString().trim();
        string = GGIOProperties.getUTFString(string);
        return new Text(string);
    }

    public Text readTA(Text text) {
        String string = this.getValueString().trim();
        string = GGIOProperties.getUTFString(string);
        if (text.getText() == null) {
            text.setText(string);
        } else {
            text.setText(text.getText() + "\n" + string);
        }
        return text;
    }

    public Text readTE(Text text) {
        int n = 0;
        ValueEnumerator valueEnumerator = new ValueEnumerator(this, this.getValueString());
        while (valueEnumerator.hasMoreElements()) {
            String string = ((String)valueEnumerator.nextElement()).trim();
            switch (n) {
                case 0: {
                    if (string == null || string.length() <= 0) break;
                    string = GGIOProperties.getUTFString(string);
                    if (text.getText() == null) {
                        text.setText(string);
                        break;
                    }
                    text.setText(text.getText() + IFormat.EOL + string);
                    break;
                }
                case 1: {
                    try {
                        text.ta = Integer.parseInt(string);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 2: {
                    try {
                        text.y = Double.valueOf(string);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 3: {
                    try {
                        text.x = Double.valueOf(string);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 4: {
                    try {
                        text.yt = Double.valueOf(string);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 5: {
                    try {
                        text.xt = Double.valueOf(string);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 6: {
                    try {
                        text.setTextWinkel(Double.valueOf(string) * Math.PI / 200.0);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            ++n;
        }
        return text;
    }

    public Bedingung readBE() {
        Bedingung bedingung = new Bedingung();
        bed2 = null;
        int n = 0;
        double d = 0.0;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n2 = 0;
        ValueEnumerator valueEnumerator = new ValueEnumerator(this, this.getValueString());
        while (valueEnumerator.hasMoreElements()) {
            String string = ((String)valueEnumerator.nextElement()).trim();
            switch (n2) {
                case 0: {
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 1: {
                    try {
                        d = Double.valueOf(string);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 2: {
                    try {
                        l = Long.parseLong(string);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 3: {
                    try {
                        l2 = Long.parseLong(string);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 4: {
                    try {
                        l3 = Long.parseLong(string);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 5: {
                    try {
                        l4 = Long.parseLong(string);
                    }
                    catch (Exception exception) {}
                    break;
                }
            }
            ++n2;
        }
        switch (n) {
            case 0: 
            case 1: {
                double d2 = d % Math.PI;
                bedingung.ba = d2 < 0.1 ? 1 : 2;
                bedingung.p1 = new Punkt(l);
                bedingung.p2 = new Punkt(l2);
                bedingung.p3 = new Punkt(l4);
                break;
            }
            case 2: 
            case 102: {
                bedingung.ba = 3;
                bedingung.p1 = new Punkt(l);
                bedingung.p2 = new Punkt(l2);
                bed2 = new Bedingung();
                GeografOutLine.bed2.ba = 0;
                GeografOutLine.bed2.p1 = new Punkt(l3);
                GeografOutLine.bed2.p2 = new Punkt(l4);
                GeografOutLine.bed2.l = d;
                break;
            }
            case 4: {
                if (d != 0.0) {
                    bedingung.ba = 4;
                    bedingung.p1 = new Punkt(l3);
                    bedingung.p2 = new Punkt(l4);
                    bedingung.p3 = new Punkt(l);
                    bedingung.l = d;
                    break;
                }
                bedingung.ba = 1;
                bedingung.p1 = new Punkt(l3);
                bedingung.p2 = new Punkt(l);
                bedingung.p3 = new Punkt(l4);
                break;
            }
            case 5: {
                bedingung.ba = 5;
                bedingung.p1 = new Punkt(l3);
                bedingung.p2 = new Punkt(l4);
                bedingung.l = d;
            }
            default: {
                return null;
            }
        }
        return bedingung;
    }

    public Bedingung readBE2() {
        return bed2;
    }

    public Integer readOG() {
        return new Integer(this.getValueString().trim());
    }

    public GGObject readOA() {
        GGObject gGObject = new GGObject();
        int n = 0;
        ValueEnumerator valueEnumerator = new ValueEnumerator(this, this.getValueString());
        while (valueEnumerator.hasMoreElements()) {
            String string = ((String)valueEnumerator.nextElement()).trim();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        try {
                            gGObject.setName(string);
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 1: {
                        try {
                            gGObject.setArt(Integer.parseInt(string));
                            break;
                        }
                        catch (Exception exception) {
                            throw new NumberFormatException("Objektart fehlerhaft: '" + string + "'");
                        }
                    }
                    case 2: {
                        try {
                            gGObject.y = new Double(string);
                            break;
                        }
                        catch (Exception exception) {
                            throw new NumberFormatException("X-Wert fehlerhaft");
                        }
                    }
                    case 3: {
                        try {
                            gGObject.x = new Double(string);
                            break;
                        }
                        catch (Exception exception) {
                            throw new NumberFormatException("Y-Wert fehlerhaft");
                        }
                    }
                    case 4: {
                        try {
                            gGObject.setTyp(Integer.parseInt(string));
                            break;
                        }
                        catch (Exception exception) {
                            throw new NumberFormatException("Objekttyp fehlerhaft");
                        }
                    }
                }
            }
            ++n;
        }
        return gGObject;
    }

    protected String getValueString() {
        return this.line.substring(this.line.indexOf(":") + 1);
    }

    final class ValueEnumerator
    implements Enumeration {
        private static final String DELIM = ",";
        private int elements;
        private int count;
        private int sIdx;
        private String valueString;

        ValueEnumerator(GeografOutLine geografOutLine, String string) {
            this.valueString = string;
            boolean bl = false;
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\"') {
                    bl = !bl;
                    continue;
                }
                if (c != ',' || bl) continue;
                ++n;
            }
            this.elements = n > 0 ? n + 1 : 0;
        }

        @Override
        public boolean hasMoreElements() {
            return this.count < this.elements;
        }

        public Object nextElement() {
            int n = this.valueString.indexOf(DELIM, this.sIdx);
            String string = n == -1 ? this.valueString.substring(this.sIdx) : this.valueString.substring(this.sIdx, n);
            string = string.replace('\"', ' ').trim();
            this.sIdx = n + 1;
            ++this.count;
            return string;
        }
    }
}

