/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IException;
import de.geocalc.awt.IProgressViewer;
import de.geocalc.geodata.Feature;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DPolygon;
import de.geocalc.geom.GeomException;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.Bedingung;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.DataContainerTable;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.FlurstueckArt;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.GObjectManipulator;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.GebaeudeKennzeichen;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.LinieParameter;
import de.geocalc.kafplot.ObjectDecor;
import de.geocalc.kafplot.ObjectSymbol;
import de.geocalc.kafplot.ObjectText;
import de.geocalc.kafplot.ObjectTyp;
import de.geocalc.kafplot.PolarAufnahme;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktParameterALK;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.Symbol;
import de.geocalc.kafplot.Text;
import de.geocalc.kafplot.TopObject;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystemTable;
import de.geocalc.kafplot.io.ErrorWriter;
import de.geocalc.kafplot.io.GeografOutLine;
import de.geocalc.kafplot.io.IDataReader;
import de.geocalc.kafplot.io.gg.GGKey;
import de.geocalc.kafplot.io.gg.GGObject;
import de.geocalc.lang.Exceptionable;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.text.IFormat;
import de.geocalc.util.LongHashList;
import de.geocalc.util.LongHashObject;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GeografOutReader
extends IDataReader {
    private static boolean OBJEKT_SEARCH = true;
    private static boolean OBJEKT_SEARCH_OF_DIGIT = false;
    Vector VP;
    Vector B;
    TrafoSystemTable T;
    DataContainerTable FLST;
    DataContainerTable GEB;
    DataContainerTable TOP;
    LongHashList HP;
    int eb;
    private final Hashtable GP = new Hashtable();
    private final Hashtable L = new Hashtable();
    private final Hashtable TX = new Hashtable();
    private final Hashtable O = new Hashtable();
    private DataInputStream in = null;

    public GeografOutReader(File file, LongHashList longHashList, Vector vector, TrafoSystemTable trafoSystemTable, DataContainerTable dataContainerTable, DataContainerTable dataContainerTable2, DataContainerTable dataContainerTable3) {
        this(file, longHashList, vector, trafoSystemTable, dataContainerTable, dataContainerTable2, dataContainerTable3, null);
    }

    public GeografOutReader(File file, LongHashList longHashList, Vector vector, TrafoSystemTable trafoSystemTable, DataContainerTable dataContainerTable, DataContainerTable dataContainerTable2, DataContainerTable dataContainerTable3, IProgressViewer iProgressViewer) {
        super(file, iProgressViewer);
        this.HP = longHashList;
        this.B = vector;
        this.T = trafoSystemTable;
        this.FLST = dataContainerTable;
        this.GEB = dataContainerTable2;
        this.TOP = dataContainerTable3;
    }

    public GeografOutReader(File file, Vector vector, Vector vector2, TrafoSystemTable trafoSystemTable, DataContainerTable dataContainerTable, DataContainerTable dataContainerTable2, DataContainerTable dataContainerTable3, IProgressViewer iProgressViewer) {
        super(file, iProgressViewer);
        this.VP = vector;
        this.B = vector2;
        this.T = trafoSystemTable;
        this.FLST = dataContainerTable;
        this.GEB = dataContainerTable2;
        this.TOP = dataContainerTable3;
    }

    public static void setObjectSearch(boolean bl) {
        OBJEKT_SEARCH = bl;
    }

    public static void setObjectSearchOfDigit(boolean bl) {
        OBJEKT_SEARCH_OF_DIGIT = bl;
    }

    public String readLine(DataInputStream dataInputStream) throws IOException {
        try {
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = dataInputStream.readUnsignedByte()) > -1) {
                if (n == 10) {
                    return stringBuffer.toString();
                }
                if (n == 13) continue;
                stringBuffer.append((char)n);
            }
            if (n > 1) {
                return stringBuffer.toString();
            }
            return null;
        }
        catch (EOFException eOFException) {
            return null;
        }
    }

    @Override
    public void userAbort() throws IFileInputException {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (Exception exception) {
            throw new IFileInputException(this.getErrorKey() + "Fehler beim Schlie\u00dfen der GeografDatei");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void read() throws IFileInputException {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Cloneable cloneable;
        if (this.VP != null) {
            this.HP = new LongHashList();
        }
        this.eb = 0;
        int n2 = 0;
        boolean bl = false;
        String string = new String();
        boolean bl2 = false;
        Riss riss = null;
        Object object6 = null;
        boolean bl3 = false;
        boolean bl4 = false;
        Vector<Integer> vector = new Vector<Integer>();
        try {
            this.in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.inFile)));
            long l = 0L;
            cloneable = new GeografOutLine();
            object5 = null;
            while ((string = this.readLine(this.in)) != null) {
                try {
                    ++n2;
                    ((GeografOutLine)((Object)cloneable)).setLine(string);
                    int n3 = ((GeografOutLine)((Object)cloneable)).getKennung();
                    if (n3 == -1) continue;
                    if (((GeografOutLine)((Object)cloneable)).hasValues()) {
                        switch (n3) {
                            case 1: {
                                object4 = ((GeografOutLine)((Object)cloneable)).getValueString().trim();
                                if (object4 != null && ((String)object4).equals("GRAFBAT V2")) break;
                                this.addException(new IException("Nicht unterst\u00fctzte GrafBatVersion: " + (String)object4 + "\nSoll: GRAFBAT V2"));
                                break;
                            }
                            case 10: {
                                this.eb = ((GeografOutLine)((Object)cloneable)).readEB();
                                break;
                            }
                            case 20: {
                                this.T.addElement(((GeografOutLine)((Object)cloneable)).readMODEL());
                                break;
                            }
                            case 100: {
                                object3 = ((GeografOutLine)((Object)cloneable)).readPK();
                                if (((Punkt)object3).nr != 0L) {
                                    this.savePunkt((Punkt)object3, this.HP);
                                    object5 = object3;
                                } else {
                                    object5 = null;
                                }
                                this.regularArt((Punkt)object3);
                                this.GP.put(new Integer(((GeografOutLine)((Object)cloneable)).getKey()), object3);
                                if (object6 == null) break;
                                ((Vector)object6).addElement(new GGKey(n3, ((GeografOutLine)((Object)cloneable)).getKey()));
                                break;
                            }
                            case 120: {
                                Linie linie = ((GeografOutLine)((Object)cloneable)).readLI();
                                linie.pa = linie.pa.nr > 1000000000000000L ? (Punkt)this.GP.get(new Integer((int)(1000000000000000L - linie.pa.nr))) : (Punkt)this.HP.get(linie.pa.nr);
                                linie.pe = linie.pe.nr > 1000000000000000L ? (Punkt)this.GP.get(new Integer((int)(1000000000000000L - linie.pe.nr))) : (Punkt)this.HP.get(linie.pe.nr);
                                this.L.put(new Integer(((GeografOutLine)((Object)cloneable)).getKey()), linie);
                                if (object6 == null) break;
                                ((Vector)object6).addElement(new GGKey(n3, ((GeografOutLine)((Object)cloneable)).getKey()));
                                break;
                            }
                            case 130: {
                                int n4 = ((GeografOutLine)((Object)cloneable)).getKey();
                                Object object7 = (Text)this.TX.get(new Integer(n4));
                                object7 = object7 == null ? ((GeografOutLine)((Object)cloneable)).readTA() : ((GeografOutLine)((Object)cloneable)).readTA((Text)object7);
                                ((Text)object7).eb = this.eb;
                                this.TX.put(new Integer(((GeografOutLine)((Object)cloneable)).getKey()), object7);
                                break;
                            }
                            case 131: {
                                int n5 = ((GeografOutLine)((Object)cloneable)).getKey();
                                Object object7 = (Text)this.TX.get(new Integer(n5));
                                if (object7 != null) break;
                                this.TX.put(new Integer(((GeografOutLine)((Object)cloneable)).getKey()), new Text());
                                break;
                            }
                            case 139: {
                                int n6 = ((GeografOutLine)((Object)cloneable)).getKey();
                                Object object7 = (Text)this.TX.get(new Integer(n6));
                                if (object7 == null) {
                                    throw new Exception("TE ohne zugeh\u00f6riges TA,TF gefunden");
                                }
                                object7 = ((GeografOutLine)((Object)cloneable)).readTE((Text)object7);
                                if (object6 == null) break;
                                ((Vector)object6).addElement(new GGKey(n3, ((GeografOutLine)((Object)cloneable)).getKey()));
                                break;
                            }
                            case 112: {
                                Punkt punkt = ((GeografOutLine)((Object)cloneable)).readKS();
                                if (object5 == null) break;
                                Object object7 = (Punkt)this.HP.get(((Punkt)object5).nr);
                                ((Punkt)object7).dx = (float)(((Punkt)object7).x - punkt.x);
                                ((Punkt)object7).dy = (float)(((Punkt)object7).y - punkt.y);
                                this.T.addPunkt(new TrafoPunkt((Punkt)object7, punkt.y, punkt.x), punkt.sw);
                                ((Punkt)object7).setUsed(true);
                                punkt.setPs(0);
                                break;
                            }
                            case 180: {
                                if (riss == null) {
                                    riss = new Riss(6, 601);
                                    this.B.addElement(riss);
                                }
                                Object object7 = ((GeografOutLine)((Object)cloneable)).readBE();
                                if (((Bedingung)object7).p1 != null) {
                                    ((Bedingung)object7).p1 = (Punkt)this.HP.get(((Bedingung)object7).p1.nr);
                                    ((Bedingung)object7).p1.setUsed(true);
                                }
                                if (((Bedingung)object7).p2 != null) {
                                    ((Bedingung)object7).p2 = (Punkt)this.HP.get(((Bedingung)object7).p2.nr);
                                    ((Bedingung)object7).p2.setUsed(true);
                                }
                                if (((Bedingung)object7).p3 != null) {
                                    ((Bedingung)object7).p3 = (Punkt)this.HP.get(((Bedingung)object7).p3.nr);
                                    ((Bedingung)object7).p3.setUsed(true);
                                }
                                riss.addElement(object7);
                                if (((Bedingung)object7).ba != 3) break;
                                object7 = ((GeografOutLine)((Object)cloneable)).readBE2();
                                if (((Bedingung)object7).p1 != null) {
                                    ((Bedingung)object7).p1 = (Punkt)this.HP.get(((Bedingung)object7).p1.nr);
                                    ((Bedingung)object7).p1.setUsed(true);
                                }
                                if (((Bedingung)object7).p2 != null) {
                                    ((Bedingung)object7).p2 = (Punkt)this.HP.get(((Bedingung)object7).p2.nr);
                                    ((Bedingung)object7).p2.setUsed(true);
                                }
                                if (((Bedingung)object7).p3 != null) {
                                    ((Bedingung)object7).p3 = (Punkt)this.HP.get(((Bedingung)object7).p3.nr);
                                    ((Bedingung)object7).p3.setUsed(true);
                                }
                                riss.addElement(object7);
                                break;
                            }
                            case 170: {
                                GGObject gGObject = ((GeografOutLine)((Object)cloneable)).readOA();
                                gGObject.setEb(this.eb);
                                vector.addElement(new Integer(((GeografOutLine)((Object)cloneable)).getKey()));
                                if (object6 != null) {
                                    gGObject.setOberObject((GGObject)object6);
                                }
                                this.O.put(new Integer(((GeografOutLine)((Object)cloneable)).getKey()), gGObject);
                                object6 = gGObject;
                                bl4 = true;
                                break;
                            }
                            case 175: {
                                object2 = (GGObject)this.O.get(((GeografOutLine)((Object)cloneable)).readOG());
                                if (object2 == null) {
                                    throw new Exception("Objekt mit dem Schl\u00fcssel " + ((GeografOutLine)((Object)cloneable)).readOG() + " nicht gefunden");
                                }
                                ((GGObject)object6).copyGeom((GGObject)object2, bl4 ? 1 : 2);
                                break;
                            }
                        }
                    } else {
                        switch (n3) {
                            case 179: {
                                vector.removeElementAt(vector.size() - 1);
                                if (vector.size() > 0) {
                                    object6 = (GGObject)this.O.get((Integer)vector.lastElement());
                                    object6 = ((GGObject)object6).getOberObject();
                                    break;
                                }
                                object6 = null;
                                break;
                            }
                            case 170: {
                                object4 = (GGObject)this.O.get(new Integer(((GeografOutLine)((Object)cloneable)).getKey()));
                                vector.addElement(new Integer(((GeografOutLine)((Object)cloneable)).getKey()));
                                if (object6 != null) {
                                    ((GGObject)object4).setOberObject((GGObject)object6);
                                }
                                object6 = object4;
                                break;
                            }
                            case 172: {
                                bl4 = false;
                            }
                            default: {
                                if (object6 == null) break;
                                ((Vector)object6).addElement(new GGKey(n3, ((GeografOutLine)((Object)cloneable)).getKey()));
                                break;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    this.addException(new IException("Lesefehler in Zeile: " + n2, exception.getMessage()));
                }
                super.setFileProgress(l += (long)(string.length() + 1));
            }
            this.in.close();
            super.setProgress(100);
        }
        catch (Exception exception) {
            this.addException(new IException("Lesefehler in Zeile: " + n2, exception.getMessage()));
        }
        finally {
            try {
                this.in.close();
            }
            catch (Exception exception) {}
        }
        Object object8 = this.O.elements();
        while (object8.hasMoreElements()) {
            object = (GGObject)object8.nextElement();
            cloneable = ((Vector)object).elements();
            while (cloneable.hasMoreElements()) {
                object5 = (GGKey)cloneable.nextElement();
                if (((GGKey)object5).getTyp() != 170) continue;
                ((GGObject)this.O.get(new Integer(((GGKey)object5).getKey()))).setOberObject((GGObject)object);
            }
        }
        if (OBJEKT_SEARCH) {
            object8 = new Vector();
            object = this.O.elements();
            while (object.hasMoreElements()) {
                try {
                    cloneable = (GGObject)object.nextElement();
                    switch (ObjectTyp.getObjectTyp(((GGObject)cloneable).getArt(), ((GGObject)cloneable).getEb())) {
                        case 1: {
                            object5 = ((GGObject)cloneable).toFlurstueck();
                            this.copyElements((GGObject)cloneable, (GObject)object5, true);
                            ((Flurstueck)object5).setAktFlaeche(Math.abs(((GObject)object5).getPolygonFlaeche()));
                            this.FLST.put((Feature)object5);
                            break;
                        }
                        case 2: {
                            Flurstueck flurstueck = ((GGObject)cloneable).toFlurstueck();
                            this.copyElements((GGObject)cloneable, flurstueck, true);
                            flurstueck.setArt(FlurstueckArt.getArt(9, 0, 0));
                            flurstueck.setAktFlaeche(Math.abs(flurstueck.getPolygonFlaeche()));
                            ((Vector)object8).addElement(flurstueck);
                            break;
                        }
                        case 3: {
                            object4 = ((GGObject)cloneable).toGebaeude();
                            this.copyElements((GGObject)cloneable, (GObject)object4, true);
                            if (((Gebaeude)object4).hasLeitzeichen()) {
                                ((Gebaeude)object4).getLeitzeichen().setAngle(this.getObjectTextOrientation((DataContainer)object4));
                            }
                            this.GEB.put((Feature)object4);
                            break;
                        }
                        case 4: {
                            object3 = ((GGObject)cloneable).toTopObject();
                            this.copyElements((GGObject)cloneable, (GObject)object3, false);
                            this.TOP.put((Feature)object3);
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    this.addException(exception);
                }
            }
            if (((Vector)object8).size() > 0) {
                object = new Vector();
                cloneable = new Vector();
                object5 = this.FLST.elements();
                while (object5.hasMoreElements()) {
                    Flurstueck flurstueck = (Flurstueck)object5.nextElement();
                    if (!flurstueck.isAbstractFlurstueck()) continue;
                    Object object9 = object4 = OBJEKT_SEARCH_OF_DIGIT ? flurstueck.getMovedPolygon() : flurstueck.getPolygon();
                    if (object4 == null) continue;
                    object3 = ((Vector)object8).elements();
                    while (object3.hasMoreElements()) {
                        Flurstueck flurstueck2 = (Flurstueck)object3.nextElement();
                        if (!((DPolygon)object4).contains(flurstueck2.y, flurstueck2.x)) continue;
                        flurstueck2.setGemarkung(flurstueck.getGemarkung());
                        flurstueck2.setFlur(flurstueck.getFlur());
                        flurstueck2.setZaehler(flurstueck.getZaehler());
                        flurstueck2.setNenner(flurstueck.getNenner());
                        flurstueck2.setTeil(flurstueck.getTeil());
                        if (flurstueck2.getOska() > 0) {
                            flurstueck2.setNutzung(flurstueck2.getOska() / 10);
                        }
                        ((Vector)object).addElement(flurstueck2);
                    }
                    if (((Vector)object).size() == 0) {
                        this.addException(new GeomException(flurstueck.getHashPoint(), flurstueck.getPolygon(), "F\u00fcr das Flurst\u00fcck: " + flurstueck.toMiniString() + " wurde keine Nutzung gefunden"));
                    } else if (((Vector)object).size() == 1) {
                        object3 = (Flurstueck)((Vector)object).firstElement();
                        double d = Math.abs(flurstueck.getAktFlaeche() - ((Flurstueck)object3).getAktFlaeche());
                        int n7 = flurstueck.getPunkte().size();
                        int n8 = ((GObject)object3).getPunkte().size();
                        if (d > 0.1) {
                            Linie linie;
                            this.addException(new GeomException(flurstueck.getHashPoint(), flurstueck.getPolygon(), "Dem Flurst\u00fcck: " + flurstueck.toMiniString() + " wurde die Nutzung " + ((Flurstueck)object3).getNutzung() + " zugeordnet,\ndie Fl\u00e4chedifferenz betr\u00e4gt: " + GeoNumberFormat.m02.format(d).toString() + "; es wird eine weitere Nutzung=999 angeh\u00e4ngt"));
                            object2 = new Flurstueck();
                            ((Flurstueck)object2).setGemarkung(flurstueck.getGemarkung());
                            ((Flurstueck)object2).setFlur(flurstueck.getFlur());
                            ((Flurstueck)object2).setZaehler(flurstueck.getZaehler());
                            ((Flurstueck)object2).setNenner(flurstueck.getNenner());
                            ((Flurstueck)object2).setTeil(flurstueck.getTeil());
                            ((Flurstueck)object2).setNutzung(999);
                            ((DataContainer)object2).setOska(999);
                            Vector<Linie> vector2 = new Vector<Linie>();
                            Object object10 = flurstueck.elements();
                            while (object10.hasMoreElements()) {
                                linie = (Linie)object10.nextElement();
                                if (linie.pe == null || ((DataContainer)object3).contains(linie)) continue;
                                vector2.addElement(linie);
                            }
                            object10 = ((DataContainer)object3).elements();
                            while (object10.hasMoreElements()) {
                                linie = (Linie)object10.nextElement();
                                if (linie.pe == null || flurstueck.contains(linie)) continue;
                                vector2.addElement(linie);
                            }
                            object10 = (Linie)this.searchStartLinie(vector2).clone();
                            this.createPolygon(vector2, (GObject)object2, (Linie)object10);
                            if (((DataContainer)object2).size() < vector2.size()) {
                                this.createPolygon(vector2, (GObject)object2, ((Linie)object10).skip());
                            }
                            ((Flurstueck)object2).setArt(FlurstueckArt.getArt(9, 0, 0));
                            flurstueck.setArt(FlurstueckArt.getArt(7, 9, 0));
                            ((Vector)cloneable).addElement(object2);
                        } else {
                            if (n8 != n7) {
                                this.addException(new GeomException(flurstueck.getHashPoint(), flurstueck.getPolygon(), "Dem Flurst\u00fcck: " + flurstueck.toMiniString() + " wurde die Nutzung " + ((Flurstueck)object3).getNutzung() + " zugeordnet,\ndie Nutzung enth\u00e4lt " + Math.abs(n7 - n8) + (n7 > n8 ? " weniger" : " mehr") + " Umringspunkte"));
                            }
                            flurstueck.setNutzung(((Flurstueck)object3).getNutzung());
                            flurstueck.setArt(FlurstueckArt.getArt(7, 0, 0));
                            if (((GObject)object3).hasDecor()) {
                                object2 = ((GObject)object3).decors();
                                while (object2.hasMoreElements()) {
                                    flurstueck.addDecor((ObjectDecor)object2.nextElement());
                                }
                            } else {
                                flurstueck.addDecor(new ObjectSymbol(Symbol.VOID, 9999, ((Flurstueck)object3).y, ((Flurstueck)object3).x, 0.0f));
                            }
                            ((Flurstueck)object3).setArt(0);
                        }
                    } else {
                        flurstueck.setArt(FlurstueckArt.getArt(7, 9, 0));
                    }
                    ((Vector)object).removeAllElements();
                }
                object5 = ((Vector)object8).elements();
                while (object5.hasMoreElements()) {
                    Flurstueck flurstueck = (Flurstueck)object5.nextElement();
                    try {
                        if (!flurstueck.isNutzstueck()) continue;
                        this.FLST.put(flurstueck);
                    }
                    catch (GeomException geomException) {
                        this.addException(geomException);
                    }
                }
                object5 = ((Vector)cloneable).elements();
                while (object5.hasMoreElements()) {
                    Flurstueck flurstueck = (Flurstueck)object5.nextElement();
                    try {
                        this.FLST.put(flurstueck);
                    }
                    catch (GeomException geomException) {
                        this.addException(geomException);
                    }
                }
            }
            object = this.GP.elements();
            while (object.hasMoreElements()) {
                cloneable = (Punkt)object.nextElement();
                ((Punkt)cloneable).dx = 0.0f;
                ((Punkt)cloneable).dy = 0.0f;
            }
        } else {
            object8 = this.O.elements();
            while (object8.hasMoreElements()) {
                try {
                    object = (GGObject)object8.nextElement();
                    cloneable = ((GGObject)object).toTopObject();
                    this.copyElements((GGObject)object, (GObject)cloneable, false);
                    this.TOP.put((Feature)((Object)cloneable));
                }
                catch (Exception exception) {
                    this.addException(exception);
                }
            }
            object8 = new Hashtable();
            int n9 = -99;
            cloneable = null;
            object5 = this.L.elements();
            while (object5.hasMoreElements()) {
                Linie linie = (Linie)object5.nextElement();
                if (linie.isOn()) continue;
                linie.setLinie();
                int n10 = linie.getFolie();
                if (n10 != n9) {
                    cloneable = this.getFoloObject(n10, (Hashtable)object8);
                }
                ((DataContainer)cloneable).addElement(linie);
            }
            object5 = this.TX.elements();
            while (object5.hasMoreElements()) {
                Text text = (Text)object5.nextElement();
                if (text.isOn()) continue;
                int n11 = text.eb;
                if (n11 != n9) {
                    cloneable = this.getFoloObject(n11, (Hashtable)object8);
                }
                ((GObject)cloneable).addDecor(new ObjectText(text.getText(), text.ta, text.y, text.x, (float)text.getTextWinkel()));
            }
        }
        long l = Long.MAX_VALUE;
        long l2 = Long.MIN_VALUE;
        int n12 = 0;
        Object object11 = this.HP.elements();
        while (object11.hasMoreElements()) {
            object3 = (Punkt)object11.nextElement();
            if (((Punkt)object3).nr >= 0L) continue;
            this.HP.remove((LongHashObject)object3);
            ((Punkt)object3).nr = this.getFreeNumber(this.HP);
            this.HP.put((LongHashObject)object3);
            l = Math.min(l, ((Punkt)object3).nr);
            l2 = Math.max(l2, ((Punkt)object3).nr);
            ++n12;
        }
        if (this.VP != null) {
            object11 = this.HP.elements();
            while (object11.hasMoreElements()) {
                this.VP.addElement(object11.nextElement());
            }
        }
        if ((n = ((String)(object11 = this.inFile.getName())).lastIndexOf(".")) >= 0) {
            object11 = ((String)object11).substring(0, n);
        }
        ErrorWriter errorWriter = new ErrorWriter(new File((String)object11 + ".Import.err"), this.getExceptionList());
        errorWriter.setHeader("#Geograf-Import am " + new Date().toString() + "\n#" + (String)(n12 > 0 ? n12 + " Punkte ohne Punktnummer, neue Nummern von " + l + " bis " + l2 : ""));
        try {
            errorWriter.write();
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private TopObject getFoloObject(int n, Hashtable hashtable) {
        TopObject topObject = (TopObject)hashtable.get(new Integer(n));
        if (topObject == null) {
            topObject = new TopObject();
            topObject.setOska(9999);
            topObject.setFolie(n);
            topObject.setBezeichnung("Ebene " + n);
            hashtable.put(new Integer(n), topObject);
            try {
                this.TOP.put(topObject);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return topObject;
    }

    private final double getObjectTextOrientation(DataContainer dataContainer) {
        double d = Double.MAX_VALUE;
        double d2 = 0.0;
        DPoint dPoint = new DPoint(dataContainer.y, dataContainer.x);
        Enumeration enumeration = dataContainer.elements();
        while (enumeration.hasMoreElements()) {
            Linie linie = (Linie)enumeration.nextElement();
            double d3 = Math.abs(linie.getInnerDistance(dPoint));
            if (d3 == Double.NaN || !(d3 < d)) continue;
            d = d3;
            d2 = linie.getRichtung();
        }
        return d2 < 0.0 ? d2 + Math.PI : d2;
    }

    private final void copyElements(GGObject gGObject, GObject gObject, boolean bl) {
        int n;
        Exceptionable exceptionable;
        Object object;
        Object object2;
        Vector<Cloneable> vector = new Vector<Cloneable>();
        int n2 = -1;
        boolean bl2 = true;
        block30: for (int i = 0; i < gGObject.size(); ++i) {
            object2 = (GGKey)gGObject.elementAt(i);
            switch (((GGKey)object2).getTyp()) {
                case 120: {
                    Object object3;
                    if (!bl2) continue block30;
                    try {
                        object3 = (Linie)this.L.get(new Integer(((GGKey)object2).getKey()));
                        ((Linie)object3).setOn(true);
                        object = (Linie)((Linie)object3).clone();
                        ((Linie)object).setMitte();
                        vector.addElement((Cloneable)object);
                    }
                    catch (Exception exception) {}
                    continue block30;
                }
                case 100: {
                    Object object3 = (Punkt)this.GP.get(new Integer(((GGKey)object2).getKey()));
                    if (object3 == null) continue block30;
                    try {
                        object = Symbol.getSymbol(Integer.toString(((Punkt)object3).getOska()));
                        gObject.addDecor(new ObjectSymbol((Symbol)object, ((Punkt)object3).getOska(), ((Punkt)object3).y, ((Punkt)object3).x, (float)((Punkt)object3).getSymbolWinkel()));
                    }
                    catch (IException iException) {
                        switch (((Punkt)object3).getOska()) {
                            case 6900: {
                                gObject.addDecor(new ObjectText("Brachland", ((Punkt)object3).getOska(), ((Punkt)object3).y, ((Punkt)object3).x, (float)(((Punkt)object3).getSymbolWinkel() + 1.5707963267948966)));
                                continue block30;
                            }
                        }
                        this.addException(new GeomException(gObject.getHashPoint(), gObject.getPolygon(), "Ein Objekt enth\u00e4lt einen Punkt mit ung\u00fcltiger Art: " + ((Punkt)object3).nr + " O=" + ((Punkt)object3).getOska()));
                    }
                    continue block30;
                }
                case 139: {
                    Object object3 = (Text)this.TX.get(new Integer(((GGKey)object2).getKey()));
                    ((Text)object3).setOn(true);
                    if (object3 == null) continue block30;
                    if (gObject instanceof Flurstueck) {
                        switch (((Text)object3).ta) {
                            case 231: 
                            case 232: 
                            case 1232: {
                                if (((Text)object3).y == gObject.y && ((Text)object3).x == gObject.x) break;
                                gObject.addDecor(new ObjectText(((Text)object3).getText(), ((Text)object3).ta, ((Text)object3).y, ((Text)object3).x, (float)((Text)object3).getTextWinkel()));
                                break;
                            }
                            case 233: 
                            case 239: {
                                if (((Text)object3).y == gObject.y && ((Text)object3).x == gObject.x || ((Text)object3).yt != gObject.y && ((Text)object3).xt != gObject.x) break;
                                gObject.yt = ((Text)object3).y;
                                gObject.xt = ((Text)object3).x;
                            }
                        }
                        if (((Text)object3).ta == gObject.getOska() || ((Text)object3).ta == gObject.getOska() + 1000) continue block30;
                        this.addException(new GeomException(gObject.getHashPoint(), gObject.getPolygon(), "Das Flurst\u00fcck: " + ((Flurstueck)gObject).toMiniString() + " enth\u00e4lt eine ung\u00fcltige Textart: '" + ((Text)object3).getText() + "' O=" + ((Text)object3).ta));
                        continue block30;
                    }
                    if (gObject instanceof Gebaeude) {
                        object = (Gebaeude)gObject;
                        switch (((Text)object3).ta) {
                            case 1031: 
                            case 1034: 
                            case 1035: {
                                Object object4;
                                if (!((Gebaeude)object).hasLeitzeichen()) continue block30;
                                try {
                                    object4 = ((Gebaeude)object).getLeitzeichen();
                                    exceptionable = GebaeudeKennzeichen.parseOutTextFormat(((Text)object3).getText());
                                    ((GebaeudeKennzeichen)exceptionable).setGemeinde(((GebaeudeKennzeichen)object4).getGemeinde());
                                    ((GebaeudeKennzeichen)exceptionable).setStrasse(((GebaeudeKennzeichen)object4).getStrasse());
                                    if (((GebaeudeKennzeichen)exceptionable).equals(object4)) {
                                        if (!(((Text)object3).y == ((GebaeudeKennzeichen)object4).y && ((Text)object3).x == ((GebaeudeKennzeichen)object4).x || ((Text)object3).yt != ((GebaeudeKennzeichen)object4).y && ((Text)object3).xt != ((GebaeudeKennzeichen)object4).x)) {
                                            ((GebaeudeKennzeichen)object4).yt = ((Text)object3).y;
                                            ((GebaeudeKennzeichen)object4).xt = ((Text)object3).x;
                                        }
                                        ((GebaeudeKennzeichen)object4).setAngle(((Text)object3).getTextWinkel());
                                        break;
                                    }
                                    if (((Text)object3).yt != ((Text)object3).y || ((Text)object3).xt != ((Text)object3).x) {
                                        ((GebaeudeKennzeichen)exceptionable).yt = ((Text)object3).y;
                                        ((GebaeudeKennzeichen)exceptionable).y = ((Text)object3).yt;
                                        ((GebaeudeKennzeichen)exceptionable).xt = ((Text)object3).x;
                                        ((GebaeudeKennzeichen)exceptionable).x = ((Text)object3).xt;
                                    } else {
                                        ((GebaeudeKennzeichen)exceptionable).y = ((Text)object3).y;
                                        ((GebaeudeKennzeichen)exceptionable).x = ((Text)object3).x;
                                    }
                                    ((GebaeudeKennzeichen)exceptionable).setAngle(((Text)object3).getTextWinkel());
                                    ((Gebaeude)object).addKennzeichen((GebaeudeKennzeichen)exceptionable);
                                }
                                catch (Exception exception) {
                                    this.addException(new GeomException(((DataContainer)object).getHashPoint(), ((GObject)object).getPolygon(), "Das Geb\u00e4ude: " + ((Gebaeude)object).getObjectName() + " enth\u00e4lt einen ung\u00fcltigen Text: '" + ((Text)object3).getText() + "'"));
                                }
                                break;
                            }
                            case 1032: {
                                Object object4 = IFormat.getLetterAndDigit(((Text)object3).getText());
                                if (!(Character.isDigit(((String)object4).charAt(0)) || ((String)object4).charAt(0) != 'P' && ((String)object4).charAt(0) != 'p')) {
                                    object4 = ((String)object4).substring(1);
                                }
                                try {
                                    if (!((Gebaeude)object).hasLeitzeichen() || Integer.parseInt((String)object4) == ((Gebaeude)object).getLeitzeichen().getLfdNummer()) continue block30;
                                    this.addException(new GeomException(((DataContainer)object).getHashPoint(), ((GObject)object).getPolygon(), "Das Geb\u00e4ude: " + ((Gebaeude)object).getObjectName() + " enth\u00e4lt eine ung\u00fcltige laufende Nummer: '" + ((Text)object3).getText() + "'"));
                                }
                                catch (Exception exception) {
                                    this.addException(new GeomException(((DataContainer)object).getHashPoint(), ((GObject)object).getPolygon(), "Das Geb\u00e4ude: " + ((Gebaeude)object).getObjectName() + " enth\u00e4lt eine ung\u00fcltigen Text: '" + ((Text)object3).getText() + "'"));
                                }
                                break;
                            }
                            default: {
                                gObject.addDecor(new ObjectText(((Text)object3).getText(), ((Text)object3).ta, ((Text)object3).y, ((Text)object3).x, (float)((Text)object3).getTextWinkel()));
                                break;
                            }
                        }
                        continue block30;
                    }
                    if (!(gObject instanceof TopObject)) continue block30;
                    object = (TopObject)gObject;
                    gObject.addDecor(new ObjectText(((Text)object3).getText(), ((Text)object3).ta, ((Text)object3).y, ((Text)object3).x, (float)((Text)object3).getTextWinkel()));
                    continue block30;
                }
                case 172: {
                    bl2 = false;
                    n2 = i;
                }
            }
        }
        if (vector.size() > 1) {
            Linie linie = this.searchStartLinie(vector);
            if (!this.testPolygon(vector, gObject = this.createPolygon(vector, gObject, linie))) {
                linie.skip();
                gObject.removeAllElements();
                gObject = this.createPolygon(vector, gObject, linie);
            }
            if (!this.testPolygon(vector, gObject)) {
                object2 = (Vector)vector.clone();
                for (int i = n2; i < gGObject.size(); ++i) {
                    object = (GGKey)gGObject.elementAt(i);
                    if (((GGKey)object).getTyp() != 120) continue;
                    ((Vector)object2).addElement(this.L.get(new Integer(((GGKey)object).getKey())));
                }
                n2 = -2;
                linie = this.searchStartLinie((Vector)object2);
                gObject.removeAllElements();
                gObject = this.createPolygon((Vector)object2, gObject, linie);
                if (!this.testPolygon((Vector)object2, gObject)) {
                    linie.skip();
                    gObject.removeAllElements();
                    gObject = this.createPolygon((Vector)object2, gObject, linie);
                }
            }
        } else {
            n2 = 0;
        }
        int n3 = 0;
        for (n = 0; n < vector.size(); ++n) {
            Linie linie = (Linie)vector.elementAt(n);
            boolean bl3 = false;
            for (int i = 0; i < gObject.size(); ++i) {
                exceptionable = (Linie)gObject.elementAt(i);
                if (!((Linie)exceptionable).equals(linie)) continue;
                bl3 = true;
                break;
            }
            if (bl3) continue;
            ++n3;
        }
        if (n2 > -1) {
            for (n = n2; n < gGObject.size(); ++n) {
                GGKey gGKey = (GGKey)gGObject.elementAt(n);
                if (gGKey.getTyp() != 120) continue;
                Linie linie = (Linie)this.L.get(new Integer(gGKey.getKey()));
                linie.setLinie();
                gObject.addElement(linie);
            }
        } else if (n2 == -2) {
            for (n = 0; n < gGObject.size(); ++n) {
                GGKey gGKey = (GGKey)gGObject.elementAt(n);
                if (gGKey.getTyp() != 120) continue;
                Linie linie = (Linie)this.L.get(new Integer(gGKey.getKey()));
                boolean bl4 = false;
                for (int i = 0; i < gObject.size(); ++i) {
                    Linie linie2 = (Linie)gObject.elementAt(i);
                    if (!linie2.equals(linie)) continue;
                    bl4 = true;
                    break;
                }
                if (bl4) continue;
                linie.setLinie();
                gObject.addElement(linie);
            }
        }
        this.regularArt(gObject);
        if (n3 > 0) {
            switch (gObject.getOska()) {
                case 231: {
                    break;
                }
                default: {
                    gObject.initGeom();
                    GObjectManipulator gObjectManipulator = new GObjectManipulator(gObject);
                    try {
                        gObjectManipulator.repair();
                        break;
                    }
                    catch (Exception exception) {
                        this.addException(new GeomException(gObject.getHashPoint(), gObject.getPolygon(), "Fehler bei der Linienzuordnung zum Objekt: " + gObject.getObjectName() + ". Es konnten nicht alle Linien des Objektumringes verarbeitet werden"));
                    }
                }
            }
        }
    }

    private boolean testPolygon(Vector vector, GObject gObject) {
        if (gObject.size() < vector.size()) {
            return false;
        }
        DPolygon dPolygon = gObject.getPolygon();
        if (dPolygon == null || dPolygon.npoints < 3) {
            return false;
        }
        double d = dPolygon.getAngleSum();
        double d2 = dPolygon.getArea();
        d = d2 > 0.0 ? (d /= (double)dPolygon.npoints - 2.0) : (d -= (double)(dPolygon.npoints + 1) * Math.PI);
        double d3 = (double)dPolygon.npoints * 1.0E-8;
        return !(Math.abs(d - Math.PI) > d3);
    }

    private Linie searchStartLinie(Vector vector) {
        Linie linie = null;
        for (int i = 0; i < vector.size(); ++i) {
            linie = (Linie)((Linie)vector.elementAt(i)).clone();
            int n = 0;
            int n2 = 0;
            for (int j = i; j < vector.size(); ++j) {
                Linie linie2 = (Linie)vector.elementAt(j);
                if (linie.pa.equals(linie2.pa) || linie.pa.equals(linie2.pe)) {
                    ++n;
                }
                if (!linie.pe.equals(linie2.pa) && !linie.pe.equals(linie2.pe)) continue;
                ++n2;
            }
            if (n == 1) {
                return linie;
            }
            if (n2 != true) continue;
            return linie.skip();
        }
        return null;
    }

    private GObject createPolygon(Vector vector, GObject gObject, Linie linie) {
        Linie linie2 = linie;
        Linie linie3 = null;
        Linie linie4 = null;
        linie.setStart();
        gObject.addElement(linie);
        do {
            linie3 = null;
            boolean bl = linie2.getOska() == 242 || linie2.getOska() == 243;
            for (int i = 0; i < vector.size(); ++i) {
                linie4 = null;
                Linie linie5 = (Linie)vector.elementAt(i);
                if (linie5.equalsIgnoreArt(linie2)) continue;
                if (linie5.pa == linie2.pe) {
                    linie4 = (Linie)linie5.clone();
                } else if (linie5.pe == linie2.pe) {
                    linie4 = ((Linie)linie5.clone()).skip();
                }
                if (linie4 == null) continue;
                if (bl) {
                    if (gObject.contains(linie4)) {
                        continue;
                    }
                } else if (linie4.getOska() == 242 || linie4.getOska() == 243) {
                    linie3 = linie4;
                    break;
                }
                if (linie3 != null) {
                    PolarAufnahme polarAufnahme = new PolarAufnahme();
                    polarAufnahme.setStandPunkt(linie2.pe);
                    polarAufnahme.setAnschlussPunkt(linie2.pa);
                    if (!(polarAufnahme.getMessungOf((Punkt)linie3.pe).l1 < polarAufnahme.getMessungOf((Punkt)linie4.pe).l1)) continue;
                    linie3 = linie4;
                    continue;
                }
                linie3 = linie4;
            }
            if (linie3 == null) break;
            linie3.setMitte();
            gObject.addElement(linie3);
            linie2 = linie3;
        } while (linie2.pe != linie.pa && gObject.size() <= vector.size() * 3);
        Linie linie6 = (Linie)gObject.lastElement();
        gObject.addElement(new Linie(9, linie6.pe, null));
        return gObject;
    }

    private void regularArt(DataContainerTable dataContainerTable) {
        Enumeration enumeration = dataContainerTable.elements();
        while (enumeration.hasMoreElements()) {
            this.regularArt((GObject)enumeration.nextElement());
        }
    }

    private GObject regularArt(GObject gObject) {
        if (OBJEKT_SEARCH) {
            int n = gObject.getOska();
            Enumeration enumeration = gObject.elements();
            while (enumeration.hasMoreElements()) {
                this.regularArt((Linie)enumeration.nextElement(), n);
            }
        } else {
            gObject.setFolie(this.eb);
        }
        return gObject;
    }

    private Linie regularArt(Linie linie, int n) {
        if (linie.pa != null) {
            linie.pa.setUsed(true);
        }
        if (linie.pe != null) {
            linie.pe.setUsed(true);
        }
        LinieParameter linieParameter = linie.getParameter();
        if (!OBJEKT_SEARCH) {
            linieParameter.setFolie(this.eb);
            linie.setParameter(linieParameter);
            return linie;
        }
        int n2 = linieParameter.getOska();
        block0 : switch (n) {
            case 233: {
                switch (n2) {
                    case 233: 
                    case 235: 
                    case 242: 
                    case 245: 
                    case 292: 
                    case 294: {
                        break block0;
                    }
                }
                n2 = 233;
                break;
            }
            case 239: {
                switch (n2) {
                    case 233: 
                    case 235: 
                    case 239: 
                    case 242: {
                        break block0;
                    }
                }
                n2 = 233;
                break;
            }
            case 231: {
                n2 = 231;
                break;
            }
            case 232: {
                n2 = 232;
                break;
            }
            case 1101: 
            case 1116: 
            case 1118: 
            case 1119: 
            case 1122: 
            case 1123: 
            case 1128: 
            case 1129: 
            case 1131: 
            case 1132: 
            case 1137: 
            case 1138: 
            case 1139: 
            case 1145: 
            case 1148: 
            case 1149: 
            case 1158: 
            case 1159: 
            case 1165: 
            case 1168: 
            case 1169: 
            case 1188: 
            case 1189: 
            case 1198: 
            case 1199: 
            case 1451: 
            case 2141: 
            case 2812: 
            case 2818: 
            case 2819: 
            case 2822: 
            case 2828: 
            case 2829: 
            case 2831: {
                switch (n2) {
                    case 242: 
                    case 292: 
                    case 295: 
                    case 1011: 
                    case 1012: 
                    case 1013: 
                    case 1014: 
                    case 1016: 
                    case 1018: 
                    case 1041: 
                    case 1042: 
                    case 1043: 
                    case 1045: 
                    case 1046: 
                    case 1047: 
                    case 1049: {
                        break block0;
                    }
                }
                n2 = 1012;
                break;
            }
            case 1001: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 1135: 
            case 1144: 
            case 1152: 
            case 1162: 
            case 1178: 
            case 1179: 
            case 1211: 
            case 1221: 
            case 1231: 
            case 1301: 
            case 1311: 
            case 1321: 
            case 1331: 
            case 1341: 
            case 1361: 
            case 1372: 
            case 1373: 
            case 1374: 
            case 1378: 
            case 1379: 
            case 1381: 
            case 1399: 
            case 1401: 
            case 1411: 
            case 1421: 
            case 1431: 
            case 1441: 
            case 1442: 
            case 1443: 
            case 1444: 
            case 1445: 
            case 1448: 
            case 1449: 
            case 1461: 
            case 1468: 
            case 1469: 
            case 1471: 
            case 1472: 
            case 1474: 
            case 1478: 
            case 1479: 
            case 1481: 
            case 1482: 
            case 1483: 
            case 1484: 
            case 1488: 
            case 1489: 
            case 1499: 
            case 1701: 
            case 1711: 
            case 1721: 
            case 1731: 
            case 1741: 
            case 1742: 
            case 1743: 
            case 1744: 
            case 1748: 
            case 1749: 
            case 1751: 
            case 1761: 
            case 1778: 
            case 1779: 
            case 1781: 
            case 1799: 
            case 1911: 
            case 1913: 
            case 2101: 
            case 2111: 
            case 2121: 
            case 2131: 
            case 2151: 
            case 2161: 
            case 2199: 
            case 2301: 
            case 2312: 
            case 2313: 
            case 2318: 
            case 2319: 
            case 2321: 
            case 2322: 
            case 2323: 
            case 2324: 
            case 2328: 
            case 2329: 
            case 2332: 
            case 2338: 
            case 2339: 
            case 2341: 
            case 2342: 
            case 2343: 
            case 2344: 
            case 2348: 
            case 2349: 
            case 2351: 
            case 2358: 
            case 2359: 
            case 2399: 
            case 2501: 
            case 2515: 
            case 2518: 
            case 2519: 
            case 2528: 
            case 2529: 
            case 2541: 
            case 2548: 
            case 2549: 
            case 2551: 
            case 2561: 
            case 2599: 
            case 2601: 
            case 2612: 
            case 2619: 
            case 2623: 
            case 2628: 
            case 2629: 
            case 2699: 
            case 2701: 
            case 2711: 
            case 2721: 
            case 2723: 
            case 2724: 
            case 2725: 
            case 2726: 
            case 2727: 
            case 2728: 
            case 2729: 
            case 2731: 
            case 2737: 
            case 2738: 
            case 2741: 
            case 2748: 
            case 2799: 
            case 2801: 
            case 2841: 
            case 2842: 
            case 2848: 
            case 2849: 
            case 2851: 
            case 2861: 
            case 2862: 
            case 2863: 
            case 2869: 
            case 2871: 
            case 2872: 
            case 2873: 
            case 2874: 
            case 2878: 
            case 2879: 
            case 2881: 
            case 2882: 
            case 2883: 
            case 2888: 
            case 2889: 
            case 2894: 
            case 2899: {
                switch (n2) {
                    case 242: 
                    case 292: 
                    case 295: 
                    case 1011: 
                    case 1012: 
                    case 1013: 
                    case 1014: 
                    case 1016: 
                    case 1018: 
                    case 1041: 
                    case 1042: 
                    case 1043: 
                    case 1044: 
                    case 1045: 
                    case 1046: 
                    case 1047: 
                    case 1049: {
                        break block0;
                    }
                }
                n2 = 1013;
                break;
            }
            case 1111: 
            case 1112: 
            case 1113: 
            case 1114: 
            case 1115: 
            case 1121: 
            case 1124: 
            case 1133: 
            case 1134: 
            case 1136: 
            case 1151: 
            case 1161: 
            case 1163: 
            case 1164: 
            case 1171: 
            case 1172: 
            case 1173: 
            case 1174: 
            case 1175: 
            case 1181: 
            case 1182: 
            case 1191: 
            case 1197: 
            case 2811: 
            case 2821: 
            case 2891: {
                switch (n2) {
                    case 242: 
                    case 292: 
                    case 295: 
                    case 1011: 
                    case 1012: 
                    case 1013: 
                    case 1014: 
                    case 1016: 
                    case 1018: 
                    case 1041: 
                    case 1042: 
                    case 1043: 
                    case 1044: 
                    case 1045: 
                    case 1046: 
                    case 1047: 
                    case 1049: {
                        break block0;
                    }
                }
                n2 = 1012;
                break;
            }
            case 1371: 
            case 1462: 
            case 1463: 
            case 1473: 
            case 1774: 
            case 2311: 
            case 2364: 
            case 2365: 
            case 2366: 
            case 2367: 
            case 2511: 
            case 2512: 
            case 2513: 
            case 2514: 
            case 2521: 
            case 2522: 
            case 2571: 
            case 2572: 
            case 2581: 
            case 2591: 
            case 2611: 
            case 2621: 
            case 2622: 
            case 2736: 
            case 2742: 
            case 2921: {
                switch (n2) {
                    case 242: 
                    case 292: 
                    case 295: 
                    case 1011: 
                    case 1012: 
                    case 1013: 
                    case 1014: 
                    case 1016: 
                    case 1018: 
                    case 1041: 
                    case 1042: 
                    case 1043: 
                    case 1044: 
                    case 1045: 
                    case 1046: 
                    case 1047: 
                    case 1049: {
                        break block0;
                    }
                }
                n2 = 1013;
                break;
            }
            case 1141: 
            case 1142: 
            case 1143: 
            case 1194: 
            case 1195: 
            case 2302: 
            case 2361: 
            case 2362: 
            case 2363: 
            case 2368: 
            case 2369: {
                switch (n2) {
                    case 242: 
                    case 292: 
                    case 295: 
                    case 1011: 
                    case 1012: 
                    case 1013: 
                    case 1014: 
                    case 1016: 
                    case 1018: 
                    case 1041: 
                    case 1042: 
                    case 1043: 
                    case 1044: 
                    case 1045: 
                    case 1046: 
                    case 1047: 
                    case 1049: {
                        break block0;
                    }
                }
                n2 = 1012;
                break;
            }
            case 1771: 
            case 1772: 
            case 1773: 
            case 2523: {
                switch (n2) {
                    case 242: 
                    case 292: 
                    case 295: 
                    case 1011: 
                    case 1012: 
                    case 1013: 
                    case 1014: 
                    case 1016: 
                    case 1018: 
                    case 1041: 
                    case 1042: 
                    case 1043: 
                    case 1044: 
                    case 1045: 
                    case 1046: 
                    case 1047: 
                    case 1049: {
                        break;
                    }
                    default: {
                        n2 = 1013;
                    }
                }
            }
            case 999: 
            case 1000: 
            case 1100: 
            case 1110: 
            case 1120: 
            case 1130: 
            case 1140: 
            case 1150: 
            case 1160: 
            case 1170: 
            case 1180: 
            case 1190: 
            case 1210: 
            case 1220: 
            case 1230: 
            case 1300: 
            case 1310: 
            case 1320: 
            case 1330: 
            case 1340: 
            case 1350: 
            case 1360: 
            case 1390: 
            case 1400: 
            case 1410: 
            case 1420: 
            case 1430: 
            case 1440: 
            case 1450: 
            case 1460: 
            case 1470: 
            case 1480: 
            case 1490: 
            case 1700: 
            case 1710: 
            case 1720: 
            case 1730: 
            case 1740: 
            case 1750: 
            case 1760: 
            case 1770: 
            case 1780: 
            case 1790: 
            case 2100: 
            case 2110: 
            case 2120: 
            case 2130: 
            case 2140: 
            case 2150: 
            case 2160: 
            case 2190: 
            case 2300: 
            case 2310: 
            case 2320: 
            case 2330: 
            case 2340: 
            case 2350: 
            case 2360: 
            case 2390: 
            case 2500: 
            case 2510: 
            case 2520: 
            case 2540: 
            case 2550: 
            case 2570: 
            case 2580: 
            case 2590: 
            case 2600: 
            case 2610: 
            case 2620: 
            case 2690: 
            case 2700: 
            case 2710: 
            case 2720: 
            case 2730: 
            case 2740: 
            case 2790: 
            case 2800: 
            case 2810: 
            case 2820: 
            case 2830: 
            case 2840: 
            case 2850: 
            case 2860: 
            case 2870: 
            case 2880: 
            case 2890: 
            case 2900: 
            case 2910: 
            case 2920: 
            case 2990: 
            case 3000: 
            case 3100: 
            case 3110: 
            case 3120: 
            case 3130: 
            case 3140: 
            case 3150: 
            case 3160: 
            case 3170: 
            case 3180: 
            case 3190: 
            case 3200: 
            case 3210: 
            case 3220: 
            case 3230: 
            case 3240: 
            case 3290: 
            case 3300: 
            case 3310: 
            case 3320: 
            case 3330: 
            case 3340: 
            case 3350: 
            case 3360: 
            case 3390: 
            case 3400: 
            case 3410: 
            case 3430: 
            case 3440: 
            case 3460: 
            case 3470: 
            case 3480: 
            case 3490: 
            case 3500: 
            case 3510: 
            case 3520: 
            case 3530: 
            case 3590: 
            case 3600: 
            case 3610: 
            case 3620: 
            case 4000: 
            case 4100: 
            case 4110: 
            case 4120: 
            case 4130: 
            case 4140: 
            case 4150: 
            case 4160: 
            case 4170: 
            case 4180: 
            case 4190: 
            case 4200: 
            case 4210: 
            case 4220: 
            case 4230: 
            case 4240: 
            case 4250: 
            case 4260: 
            case 4270: 
            case 4280: 
            case 4290: 
            case 4300: 
            case 5000: 
            case 5110: 
            case 5120: 
            case 5130: 
            case 5140: 
            case 5150: 
            case 5160: 
            case 5200: 
            case 5210: 
            case 5220: 
            case 5230: 
            case 5240: 
            case 5250: 
            case 5260: 
            case 5300: 
            case 5310: 
            case 5320: 
            case 5330: 
            case 5340: 
            case 5390: 
            case 5400: 
            case 5410: 
            case 5430: 
            case 5450: 
            case 5480: 
            case 5490: 
            case 5500: 
            case 5510: 
            case 5520: 
            case 5530: 
            case 5590: 
            case 5600: 
            case 5610: 
            case 5620: 
            case 5650: 
            case 5690: 
            case 5800: 
            case 5900: 
            case 5910: 
            case 5920: 
            case 5930: 
            case 5940: 
            case 6000: 
            case 6100: 
            case 6110: 
            case 6120: 
            case 6130: 
            case 6140: 
            case 6200: 
            case 6210: 
            case 6220: 
            case 6300: 
            case 6310: 
            case 6320: 
            case 6400: 
            case 6500: 
            case 6600: 
            case 6700: 
            case 6710: 
            case 6720: 
            case 6800: 
            case 6900: 
            case 6910: 
            case 6920: 
            case 6930: 
            case 6940: 
            case 6950: 
            case 6960: 
            case 6970: 
            case 7000: 
            case 7100: 
            case 7200: 
            case 7300: 
            case 7400: 
            case 7600: 
            case 8000: 
            case 8100: 
            case 8110: 
            case 8120: 
            case 8130: 
            case 8200: 
            case 8210: 
            case 8220: 
            case 8300: 
            case 8310: 
            case 8320: 
            case 8400: 
            case 8500: 
            case 8600: 
            case 8610: 
            case 8620: 
            case 8640: 
            case 8650: 
            case 8690: 
            case 8800: 
            case 8900: 
            case 9000: 
            case 9100: 
            case 9110: 
            case 9120: 
            case 9130: 
            case 9190: 
            case 9200: 
            case 9220: 
            case 9230: 
            case 9240: 
            case 9250: 
            case 9260: 
            case 9290: 
            case 9300: 
            case 9310: 
            case 9320: 
            case 9330: 
            case 9340: 
            case 9350: 
            case 9360: 
            case 9390: 
            case 9400: 
            case 9410: 
            case 9420: 
            case 9430: 
            case 9500: 
            case 9510: 
            case 9520: 
            case 9530: 
            case 9590: {
                switch (n2) {
                    case 231: 
                    case 232: 
                    case 233: 
                    case 235: 
                    case 239: 
                    case 242: 
                    case 245: 
                    case 292: 
                    case 294: {
                        break block0;
                    }
                }
                n2 = 241;
            }
        }
        if (n2 >= 200 && n2 <= 300) {
            if (n2 == 241) {
                linieParameter.setLa(4);
                linieParameter.setEb(47);
            } else if (n2 == 242) {
                linieParameter.setLa(0);
                linieParameter.setEb(0);
            } else {
                linieParameter.setLa(2);
                linieParameter.setEb(1);
            }
        } else if (n2 >= 1000 && n2 < 3000 || n2 == 915) {
            linieParameter.setLa(3);
            linieParameter.setEb(2);
        }
        linieParameter.setOska(n2);
        linie.setParameter(linieParameter);
        return linie;
    }

    private void regularArt(Punkt punkt) {
        PunktParameterALK punktParameterALK = (PunktParameterALK)punkt.getParameter();
        if (OBJEKT_SEARCH) {
            switch (punktParameterALK.getModOska()) {
                case 0: {
                    if (this.eb == 57) {
                        punktParameterALK.setEb(50);
                        punktParameterALK.setPa(7);
                        break;
                    }
                    return;
                }
                case 161: 
                case 162: 
                case 164: 
                case 165: 
                case 966: {
                    punktParameterALK.setEb(19);
                    punktParameterALK.setPa(0);
                    break;
                }
                case 122: 
                case 123: {
                    punktParameterALK.setEb(19);
                    punktParameterALK.setPa(1);
                    break;
                }
                case 117: 
                case 118: 
                case 119: {
                    punktParameterALK.setEb(1);
                    punktParameterALK.setPa(2);
                    break;
                }
                case 151: {
                    punktParameterALK.setEb(2);
                    punktParameterALK.setPa(3);
                    break;
                }
                case 152: {
                    punktParameterALK.setEb(3);
                    punktParameterALK.setPa(4);
                    break;
                }
                case 148: {
                    punktParameterALK.setEb(18);
                    punktParameterALK.setPa(9);
                    break;
                }
                case 5117: 
                case 5118: 
                case 5119: {
                    punktParameterALK.setOska(punktParameterALK.getModOska() - 5000);
                    punktParameterALK.setPa(-1);
                    break;
                }
                case 8117: 
                case 8118: 
                case 8119: {
                    punktParameterALK.setOska(punktParameterALK.getModOska() - 8000);
                    punktParameterALK.setPa(-1);
                    break;
                }
                default: {
                    punktParameterALK.setPa(-1);
                    break;
                }
            }
        } else {
            punktParameterALK.setFolie(this.eb);
        }
        punkt.initParameter(punktParameterALK);
    }
}

