/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DPolygon;
import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.AbstractObject;
import de.geocalc.kafplot.ArtKey;
import de.geocalc.kafplot.Buchungsstelle;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.FlurstueckArt;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.GebaeudeKennzeichen;
import de.geocalc.kafplot.GeografProperties;
import de.geocalc.kafplot.Grundbuchblatt;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.Name;
import de.geocalc.kafplot.NutzungsArt;
import de.geocalc.kafplot.ObjectDecor;
import de.geocalc.kafplot.ObjectSymbol;
import de.geocalc.kafplot.ObjectText;
import de.geocalc.kafplot.Oska;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.io.IFileWriter;
import de.geocalc.kafplot.io.gg.GGIOProperties;
import de.geocalc.text.IFormat;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class GeografOutWriter
extends IFileWriter {
    public static final String TITLE = "GeografOutWriter";
    public static final String VERSION = "1.1";
    protected DataBase db;
    protected Hashtable PNR = new Hashtable();
    protected Hashtable LNR = new Hashtable();
    protected int pNr;
    protected int sNr;
    protected int lNr;
    protected int tNr;
    protected int oNr;
    protected int eb;
    protected int lOska;
    protected boolean oskaIsId = false;
    protected static int FOLIE_GEMARKUNG;
    protected static int FOLIE_NUTZUNG;
    protected static int FOLIE_FLURSTUECKE;
    protected static int TA_GEMARKUNG;
    protected static int TA_FLUR;
    protected static int TA_NUTZUNG;
    protected static int TA_FLST;
    protected static int TA_FLST_STR;
    protected static int TA_ONAME_PSNR;
    protected static int TA_ONAME_HSNR;
    protected static int TA_ONAME_LNR;
    protected static int TA_GEB_NAME;
    protected static int TA_GEB_DECOR;
    public static boolean moveObjectKoo;
    public static boolean writeNutzungText;
    public static boolean writeNutzungKey;
    private static double moveObjectKooDist;
    protected static final String COMMENT_MARKER = "* ";
    protected static final String DELIM = ",";
    protected static final String STR = "\"";
    protected static final String SPACE = " ";
    protected static final String EOL = "\n";
    protected static final String TYP = "GRAFBAT V8 f\u00fcr GEOgraf f\u00fcr Windows V1";
    protected static final String PAR_BLATT = "\"GEOGRAF\"";
    protected static final String PAR_MASSTAB = "500";

    public GeografOutWriter(File file, DataBase dataBase) {
        super(file);
        this.db = dataBase;
        this.setParameter();
    }

    protected void setParameter() {
        FOLIE_GEMARKUNG = 1;
        FOLIE_FLURSTUECKE = 1;
        FOLIE_NUTZUNG = 47;
        TA_GEMARKUNG = 102;
        TA_FLUR = 101;
        TA_FLST = 100;
        TA_FLST_STR = 100;
        TA_NUTZUNG = 4700;
        TA_ONAME_PSNR = 200;
        TA_ONAME_HSNR = 200;
        TA_ONAME_LNR = 200;
        TA_GEB_NAME = 200;
        TA_GEB_DECOR = 201;
    }

    @Override
    protected String getDefaultEncoding() {
        return "ISO-8859-1";
    }

    @Override
    public void write() throws IFileOutputException {
        this.pNr = 0;
        this.sNr = 0;
        this.lNr = 0;
        this.tNr = 0;
        this.oNr = 0;
        PrintWriter printWriter = null;
        try {
            Cloneable cloneable;
            Object object;
            this.PNR.clear();
            this.LNR.clear();
            printWriter = this.createWriter();
            this.writeOutHeader(printWriter);
            printWriter.println("TYP: GRAFBAT V8 f\u00fcr GEOgraf f\u00fcr Windows V1");
            String string = GGIOProperties.getCooSystem();
            if (string != null && string.length() > 0) {
                printWriter.println("System: " + string);
            }
            printWriter.println("PAR: \"" + GeografProperties.getGrafArtFileName() + "\",\"" + GeografProperties.getGrafSymFileName() + "\",\"GEOGRAF\",500");
            int n = 0;
            int n2 = 0;
            super.setLabelText("ausgegebene Punkte: ");
            super.setEndValue(DataBase.P.size());
            super.setProgressBreak();
            super.setProgress(0);
            ArtKey artKey = null;
            this.eb = GeografProperties.getDefaultEbene();
            n2 = 0;
            this.writeEbene(printWriter, this.eb);
            Object object2 = DataBase.P.elements();
            while (object2.hasMoreElements()) {
                object = (Punkt)object2.nextElement();
                if (this.punktFilter.isPunktEnabled((Punkt)object)) {
                    cloneable = ((Punkt)object).getParameter(1);
                    if (GeografProperties.getArtExport() || GeografProperties.getEbeneExport()) {
                        artKey = GeografProperties.isOskaModus() ? new ArtKey(Oska.getFolie(((PunktParameter)cloneable).getOska()), ((PunktParameter)cloneable).getOska()) : GeografProperties.getGrafKey((PunktParameter)cloneable);
                    }
                    if (artKey != null && artKey.getEbene() != this.eb) {
                        this.eb = artKey.getEbene();
                        this.writeEbene(printWriter, this.eb);
                    }
                    printWriter.println(((Punkt)object).toGeografOutLine(++n2, GeografProperties.getArtExport() ? artKey.getArt() : GeografProperties.getDefaultPunktArt()));
                    this.PNR.put(object, new Integer(n2));
                    if ((long)n % super.getProgressBreak() == 0L) {
                        super.setLabelValue(n2);
                        super.showProgress(n);
                    }
                }
                ++n;
            }
            n = 0;
            n2 = 0;
            object2 = this.db.getLinien();
            super.setLabelText("ausgegebene Linien: ");
            super.setEndValue(((Hashtable)object2).size());
            super.setProgressBreak();
            super.showProgress(n2);
            this.eb = -1;
            object = ((Hashtable)object2).elements();
            while (object.hasMoreElements()) {
                cloneable = (Linie)object.nextElement();
                if (this.punktFilter.isPunktEnabled(((Linie)cloneable).pa) && this.punktFilter.isPunktEnabled(((Linie)cloneable).pe)) {
                    if (GeografProperties.getArtExport() || GeografProperties.getEbeneExport()) {
                        artKey = GeografProperties.isOskaModus() ? new ArtKey(Oska.getFolie(((Linie)cloneable).getOska()), ((Linie)cloneable).getOska()) : GeografProperties.getGrafKey((Linie)cloneable);
                    }
                    if (artKey != null && artKey.getEbene() != this.eb) {
                        this.eb = artKey.getEbene();
                        this.writeEbene(printWriter, this.eb);
                    }
                    printWriter.println(((Linie)cloneable).toGeografOutLine(++n2, GeografProperties.getArtExport() ? artKey.getArt() : GeografProperties.getDefaultLinieArt()));
                    this.LNR.put(this.oskaIsId ? ((Linie)cloneable).getArtEbeneOskaHashKey() : ((Linie)cloneable).getArtEbeneHashKey(), new Integer(n2));
                    if ((long)n % super.getProgressBreak() == 0L) {
                        super.setLabelValue(n2);
                        super.setProgress(n);
                    }
                }
                ++n;
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
    }

    protected void writeOutHeader(PrintWriter printWriter) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeZone(TimeZone.getTimeZone("ECT"));
        printWriter.println(COMMENT_MARKER);
        printWriter.println("* GRAFBAT - D A T E I  GEOgraf");
        printWriter.println(COMMENT_MARKER);
        printWriter.println("* erstellt mit GeografOutWriter 1.1");
        printWriter.println("* Datum: " + gregorianCalendar.get(5) + "/" + gregorianCalendar.get(2) + "/" + gregorianCalendar.get(1));
        printWriter.println(COMMENT_MARKER);
    }

    protected void writeEbene(PrintWriter printWriter, int n) {
        printWriter.println("EB: " + n);
    }

    protected void writeGebaeudeKennzeichen(PrintWriter printWriter, GebaeudeKennzeichen gebaeudeKennzeichen, GObject gObject) {
        if (gebaeudeKennzeichen.getLfdNummer() == 1 ? gebaeudeKennzeichen.isPseudoNummer() && TA_ONAME_PSNR == 0 : TA_ONAME_LNR == 0) {
            return;
        }
        printWriter.print("TA");
        printWriter.print(++this.tNr);
        printWriter.print(": ");
        if (gebaeudeKennzeichen.getLfdNummer() == 1) {
            if (gebaeudeKennzeichen.isPseudoNummer()) {
                printWriter.print("(");
                if (gebaeudeKennzeichen.isPseudoNummer()) {
                    printWriter.print("P");
                }
                printWriter.print(Integer.toString(gebaeudeKennzeichen.getHausNummer()));
                if (gebaeudeKennzeichen.hasAdressenZusatz()) {
                    printWriter.print(gebaeudeKennzeichen.getAdressenZusatz());
                }
                printWriter.print(")");
            } else {
                printWriter.print(Integer.toString(gebaeudeKennzeichen.getHausNummer()));
                if (gebaeudeKennzeichen.hasAdressenZusatz()) {
                    printWriter.print(gebaeudeKennzeichen.getAdressenZusatz());
                }
            }
        } else {
            printWriter.print("(");
            if (gebaeudeKennzeichen.isPseudoNummer()) {
                printWriter.print("P");
            }
            printWriter.print(Integer.toString(gebaeudeKennzeichen.getLfdNummer()));
            printWriter.print(")");
        }
        printWriter.println("");
        printWriter.print("TE");
        printWriter.print(this.tNr);
        printWriter.print(": ,");
        if (gebaeudeKennzeichen.getLfdNummer() == 1) {
            if (gebaeudeKennzeichen.isPseudoNummer()) {
                printWriter.print(Integer.toString(TA_ONAME_PSNR));
            } else {
                printWriter.print(Integer.toString(TA_ONAME_HSNR));
            }
        } else {
            printWriter.print(Integer.toString(TA_ONAME_LNR));
        }
        printWriter.print(DELIM);
        DPoint dPoint = null;
        dPoint = gebaeudeKennzeichen.hasLocation() ? this.createObjectPoint(gebaeudeKennzeichen.y, gebaeudeKennzeichen.x, gObject) : (gObject.hasLocation() ? new DPoint(gObject.y, gObject.x) : gObject.getMitte());
        printWriter.print(IFormat.f_3.format(dPoint.y).toString());
        printWriter.print(DELIM);
        printWriter.print(IFormat.f_3.format(dPoint.x).toString());
        printWriter.print(DELIM);
        printWriter.print(IFormat.f_3.format(dPoint.y).toString());
        printWriter.print(DELIM);
        printWriter.print(IFormat.f_3.format(dPoint.x).toString());
        printWriter.print(DELIM);
        printWriter.print(IFormat.f_3.format((double)gebaeudeKennzeichen.getAngle() * 200.0 / Math.PI).toString());
        printWriter.println(",0,0,1,0,0.0000,0,0.0000,0.0000,0.000000");
    }

    protected void writeTextDecor(PrintWriter printWriter, ObjectText objectText, GObject gObject) {
        printWriter.print("TA");
        printWriter.print(++this.tNr);
        printWriter.print(": ");
        printWriter.println(GGIOProperties.getDosString(objectText.getText()));
        printWriter.print("TE");
        printWriter.print(this.tNr);
        printWriter.print(": ,");
        printWriter.print(Integer.toString(objectText.getOska()));
        printWriter.print(DELIM);
        if (objectText.hasLocation()) {
            DPoint dPoint = this.createObjectPoint(objectText.y, objectText.x, gObject);
            if (objectText.hasDecorLocation()) {
                dPoint.y = objectText.yt + (dPoint.y - objectText.y);
                dPoint.x = objectText.xt + (dPoint.x - objectText.x);
            }
            printWriter.print(IFormat.f_3.format(dPoint.y).toString());
            printWriter.print(DELIM);
            printWriter.print(IFormat.f_3.format(dPoint.x).toString());
            printWriter.print(DELIM);
            printWriter.print(IFormat.f_3.format(dPoint.y).toString());
            printWriter.print(DELIM);
            printWriter.print(IFormat.f_3.format(dPoint.x).toString());
        } else {
            printWriter.print(DELIM);
            printWriter.print(DELIM);
            printWriter.print(DELIM);
        }
        printWriter.print(DELIM);
        printWriter.print(IFormat.f_3.format((double)objectText.getAngle() * 200.0 / Math.PI));
        printWriter.println(",0,0,1,0,0.0000,0,0.0000,0.0000,0.000000");
    }

    protected void writeSymbolDecor(PrintWriter printWriter, ObjectSymbol objectSymbol, GObject gObject) {
        DPoint dPoint = new DPoint(objectSymbol.y, objectSymbol.x);
        boolean bl = false;
        Object object = this.PNR.keys();
        while (object.hasMoreElements()) {
            Punkt punkt = (Punkt)object.nextElement();
            if (punkt.getOska() != objectSymbol.getOska()) continue;
            DPoint dPoint2 = punkt.getOriginal();
            if (Math.abs(dPoint2.y - dPoint.y) > moveObjectKooDist || Math.abs(dPoint2.x - dPoint.x) > moveObjectKooDist) continue;
            printWriter.print("PK");
            printWriter.print((Integer)this.PNR.get(punkt));
            printWriter.println(":");
            bl = true;
            break;
        }
        if (!bl) {
            printWriter.print("PK");
            printWriter.print(++this.pNr);
            printWriter.print(": SYM");
            printWriter.print(++this.sNr);
            printWriter.print(DELIM);
            printWriter.print(Integer.toString(objectSymbol.getOska()));
            printWriter.print(DELIM);
            object = this.createObjectPoint(objectSymbol.y, objectSymbol.x, gObject);
            printWriter.print(IFormat.f_3.format(((DPoint)object).y));
            printWriter.print(DELIM);
            printWriter.print(IFormat.f_3.format(((DPoint)object).x));
            printWriter.print(DELIM);
            printWriter.print(DELIM);
            printWriter.print(IFormat.f_3.format((double)objectSymbol.getAngle() * 200.0 / Math.PI));
            printWriter.println(",0,0,,,,,,,,,,,,,,");
        }
    }

    protected void writeDecors(PrintWriter printWriter, GObject gObject) {
        Enumeration enumeration = gObject.decors();
        block6: while (enumeration.hasMoreElements()) {
            ObjectDecor objectDecor;
            ObjectDecor objectDecor2 = (ObjectDecor)enumeration.nextElement();
            if (objectDecor2 instanceof ObjectText) {
                objectDecor = (ObjectText)objectDecor2;
                switch (objectDecor.getOska()) {
                    case 6900: {
                        this.writeSymbolDecor(printWriter, new ObjectSymbol(null, objectDecor.getOska(), ((ObjectText)objectDecor).y, ((ObjectText)objectDecor).x, objectDecor.getAngle()), gObject);
                        break;
                    }
                    default: {
                        this.writeTextDecor(printWriter, (ObjectText)objectDecor, gObject);
                        break;
                    }
                }
                continue;
            }
            if (!(objectDecor2 instanceof ObjectSymbol)) continue;
            objectDecor = (ObjectSymbol)objectDecor2;
            switch (objectDecor.getOska()) {
                case 9999: {
                    continue block6;
                }
            }
            this.writeSymbolDecor(printWriter, (ObjectSymbol)objectDecor, gObject);
        }
    }

    protected void writeFlst(PrintWriter printWriter, Flurstueck flurstueck, Hashtable hashtable) {
        Object object;
        if (flurstueck.hasLocation()) {
            printWriter.print("OA");
        } else {
            printWriter.print("OAX");
        }
        printWriter.print(Integer.toString(++this.oNr));
        printWriter.print(": ");
        printWriter.print('\"');
        if (FlurstueckArt.getArt(flurstueck.getArt()) == 2) {
            printWriter.print(IFormat.i06.format(flurstueck.getGemarkung()).toString());
        } else if (FlurstueckArt.getArt(flurstueck.getArt()) == 3) {
            printWriter.print(IFormat.i06.format(flurstueck.getGemarkung()).toString());
            printWriter.print(IFormat.i03.format(flurstueck.getFlur()).toString());
        } else {
            printWriter.print(IFormat.i06.format(flurstueck.getGemarkung()).toString());
            printWriter.print(IFormat.i03.format(flurstueck.getFlur()).toString());
            if (flurstueck.hasVorgabeNummer() && IFormat.hasNumbers(flurstueck.getVorgabeNummer())) {
                if (IFormat.hasOnlyNumbers(flurstueck.getVorgabeNummer())) {
                    printWriter.print(IFormat.i05.format(Integer.parseInt(flurstueck.getVorgabeNummer())));
                    printWriter.print(IFormat.i03.format(0L));
                } else {
                    object = new StringTokenizer(flurstueck.getVorgabeNummer(), " /\\,;.:-_");
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        printWriter.print(IFormat.i05.format(Integer.parseInt(IFormat.getFirstDigits(((StringTokenizer)object).nextToken()))));
                        if (((StringTokenizer)object).hasMoreTokens()) {
                            printWriter.print(IFormat.i03.format(Integer.parseInt(IFormat.getFirstDigits(((StringTokenizer)object).nextToken()))));
                        } else {
                            printWriter.print(IFormat.i03.format(0L));
                        }
                    } else {
                        printWriter.print(IFormat.i08.format(0L));
                    }
                }
            } else {
                printWriter.print(IFormat.i05.format(flurstueck.getZaehler()).toString());
                printWriter.print(IFormat.i03.format(flurstueck.getNenner()).toString());
            }
            printWriter.print("00");
        }
        printWriter.print("\",");
        printWriter.print(flurstueck.getOska());
        printWriter.print(DELIM);
        if (flurstueck.hasLocation()) {
            object = this.createObjectPoint(flurstueck);
            printWriter.print(IFormat.f_3.format(((DPoint)object).y).toString());
            printWriter.print(DELIM);
            printWriter.print(IFormat.f_3.format(((DPoint)object).x).toString());
        } else {
            printWriter.print(DELIM);
        }
        printWriter.print(DELIM);
        printWriter.print(Integer.toString(0));
        printWriter.println(DELIM);
        this.writeObjectLinien(printWriter, flurstueck, hashtable);
        this.writeFlstText(printWriter, flurstueck);
        printWriter.println("OE" + this.oNr + ":");
    }

    protected void writeFlstText(PrintWriter printWriter, Flurstueck flurstueck) {
        if (flurstueck.hasLocation()) {
            Object object;
            printWriter.print("TA");
            printWriter.print(++this.tNr);
            printWriter.print(": ");
            if (flurstueck.isGemarkung()) {
                printWriter.print("Gemarkung " + flurstueck.getGemarkung());
            } else if (flurstueck.isFlur()) {
                printWriter.print("Flur " + flurstueck.getFlur());
            } else if (flurstueck.isNutzstueck()) {
                if (writeNutzungText && (object = NutzungsArt.getNutzungsArt(flurstueck.getNutzung())) != null) {
                    printWriter.print(((NutzungsArt)object).getAbkuerzung() + SPACE);
                }
                if (writeNutzungKey) {
                    printWriter.print("(" + flurstueck.getNutzung() + ")");
                }
            } else if (flurstueck.hasVorgabeNummer()) {
                printWriter.print(flurstueck.getVorgabeNummer());
            } else {
                printWriter.print(flurstueck.getZaehler());
                if (flurstueck.getNenner() > 0) {
                    printWriter.print("_" + flurstueck.getNenner());
                }
            }
            printWriter.println("");
            printWriter.print("TE");
            printWriter.print(this.tNr);
            printWriter.print(": ,");
            printWriter.print(this.getFlstTextArt(flurstueck));
            printWriter.print(DELIM);
            if (flurstueck.hasLocation()) {
                object = this.createObjectPoint(flurstueck);
                if (flurstueck.hasTextLocation()) {
                    ((DPoint)object).y = flurstueck.yt + (((DPoint)object).y - flurstueck.y);
                    ((DPoint)object).x = flurstueck.xt + (((DPoint)object).x - flurstueck.x);
                }
                printWriter.print(IFormat.f_3.format(((DPoint)object).y).toString());
                printWriter.print(DELIM);
                printWriter.print(IFormat.f_3.format(((DPoint)object).x).toString());
            } else {
                printWriter.print(DELIM);
            }
            printWriter.print(DELIM);
            if (flurstueck.hasLocation()) {
                object = this.createObjectPoint(flurstueck);
                printWriter.print(IFormat.f_3.format(((DPoint)object).y).toString());
                printWriter.print(DELIM);
                printWriter.print(IFormat.f_3.format(((DPoint)object).x).toString());
            } else {
                printWriter.print(DELIM);
            }
            printWriter.print(",100.000000,0,0,");
            if (flurstueck.isNutzstueck()) {
                printWriter.print(7);
            } else {
                printWriter.print(flurstueck.getNenner() > 0 ? 4 : 1);
            }
            printWriter.println(",0,0.0000,0,0.0000,0.0000,0.000000");
        }
    }

    protected void writeBstText(PrintWriter printWriter, Flurstueck flurstueck, int n) {
        if (!flurstueck.hasBuchung()) {
            return;
        }
        ++this.tNr;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = flurstueck.buchungen();
        while (enumeration.hasMoreElements()) {
            Buchungsstelle buchungsstelle = (Buchungsstelle)enumeration.nextElement();
            Grundbuchblatt grundbuchblatt = (Grundbuchblatt)DataBase.BUCH.get(buchungsstelle.getGrundbuchblattName());
            if (grundbuchblatt == null) continue;
            stringBuffer.append("GB: " + grundbuchblatt.getBlatt());
            boolean bl = false;
            Enumeration enumeration2 = grundbuchblatt.elements();
            while (enumeration2.hasMoreElements()) {
                Name name = (Name)enumeration2.nextElement();
                bl = false;
                bl = GeografOutWriter.appendText(stringBuffer, bl, name.getNameAsString());
                bl = false;
                if (name.hasGeburtName()) {
                    bl = GeografOutWriter.appendText(stringBuffer, bl, name.getGeburtName());
                }
                if (name.hasGeburtDatum()) {
                    bl = GeografOutWriter.appendText(stringBuffer, bl, name.getGeburtDatum());
                }
                bl = false;
                if (name.hasAdresse()) {
                    bl = GeografOutWriter.appendText(stringBuffer, bl, name.getAdresse());
                }
                if (name.hasPlzPf()) {
                    bl = GeografOutWriter.appendText(stringBuffer, bl, name.getPlzPfAsString());
                }
                if (name.hasPostfach()) {
                    bl = GeografOutWriter.appendText(stringBuffer, bl, name.getPostfachAsString());
                }
                bl = false;
                if (name.hasPostleitzahl()) {
                    bl = GeografOutWriter.appendText(stringBuffer, bl, name.getPostleitzahlAsString());
                }
                if (name.hasOrt()) {
                    bl = GeografOutWriter.appendText(stringBuffer, bl, name.getOrt());
                }
                if (!name.hasLand()) continue;
                bl = GeografOutWriter.appendText(stringBuffer, bl, name.getLandAsString());
            }
            if (!grundbuchblatt.hasZusatz()) continue;
            enumeration2 = new StringTokenizer(grundbuchblatt.getZusatz(), ";");
            while (((StringTokenizer)enumeration2).hasMoreTokens()) {
                stringBuffer.append(EOL + ((StringTokenizer)enumeration2).nextToken());
            }
        }
        enumeration = new StringTokenizer(stringBuffer.toString(), EOL);
        while (((StringTokenizer)enumeration).hasMoreTokens()) {
            printWriter.println("TA" + this.tNr + ": " + GGIOProperties.getDosString(((StringTokenizer)enumeration).nextToken()));
        }
        printWriter.println("TE" + this.tNr + ": ," + n + DELIM + IFormat.f_3.format(flurstueck.y) + DELIM + IFormat.f_3.format(flurstueck.x) + DELIM + IFormat.f_3.format(flurstueck.y) + DELIM + IFormat.f_3.format(flurstueck.x) + ",100.000000,0,0,4,,0,0.0000,0,0.0000,0.0000,0.000000");
    }

    private static boolean appendText(StringBuffer stringBuffer, boolean bl, String string) {
        if (!bl) {
            stringBuffer.append(EOL);
            bl = true;
        } else {
            stringBuffer.append(SPACE);
        }
        stringBuffer.append(string);
        return bl;
    }

    protected int getFlstTextArt(Flurstueck flurstueck) {
        int n = 0;
        n = flurstueck.isGemarkung() ? TA_GEMARKUNG : (flurstueck.isFlur() ? TA_FLUR : (flurstueck.isNutzstueck() ? TA_NUTZUNG : TA_FLST));
        return n;
    }

    protected void writeObjectLinien(PrintWriter printWriter, GObject gObject, Hashtable hashtable) {
        int n;
        Cloneable cloneable;
        if (gObject.isKomplexArea()) {
            Linie linie;
            Linie linie2;
            AbstractObject abstractObject = new AbstractObject();
            Hashtable<Object, Linie> hashtable2 = new Hashtable<Object, Linie>();
            cloneable = new Hashtable();
            for (n = 0; n < gObject.size() && !(linie2 = (Linie)gObject.elementAt(n)).isEnde(); ++n) {
                linie = hashtable2.put(linie2.getArtHashKey(), linie2);
                if (linie == null) continue;
                hashtable2.remove(linie2.getArtHashKey());
                ((Hashtable)cloneable).put(linie2.getArtHashKey(), linie2);
            }
            n = 1;
            for (int i = 0; i < gObject.size(); ++i) {
                linie = (Linie)gObject.elementAt(i);
                if (n != 0) {
                    if (linie.isEnde()) {
                        abstractObject.addElement(linie);
                        n = 0;
                        Enumeration enumeration = ((Hashtable)cloneable).elements();
                        while (enumeration.hasMoreElements()) {
                            Linie linie3 = (Linie)((Linie)enumeration.nextElement()).clone();
                            linie3.setLinie();
                            abstractObject.addElement(linie3);
                        }
                    }
                    if (n != 0 && ((Hashtable)cloneable).get(linie.getArtHashKey()) != null) continue;
                }
                abstractObject.addElement(linie);
            }
            gObject = abstractObject;
        }
        boolean bl = true;
        int n2 = -1;
        if (gObject.defMultiArea()) {
            cloneable = null;
            block7: for (n = 0; n < gObject.size(); ++n) {
                Linie linie = (Linie)gObject.elementAt(n);
                switch (linie.getLs()) {
                    case 1: {
                        cloneable = linie.pa;
                        continue block7;
                    }
                    case 9: {
                        if (linie.pa != cloneable) continue block7;
                        n2 = n;
                    }
                }
            }
        }
        for (int i = 0; i < gObject.size(); ++i) {
            Linie linie = (Linie)gObject.elementAt(i);
            if (linie.isEnde()) {
                if (!bl || n2 > i) continue;
                printWriter.println("OD" + this.oNr + ":");
                bl = false;
                continue;
            }
            if (bl && linie.isLinie()) {
                printWriter.println("OD" + this.oNr + ":");
                bl = false;
            }
            printWriter.print("LI");
            printWriter.print(hashtable.get(this.oskaIsId ? linie.getArtEbeneOskaHashKey() : linie.getArtEbeneHashKey()).toString());
            printWriter.println(':');
        }
        if (bl) {
            printWriter.println("OD" + this.oNr + ":");
        }
    }

    protected DPoint createObjectPoint(GObject gObject) {
        return this.createObjectPoint(gObject.y, gObject.x, gObject);
    }

    protected DPoint createObjectPoint(double d, double d2, GObject gObject) {
        DPoint dPoint = new DPoint(d, d2);
        if (!moveObjectKoo) {
            return dPoint;
        }
        DPoint dPoint2 = null;
        Enumeration enumeration = DataBase.P.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            if (punkt.dy == 0.0f || punkt.dx == 0.0f) continue;
            DPoint dPoint3 = punkt.getOriginal();
            if (Math.abs(dPoint3.y - dPoint.y) > moveObjectKooDist || Math.abs(dPoint3.x - dPoint.x) > moveObjectKooDist) continue;
            dPoint2 = dPoint3;
            break;
        }
        if (dPoint2 != null) {
            return dPoint2.round(1);
        }
        dPoint2 = this.createObjectPoint(d, d2, gObject, gObject.isArea());
        if (dPoint2 != null) {
            return dPoint2;
        }
        dPoint2 = this.createObjectPoint(d, d2, DataBase.P);
        if (dPoint2 != null) {
            return dPoint2;
        }
        return dPoint;
    }

    protected DPoint createObjectPoint(double d, double d2, GObject gObject, boolean bl) {
        DPoint dPoint = new DPoint(d, d2);
        if (!moveObjectKoo) {
            return dPoint;
        }
        DPolygon dPolygon = gObject.getOriginalPolygon();
        if (bl && dPolygon != null && dPolygon.contains(dPoint)) {
            DPoint dPoint2;
            DPoint dPoint3;
            Punkt punkt;
            Punkt punkt2;
            int n;
            Object object;
            Punkt punkt3 = gObject.getNearestPunkt(dPoint);
            for (int i = 0; i < gObject.size(); ++i) {
                object = (Linie)gObject.elementAt(i);
                if (((Linie)object).pa == punkt3) break;
            }
            object = new DPolygon(3);
            DPoint dPoint4 = punkt3.getOriginal();
            ((DPolygon)object).setPointAt(dPoint4, 0);
            for (n = i; n > 1; --n) {
                punkt2 = ((Linie)gObject.elementAt((int)(n - 1))).pa;
                punkt = ((Linie)gObject.elementAt((int)(n - 2))).pa;
                dPoint3 = punkt2.getOriginal();
                ((DPolygon)object).setPointAt(dPoint3, 1);
                dPoint2 = punkt.getOriginal();
                ((DPolygon)object).setPointAt(dPoint2, 2);
                if (!((DPolygon)object).contains(dPoint)) continue;
                return this.createTrianglePoint(dPoint, punkt3, punkt2, punkt).round(1);
            }
            for (n = i; n < gObject.size() - 2; ++n) {
                punkt2 = ((Linie)gObject.elementAt((int)(n + 1))).pa;
                punkt = ((Linie)gObject.elementAt((int)(n + 2))).pa;
                dPoint3 = punkt2.getOriginal();
                dPoint2 = punkt.getOriginal();
                ((DPolygon)object).setPointAt(dPoint3, 1);
                ((DPolygon)object).setPointAt(dPoint2, 2);
                if (!((DPolygon)object).contains(dPoint)) continue;
                return this.createTrianglePoint(dPoint, punkt3, punkt2, punkt).round(1);
            }
        } else {
            Punkt punkt = gObject.getNearestPunkt(dPoint);
            if (punkt != null) {
                return new DPoint(d + (double)punkt.dy, d2 + (double)punkt.dx);
            }
        }
        return null;
    }

    protected DPoint createObjectPoint(double d, double d2, PunktTable punktTable) {
        DPoint dPoint = new DPoint(d, d2);
        if (!moveObjectKoo) {
            return dPoint;
        }
        if (punktTable.size() < 3) {
            return null;
        }
        Punkt punkt = null;
        Punkt punkt2 = null;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MAX_VALUE;
        Object object = punktTable.elements();
        while (object.hasMoreElements()) {
            Punkt punkt3 = (Punkt)object.nextElement();
            double d5 = DPoint.ptDistSq(dPoint.y, dPoint.x, punkt3.y, punkt3.x);
            if (d5 < d3) {
                d4 = d3;
                punkt2 = punkt;
                d3 = d5;
                punkt = punkt3;
                continue;
            }
            if (!(d5 < d4)) continue;
            d4 = d5;
            punkt2 = punkt3;
        }
        if (punkt2 == null || punkt == null) {
            if (punkt != null) {
                return new DPoint(dPoint.y + (double)punkt.dy, dPoint.x + (double)punkt.dx).round(1);
            }
            if (punkt2 != null) {
                return new DPoint(dPoint.y + (double)punkt2.dy, dPoint.x + (double)punkt2.dx).round(1);
            }
            return null;
        }
        object = new DPolygon(3);
        ((DPolygon)object).setPointAt(punkt.y, punkt.x, 0);
        ((DPolygon)object).setPointAt(punkt2.y, punkt2.x, 1);
        double d6 = d4;
        Punkt punkt4 = this.getMinDistPunkt(dPoint.y, dPoint.x, d6, punktTable);
        if (punkt4 != null) {
            ((DPolygon)object).setPointAt(punkt4.y, punkt4.x, 2);
            if (((DPolygon)object).contains(dPoint)) {
                return this.createTrianglePoint(dPoint, punkt, punkt2, punkt4).round(1);
            }
            d6 = DPoint.ptDistSq(dPoint.y, dPoint.x, punkt4.y, punkt4.x);
        }
        return new DPoint(dPoint.y + (double)(punkt.dy + punkt2.dy) / 2.0, dPoint.x + (double)(punkt.dx + punkt2.dx) / 2.0).round(1);
    }

    protected Linie getInnerMinDistLinie(double d, double d2, double d3, GObject gObject) {
        double d4 = Double.MAX_VALUE;
        Linie linie = null;
        Enumeration enumeration = gObject.elements();
        while (enumeration.hasMoreElements()) {
            Linie linie2 = (Linie)enumeration.nextElement();
            if (linie2.pe == null) continue;
            DPoint dPoint = linie2.pa.getOriginal();
            DPoint dPoint2 = linie2.pe.getOriginal();
            double d5 = DLine.ptSegDistSq(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x, d, d2);
            if (Double.isNaN(d5) || !(d5 > d3) || !(d5 < d4)) continue;
            linie = linie2;
            d4 = d5;
        }
        return linie;
    }

    protected Linie getMinDistLinie(double d, double d2, double d3, GObject gObject) {
        double d4 = Double.MAX_VALUE;
        Linie linie = null;
        Enumeration enumeration = gObject.elements();
        while (enumeration.hasMoreElements()) {
            Linie linie2 = (Linie)enumeration.nextElement();
            if (linie2.pe == null) continue;
            DPoint dPoint = linie2.pa.getOriginal();
            DPoint dPoint2 = linie2.pe.getOriginal();
            double d5 = DLine.ptLineDistSq(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x, d, d2);
            if (Double.isNaN(d5) || !(d5 > d3) || !(d5 < d4)) continue;
            linie = linie2;
            d4 = d5;
        }
        return linie;
    }

    protected Punkt getMinDistPunkt(double d, double d2, double d3, PunktTable punktTable) {
        double d4 = Double.MAX_VALUE;
        Punkt punkt = null;
        Enumeration enumeration = punktTable.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt2 = (Punkt)enumeration.nextElement();
            DPoint dPoint = punkt2.getOriginal();
            double d5 = DPoint.ptDistSq(dPoint.y, dPoint.x, d, d2);
            if (!(d5 > d3) || !(d5 < d4)) continue;
            punkt = punkt2;
            d4 = d5;
        }
        return punkt;
    }

    protected DPoint createTrianglePoint(DPoint dPoint, Punkt punkt, Punkt punkt2, Punkt punkt3) {
        DPoint dPoint2 = punkt.getOriginal();
        DPoint dPoint3 = punkt2.getOriginal();
        DPoint dPoint4 = punkt3.getOriginal();
        double d = ((dPoint2.x - dPoint4.x) * (dPoint2.y - dPoint.y) - (dPoint2.x - dPoint.x) * (dPoint2.y - dPoint4.y)) / ((dPoint3.x - dPoint4.x) * (dPoint2.y - dPoint.y) - (dPoint2.x - dPoint.x) * (dPoint3.y - dPoint4.y));
        double d2 = dPoint4.y + d * (dPoint3.y - dPoint4.y);
        double d3 = dPoint4.x + d * (dPoint3.x - dPoint4.x);
        double d4 = Math.sqrt((dPoint4.y - dPoint3.y) * (dPoint4.y - dPoint3.y) + (dPoint4.x - dPoint3.x) * (dPoint4.x - dPoint3.x));
        double d5 = Math.sqrt((dPoint4.y - d2) * (dPoint4.y - d2) + (dPoint4.x - d3) * (dPoint4.x - d3));
        double d6 = (double)punkt3.dy + (double)(punkt2.dy - punkt3.dy) * d5 / d4;
        double d7 = (double)punkt3.dx + (double)(punkt2.dx - punkt3.dx) * d5 / d4;
        d4 = Math.sqrt((dPoint2.y - d2) * (dPoint2.y - d2) + (dPoint2.x - d3) * (dPoint2.x - d3));
        d5 = Math.sqrt((dPoint2.y - dPoint.y) * (dPoint2.y - dPoint.y) + (dPoint2.x - dPoint.x) * (dPoint2.x - dPoint.x));
        d6 = (double)punkt.dy + (d6 - (double)punkt.dy) * d5 / d4;
        d7 = (double)punkt.dx + (d7 - (double)punkt.dx) * d5 / d4;
        dPoint.y += d6;
        dPoint.x += d7;
        return dPoint;
    }

    protected DPoint createLinePoint(DPoint dPoint, Punkt punkt, Punkt punkt2) {
        DPoint dPoint2 = punkt.getOriginal();
        DPoint dPoint3 = punkt2.getOriginal();
        dPoint.y += (double)punkt.dy + (dPoint.y - punkt.y) * (double)(punkt2.dy - punkt.dy) / (dPoint3.y - dPoint2.y);
        dPoint.x += (double)punkt.dx + (dPoint.x - punkt.x) * (double)(punkt2.dx - punkt.dx) / (dPoint3.x - dPoint2.x);
        return dPoint;
    }

    static {
        moveObjectKoo = true;
        writeNutzungText = false;
        writeNutzungKey = true;
        moveObjectKooDist = 0.1;
    }
}

