/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.kafplot.ArtKey;
import de.geocalc.kafplot.GeografProperties;
import de.geocalc.kafplot.Oska;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.io.IPunktWriter;
import de.geocalc.util.LongHashList;
import java.io.File;
import java.util.Vector;

public class GeografPunktWriter
extends IPunktWriter {
    public GeografPunktWriter(File file, LongHashList longHashList) {
        super(file, longHashList);
        this.setParameter();
    }

    public GeografPunktWriter(File file, Vector vector) {
        super(file, vector);
        this.setParameter();
    }

    @Override
    protected void setParameter() {
        super.setSortModus(1);
    }

    @Override
    protected void initValues() {
    }

    @Override
    protected String punktToLine(Punkt punkt) {
        PunktParameter punktParameter = punkt.getParameter();
        if (GeografProperties.hasAlkisDefs()) {
            return punkt.toGeografLine();
        }
        ArtKey artKey = null;
        PunktParameter punktParameter2 = punkt.getParameter(1);
        if (GeografProperties.getArtExport() || GeografProperties.getEbeneExport()) {
            artKey = GeografProperties.isOskaModus() ? new ArtKey(Oska.getFolie(punktParameter2.getOska()), punktParameter2.getOska()) : GeografProperties.getGrafKey(punktParameter2);
        }
        return punkt.toGeografLine(GeografProperties.getEbeneExport() ? artKey.getEbene() : GeografProperties.getDefaultEbene(), GeografProperties.getArtExport() ? artKey.getArt() : GeografProperties.getDefaultPunktArt());
    }

    @Override
    protected String getHeader() {
        return null;
    }

    @Override
    protected String getEndOfFile() {
        return null;
    }
}

