/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IInscription;
import de.geocalc.awt.IInscriptionComponent;
import de.geocalc.geom.DPoint;
import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.GebaeudeKennzeichen;
import de.geocalc.kafplot.GeografProperties;
import de.geocalc.kafplot.GeografRissArt;
import de.geocalc.kafplot.KafPlotColor;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.LinieArt;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.OrthoLinie;
import de.geocalc.kafplot.Oska;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.VermarkungsArt;
import de.geocalc.kafplot.io.GeografOutWriter;
import de.geocalc.kafplot.io.gg.GGIOProperties;
import de.geocalc.text.DecimalFormat;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.text.IFormat;
import java.awt.Font;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GeografRissWriter
extends GeografOutWriter {
    public static final String TITLE = "GeografRissWriter";
    public static final String VERSION = "1.1";
    private double masstab = 500.0;
    private Vector dM;
    private int nextNumber;
    private static int AUFNAHME_GEOMETRIE_EBENE = 50;
    private static int PUNKT_BESCHRIFTUNG_EBENE = 51;
    private static int MASS_BESCHRIFTUNG_EBENE = 52;
    private static int BESTAND_BESCHRIFTUNG_EBENE = 61;
    private static int TEXTART_PUNKTBESCHRIFTUNG = 5000;
    private static int TEXTART_MASSBESCHRIFTUNG = 5000;
    private static int TEXTART_BESTANDBESCHRIFTUNG = 6002;
    private static int ABSTAND_PUNKTBESCHRIFTUNG = 1;
    private DecimalFormat pnrFormat = null;
    protected static final String COMMENT_MARKER = "* ";
    protected static final String DELIM = ",";
    protected static final String STR = "\"";
    protected static final String SPACE = " ";
    protected static final String EOL = "\n";
    protected static final String TYP = "GRAFBAT V8 f\u00fcr GEOgraf f\u00fcr Windows V1";
    protected static final String PAR_ART = "\"s500\"";
    protected static final String PAR_SYM = "\"din1.sym\"";
    protected static final String PAR_BLATT = "\"GEOGRAF\"";
    protected static final String PAR_MASSTAB = "500";

    public GeografRissWriter(File file, DataBase dataBase) {
        super(file, dataBase);
        this.setParameter();
    }

    @Override
    protected void setParameter() {
        super.setParameter();
        TA_ONAME_PSNR = 0;
        TA_ONAME_HSNR = 200;
        TA_ONAME_LNR = 0;
        TA_GEB_NAME = 200;
        TA_GEB_DECOR = 201;
        writeNutzungText = true;
    }

    @Override
    protected String getDefaultEncoding() {
        return "ISO-8859-1";
    }

    @Override
    public void write() throws IFileOutputException {
        this.pNr = 0;
        this.sNr = 0;
        this.lNr = 0;
        this.tNr = 0;
        this.oNr = 0;
        PrintWriter printWriter = null;
        this.pnrFormat = KafPlotProperties.getPnrFormat();
        try {
            Cloneable cloneable;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            this.PNR.clear();
            this.LNR.clear();
            printWriter = this.createWriter();
            this.writeOutHeader(printWriter);
            printWriter.println("TYP: GRAFBAT V8 f\u00fcr GEOgraf f\u00fcr Windows V1");
            String string = GGIOProperties.getCooSystem();
            if (string != null && string.length() > 0) {
                printWriter.println("System: " + string);
            }
            printWriter.println("PAR: \"" + GeografProperties.getRissArtFileName() + "\",\"" + GeografProperties.getRissSymFileName() + "\",\"GEOGRAF\",500");
            super.setLabelText("ausgegebene Punkte: ");
            super.setEndValue(DataBase.P.size());
            super.setProgressBreak();
            super.showProgress(0L);
            int n = 0;
            int n2 = 0;
            int n3 = -1;
            Object object6 = DataBase.P.elements();
            while (object6.hasMoreElements()) {
                object5 = (Punkt)object6.nextElement();
                object4 = ((Punkt)object5).getParameter();
                if (((Punkt)object5).isUsed() && this.punktFilter.isPunktEnabled((Punkt)object5)) {
                    if (((Punkt)object5).isStandPunkt() && ((PunktParameter)object4).getKafPa() == -1) {
                        if (n3 != AUFNAHME_GEOMETRIE_EBENE) {
                            n3 = AUFNAHME_GEOMETRIE_EBENE;
                            this.writeEbene(printWriter, n3);
                        }
                        printWriter.println(((Punkt)object5).toGeografOutLine(++this.pNr, 0));
                        this.PNR.put(object5, new Integer(this.pNr));
                        this.writeFreeStandPunkt(printWriter, ++this.tNr, (Punkt)object5);
                    } else {
                        if (((PunktParameter)object4).getEb() != n3) {
                            n3 = ((PunktParameter)object4).getEb();
                            this.writeEbene(printWriter, n3);
                        }
                        object3 = new GeografRissArt((Punkt)object5);
                        printWriter.println(((Punkt)object5).toGeografOutLine(++this.pNr, ((GeografRissArt)object3).getArt()));
                        this.PNR.put(object5, new Integer(this.pNr));
                    }
                    if ((long)n % super.getProgressBreak() == 0L) {
                        super.setLabelValue(this.pNr);
                        super.setProgress(n);
                    }
                }
                ++n;
            }
            n = 0;
            n2 = 0;
            super.setLabelText("ausgegebene Messungen: ");
            super.setEndValue(DataBase.P.size() + DataBase.MM.size());
            super.setProgressBreak();
            super.showProgress(n2);
            this.writeEbene(printWriter, AUFNAHME_GEOMETRIE_EBENE);
            object6 = null;
            object5 = DataBase.P.elements();
            while (object5.hasMoreElements()) {
                object4 = (Punkt)object5.nextElement();
                if (this.punktFilter.isPunktEnabled((Punkt)object4)) {
                    object3 = new GeografRissArt((Punkt)object4);
                    object2 = new Vector<Messung>();
                    object = DataBase.MP.objects();
                    while (object.hasMoreElements()) {
                        cloneable = (Messung)object.nextElement();
                        if (((Messung)cloneable).ps != null) {
                            object6 = ((Messung)cloneable).ps;
                        }
                        if (((Messung)cloneable).pz != object4) continue;
                        cloneable = (Messung)((Messung)cloneable).clone();
                        if (((Messung)cloneable).ps == null) {
                            ((Messung)cloneable).ps = object6;
                        }
                        if (this.isWrited((Messung)cloneable, (Vector)object2)) continue;
                        ((Vector)object2).addElement(cloneable);
                    }
                    object = ((Vector)object2).elements();
                    while (object.hasMoreElements()) {
                        cloneable = (Messung)object.nextElement();
                        this.writePolarAufnahme(printWriter, ++this.lNr, (Messung)cloneable, ((GeografRissArt)object3).getRadius(this.masstab));
                    }
                    if ((long)n % super.getProgressBreak() == 0L) {
                        super.setLabelValue(this.lNr);
                        super.setProgress(n);
                    }
                }
                ++n;
            }
            object5 = DataBase.MG.objects();
            while (object5.hasMoreElements()) {
                object4 = (Messung)object5.nextElement();
                if (((Messung)object4).ps != null) {
                    object6 = ((Messung)object4).ps;
                } else {
                    object4 = (Messung)((Messung)object4).clone();
                    if (((Messung)object4).ps == null) {
                        ((Messung)object4).ps = object6;
                    }
                }
                this.writeGpsAufnahme(printWriter, ++this.lNr, (Messung)object4);
            }
            object5 = this.db.getLinien();
            n = 0;
            n2 = 0;
            super.setLabelText("ausgegebene Linien: ");
            super.setEndValue(((Hashtable)object5).size());
            super.setProgressBreak();
            super.showProgress(n2);
            n3 = -1;
            object4 = ((Hashtable)object5).elements();
            while (object4.hasMoreElements()) {
                object3 = (Linie)object4.nextElement();
                if (this.punktFilter.isPunktEnabled(((Linie)object3).pa) && this.punktFilter.isPunktEnabled(((Linie)object3).pe)) {
                    if (((Linie)object3).getEb() != n3) {
                        n3 = ((Linie)object3).getEb();
                        this.writeEbene(printWriter, n3);
                    }
                    printWriter.println(((Linie)object3).toGeografOutLine(++this.lNr, LinieArt.getGeografLinieArt((Linie)object3)));
                    this.LNR.put(((Linie)object3).getHashKey(), new Integer(this.lNr));
                    if ((long)n % super.getProgressBreak() == 0L) {
                        super.setLabelValue(n);
                        super.setProgress(n);
                    }
                }
                ++n;
            }
            n = 0;
            n3 = -1;
            n3 = PUNKT_BESCHRIFTUNG_EBENE;
            this.writeEbene(printWriter, n3);
            object4 = DataBase.P.elements();
            while (object4.hasMoreElements()) {
                object3 = (Punkt)object4.nextElement();
                if (((Punkt)object3).isOn() && ((Punkt)object3).isUsed() && this.punktFilter.isPunktEnabled((Punkt)object3) && ((Punkt)object3).getKafPa() != -1) {
                    this.writePunktBeschriftung(printWriter, ++this.tNr, ++this.oNr, (Punkt)object3);
                }
                ++n;
            }
            n = 0;
            super.setLabelText("ausgegebene Objekte: ");
            super.setEndValue(DataBase.FLST.size() + DataBase.GEB.size() + DataBase.TOP.size());
            super.setProgressBreak();
            super.showProgress(this.oNr);
            object4 = DataBase.FLST.elements();
            while (object4.hasMoreElements()) {
                object3 = (Flurstueck)object4.nextElement();
                if (((Flurstueck)object3).isGemarkung()) {
                    n3 = FOLIE_GEMARKUNG;
                    this.writeEbene(printWriter, n3);
                    this.writeFlstText(printWriter, (Flurstueck)object3);
                } else if (((Flurstueck)object3).isFlur()) {
                    n3 = FOLIE_GEMARKUNG;
                    this.writeEbene(printWriter, n3);
                    this.writeFlstText(printWriter, (Flurstueck)object3);
                } else if (((Flurstueck)object3).isNutzstueck()) {
                    if (n3 != FOLIE_NUTZUNG) {
                        n3 = FOLIE_NUTZUNG;
                        this.writeEbene(printWriter, n3);
                    }
                    this.writeFlstText(printWriter, (Flurstueck)object3);
                } else {
                    if (n3 != FOLIE_FLURSTUECKE) {
                        n3 = FOLIE_FLURSTUECKE;
                        this.writeEbene(printWriter, n3);
                    }
                    this.writeFlstText(printWriter, (Flurstueck)object3);
                    if (((Flurstueck)object3).getNutzung() != -1) {
                        n3 = FOLIE_NUTZUNG;
                        this.writeEbene(printWriter, n3);
                        object2 = new Flurstueck();
                        ((Flurstueck)object2).setNutzung(((Flurstueck)object3).getNutzung());
                        ((Flurstueck)object2).setArt(901);
                        ((Flurstueck)object2).x = ((Flurstueck)object3).x;
                        ((Flurstueck)object2).y = ((Flurstueck)object3).y;
                        this.writeFlstText(printWriter, (Flurstueck)object2);
                    }
                    if (((Flurstueck)object3).hasBuchung()) {
                        n3 = BESTAND_BESCHRIFTUNG_EBENE;
                        this.writeEbene(printWriter, n3);
                        this.writeBstText(printWriter, (Flurstueck)object3, TEXTART_BESTANDBESCHRIFTUNG);
                    }
                }
                if ((long)n % super.getProgressBreak() == 0L) {
                    super.setLabelValue(n);
                    super.setProgress(n);
                }
                ++n;
            }
            object4 = DataBase.GEB.elements();
            while (object4.hasMoreElements()) {
                object3 = (Gebaeude)object4.nextElement();
                if (((Gebaeude)object3).hasLeitzeichen()) {
                    this.writeGebaeudeKennzeichen(printWriter, ((Gebaeude)object3).getLeitzeichen(), (GObject)object3);
                }
                if (((Gebaeude)object3).hasKennzeichen()) {
                    object2 = ((Gebaeude)object3).kennzeichen();
                    while (object2.hasMoreElements()) {
                        this.writeGebaeudeKennzeichen(printWriter, (GebaeudeKennzeichen)object2.nextElement(), (GObject)object3);
                    }
                }
                if (((DataContainer)object3).getOska() > 0) {
                    object2 = ((GObject)object3).getMitte();
                    ++this.tNr;
                    object = Oska.getRissText(((DataContainer)object3).getOska());
                    if (object == null) {
                        object = "";
                    }
                    object = (String)object + " (" + ((DataContainer)object3).getOska() + ")";
                    printWriter.println("TA" + this.tNr + ": " + (String)object);
                    printWriter.println("TE" + this.tNr + ": ," + TA_GEB_NAME + DELIM + IFormat.f_3.format(((DPoint)object2).y).toString() + DELIM + IFormat.f_3.format(((DPoint)object2).x).toString() + DELIM + IFormat.f_3.format(((DPoint)object2).y).toString() + DELIM + IFormat.f_3.format(((DPoint)object2).x).toString() + ",100.000,0,0,1,0,0.0000,0,0.0000,0.0000,0.000000");
                }
                if ((long)n % super.getProgressBreak() == 0L) {
                    super.setLabelValue(n);
                    super.setProgress(n);
                }
                ++n;
            }
            n3 = MASS_BESCHRIFTUNG_EBENE;
            this.writeEbene(printWriter, n3);
            int n4 = 0;
            int n5 = 0;
            object2 = new OrthoLinie();
            object = DataBase.MM.elements();
            while (object.hasMoreElements()) {
                cloneable = (Riss)object.nextElement();
                block23: for (int i = 0; i < ((DataContainer)cloneable).size(); ++i) {
                    Messung messung = (Messung)((DataContainer)cloneable).elementAt(i);
                    switch (messung.getMessungsArt()) {
                        case 220: 
                        case 240: 
                        case 260: {
                            Linie linie = new Linie(2, 7, MASS_BESCHRIFTUNG_EBENE, messung.ps, messung.pz, messung.l1, messung.l2);
                            Integer n6 = (Integer)this.LNR.get(linie.getHashKey());
                            if (n6 == null) {
                                printWriter.println(linie.toGeografOutLine(++this.lNr, 5000));
                                this.LNR.put(linie.getHashKey(), new Integer(this.lNr));
                            }
                            this.writeLineMass(printWriter, linie, n6 != null ? n6 : this.lNr, IFormat.f_2.format(messung.l1), 0, ++this.tNr, ++this.oNr);
                            continue block23;
                        }
                        case 210: {
                            object2 = new OrthoLinie();
                            ((Vector)object2).addElement(messung.pz != null ? messung.pz : messung.ps);
                            n4 = i;
                            continue block23;
                        }
                        case 290: {
                            ((Vector)object2).addElement(messung.pz != null ? messung.pz : messung.ps);
                            double d = new Linie(((OrthoLinie)object2).getAnfangsPunkt(), ((OrthoLinie)object2).getEndPunkt()).getRichtung() * 200.0 / Math.PI;
                            n5 = i;
                            Punkt punkt = null;
                            for (int j = n4; j <= n5; ++j) {
                                Object object7;
                                Object object8;
                                Object object9;
                                Messung messung2 = (Messung)((DataContainer)cloneable).elementAt(j);
                                int n7 = messung2.getMessungsArt(false);
                                int n8 = 0;
                                switch (n7) {
                                    case 210: {
                                        if (messung2.l1 == 0.0) break;
                                        n8 = 1;
                                        break;
                                    }
                                    case 200: 
                                    case 240: {
                                        if (!messung2.isEinbindeMass()) break;
                                        n8 = 3;
                                        break;
                                    }
                                    case 290: {
                                        n8 = 4;
                                    }
                                }
                                Object object10 = object9 = messung2.pz != null ? messung2.pz : messung2.ps;
                                if (n7 == 240) {
                                    object9 = messung2.ps;
                                }
                                if (messung2.pz != null && n7 != 240) {
                                    object8 = new Punkt(this.getFreeNumber(), ((Punkt)object9).y, ((Punkt)object9).x);
                                    if (((Punkt)object9).nr <= 0L) {
                                        object9 = object8;
                                    }
                                    object7 = new Linie(2, 7, MASS_BESCHRIFTUNG_EBENE, (Punkt)(messung2.l2 > 0.0 ? object9 : messung2.ps), (Punkt)(messung2.l2 > 0.0 ? messung2.ps : object9));
                                    double d2 = ((Linie)object7).getRichtung();
                                    if (messung2.l2 < 0.0) {
                                        d2 += 1.5707963267948966;
                                    }
                                    ((Punkt)object8).setSymbolWinkel(d2);
                                    printWriter.println(((Punkt)object8).toGeografOutLine(++this.pNr, 5008));
                                    this.PNR.put(object8, new Integer(this.pNr));
                                    Integer n9 = (Integer)this.LNR.get(((Linie)object7).getHashKey());
                                    if (n9 == null) {
                                        printWriter.println(((Linie)object7).toGeografOutLine(++this.lNr, 5000));
                                        this.LNR.put(((Linie)object7).getHashKey(), new Integer(this.lNr));
                                    }
                                    this.writeLineMass(printWriter, (Linie)object7, n9 != null ? n9 : this.lNr, IFormat.f_2.format(Math.abs(messung2.l2)), 0, ++this.tNr, ++this.oNr);
                                }
                                if (messung2.getWerteBelegung() > 0 && (object8 = (Integer)this.PNR.get(object9)) != null) {
                                    this.writePunktMass(printWriter, (Punkt)object9, (Integer)object8, IFormat.f_2.format(messung2.l1), d + 100.0, n8, messung2.l2 <= 0.0 ? 3 : 5, ++this.tNr, ++this.oNr);
                                }
                                if (punkt != null && (object7 = (Integer)this.LNR.get(((Linie)(object8 = new Linie(2, 7, MASS_BESCHRIFTUNG_EBENE, punkt, (Punkt)object9))).getHashKey())) == null) {
                                    printWriter.println(((Linie)object8).toGeografOutLine(++this.lNr, 5000));
                                    this.LNR.put(((Linie)object8).getHashKey(), new Integer(this.lNr));
                                }
                                punkt = object9;
                            }
                            continue block23;
                        }
                    }
                }
                if ((long)n % super.getProgressBreak() == 0L) {
                    super.setLabelValue(this.lNr);
                    super.setProgress(n);
                }
                ++n;
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
    }

    protected void writePunktMass(PrintWriter printWriter, Punkt punkt, int n, String string, double d, int n2, int n3, int n4, int n5) {
        double d2 = 7.0E-4 * (n3 == 5 ? -1.0 : 1.0);
        printWriter.println("TA" + n4 + ": " + string);
        printWriter.println("TF" + n4 + ": " + string);
        printWriter.println("TE" + n4 + ": ," + TEXTART_MASSBESCHRIFTUNG + DELIM + IFormat.f_4.format(punkt.y) + DELIM + IFormat.f_4.format(punkt.x) + DELIM + IFormat.f_4.format(punkt.y) + DELIM + IFormat.f_4.format(punkt.x) + DELIM + IFormat.f_4.format(d) + DELIM + n2 + ",0," + n3 + ",0,,161," + Math.sin(d * Math.PI / 200.0) * d2 + DELIM + Math.cos(d * Math.PI / 200.0) * d2 + DELIM);
        printWriter.println("OA" + n5 + ": \"Beschriftung\",9999,0.0000,0.0000,2,,,,,,0");
        printWriter.println("PK" + n + ":");
        printWriter.println("TE" + n4 + ":");
        printWriter.println("OD" + n5 + ":");
        printWriter.println("OT" + n5 + ":");
        printWriter.println("OE" + n5 + ":");
    }

    protected void writeLineMass(PrintWriter printWriter, Linie linie, int n, String string, int n2, int n3, int n4) {
        printWriter.println("TA" + n3 + ": " + string);
        printWriter.println("TF" + n3 + ": " + string);
        DPoint dPoint = linie.getHashPoint();
        printWriter.println("TE" + n3 + ": ," + TEXTART_MASSBESCHRIFTUNG + DELIM + IFormat.f_4.format(dPoint.y) + DELIM + IFormat.f_4.format(dPoint.x) + DELIM + IFormat.f_4.format(dPoint.y) + DELIM + IFormat.f_4.format(dPoint.x) + DELIM + IFormat.f_4.format(linie.getRichtung() * 200.0 / Math.PI) + DELIM + n2 + ",0,1,0,,177,,0.0002");
        printWriter.println("OA" + n4 + ": \"Beschriftung\",9999,0.0000,0.0000,2,,,,,,0");
        printWriter.println("TE" + n3 + ":");
        printWriter.println("OD" + n4 + ":");
        printWriter.println("OT" + n4 + ":");
        printWriter.println("LI" + n + ":");
        printWriter.println("OE" + n4 + ":");
    }

    protected void writePunktBeschriftung(PrintWriter printWriter, int n, int n2, Punkt punkt) {
        IInscription iInscription = new IInscription(new Point());
        IInscriptionComponent iInscriptionComponent = null;
        Font font = new Font("Monospaced", 0, 10);
        boolean bl = false;
        int n3 = 0;
        iInscription.add(new IInscriptionComponent(this.pnrFormat.format(punkt.getNr()).toString(), 0, n3++));
        PunktParameter punktParameter = punkt.getParameter();
        if (punktParameter.getKafVa() > 0) {
            String string = VermarkungsArt.getVermarkungsArt(punktParameter.getVa()).getKuerzel();
            VermarkungsArt vermarkungsArt = VermarkungsArt.getVermarkungsArt(punktParameter.getVva());
            String string2 = !vermarkungsArt.isUnvermarkt() ? vermarkungsArt.getKuerzel() : null;
            int n4 = punktParameter.getModVva();
            if (n4 == 99) {
                string = vermarkungsArt.getKuerzel();
                string2 = null;
            } else if (n4 == 98) {
                string2 = string;
                string = vermarkungsArt.getKuerzel();
            }
            if (string != null) {
                if (punktParameter.getKafVvt() == 0 || string2 != null) {
                    iInscriptionComponent = new IInscriptionComponent(string, 0, n3++);
                    iInscription.add(iInscriptionComponent);
                } else {
                    iInscriptionComponent = new IInscriptionComponent((punktParameter.getKafVvt() > 0 ? GeoNumberFormat.m01.format((double)Math.abs(punktParameter.getKafVvt()) / 10.0).toString() : string) + "\t" + (punktParameter.getKafVvt() < 0 ? GeoNumberFormat.m01.format((double)Math.abs(punktParameter.getKafVvt()) / 10.0).toString() : string), 0, n3++);
                    iInscription.add(iInscriptionComponent);
                }
                iInscriptionComponent.setFont(font);
                iInscriptionComponent.setForeground(punkt.isNeuVermarkt() ? KafPlotColor.GP_NEU : KafPlotColor.GP_VORHANDEN);
            }
            if (string2 != null) {
                if (punktParameter.getKafVvt() == 0) {
                    iInscriptionComponent = new IInscriptionComponent(string2, 0, n3);
                    iInscription.add(iInscriptionComponent);
                } else {
                    iInscriptionComponent = new IInscriptionComponent((punktParameter.getKafVvt() > 0 ? GeoNumberFormat.m01.format((double)Math.abs(punktParameter.getKafVvt()) / 10.0).toString() : string2) + "\t" + (punktParameter.getKafVvt() < 0 ? GeoNumberFormat.m01.format((double)Math.abs(punktParameter.getKafVvt()) / 10.0).toString() : string2), 0, n3);
                    iInscription.add(iInscriptionComponent);
                }
                iInscriptionComponent.setFont(font);
                iInscriptionComponent.setForeground(KafPlotColor.GP_VORHANDEN);
                iInscriptionComponent = new IInscriptionComponent("aufgef.", 1, n3);
                iInscription.add(iInscriptionComponent);
                iInscriptionComponent.setFont(font);
                iInscriptionComponent.setForeground(KafPlotColor.GP_VORHANDEN);
            }
        }
        if (iInscription.getComponentCount() > 0) {
            int n5;
            iInscription.doLayout();
            printWriter.print("OA" + n2 + ": \"Beschriftung\",9999,");
            printWriter.print(GeoNumberFormat.koo04.format(punkt.y).toString() + DELIM);
            printWriter.print(GeoNumberFormat.koo04.format(punkt.x).toString() + DELIM);
            printWriter.println("2,");
            printWriter.println("PK" + String.valueOf(this.PNR.get(punkt)) + ":");
            for (n5 = 0; n5 < iInscription.getComponentCount(); ++n5) {
                printWriter.println("TA" + n + ": " + ((IInscriptionComponent)iInscription.getComponent(n5)).getText().replace('\t', '_'));
            }
            for (n5 = 0; n5 < iInscription.getComponentCount(); ++n5) {
                printWriter.println("TF" + n + ": " + ((IInscriptionComponent)iInscription.getComponent(n5)).getText().replace('\t', '_'));
            }
            printWriter.print("TE" + n + ": ," + TEXTART_PUNKTBESCHRIFTUNG + DELIM);
            printWriter.print(GeoNumberFormat.koo04.format(punkt.y + (double)ABSTAND_PUNKTBESCHRIFTUNG * this.masstab / 1000.0).toString() + DELIM);
            printWriter.print(GeoNumberFormat.koo04.format(punkt.x + (double)ABSTAND_PUNKTBESCHRIFTUNG * this.masstab / 1000.0).toString() + DELIM);
            printWriter.print(",,,,,,,,161,");
            printWriter.print(new GeografRissArt(punkt).getRadius(this.masstab) / this.masstab + (double)ABSTAND_PUNKTBESCHRIFTUNG / 1000.0);
            printWriter.println(",0.0,0.0");
            printWriter.println("OD:");
            printWriter.println("OT:");
            printWriter.println("OE:");
        }
    }

    protected void writePolarAufnahme(PrintWriter printWriter, int n, Messung messung) {
        this.writePolarAufnahme(printWriter, n, messung, 0.0);
    }

    protected void writePolarAufnahme(PrintWriter printWriter, int n, Messung messung, double d) {
        printWriter.print("LI" + n + ":");
        printWriter.print(GeografProperties.getPunktNummer(messung.ps) + DELIM);
        printWriter.print(GeografProperties.getPunktNummer(messung.pz) + DELIM);
        int n2 = 5060;
        if (messung.pz.isStandPunkt()) {
            if (this.isPolarGegenseitig(messung)) {
                n2 = 5061;
            }
        } else if (messung.mNr > 1) {
            n2 = 5062;
        }
        printWriter.print(new Integer(n2) + DELIM);
        printWriter.print(GeoNumberFormat.koo04.format(0.0).toString() + DELIM);
        printWriter.print(GeoNumberFormat.koo04.format(0.0).toString() + DELIM);
        printWriter.print(GeoNumberFormat.koo04.format(0.0).toString() + DELIM);
        printWriter.print("1,1,0.0000,,");
        if (messung.pz.isStandPunkt()) {
            printWriter.println(GeoNumberFormat.koo04.format(1.0).toString());
        } else {
            printWriter.println(GeoNumberFormat.koo04.format(d).toString());
        }
    }

    protected void writeGpsAufnahme(PrintWriter printWriter, int n, Messung messung) {
        printWriter.print("LI" + n + ":");
        printWriter.print(GeografProperties.getPunktNummer(messung.ps) + DELIM);
        printWriter.print(GeografProperties.getPunktNummer(messung.pz) + DELIM);
        printWriter.print("5065,");
        printWriter.print(GeoNumberFormat.koo04.format(0.0).toString() + DELIM);
        printWriter.print(GeoNumberFormat.koo04.format(0.0).toString() + DELIM);
        printWriter.print(GeoNumberFormat.koo04.format(0.0).toString() + DELIM);
        printWriter.print("1,1,0.0000,,");
        printWriter.println(GeoNumberFormat.koo04.format(0.0).toString());
    }

    protected void writeFreeStandPunkt(PrintWriter printWriter, int n, Punkt punkt) {
        printWriter.println("TA" + n + ": " + GeografProperties.getPunktNummer(punkt));
        printWriter.print("TE" + n + ": ,");
        printWriter.print("5000,");
        printWriter.print(GeoNumberFormat.koo04.format(punkt.y).toString() + DELIM);
        printWriter.print(GeoNumberFormat.koo04.format(punkt.x).toString() + DELIM);
        printWriter.print(GeoNumberFormat.koo04.format(punkt.y).toString() + DELIM);
        printWriter.print(GeoNumberFormat.koo04.format(punkt.x).toString() + DELIM);
        printWriter.print(GeoNumberFormat.koo04.format(100.0).toString() + DELIM);
        printWriter.println("2, 1, 4, 0, 0.0, 0, 0.0, 0.0, 0.0");
    }

    private long getFreeNumber() {
        return --this.nextNumber;
    }

    private boolean isWrited(Messung messung, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Messung messung2 = (Messung)enumeration.nextElement();
            if (!messung.equals(messung2)) continue;
            return true;
        }
        return false;
    }

    private boolean isPolarGegenseitig(Messung messung) {
        Enumeration enumeration = DataBase.MP.objects();
        while (enumeration.hasMoreElements()) {
            Messung messung2 = (Messung)enumeration.nextElement();
            if (!messung.equalsIgnoreChange(messung2)) continue;
            return true;
        }
        return false;
    }
}

