/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.GeografProperties;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.io.GeografOutWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class GeografUmnumWriter
extends GeografOutWriter {
    public static final String TITLE = "GeografUmnumWriter";
    public static final String VERSION = "1.0";
    protected static final String COMMENT_MARKER = "* ";
    protected static final String DELIM = ",";
    protected static final String STR = "\"";
    protected static final String SPACE = " ";
    protected static final String EOL = "\n";
    protected static final String TYP = "GRAFBAT V8 f\u00fcr GEOgraf f\u00fcr Windows V1";
    protected static final String PAR_BLATT = "\"GEOGRAF\"";
    protected static final String PAR_MASSTAB = "500";

    public GeografUmnumWriter(File file, DataBase dataBase) {
        super(file, dataBase);
    }

    @Override
    protected void setParameter() {
    }

    @Override
    public void write() throws IFileOutputException {
        PrintWriter printWriter = null;
        try {
            printWriter = this.createWriter();
            this.writeOutHeader(printWriter);
            printWriter.println("TYP: GRAFBAT V8 f\u00fcr GEOgraf f\u00fcr Windows V1");
            printWriter.println("PAR: \"" + GeografProperties.getGrafArtFileName() + "\",\"" + GeografProperties.getGrafSymFileName() + "\",\"GEOGRAF\",500");
            int n = 0;
            int n2 = 0;
            super.setLabelText("ausgegebene Punkte: ");
            super.setEndValue(DataBase.P.size());
            super.setProgressBreak();
            super.setProgress(0);
            Enumeration enumeration = DataBase.P.elements();
            while (enumeration.hasMoreElements()) {
                Punkt punkt = (Punkt)enumeration.nextElement();
                if (this.punktFilter.isPunktEnabled(punkt)) {
                    String string;
                    String string2 = Long.toString(punkt.nr);
                    if (!string2.equals(string = GeografProperties.getPunktNummer(punkt))) {
                        printWriter.print("PKNUM");
                        printWriter.print(n);
                        printWriter.print(": ");
                        printWriter.print(string2);
                        printWriter.print(", ");
                        printWriter.println(string);
                        ++n2;
                    }
                    if ((long)n % super.getProgressBreak() == 0L) {
                        super.setLabelValue(n2);
                        super.showProgress(n);
                    }
                }
                ++n;
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
        finally {
            try {
                printWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    protected void writeOutHeader(PrintWriter printWriter) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeZone(TimeZone.getTimeZone("ECT"));
        printWriter.println(COMMENT_MARKER);
        printWriter.println("* U M N U M M E R I E R U N G  GEOgraf");
        printWriter.println(COMMENT_MARKER);
        printWriter.println("* erstellt mit GeografUmnumWriter 1.0");
        printWriter.println("* Datum: " + gregorianCalendar.get(5) + "/" + gregorianCalendar.get(2) + "/" + gregorianCalendar.get(1));
        printWriter.println(COMMENT_MARKER);
    }
}

