/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.geom.DArc;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.ggout.Data;
import de.geocalc.ggout.GeografOutReader;
import de.geocalc.ggout.objects.GGElement;
import de.geocalc.ggout.objects.HashElement;
import de.geocalc.ggout.objects.LI;
import de.geocalc.ggout.objects.OList;
import de.geocalc.ggout.objects.OO;
import de.geocalc.ggout.objects.OOX;
import de.geocalc.ggout.objects.OR;
import de.geocalc.ggout.objects.PA;
import de.geocalc.ggout.objects.PK;
import de.geocalc.ggout.objects.TE;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.GObjectManipulator;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.GebaeudeKennzeichen;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.Nutzung;
import de.geocalc.kafplot.ObjectSymbol;
import de.geocalc.kafplot.ObjectText;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.PunktParameterALKIS;
import de.geocalc.kafplot.TopObject;
import de.geocalc.kafplot.io.IDataReader;
import de.geocalc.kataster.model.Alkis;
import de.geocalc.text.IFormat;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class GgOutReader
extends IDataReader {
    private static boolean OBJEKT_SEARCH = true;
    private static boolean OBJEKT_SEARCH_OF_DIGIT = false;
    DataBase db;
    int eb;
    Data data;
    private final Hashtable POINTS = new Hashtable();
    private GeografOutReader reader = null;

    public GgOutReader(File file, DataBase dataBase) {
        this(file, dataBase, null);
    }

    public GgOutReader(File file, DataBase dataBase, IProgressViewer iProgressViewer) {
        super(file, iProgressViewer);
        this.db = dataBase;
    }

    @Override
    public void userAbort() throws IFileInputException {
        try {
            if (this.reader != null) {
                this.reader.userAbort();
            }
        }
        catch (Exception exception) {
            throw new IFileInputException(this.getErrorKey() + "Fehler beim Schlie\u00dfen der Datei: " + this.inFile.getName());
        }
    }

    @Override
    public void read() throws IFileInputException {
        this.data = new Data();
        this.reader = new GeografOutReader();
        this.reader.setFile(this.inFile);
        this.reader.setData(this.data);
        this.reader.setProgressView(this.progressBar);
        try {
            this.reader.read();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IFileInputException(exception.getMessage());
        }
        this.progressBar.setValue(0);
        int n = this.data.size();
        int n2 = n / 100;
        int n3 = 0;
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            GGElement gGElement = (GGElement)enumeration.nextElement();
            try {
                if (gGElement instanceof PK) {
                    var6_7 = (PK)gGElement;
                    Punkt punkt = new Punkt();
                    punkt.nr = ((PK)var6_7).getName().length() != 0 && IFormat.hasOnlyNumbers(((PK)var6_7).getName()) ? Long.parseLong(((PK)var6_7).getName()) : this.getFreeNumber(DataBase.P);
                    this.POINTS.put(new Integer(var6_7.getKey()), punkt);
                    punkt.x = ((PK)var6_7).getY();
                    punkt.y = ((PK)var6_7).getX();
                    punkt.h = (float)((PK)var6_7).getZ();
                    var8_11 = var6_7.getKatalog();
                    var9_12 = var6_7.getEbene();
                    int n4 = ((PK)var6_7).getArt();
                    if (var8_11 == 0 || var8_11 == 1600) {
                        int n5 = 0;
                        switch (((PK)var6_7).getArt()) {
                            case 0: 
                            case 3020: {
                                n5 = 20;
                                break;
                            }
                            case 3413: 
                            case 3415: 
                            case 3629: {
                                break;
                            }
                            case 13001: {
                                n5 = 10;
                                break;
                            }
                            case 13002: {
                                n5 = 11;
                                break;
                            }
                            case 13003: {
                                n5 = 60;
                                break;
                            }
                            case 31005: {
                                n5 = 30;
                                break;
                            }
                            case 51011: {
                                n5 = 40;
                                break;
                            }
                            case 61009: {
                                n5 = 50;
                                break;
                            }
                            default: {
                                System.out.println("Unbekannte ALKIS-Art: " + var6_7.getKatalog() + var6_7.getEbene() + ":" + ((PK)var6_7).getArt());
                            }
                        }
                        PunktParameterALKIS punktParameterALKIS = null;
                        if (n5 != 0) {
                            punktParameterALKIS = new PunktParameterALKIS();
                            ((PunktParameter)punktParameterALKIS).setPa(n5);
                            Enumeration enumeration2 = ((OList)var6_7).elements();
                            while (enumeration2.hasMoreElements()) {
                                GGElement gGElement2 = (GGElement)enumeration2.nextElement();
                                if (!(gGElement2 instanceof PA)) continue;
                                int n6 = ((PA)gGElement2).getKatalog();
                                int n7 = ((PA)gGElement2).getArt();
                                if (n6 == 1650) {
                                    ((PunktParameter)punktParameterALKIS).setLg(n7);
                                    continue;
                                }
                                if (n6 == 1651) {
                                    ((PunktParameter)punktParameterALKIS).setVa(n7);
                                    continue;
                                }
                                if (n6 != 1652) continue;
                                ((PunktParameter)punktParameterALKIS).setVb(n7);
                            }
                        }
                        if (punktParameterALKIS != null) {
                            punkt.initParameter(punktParameterALKIS);
                        }
                    }
                    this.savePunkt(punkt, DataBase.P);
                } else if (gGElement instanceof OOX) {
                    var6_7 = (OOX)gGElement;
                    int n8 = var6_7.getKatalog();
                    var8_11 = var6_7.getEbene();
                    var9_12 = ((OOX)var6_7).getArt();
                    if (n8 == 0 || n8 == 1600) {
                        if (var9_12 == 11001) {
                            DataBase.FLST.put(this.parseFlst((OOX)var6_7));
                        } else if (var9_12 == 31001) {
                            DataBase.GEB.put(this.parseGeb((OOX)var6_7));
                        } else if (var9_12 >= 41001 && var9_12 <= 44007) {
                            DataBase.NUTZ.put(this.parseNutzung((OOX)var6_7));
                        } else {
                            DataBase.TOP.put(this.parseTopObject((OOX)var6_7));
                        }
                    }
                }
                if (++n3 % n2 != 0) continue;
                this.progressBar.setValue(n3 * 100 / n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private Flurstueck parseFlst(OOX oOX) throws Exception {
        Flurstueck flurstueck = new Flurstueck();
        flurstueck.setArt(700);
        String string = oOX.getName();
        if (string.length() > 0) {
            try {
                int n = string.indexOf("/");
                if (n >= 0) {
                    flurstueck.setZaehler(Integer.parseInt(string.substring(0, n)));
                    flurstueck.setNenner(Integer.parseInt(string.substring(n + 1)));
                } else {
                    flurstueck.setZaehler(Integer.parseInt(string));
                }
            }
            catch (Exception exception) {
                throw new Exception("Fehler beim Auswerten der Flurst\u00fccksnummer: " + oOX.getName());
            }
        }
        if (!(oOX instanceof OO)) {
            throw new Exception("Objekt " + String.valueOf(oOX) + " hat falschen Objekttyp");
        }
        OO oO = (OO)oOX;
        if (oO.getOberObject() == 0) {
            throw new Exception("Dem Flurst\u00fccksobjekt " + String.valueOf(oOX) + " fehlt das Flur-Oberobjekt");
        }
        OO oO2 = (OO)this.data.getObject(0xA000000 + oO.getOberObject());
        if (oO2 == null) {
            throw new Exception("Flur-Oberobjekt" + Integer.toString(oO2.getOberObject(), 16) + " nicht im Datensatz enthalten");
        }
        try {
            flurstueck.setFlur(Integer.parseInt(oO2.getName()));
        }
        catch (Exception exception) {
            throw new Exception("Fehler beim Auswerten der Flurnummer: " + oO2.getName());
        }
        if (oO2.getOberObject() == 0) {
            throw new Exception("Dem Flurobjekt " + String.valueOf(oO2) + " fehlt das Gemarkung-Oberobjekt");
        }
        OO oO3 = (OO)this.data.getObject(0xA000000 + oO2.getOberObject());
        if (oO3 == null) {
            throw new Exception("Gemarkung-Oberobjekt" + Integer.toString(oO2.getOberObject(), 16) + " nicht im Datensatz enthalten");
        }
        try {
            flurstueck.setGemarkung(Integer.parseInt(oO3.getName()));
        }
        catch (Exception exception) {
            throw new Exception("Fehler beim Auswerten der Gemarkungsnummer: " + oO3.getName());
        }
        this.parseGeom(oOX, flurstueck);
        return flurstueck;
    }

    private Nutzung parseNutzung(OOX oOX) throws Exception {
        Nutzung nutzung = new Nutzung(Alkis.createNutzungsart(oOX.getArt(), 0, 0, 0), oOX.getArt());
        this.parseGeom(oOX, nutzung);
        return nutzung;
    }

    private Gebaeude parseGeb(OOX oOX) throws Exception {
        Gebaeude gebaeude = new Gebaeude();
        String string = oOX.getName();
        GebaeudeKennzeichen gebaeudeKennzeichen = new GebaeudeKennzeichen();
        if (string.length() > 0) {
            Object object;
            Object object2;
            Enumeration<Object> enumeration;
            try {
                enumeration = new StringTokenizer(string, "|");
                if (((StringTokenizer)enumeration).hasMoreTokens()) {
                    gebaeudeKennzeichen.setGemeinde(Integer.parseInt(((StringTokenizer)enumeration).nextToken()));
                }
                if (((StringTokenizer)enumeration).hasMoreTokens()) {
                    gebaeudeKennzeichen.setStrasse(Integer.parseInt(((StringTokenizer)enumeration).nextToken()));
                }
                if (((StringTokenizer)enumeration).hasMoreTokens()) {
                    int n;
                    String string2;
                    object2 = ((StringTokenizer)enumeration).nextToken();
                    object = new StringTokenizer((String)object2, "()");
                    int n2 = ((StringTokenizer)object).countTokens();
                    if (n2 == 2) {
                        string2 = ((StringTokenizer)object).nextToken().trim();
                        if (string2.charAt(0) == 'P') {
                            gebaeudeKennzeichen.setPseudoNummer(true);
                            string2 = string2.substring(1);
                        }
                        gebaeudeKennzeichen.setLfdNummer(Integer.parseInt(string2));
                    } else {
                        gebaeudeKennzeichen.setLfdNummer(0);
                    }
                    string2 = ((StringTokenizer)object).nextToken().trim();
                    if (string2.charAt(0) == 'P') {
                        string2 = string2.substring(1);
                    }
                    if ((n = string2.indexOf(" ")) > 0) {
                        gebaeudeKennzeichen.setHausNummer(Integer.parseInt(string2.substring(0, n)));
                        gebaeudeKennzeichen.setAdressenZusatz(string2.substring(n + 1));
                    } else {
                        gebaeudeKennzeichen.setHausNummer(Integer.parseInt(string2));
                    }
                }
                gebaeude.setLeitzeichen(gebaeudeKennzeichen);
            }
            catch (Exception exception) {
                throw new Exception("Fehler beim Auswerten des Geb\u00e4udekennzeichens " + oOX.getName());
            }
            enumeration = oOX.elements();
            while (enumeration.hasMoreElements()) {
                TE tE;
                object2 = (OR)enumeration.nextElement();
                if (((OR)object2).getTyp() != 1 || !((object = this.data.getObject(((OR)object2).getLink())) instanceof TE) || (tE = (TE)object).getArt() != 4070) continue;
                gebaeudeKennzeichen.setLocation(tE.getX(), tE.getY());
                gebaeudeKennzeichen.setAngle(tE.getAngle() * Math.PI / 200.0);
            }
        }
        this.parseGeom(oOX, gebaeude);
        return gebaeude;
    }

    public TopObject parseTopObject(OOX oOX) throws Exception {
        TopObject topObject = new TopObject();
        topObject.setOska(oOX.getArt());
        this.parseGeom(oOX, topObject);
        Enumeration enumeration = oOX.elements();
        while (enumeration.hasMoreElements()) {
            OList oList;
            OR oR = (OR)enumeration.nextElement();
            if (oR.getTyp() != 1) continue;
            HashElement hashElement = this.data.getObject(oR.getLink());
            if (hashElement instanceof PK) {
                oList = (PK)hashElement;
                topObject.addDecor(new ObjectSymbol(null, ((PK)oList).getArt(), ((PK)oList).getX(), ((PK)oList).getY(), (float)(((PK)oList).getAngle() * Math.PI / 200.0)));
                continue;
            }
            if (!(hashElement instanceof TE)) continue;
            oList = (TE)hashElement;
            topObject.addDecor(new ObjectText(((TE)oList).getAllTextlines(), ((TE)oList).getArt(), ((TE)oList).getX(), ((TE)oList).getY(), (float)(((TE)oList).getAngle() * Math.PI / 200.0)));
        }
        return topObject;
    }

    public void parseGeom(OOX oOX, GObject gObject) throws Exception {
        if (gObject != null) {
            Linie linie;
            Punkt punkt;
            Punkt punkt2;
            PK pK;
            PK pK2;
            LI lI;
            HashElement hashElement;
            OR oR;
            if (oOX instanceof OO) {
                gObject.x = ((OO)oOX).getY();
                gObject.y = ((OO)oOX).getX();
            }
            Object object = oOX.elements();
            while (object.hasMoreElements()) {
                oR = (OR)object.nextElement();
                if (oR.getTyp() != 2 || !((hashElement = this.data.getObject(oR.getLink())) instanceof LI)) continue;
                lI = (LI)hashElement;
                pK2 = (PK)this.data.getObject(lI.getName1());
                pK = (PK)this.data.getObject(lI.getName2());
                if (pK2 == null || pK == null) {
                    // empty if block
                }
                punkt2 = (Punkt)this.POINTS.get(new Integer(pK2.getKey()));
                punkt = (Punkt)this.POINTS.get(new Integer(pK.getKey()));
                linie = new Linie(punkt2, punkt);
                if (lI.getRadius1() != 0.0) {
                    if (lI.getRadius2() == 0.0) {
                        linie.setRadius(lI.getRadius1());
                    } else if (lI.getRadius2() == 1.0) {
                        linie.setRadius(-lI.getRadius1());
                    } else if (lI.getA() == 0.0) {
                        DPoint dPoint = new DPoint(lI.getRadius1(), lI.getRadius2());
                        linie.setRadius(DArc.getRadiusFrom3Points(punkt2, dPoint, punkt));
                        if (DLine.getDistance(punkt2.y, punkt2.x, punkt.y, punkt.x, dPoint.y, dPoint.x) > 0.0) {
                            linie.setRadius(-linie.getRadius());
                        }
                    }
                }
                gObject.addElement(linie);
            }
            if (gObject.size() > 0) {
                object = new GObjectManipulator(gObject);
                ((GObjectManipulator)object).repair();
            }
            object = oOX.elements();
            while (object.hasMoreElements()) {
                oR = (OR)object.nextElement();
                if (oR.getTyp() != 1 || !((hashElement = this.data.getObject(oR.getLink())) instanceof LI)) continue;
                lI = (LI)hashElement;
                pK2 = (PK)this.data.getObject(lI.getName1());
                pK = (PK)this.data.getObject(lI.getName2());
                if (pK2 == null || pK == null) {
                    // empty if block
                }
                punkt2 = (Punkt)this.POINTS.get(new Integer(pK2.getKey()));
                punkt = (Punkt)this.POINTS.get(new Integer(pK.getKey()));
                linie = new Linie(punkt2, punkt);
                gObject.addElement(linie);
            }
        }
    }
}

