/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.geom.DPoint;
import de.geocalc.ggout.Data;
import de.geocalc.ggout.GeografOutWriter;
import de.geocalc.ggout.objects.SYSTEM;
import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.KafPlotVersion;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.io.IFileWriter;
import de.geocalc.kafplot.io.gg.GGIOProperties;
import de.geocalc.text.IFormat;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class GgOutWriter
extends IFileWriter {
    protected static final double RO = 63.66197723675813;
    protected DataBase db;
    protected Data data;
    protected Hashtable lineHash;

    public GgOutWriter(File file, DataBase dataBase) {
        super(file);
        this.db = dataBase;
        this.data = new Data(true, false);
        this.setParameter();
        this.lineHash = new Hashtable();
    }

    protected void setParameter() {
        String string = GGIOProperties.getCooSystem();
        if (string != null && string.length() > 0) {
            try {
                this.data.put(new SYSTEM(string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            try {
                if (DataBase.getKooSystem() == 489) {
                    this.data.put(new SYSTEM("BB:ETRS89_UTM33,proj=utm,zone=33,ellps=GRS80,units=m,towgs84=0;0;0;0;0;0;0,no_defs"));
                } else if (DataBase.getKooSystem() == 150) {
                    this.data.put(new SYSTEM("BB:DE_42-83_3GK5,proj=tmerc,lat_0=0,lon_0=15,k=1.000000,x_0=5500000,y_0=0,ellps=krass,units=m,nadgrids=bb3040h.gsb,no_defs"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void write() throws IFileOutputException {
        this.setParameter();
        try {
            Cloneable cloneable;
            Object object = DataBase.P.elements();
            while (object.hasMoreElements()) {
                cloneable = (Punkt)object.nextElement();
                if (!this.use((Punkt)cloneable)) continue;
                this.storePunkt(this.data, (Punkt)cloneable);
            }
            object = DataBase.FLST.elements();
            while (object.hasMoreElements()) {
                cloneable = (GObject)object.nextElement();
                if (!this.use((GObject)cloneable)) continue;
                this.storeObject(this.data, (GObject)cloneable);
            }
            object = DataBase.NUTZ.elements();
            while (object.hasMoreElements()) {
                cloneable = (GObject)object.nextElement();
                if (!this.use((GObject)cloneable)) continue;
                this.storeObject(this.data, (GObject)cloneable);
            }
            object = DataBase.GEB.elements();
            while (object.hasMoreElements()) {
                cloneable = (GObject)object.nextElement();
                if (!this.use((GObject)cloneable)) continue;
                this.storeObject(this.data, (GObject)cloneable);
            }
            object = DataBase.TOP.elements();
            while (object.hasMoreElements()) {
                cloneable = (GObject)object.nextElement();
                if (!this.use((GObject)cloneable)) continue;
                this.storeObject(this.data, (GObject)cloneable);
            }
            this.storeSpecial(this.data, this.db);
            object = new GeografOutWriter(this.outFile);
            ((GeografOutWriter)object).setCreator(KafPlotVersion.getName(1));
            ((GeografOutWriter)object).setData(this.data);
            ((GeografOutWriter)object).write();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected boolean use(Punkt punkt) {
        return this.punktFilter.isPunktEnabled(punkt);
    }

    protected boolean use(Linie linie) {
        return linie.pa != null && this.use(linie.pa) && linie.pe != null && this.use(linie.pe);
    }

    protected boolean use(GObject gObject) {
        Enumeration enumeration = gObject.elements();
        while (enumeration.hasMoreElements()) {
            Linie linie = (Linie)enumeration.nextElement();
            if (!this.use(linie)) continue;
            return true;
        }
        return false;
    }

    protected abstract void storePunkt(Data var1, Punkt var2) throws Exception;

    protected abstract void storeLinie(Data var1, Linie var2) throws Exception;

    protected void storeObject(Data data, GObject gObject) throws Exception {
        this.storeObjectGeom(data, gObject);
        this.storeObjectData(data, gObject);
    }

    protected void storeObjectGeom(Data data, GObject gObject) throws Exception {
        Enumeration enumeration = gObject.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Linie linie = (Linie)enumeration.nextElement();
            if (!this.use(linie) || this.lineHash.put(object = linie.getArtHashKey(), object) != null) continue;
            this.storeLinie(data, linie);
        }
    }

    protected abstract void storeObjectData(Data var1, GObject var2) throws Exception;

    protected abstract void storeSpecial(Data var1, DataBase var2) throws Exception;

    protected String createKooName(DPoint dPoint) {
        return "\"" + IFormat.f_4.format(dPoint.y) + "," + IFormat.f_4.format(dPoint.x) + "\"";
    }
}

