/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.geom.Koordinate2D;
import de.geocalc.ggout.Data;
import de.geocalc.ggout.objects.BLATT;
import de.geocalc.ggout.objects.GGElement;
import de.geocalc.ggout.objects.KatalogEbeneArtElement;
import de.geocalc.ggout.objects.LI;
import de.geocalc.ggout.objects.OList;
import de.geocalc.ggout.objects.OVector;
import de.geocalc.ggout.objects.PK;
import de.geocalc.ggout.objects.POS;
import de.geocalc.ggout.objects.SCH;
import de.geocalc.ggout.objects.SuperElement;
import de.geocalc.ggout.objects.TE;
import de.geocalc.ggout.objects.TX;
import de.geocalc.kafplot.Buchungsstelle;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.GebaeudeKennzeichen;
import de.geocalc.kafplot.GeografProperties;
import de.geocalc.kafplot.Grundbuchblatt;
import de.geocalc.kafplot.Lagegenauigkeit;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.LinieParameter;
import de.geocalc.kafplot.Name;
import de.geocalc.kafplot.Nutzung;
import de.geocalc.kafplot.NutzungsArt;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.Symbol;
import de.geocalc.kafplot.io.GgOutWriter;
import de.geocalc.kafplot.io.IOProperties;
import de.geocalc.kataster.model.Alkis;
import de.geocalc.util.IntegerHashObject;
import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class GgPlanWriter
extends GgOutWriter {
    private boolean hasMenge = false;
    private int EB_OFFSET = 10000;
    private boolean alkis = false;

    public GgPlanWriter(File file, DataBase dataBase) {
        super(file, dataBase);
        try {
            BLATT bLATT = new BLATT();
            bLATT.setContent("GEOGRAF", GeografProperties.getGrafArtFileName(), GeografProperties.getGrafSymFileName(), GeografProperties.getGrafPenFileName(), GeografProperties.getGrafMacFileName(), 500, 0, "", "", GeografProperties.getGrafColFileName());
            this.data.put(bLATT);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected boolean use(Punkt punkt) {
        return this.hasMenge ? DataBase.MENGE.contains(punkt) : this.punktFilter.isPunktEnabled(punkt);
    }

    @Override
    protected void setParameter() {
        super.setParameter();
        this.hasMenge = DataBase.MENGE.size() > 0;
        this.alkis = GeografProperties.hasAlkisDefs();
    }

    private void storeElem(KatalogEbeneArtElement katalogEbeneArtElement, String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+:", true);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("+")) {
                KatalogEbeneArtElement katalogEbeneArtElement2 = (KatalogEbeneArtElement)((GGElement)((Object)katalogEbeneArtElement)).clone();
                this.data.put((GGElement)((Object)katalogEbeneArtElement));
                katalogEbeneArtElement = katalogEbeneArtElement2;
                if (!(katalogEbeneArtElement instanceof PK)) continue;
                ((PK)katalogEbeneArtElement).setName(null);
                continue;
            }
            if (string2.equals(":")) {
                bl = true;
                continue;
            }
            if (bl) {
                if (katalogEbeneArtElement instanceof SCH) {
                    this.setSchValues((SCH)katalogEbeneArtElement, string2);
                }
                bl = false;
                continue;
            }
            this.setElemArt(katalogEbeneArtElement, string2);
        }
        this.data.put((GGElement)((Object)katalogEbeneArtElement));
    }

    private void setElemArt(KatalogEbeneArtElement katalogEbeneArtElement, String string) {
        String[] stringArray = string.split("\\.");
        int n = 0;
        int n2 = stringArray.length - 1;
        while (n2 >= 0) {
            int n3;
            int n4 = n3 = stringArray[n2].length() > 0 ? Integer.parseInt(stringArray[n2]) : 0;
            if (n == 0) {
                katalogEbeneArtElement.setArt(n3);
            } else if (n == 1) {
                katalogEbeneArtElement.setEbene(n3);
            } else if (n == 2) {
                katalogEbeneArtElement.setKatalog(n3);
            }
            --n2;
            ++n;
        }
    }

    private void setSchValues(SCH sCH, String string) {
        try {
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                if (i == 0) {
                    sCH.setSubTyp(Integer.parseInt(stringArray[i]));
                    continue;
                }
                if (i == 1) {
                    sCH.setAngle(sCH.getAngle() + Double.parseDouble(stringArray[i]));
                    continue;
                }
                if (i != 2) continue;
                sCH.setSize(Double.parseDouble(stringArray[i]));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected void storePunkt(Data data, Punkt punkt) throws Exception {
        PK pK = new PK(GeografProperties.getPunktNummer(punkt), punkt.y, punkt.x, punkt.h, 0, 0);
        if (IOProperties.isHoeheModus() && punkt.h != 0.0f) {
            pK.setZ(punkt.h);
            pK.setHoeheStatus(3);
        }
        if (punkt.getPs() == 1 || punkt.getPs() == 2 || punkt.isOn()) {
            pK.setHoeheStatus(3);
        }
        pK.setAngle(punkt.getSymbolWinkel() * 63.66197723675813);
        if (this.alkis) {
            String string = GeografProperties.getArten(punkt);
            if (string != null) {
                this.storeElem(pK, string);
            }
        } else {
            int n = this.getGgEbArt(punkt);
            pK.setEbene(n / this.EB_OFFSET);
            pK.setArt(n % this.EB_OFFSET);
            data.put(pK);
        }
    }

    @Override
    protected void storeLinie(Data data, Linie linie) throws Exception {
        if (linie.isAnchorLine()) {
            return;
        }
        LI lI = new LI(GeografProperties.getPunktNummer(linie.pa), GeografProperties.getPunktNummer(linie.pe));
        if (this.alkis) {
            String string = GeografProperties.getArten(linie);
            if (string != null) {
                lI.setRadius1(Math.abs(linie.getKooRadius()));
                if (linie.isBogen()) {
                    lI.setRadius2(linie.getRadius() < 0.0 ? -1.0 : 1.0);
                }
                this.storeElem(lI, string);
            }
        } else {
            LinieParameter linieParameter = linie.getParameter();
            int n = linieParameter.getLa();
            int n2 = linieParameter.getEb();
            int n3 = linieParameter.getSig2();
            int n4 = 0;
            int n5 = 0;
            if (n == 2) {
                if (n3 == 1104) {
                    n4 = 1;
                } else if (n3 == 1105) {
                    n4 = 2;
                } else if (n3 == 1101) {
                    n4 = 4;
                } else if (n3 == 1107) {
                    n4 = 5;
                } else if (n3 == 1103) {
                    n4 = 6;
                } else if (n3 == 1102) {
                    n4 = 7;
                }
                if (n2 == 48) {
                    n5 = 110;
                    n4 += 110;
                } else {
                    n5 = 100;
                    n4 += 100;
                }
            } else if (n == 3) {
                n5 = n2 == 42 ? 210 : 200;
                n4 = n5;
            } else if (n == 5) {
                n5 = 500;
                n4 = 500;
            } else if (n == 4) {
                n5 = 400;
                n4 = 400;
            }
            lI.setArt(n4);
            lI.setEbene(n5 += Math.max(this.getGgEbArt(linie.pa) % 10, this.getGgEbArt(linie.pe) % 10));
            data.put(lI);
        }
    }

    @Override
    protected void storeObjectData(Data data, GObject gObject) throws Exception {
        boolean bl;
        if (!this.alkis) {
            return;
        }
        String string = null;
        boolean bl2 = bl = gObject.yt != 0.0 && gObject.xt != 0.0;
        if (gObject instanceof Flurstueck) {
            int n = 0;
            Flurstueck flurstueck = (Flurstueck)gObject;
            TE tE = new TE(null, bl ? gObject.yt : gObject.y, bl ? gObject.xt : gObject.x, 100.0, 0, 0);
            tE.setYBez(gObject.x);
            tE.setXBez(gObject.y);
            tE.setPosition(1);
            Object object = null;
            if (flurstueck.isTeilstueck()) {
                object = flurstueck.getVorgabeNummer() != null ? flurstueck.getVorgabeNummerAsString() : flurstueck.getTeilAsString();
                n = 1;
            } else {
                object = flurstueck.getZaehlerAsString();
                if (flurstueck.getNenner() > 0) {
                    object = (String)object + "\u02fd" + flurstueck.getNennerAsString();
                }
                if (flurstueck.hasTeile()) {
                    tE.setCrossout(true);
                    n = 2;
                }
            }
            tE.addElement(new TX((String)object));
            string = GeografProperties.getArten(gObject, 3, 100, 31, n);
            if (string != null) {
                this.storeElem(tE, string);
            }
            if ((string = GeografProperties.getArten(gObject, 3, 100, 32, n)) != null) {
                TE tE2 = null;
                if (!flurstueck.isTeilstueck()) {
                    Enumeration enumeration = flurstueck.buchungen();
                    while (enumeration.hasMoreElements()) {
                        Buchungsstelle buchungsstelle = (Buchungsstelle)enumeration.nextElement();
                        Grundbuchblatt grundbuchblatt = (Grundbuchblatt)DataBase.BUCH.get(buchungsstelle.getGrundbuchblattName());
                        if (grundbuchblatt == null) continue;
                        tE2 = new TE(null, bl ? gObject.yt : gObject.y, bl ? gObject.xt : gObject.x, 100.0, 1, 110);
                        Enumeration enumeration2 = grundbuchblatt.elements();
                        while (enumeration2.hasMoreElements()) {
                            Name name = (Name)enumeration2.nextElement();
                            StringBuffer stringBuffer = new StringBuffer(name.getNameAsString());
                            if (name.hasGeburtName()) {
                                stringBuffer.append(" geb. ");
                                stringBuffer.append(name.getGeburtName());
                            }
                            tE2.addElement(new TX(stringBuffer.toString()));
                        }
                    }
                }
                if (tE2 != null) {
                    tE2.setYBez(gObject.x);
                    tE2.setXBez(gObject.y);
                    tE2.setPosition(7);
                    this.storeElem(tE2, string);
                }
            }
        } else if (gObject instanceof Gebaeude) {
            SuperElement superElement;
            Gebaeude gebaeude = (Gebaeude)gObject;
            string = GeografProperties.getArten(gObject, 3, 200, 31, 0);
            if (string != null) {
                Koordinate2D koordinate2D;
                Object object;
                if (gebaeude.hasLeitzeichen() && ((GebaeudeKennzeichen)(object = gebaeude.getLeitzeichen())).getLfdNummer() == 0) {
                    koordinate2D = new TE(null, ((GebaeudeKennzeichen)object).y, ((GebaeudeKennzeichen)object).x, 100.0, 0, 0);
                    ((TE)koordinate2D).setAngle((double)((GebaeudeKennzeichen)object).getAngle() * 63.66197723675813);
                    ((TE)koordinate2D).setPosition(7);
                    ((OList)((Object)koordinate2D)).addElement(new TX(((GebaeudeKennzeichen)object).getInscription()));
                    this.storeElem((KatalogEbeneArtElement)((Object)koordinate2D), string);
                }
                if (gebaeude.hasKennzeichen()) {
                    object = gebaeude.kennzeichen();
                    while (object.hasMoreElements()) {
                        koordinate2D = (GebaeudeKennzeichen)object.nextElement();
                        superElement = new TE(null, ((GebaeudeKennzeichen)koordinate2D).y, ((GebaeudeKennzeichen)koordinate2D).x, 100.0, 0, 0);
                        ((TE)superElement).setAngle((double)((GebaeudeKennzeichen)koordinate2D).getAngle() * 63.66197723675813);
                        ((TE)superElement).setPosition(7);
                        ((OList)superElement).addElement(new TX(((GebaeudeKennzeichen)koordinate2D).getInscription()));
                        this.storeElem((KatalogEbeneArtElement)((Object)superElement), string);
                    }
                }
            }
            int n = 0;
            int n2 = Alkis.getGebaeudeFunctionGroup(gebaeude.getFunktion());
            if (n2 == 1) {
                n = 41;
            } else if (n2 == 3) {
                n = 43;
            } else if (n2 == 2) {
                n = 42;
            }
            string = GeografProperties.getArten(gObject, 5, 200, n, 0);
            if (string != null) {
                superElement = new SCH(0);
                ((SCH)superElement).setSubTyp(7);
                double d = 0.0;
                double d2 = 0.0;
                Enumeration enumeration = gebaeude.elements();
                while (enumeration.hasMoreElements()) {
                    Linie linie = (Linie)enumeration.nextElement();
                    ((OVector)superElement).addElement(POS.create(linie.pa.y, linie.pa.x));
                    double d3 = linie.getLaenge();
                    if (!(d3 > d)) continue;
                    d = d3;
                    d2 = linie.getRichtung();
                }
                ((SCH)superElement).setAngle(d2 * 63.66197723675813);
                this.storeElem((KatalogEbeneArtElement)((Object)superElement), string);
            }
        } else if (gObject instanceof Nutzung) {
            IntegerHashObject integerHashObject;
            Nutzung nutzung = (Nutzung)gObject;
            String string2 = GeografProperties.getArten(gObject, 3, 300, 31, 0);
            String string3 = GeografProperties.getArten(gObject, 3, 300, 32, 0);
            if (string2 != null) {
                integerHashObject = new TE(null, nutzung.y, nutzung.x, 100.0, 0, 0);
                ((TE)integerHashObject).setPosition(string3 != null ? 1 : 4);
                ((OList)integerHashObject).addElement(new TX(Integer.toString(nutzung.getArt())));
                this.storeElem((KatalogEbeneArtElement)((Object)integerHashObject), string2);
            }
            if (string3 != null && (integerHashObject = NutzungsArt.getNutzungsArt(nutzung.getArt())) != null) {
                TE tE = new TE(null, nutzung.y, nutzung.x, 100.0, 0, 0);
                tE.setPosition(string2 != null ? 7 : 4);
                tE.addElement(new TX(((NutzungsArt)integerHashObject).getAbkuerzung()));
                this.storeElem(tE, string3);
            }
        }
    }

    @Override
    protected void storeSpecial(Data data, DataBase dataBase) throws Exception {
    }

    private int getGgEbArt(Punkt punkt) {
        int n;
        PunktParameter punktParameter = punkt.getParameter();
        int n2 = punktParameter.getKafPa();
        int n3 = 0;
        int n4 = 0;
        if (n2 == 1) {
            n3 = punkt.getKarteSymbol() == Symbol.GP ? 101 : 100;
            n4 = 100;
        } else if (n2 == 2) {
            n3 = 200;
            n4 = 200;
        } else if (n2 == 3) {
            n3 = 900;
            n4 = 900;
        } else if (n2 == 8) {
            n3 = 911;
            n4 = 910;
        } else if (n2 == 7) {
            n3 = 921;
            n4 = 920;
        } else if (n2 == 9) {
            n3 = 991;
            n4 = 990;
        } else if (n2 == 0) {
            n = punktParameter.getPa();
            if (n == 91) {
                n3 = 500;
                n4 = 500;
            } else if (n == 92) {
                n3 = 300;
                n4 = 300;
            } else if (n == 93) {
                n3 = 400;
                n4 = 400;
            } else if (n == 95) {
                n3 = 931;
                n4 = 930;
            }
        }
        if (punktParameter.getKafEa() == 1000) {
            n = punktParameter.getKafLg();
            if (n == 0 && punktParameter.getKafLl() > 0.0f) {
                n = Lagegenauigkeit.createFromLl(punktParameter.getKafLl());
            }
            n4 += n;
        } else {
            n4 += 9;
        }
        return n4 * this.EB_OFFSET + n3;
    }
}

